<?php
$title = 'Смена пароля';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");

if (isset($active)) {

    header('Location: /');

} else {

    $key = md5(md5($act));

    $strow = $connect->prepare("select * from `speedpass` where `key` = ?");
    $strow->execute(array($key));
    $row = $strow->fetch();

    if (!$row) {

        header('Location: /');

    } else {

        echo '<div class="title">Смена пароля</div>';

        if ($row['time'] < time() - 3600 * $sys['system']['hsp']) {

            echo '<div class="menu"><div class="forbidden">Ссылка недействительна!</div></div>';

        } else {

            $row_u = user($row['uid']);

            if (!$row_u) {

                header('Location: /');

            } else {

                echo '<div class="menu">
                Логин: '.$row_u['login'].'<br/>
                E-mail: '.$row_u['email'].'
                <div class="danger">До удаления ссылки осталось: '.restime($row['time'] - time() + 3600 * $sys['system']['hsp']).'</div>
                </div>';

                if (isset($_POST['sp'])) {

                    $error = '';

                    if (empty($_POST['code'])) {
                        $error.= 'Введите код с картинки!<br/>';
                    }
                    elseif ($_SESSION['code'] != $_POST['code']) {
                        $error.= 'Код с картинки введен неверно!<br/>';
                    }
                    elseif (empty($_POST['new_pass'])) {
                        $error.= 'Введите новый пароль!<br/>';
                    }
                    elseif (mb_strlen($_POST['new_pass']) < 3 || mb_strlen($_POST['new_pass']) > 15) {
                        $error.= 'Новый пароль должен содержать от 3 до 15 символов!<br/>';
                    }
                    elseif (empty($_POST['last_pass'])) {
                        $error.= 'Введите проверочный пароль!<br/>';
                    }
                    elseif ($_POST['last_pass'] != $_POST['new_pass']) {
                        $error.= 'Проверочный пароль введен неверно!<br/>';
                    }
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {

                        $password = password_hash($_POST['new_pass'], PASSWORD_DEFAULT);

                        $stmt = $connect->prepare("update `users` set `pass` = ? where `id` = ?");
                        $del = $connect->prepare("delete from `speedpass` where `key` = ?");

                        $auth = bin2hex(random_bytes($sys['system']['authkey'])); // ключ авторизации

                        if ($stmt->execute(array($password, $row['uid'])) &&
                            $del->execute(array($key)) &&
                            $authlog->execute(array(time(), $row['uid'], $ip, $ua, md5(md5($auth)), 0))) {

                            $expire = time() + 3600 * 24 * 365;

                            // авторизация
                            setcookie('user_id', $row['uid']);
                            setcookie('user_id', $row['uid'], $expire, '/');
                            setcookie('pass', $password);
                            setcookie('pass', $password, $expire, '/');
                            setcookie('auth', $auth);
                            setcookie('auth', $auth, $expire, '/');

                            header('Location: /');

                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                }

                echo '<div class="menu">
                <form action="" method="POST">
                Новый пароль:<br/><input type="password" name="new_pass" maxlength="15"/><br/>
                Повторите новый пароль:<br/><input type="password" name="last_pass" maxlength="15"/><br/>
                Код с картинки:<img id="captcha" src="/img/code.php" alt="check" onClick="UpCaptcha()"><br/>
                <input type="text" name="code"><br/> 
                <input type="submit" name="sp" value="Продолжить">
                </form></div>';

            }

        }

    }

}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");

?>