<?php
$title = 'Новое задание';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['task'] == 1) {

    echo '<div class="title">Новое задание</div>';

    if (isset($_POST['submit'])) {

        $error = '';

        if (empty($_POST['name'])) {
            $error.= 'Введите название!<br/>';
        }
        elseif (mb_strlen($_POST['name']) < 5 || mb_strlen($_POST['name']) > 250) {
            $error.= 'Название должно содержать от 5 до 250 символов!<br/>';
        }
        if (empty($_POST['text'])) {
            $error.= 'Введите требования по выполнению задания!<br/>';
        }
        elseif (mb_strlen($_POST['text']) < 15 || mb_strlen($_POST['text']) > 15000) {
            $error.= 'Требования должны содержать от 15 до 15000 символов!<br/>';
        }
        if (empty($_POST['cena'])) {
            $error.= 'Введите цену выполнения!<br/>';
        }
        elseif ($_POST['cena'] < $sys['system']['tcena']) {
            $error.= 'Минимальная цена выполнения - '.rub($sys['system']['tcena']).'!<br/>';
        }
        elseif (empty($_POST['col'])) {
            $error.= 'Введите количество выполнений!<br/>';
        }
        elseif (!is_numeric($_POST['col'])) {
            $error.= 'Неверное значение!<br/>';
        }
        elseif ($_POST['col'] < 1) {
            $error.= 'Минимальное количество выполнений - 1!<br/>';
        }
        elseif ($user['money'] < $_POST['col'] * $_POST['cena']) {
            $error.= 'Недостаточно средств!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            $col = intval($_POST['col']);
            $cena = floatval($_POST['cena']);
            $sum = $col * $cena;
            $status = ($adm_id == 1 || $sys['modules']['mod_t'] == 1) ? 1 : 3;

            $stmt = $connect->prepare("insert into `task` set `time` = ?, `uid` = ?, `name` = ?, `text` = ?, `col` = ?, `memory` = ?, `cena` = ?, `status` = ?");

            if (pay(-$sum, $user['id']) && $stmt->execute(array(time(), $user['id'], $_POST['name'], $_POST['text'], $col, $col, $cena, $status))) {
                $lid = $connect->LastInsertId();
                header('location: /task/view/'.$lid);
            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }
        }
    }
    echo '<div class="menu">
    <form action="" method="POST">
    Название [5-250]:<br/><input type="text" name="name"><br/>
    Требования [15-15000]:<br/><textarea name="text" rows="3" cols="20"></textarea><br/>
    Количество выполнений:<br/><input type="text" name="col"><br/>
    Цена выполнения:<br/><input type="text" name="cena"><br/>
    <input type="submit" name="submit" value="Создать задание">
    </form></div>';

    echo '<div class="forlink"><a href="/task" class="links"><img src="/img/quest.png" alt="">Мои задания</a></div>';

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>