<?php
$title = 'Мои задания';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['task'] == 1) {

    if ($count_user_tasks > 0) {

        echo '<div class="title">Массовое пополнение баланса заданий</div>';

        // prepared
        $stmt_nulled = $connect->prepare("select count(*) from `task` where `uid` = ? and `col` = ?");
        $memory = $connect->prepare("update `users` set `memory_task` = ? where `id` = ?");
        $mass_bs = $connect->prepare("update `task` set `col` = `col` + ? where `id` = ?");

        if (isset($_POST['mass_bs'])) {

            $stmt_nulled->execute(array($user['id'], 0));

            if (isset($_POST['nulled']) && !$stmt_nulled->fetchColumn()) {
                $error.= 'Заданий с нулевым балансом нет!<br/>';
            }
            elseif (empty($_POST['col'])) {
                $error.= 'Введите количество выполнений!<br/>';
            }
            elseif (!is_numeric($_POST['col'])) {
                $error.= 'Неверное значение!<br/>';
            }
            elseif ($_POST['col'] < 1) {
                $error.= 'Минимальное количество выполнений - 1!<br/>';
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $success = 0; // успешных пополнений

                $col = intval($_POST['col']);

                $data = $connect->prepare("select * from `task` where `uid` = :uid order by `id` desc");
                $data->bindValue(':uid', $user['id'], PDO::PARAM_INT);
                $data->execute();
                $sql = $data->fetchAll();

                foreach ($sql as $row) {

                    // checkbox "nulled"
                    if (isset($_POST['nulled'])
                          && $row['col'] > 0)
                                        continue;

                    // сумма
                    $sum = $col * $row['cena'];

                    // если заблокировано, то не пополняем
                    if ($row['status'] == 2)
                                        continue;

                    // если недостаточно средств, то не пополняем
                    if ($user['money'] < $sum)
                                        continue;

                    // пополняем
                    if (pay(-$sum, $user['id']) &&
                        $mass_bs->execute(array($col, $row['id'])))
                            $success++; // +1 к успешным пополнениям

                }

                // эффект памяти :)
                if ($success > 0)
                    $memory->execute(array($col, $user['id']));

                header('Location: /task');

            }

        }

        echo '<div class="menu">
        <form action="" method="POST">
        Количество выполнений:<br/><input type="text" name="col" value="'.($user['memory_task'] > 0 ? $user['memory_task'] : '').'"><br/>
        <input type="checkbox" name="nulled" value="1">Заданиям с нулевым балансом<br/>
        <input type="submit" name="mass_bs" value="Пополнить">
        </form></div>';

    }

    echo '<div class="title">Мои задания ('.$count_user_tasks.')</div>
    <div class="forlink"><a href="/task/add" class="links"><img src="/img/add.png" alt="add">Создать задание</a></div>';

    $stmt_ans = $connect->prepare("select count(*) from `task_ans` where `status` = ? and `tid` = ?");

    if ($count_user_tasks == 0) {
        echo '<div class="menu">Нет заданий!</div>';
    } else {

        $page = new Pagination($count_user_tasks, 10);

        $data = $connect->prepare("select * from `task` where `uid` = :uid order by `id` desc limit :start, 10");
        $data->bindValue(':uid', $user['id'], PDO::PARAM_INT);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            // в обработке
            $stmt_ans->execute(array(0, $row['id']));
            $answers = $stmt_ans->fetchColumn();

            echo '<div class="forlink">
            <a href="/task/view/'.$row['id'].'" class="links">
            '.($row['status'] == 2 ? '<img src="/img/block.png" alt="block">' : '<img src="/img/task.png" alt="task">').
            $row['name'].'<div class="chi">Заявки: '.$answers.' / Баланс: '.$row['col'].'</div>
            </a></div>';

        }

        $page->navigation();

    }

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>