<?php
$title = 'Выполнение заданий';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['task'] == 1) {

    $stmt_answer = $connect->prepare("select * from `task_ans` where `uid` = ? and `tid` = ?");
    $stmt_send = $connect->prepare("select count(*) from `task_ans` where `status` = ? and `tid` = ?");

    echo '<div class="title">Выполнение заданий ('.$count_tasks.')</div>';

    if ($count_tasks == 0) {
        echo '<div class="menu">Заданий нет!</div>';
    } else {

        $page = new Pagination($count_tasks, 10);

        $data = $connect->prepare("select * from `task` where `status` = '1' and `col` > '0' and `uid` != :uid order by `cena` desc limit :start, 10");
        $data->bindValue(':uid', $user['id'], PDO::PARAM_INT);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            $stmt_answer->execute(array($user['id'], $row['id']));
            $answer = $stmt_answer->fetch();

            $stmt_send->execute(array(0, $row['id']));
            $send = $stmt_send->fetchColumn();

            echo '<div class="forlink">
            <a href="/task/view/'.$row['id'].'" class="links">
            '.($answer ? ($answer['status'] == 1 ? '<img src="/img/done.png" alt="done">' :
              ($answer['status'] == 2 ? '<img src="/img/block.png" alt="block">' : '<img src="/img/wait.png" alt="wait">')) : '<img src="/img/task.png" alt="task">').
               $row['name'] . ($send >= $row['col'] ? '<div class="chi">[!]</div>' : '').'
            <span class="count">'.$row['cena'].'</span>
            </a></div>';

        }

        $page->navigation();

    }

    echo '<div class="title">Меню</div>
    <div class="forlink"><a href="/task" class="links"><img src="/img/quest.png" alt="">Мои задания<div class="chi">'.$count_user_tasks.'</div></a></div>
    <div class="forlink"><a href="/task/stats" class="links"><img src="/img/stats.png" alt="">Статистика выполнений<div class="chi">'.$user_task_stat.'</div></a></div>
        <div class="forlink"><a href="/task/today" class="links"><img src="/img/stars.png" alt="stars">Активные сегодня<div class="chi">'.$active_task_users.'</div></a></div>';

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>