<?php
$title = 'Бонусы';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if ($adm_id == 1) {

    echo '<div class="title">Бонусы ('.$count_bonus.')</div>';

    $strow = $connect->prepare("select * from `bonus` where `id` = ?");
    $stmt_sum = $connect->prepare("select sum(`sum`) from `bonus_rec` where `bid` = ?");

    if (isset($_GET['edit'])) {
        $strow->execute(array($_GET['edit']));
        $row = $strow->fetch();
        if ($row) {
            if (isset($_POST['cancel'])) {
                header('Location: /adm/bonus');
            }
            elseif (isset($_POST['ok'])) {
                $error = '';
                if (empty($_POST['min']) || empty($_POST['max'])) {
                    $error.= 'Укажите бонус!<br/>';
                }
                elseif ($_POST['min'] < 0.01 || $_POST['max'] < 0.01) {
                    $error.= 'Бонус не может быть меньше 0.01!<br/>';
                }
                elseif ($_POST['min'] > $_POST['max']) {
                    $error.= 'Мин. бонус не может быть больше макс. бонуса!<br/>';
                }
                if (empty($_POST['start']) || empty($_POST['end'])) {
                    $error.= 'Укажите время включения и выключения бонуса!<br/>';
                }
                elseif (!validateDate($_POST['start'], 'H:i') || !validateDate($_POST['end'], 'H:i')) {
                    $error.= 'Некорректный формат времени!<br/>';
                }
                elseif (validateDate($_POST['start'], 'H:i') > validateDate($_POST['end'], 'H:i')) {
                    $error.= 'Включение бонуса должно быть раньше, чем выключение!<br/>';
                }
                if (!empty($_POST['comment']) && (mb_strlen($_POST['comment']) < 5 || mb_strlen($_POST['comment']) > 250)) {
                    $error.= 'Комментарий к бонусу должен содержать от 5 до 250 символов!<br/>';
                }
                if (!empty($_POST['period']) && validateDate($_POST['date'], 'Y-m-d') < time()) {
                    $error.= 'Некорректный формат даты!<br/>';
                }
                if ($error) {
                    echo '<div class="menu">'.$error.'</div>';
                } else {
                    $limit = intval(abs($_POST['limit']));
                    $min = floatval(abs($_POST['min']));
                    $max = floatval(abs($_POST['max']));
                    $date = empty($_POST['period']) ? 0 : $_POST['date'];
                    $stmt = $connect->prepare("update `bonus` set `min` = ?, `max` = ?, `start` = ?, `end` = ?, `comment` = ?, `date` = ?, `limit` = ? where `id` = ?");
                    if ($stmt->execute(array($min, $max, $_POST['start'], $_POST['end'], $_POST['comment'], $date, $limit, $_GET['edit']))) {
                        header('Location: /adm/bonus');
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
            }

            echo '<div class="menu">
            <form action"" method="POST">
            Бонус (Мин. и Макс.):<br/>
            <input type ="text" name="min" value="'.$row['min'].'" size="4">
            <input type ="text" name="max" value="'.$row['max'].'" size="4"><br/>
            Время включения и выключения: <small>(ЧЧ:ММ)</small><br/>
            <input type="text" name="start" value="'.$row['start'].'" size="5">
            <input type="text" name="end" value="'.$row['end'].'" size="5"><br/>
            Дневной лимит бонусов (0 - без ограничений):<br/><input type="text" name="limit" value="'.$row['limit'].'"><br/>
            Комментарий к бонусу [5-250]:<br/><input type="text" name="comment" value="'.$row['comment'].'"><br/>
            Период:<br/>
            <select id="edit" name="period">
            <option value="0">Каждый день</option>
            <option '.($row['date'] ? 'selected' : '').' value="1">Установить дату</option>
            </select><br/>
            <div id="date_e" class="'.($row['date'] ? 'wa-block' : 'wa-hidden').'">
            Дата: <small>ГГГГ-ММ-ДД</small><br/><input type="date" name="date" min="'.date('Y-m-d').'" value="'.$row['date'].'">
            </div>
            <input type="submit" name="ok" value="Сохранить ('.intval($_GET['edit']).')">
            <input type="submit" name="cancel" value="Отмена">
            <div class="chi">Бонусы указывайте в рублях.</div>
            </form></div>';

            ?>
            <script>
                $(function() {
                    var edit = $('#edit');
                    edit.change(function() {
                        if (edit.val() == 1) {
                            $('#date_e').show();
                        } else {
                            $('#date_e').hide();
                        }
                    });
                });
            </script>
            <?

        } else {
            header('Location: /adm/bonus');
        }
    }
    elseif (isset($_GET['del'])) {
        $strow->execute(array($_GET['del']));
        $row = $strow->fetch();
        if ($row) {
            if (isset($_POST['cancel'])) {
                header('Location: /adm/bonus');
            }
            if (isset($_POST['ok'])) {
                $del = $connect->prepare("delete from `bonus` where `id` = ?");
                $del_rec = $connect->prepare("delete from `bonus_rec` where `bid` = ?");
                if ($del->execute(array($_GET['del'])) && $del_rec->execute(array($_GET['del']))) {
                    header('Location: /adm/bonus');
                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
            echo '<div class="menu">
            <form action"" method="POST">
            <input type="submit" name="ok" value="Удалить ('.intval($_GET['del']).')">
            <input type="submit" name="cancel" value="Отмена">
            </form></div>';
        } else {
            header('Location: /adm/bonus');
        }
    }

    if ($count_bonus == 0){
        echo '<div class="menu">NONE</div>';
    } else {

        $page = new Pagination($count_bonus, 10);

        $data = $connect->prepare("select * from `bonus` order by `id` desc limit :start, 10");
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            $rec = WhoGotBonus($row['id']);
            $rec_count = count($rec);

            $stmt_sum->execute(array($row['id']));
            $rec_sum = $stmt_sum->fetchColumn() ?? 0;

            echo '<div class="menu">
            Бонус:<span class="green">'.($row['min'] == $row['max'] ? $row['min'] : $row['min'].' - '.$row['max']).'</span><br/>
            Время: <span class="orange">'.$row['start'].' - '.$row['end'].'</span><br/>
            '.($row['date'] ? 'Дата: <span class="red">'.$row['date'].'</span>' : 'Период: <span class="blue">каждый день</span>').'<br/>
            Дневной лимит: '.($row['limit'] ? $row['limit'] : 'без ограничений').'<br/>
            '.($row['comment'] ? 'Комментарий к бонусу: '.$row['comment'].'<br/>' : '').'
            Сегодня роздано: '.rub($rec_sum).' ('.$rec_count.')
            '.($rec_count > 0 ?
            '<a href="javascript:$(\'#rec_'.$row['id'].'\').slideToggle(500)"><img src="/img/peoples.png" alt="peoples"></a>
             <div style="display: none" class="vote" id="rec_'.$row['id'].'">'.congestionOutputLinks($rec).'</div>' : '').
             ($row['date'] != 0 && validateDate($row['date'].' '.$row['end'], 'Y-m-d H:i') < time() ? '<div class="forbidden">Недействительный бонус!</div>' : '').'
            <div class="butt2">
            <a href="?edit='.$row['id'].'">Редактировать</a>
            <a href="?del='.$row['id'].'">Удалить</a>
            </div>
            </div>';

        }

        $page->navigation();

    }

    echo '<div class="title">Новый бонус</div>';

    if (isset($_POST['submit'])) {
        $error = '';
        if (empty($_POST['min']) || empty($_POST['max'])) {
            $error.= 'Укажите бонус!<br/>';
        }
        elseif ($_POST['min'] < 0.01 || $_POST['max'] < 0.01) {
            $error.= 'Бонус не может быть меньше 0.01!<br/>';
        }
        elseif ($_POST['min'] > $_POST['max']) {
            $error.= 'Мин. бонус не может быть больше макс. бонуса!<br/>';
        }
        if (empty($_POST['start']) || empty($_POST['end'])) {
            $error.= 'Укажите время включения и выключения бонуса!<br/>';
        }
        elseif (!validateDate($_POST['start'], 'H:i') || !validateDate($_POST['end'], 'H:i')) {
            $error.= 'Некорректный формат времени!<br/>';
        }
        elseif (validateDate($_POST['start'], 'H:i') > validateDate($_POST['end'], 'H:i')) {
            $error.= 'Включение бонуса должно быть раньше, чем выключение!<br/>';
        }
        if (!empty($_POST['comment']) && (mb_strlen($_POST['comment']) < 5 || mb_strlen($_POST['comment']) > 250)) {
            $error.= 'Комментарий к бонусу должен содержать от 5 до 250 символов!<br/>';
        }
        if (!empty($_POST['period']) && validateDate($_POST['date'], 'Y-m-d') < time()) {
            $error.= 'Некорректный формат даты!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {
            $limit = intval(abs($_POST['limit']));
            $min = floatval(abs($_POST['min']));
            $max = floatval(abs($_POST['max']));
            $date = empty($_POST['period']) ? 0 : $_POST['date'];
            $stmt = $connect->prepare("insert into `bonus` set `min` = ?, `max` = ?, `start` = ?, `end` = ?, `comment` = ?, `date` = ?, `limit` = ?");
            if ($stmt->execute(array($min, $max, $_POST['start'], $_POST['end'], $_POST['comment'], $date, $limit))) {
                header('Location: /adm/bonus');
            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }
        }
    }

    echo '<div class="menu">
    <form action"" method="POST">
    Бонус (Мин. и Макс.):<br/>
    <input type ="text" name="min" value="0.01" size="4">
    <input type ="text" name="max" value="0.05" size="4"><br/>
    Время включения и выключения: <small>(ЧЧ:ММ)</small><br/>
    <input type="text" name="start" value="00:00" size="5">
    <input type="text" name="end" value="23:59" size="5"><br/>
    Дневной лимит бонусов (0 - без ограничений):<br/><input type="text" name="limit" value="0"><br/>
    Комментарий к бонусу [5-250]:<br/><input type="text" name="comment"><br/>
    Период:<br/>
    <select id="add" name="period">
    <option value="0">Каждый день</option>
    <option value="1">Установить дату</option>
    </select><br/>
    <div id="date_a" style="display: none">
    Дата: <small>ГГГГ-ММ-ДД</small><br/><input type="date" name="date" min="'.date('Y-m-d').'">
    </div>
    <input type="submit" name="submit" value="Продолжить"><div class="chi">Бонусы указывайте в рублях.</div>
    </form></div>';

    ?>
    <script>
        $(function() {
            var add = $('#add');
            add.change(function() {
                if (add.val() == 1) {
                    $('#date_a').show();
                } else {
                    $('#date_a').hide();
                }
            });
        });
    </script>
    <?

} else {
    header ('location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>