<?php
$title = 'Задания';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (($adm_id == 1 || $adm_id == 5 || $adm_id == 6) && $sys['modules']['task'] == 1) {

    if ($adm_id == 1) {

        echo '<div class="title">Настройки</div>';

        if (isset($_POST['settings'])) {
 
            $error = '';

            if (empty($_POST['tlast'])) {
                $error.= 'Укажите максимальное время отсуствия автора!<br/>';
            }
            if (empty($_POST['tcena'])) {
                $error.= 'Укажите минимальную цену выполнения задания!<br/>';
            }
            elseif ($_POST['tcena'] < 0.01) {
                $error.= 'Минимальная цена выполнения задания не может быть меньше 0.01!<br/>';
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $sys['system']['tlast'] = ceil(abs($_POST['tlast']));
                $sys['system']['tcena'] = floatval(abs($_POST['tcena']));
                $sys['modules']['mod_t'] = intval($_POST['mod_t']);

                write_ini_file(FILE_CONFIG, $sys);

                header('Location: /adm/task');

            }

        }

        echo '<div class="menu">
        <form action="" method="POST">
        Автомодерация заданий:<br/><select name="mod_t"><option value="1">Вкл.</option><option '.($sys['modules']['mod_t'] == 3 ? 'selected' : '').' value="3">Откл.</option></select><br/>
        Максимальное время отсуствия автора (в днях):<br/><input type="text" name="tlast" value="'.$sys['system']['tlast'].'"><br/>
        Минимальная цена выполнения задания:<br/><input type="text" name="tcena" value="'.$sys['system']['tcena'].'"><br/>
        <input type="submit" name="settings" value="Сохранить">
        </form></div>';

    }

    echo '<div class="title">Массовое пополнение баланса заданий</div>';

    if (isset($_POST['bs_active'])) {

        $col = intval($_POST['col']);
        $bs_min = intval(abs($_POST['bs_min']));
        $status = isset($_POST['active']) ? 1 : RS_ALL_CHARS;

        $bs_num = $connect->prepare("select count(*) from `task` where `status` rlike ? and `col` >= ?");
        $bs_num->execute(array($status, $bs_min));
        $count_bs = $bs_num->fetchColumn();

        $error = '';

        if ($count_bs == 0) {
            $error.= 'Заданий не найдено!<br/>';
        }
        elseif (empty($col)) {
            $error.= 'Введите количество переходов!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {
            $stmt = $connect->prepare("update `task` set `col` = `col` + ? where `status` rlike ? and `col` >= ?");
            if ($stmt->execute(array($col, $status, $bs_min))) {
                header('Location: /adm/task');
            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }
        }
    }
    echo '<div class="menu">
    <form action="" method="POST">
    Количество выполнений:<br/><input type="text" name="col"><br/>
    При условии, что нынешний баланс не меньше:<br/><input type="text" name="bs_min" value="1"><br/>
    <input type="submit" name="bs_active" value="Пополнить"/><input type="checkbox" checked name="active" value="1">Только активным
    </form></div>';

    echo '<div class="title">Задания ('.$all_tasks . $new_mod_task.')</div> 
    <div class="menu">
    <form action="" method="GET">
    <input type="text" name="search" value="'.$search.'">
    <input type="submit" value="Поиск">
    </form></div>';

    $stmt_ans = $connect->prepare("select count(*) from `task_ans` where `status` = ? and `tid` = ?");
    $num_u = $connect->prepare("select count(*) from `task` where `id` = ?");
    $strow = $connect->prepare("select * from `task` where `id` = ?");

    if ($adm_id == 1) {
        if (isset($_GET['edit'])) {
            $num_u->execute(array($_GET['edit']));
            if ($num_u->fetchColumn()) {
                $strow->execute(array($_GET['edit']));
                $row = $strow->fetch();
                if (isset($_POST['cancel'])) {
                    header ('location: /adm/task');
                }
                elseif (isset($_POST['red'])) {

                    $row_u = user($_POST['login'], 1);

                    $error = '';

                    if (empty($_POST['login'])) {
                        $error.= 'Введите логин пользователя!<br/>';
                    }
                    elseif (!$row_u) {
                        $error.= 'Пользователь с таким логином не найден в системе!<br/>';
                    }
                    if (empty($_POST['name'])) {
                        $error.= 'Введите название!<br/>';
                    }
                    elseif (mb_strlen($_POST['name']) < 5 || mb_strlen($_POST['name']) > 250) {
                        $error.= 'Название должно содержать от 5 до 250 символов!<br/>';
                    }
                    if (empty($_POST['text'])) {
                        $error.= 'Введите требования по выполнению задания!<br/>';
                    }
                    elseif (mb_strlen($_POST['text']) < 15 || mb_strlen($_POST['text']) > 15000) {
                        $error.= 'Требования должны содержать от 15 до 15000 символов!<br/>';
                    }
                    if (empty($_POST['cena'])) {
                        $error.= 'Введите цену выполнения!<br/>';
                    }
                    elseif ($_POST['cena'] < $sys['system']['tcena']) {
                        $error.= 'Минимальная цена выполнения - '.rub($sys['system']['tcena']).'!<br/>';
                    }
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {
                        $cena = floatval($_POST['cena']);
                        $stmt = $connect->prepare("update `task` set `name` = ?, `text` = ?, `cena` = ?, `uid` = ? where `id` = ?");
                        if ($stmt->execute(array($_POST['name'], $_POST['text'], $cena, $row_u['id'], $_GET['edit']))) {
                            header ('location: /adm/task');
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                }
                echo '<div class="menu">
                <form action="" method="POST">
                Название [5-250]:<br/><input type="text" name="name" value="'.$row['name'].'"><br/>
                Требования [15-15000]:<br/><textarea name="text" rows="3" cols="20">'.$row['text'].'</textarea><br/>
                Цена выполнения:<br/><input type="text" name="cena" value="'.$row['cena'].'"><br/>
                Пользователь:<br/><input type="text" name="login" value="'.user($row['uid'])['login'].'"><br/>
                <input type="submit" name="red" value="Сохранить ('.intval($_GET['edit']).')">
                <input type="submit" name="cancel" value="Отмена">
                </form></div>';
            } else {
                header ('location: /adm/task');
            }
        }
        elseif (isset($_GET['del'])) {
            $num_u->execute(array($_GET['del']));
            if ($num_u->fetchColumn()) {
                if (isset($_POST['yes'])) {
                    $strow->execute(array($_GET['del']));
                    $row = $strow->fetch();
                    $del = $connect->prepare("delete from `task` where `id` = ?");
                    if ($del->execute(array($_GET['del'])) &&
                        Comments::DelMess($_GET['del'], 4)) {
                        if (isset($_POST['moneyback']))
                            pay($row['col'] * $row['cena'], $row['uid']);
                        header('Location: /adm/task');
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
                elseif (isset($_POST['no'])) {
                    header('Location: /adm/task');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="checkbox" checked name="moneyback" value="1" >С возвратом средств<br/>
                <input type="submit" name="yes" value="Удалить ('.intval($_GET['del']).')"/>
                <input type="submit" name="no" value="Отмена"/>
                </form></div>';
            } else {
                header('Location: /adm/task');
            }
        }
        elseif (isset($_GET['bs'])) {
            $num_u->execute(array($_GET['bs']));
            if ($num_u->fetchColumn()) {
                $strow->execute(array($_GET['bs']));
                $row = $strow->fetch();
                if (isset($_POST['yes'])) {
                    $error = '';
                    if (empty($_POST['col'])) {
                        $error.= 'Введите количество выполнений!<br/>';
                    }
                    elseif (!is_numeric($_POST['col'])) {
                        $error.= 'Неверное значение!<br/>';
                    }
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {
                        $col = intval($_POST['col']);
                        $stmt = $connect->prepare("update `task` set `col` = `col` + ? where `id` = ?");
                        if ($stmt->execute(array($col, $_GET['bs']))) {
                            header('Location: /adm/task');
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                }
                elseif (isset($_POST['no'])) {
                    header('Location: /adm/task');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                Количество выполнений:<br/><input type="text" name="col" value="'.($row['memory'] > 0 ? $row['memory'] : '').'"><br/>
                <input type="submit" name="yes" value="Пополнить ('.intval($_GET['bs']).')"/> 
                <input type="submit" name="no" value="Отмена"/>
                </form></div>';
            } else {
                header('Location: /adm/task');
            }
        }
    }

    if (isset($_GET['ban'])) {
        $num_u->execute(array($_GET['ban']));
        if ($num_u->fetchColumn()) {
            $strow->execute(array($_GET['ban']));
            $row = $strow->fetch();
            if (isset($_POST['done']) || isset($_POST['block'])) {
                $status = isset($_POST['block']) ? 2 : 1;
                $stmt = $connect->prepare("update `task` set `status` = ? where `id` = ?");
                if ($stmt->execute(array($status, $_GET['ban']))) {
                    notification('Ваше задание (ID: '.$row['id'].') '.($status == 2 ? '[color=red]заблокировано[/color]' : '[color=green]активировано[/color]'), $row['uid']);
                    header('Location: /adm/task');
                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
            elseif (isset($_POST['cancel'])) {
                header('Location: /adm/task');
            }

            echo '<div class="menu">
            <form action="" method="POST">
            ID: '.intval($_GET['ban']).'<hr/>
           '.($row['status'] != 1 ? '<input type="submit" name="done" value="Активировать">' : '').
             ($row['status'] != 2 ? '<input type="submit" name="block" value="Заблокировать">' : '').'
            <input type="submit" name="cancel" value="Отмена"/>
            </form></div>';
        } else {
            header('Location: /adm/task');
        }
    }

    $keywords = $search ? preg_replace("/[\s,]+/", "|", $search) : RS_ALL_CHARS;

    $stmt_num = $connect->prepare("select count(*) from `task` where `text` rlike :keywords or `name` rlike :keywords or `uid` rlike :keywords");
    $stmt_num->bindValue(':keywords', $keywords);
    $stmt_num->execute();
    $count_res = $stmt_num->fetchColumn();

    if ($count_res == 0) {
        echo '<div class="menu">NONE</div>';
    } else {

        $page = new Pagination($count_res, 10);

        if ($search) {

            $page->setLink('?search=' . $search . '&');

            echo '<div class="menu">Найдено по запросу: '.$count_res.'</div>';

        }

        $data = $connect->prepare("select * from `task` where `text` rlike :keywords or `name` rlike :keywords or `uid` rlike :keywords order by `status` desc, `col` desc, `id` desc limit :start, 10");
        $data->bindValue(':keywords', $keywords);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            // в обработке
            $stmt_ans->execute(array(0, $row['id']));
            $answers = $stmt_ans->fetchColumn();
            // выполнено
            $stmt_ans->execute(array(1, $row['id']));
            $success = $stmt_ans->fetchColumn();
            // не выполнено
            $stmt_ans->execute(array(2, $row['id']));
            $fails = $stmt_ans->fetchColumn();

            echo '<div class="menu">
            ID: '.$row['id'].'<br/>
            Название: '.$row['name'].'<br/>
            Требования: '.smiles(bb(bblinks($row['text']))).'<br/>
            Баланс: '.$row['col'].'<br/>
            Статус: '.($row['status'] == 1 ? 'Включено' : 'Отключено').'<br/>
            Выполнений: [<font color="#4cae4c">'.$success.'</font>|<font color="#eea236">'.$answers.'</font>]|<font color="#d8544f">'.$fails.'</font>]<br/>
            Дата добавления: '.daytime($row['time']).'<br/>
            Пользователь: '.profileLink($row['uid']).'<br/>
            <div class="chi">Цена выполнения: '.rub($row['cena']).'</div>
            '.($row['status'] == 3 ? '<div class="information">На модерации!</div>' : ($row['status'] == 2 ? '<div class="danger">Задание заблокировано!</div>' : '')).'
            <div class="butt2">
            '.($adm_id == 1 ? '<a href="?del='.$row['id'].'">Удалить</a>
            <a href="?edit='.$row['id'].'">Редактировать</a>
            <a href="?ban='.$row['id'].'">Модерация</a><br/>
            <a href="?bs='.$row['id'].'">Пополнить баланс</a>' : '').'
            <a href="/task/ans/'.$row['id'].'">Проверка выполнения</a>
            </div> 
            </div>';

        }

        $page->navigation();

    }

} else {
    header ('location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>