<?php

/* Комментарии */

class Comments {

    // Настройки и т. п.
    public $sys, $connect, $user;

    // установки
    public $count_comm;
    private $did, $type, $author, $adm, $redirect;

    function __construct($did, $type, $author, $adm, $redirect, $title = 'Комментарии') {

        global $sys, $connect, $user;

        // установки
        $this->did = $did;
        $this->type = $type;
        // автор темы и т. п.
        $this->author = $author;
        // Доступ для админки
        $this->adm = $adm;
        // Адрес перенаправления
        $this->redirect = $redirect;

        // Настройки
        $this->sys = $sys;
        $this->connect = $connect;

        // Юзер
        if (isset($user))
            $this->user = $user;

        // количество комментариев
        $this->count_comm = self::CountMess($did, $type);

        // Заголовок
        echo '<div class="title">'.$title.' ('.$this->count_comm.')</div>';

    }

    /* Удаление комментария */

    public static function Del($id) {

        global $connect;

        $del_comm = $connect->prepare("delete from `comments` where `id` = ?");

        $file = GlobFiles::findById($id, GlobFiles::Files, GlobFiles::MaskComment);

        if ($file) // чистим мусор
            unlink($file);

        return $del_comm->execute(array($id)); // удаляем сообщение

    }

    /* Удаление старых комментариев */

    public static function DelOldMess($did, $type, $date) {

        global $connect;

        /* Чистим мусор и удаляем сообщения */

        $data = $connect->prepare("select * from `comments` where `did` = :did and type = :type and `date` < :date order by `id` desc");
        $data->bindValue(':did', $did, PDO::PARAM_INT);
        $data->bindValue(':type', $type, PDO::PARAM_INT);
        $data->bindValue(':date', $date, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row)
            self::Del($row['id']);

        return true;

    }

    /* Удаление комментариев юзера */

    public static function DelUserMess($uid) {

        global $connect;

        $data = $connect->prepare("select * from `comments` where `uid` = :uid order by `id` desc");
        $data->bindValue(':uid', $uid, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row)
            self::Del($row['id']);

        return true;

    }

    /* Удаление комментариев */

    public static function DelMess($did, $type) {

        global $connect;

        $data = $connect->prepare("select * from `comments` where `did` = :did and `type` = :type order by `id` desc");
        $data->bindValue(':did', $did, PDO::PARAM_INT);
        $data->bindValue(':type', $type, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row)
            self::Del($row['id']);

        return true;

    }

    /* Удаление комментариев во всем разделе */

    public static function AllDelMess($type) {

        global $connect;

        $data = $connect->prepare("select * from `comments` where `type` = :type order by `id` desc");
        $data->bindValue(':type', $type, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row)
            self::Del($row['id']);

        return true;

    }

    /* Количество комментариев */

    public static function CountMess($did, $type) {

        global $connect;

        $stmt_comm = $connect->prepare("select count(*) from `comments` where `did` = ? and `type` = ?");
        $stmt_comm->execute(array($did, $type));
        $count_comm = $stmt_comm->fetchColumn();

        return $count_comm;

    }

    /* Количество комментариев во всем разделе */

    public static function AllMess($type) {

        global $connect;

        $stmt_comm = $connect->prepare("select count(*) from `comments` where `type` = ?");
        $stmt_comm->execute(array($type));
        $count_comm = $stmt_comm->fetchColumn();

        return $count_comm;

    }

    /* Количество новых комментариев */

    public static function NewMess($did, $type, $time = false, $me = 0) {

        global $connect;

        if (!$time)
             $time = mktime(0, 0, 0);

        $stmt_comm = $connect->prepare("select count(*) from `comments` where `did` = ? and `type` = ? and `date` > ? and `uid` != ?");
        $stmt_comm->execute(array($did, $type, $time, $me));
        $count_comm = $stmt_comm->fetchColumn();

        return $count_comm;

    }

    /* Количество новых комментариев во всем разделе */

    public static function AllNewMess($type, $time = false, $me = 0) {

        global $connect;

        if (!$time)
             $time = mktime(0, 0, 0);

        $stmt_comm = $connect->prepare("select count(*) from `comments` where `type` = ? and `date` > ? and `uid` != ?");
        $stmt_comm->execute(array($type, $time, $me));
        $count_comm = $stmt_comm->fetchColumn();

        return $count_comm;

    }

    /* Форма ввода */

    public function InsertForm($insert_notif, $cit_notif, $ans_notif, $attach = false) {

        if (isset($this->user)) {

            SmilesAndBB();

            // prepared
            $strow = $this->connect->prepare("select * from `comments` where `id` = ? and `type` = ? and `did` = ?");
            $in_comment = $this->connect->prepare("insert into `comments` set `date` = ?, `uid` = ?, `text` = ?, `did` = ?, `type` = ?");

            if (isset($_GET['file'])) {
                $strow->execute(array($_GET['file'], $this->type, $this->did));
                $row = $strow->fetch();
                $file = GlobFiles::findById($_GET['file'], GlobFiles::Files, GlobFiles::MaskComment);
                if ($row && ($this->adm || $row['uid'] == $this->user['id']) && $file) {
                    if (isset($_POST['yes'])) {
                        unlink($file);
                        header('Location: '.$this->redirect);
                    }
                    elseif (isset($_POST['no'])) {
                        header('Location: '.$this->redirect);
                    }
                    echo '<div class="menu">
                    <form action="" method="POST">
                    <input type="submit" name="yes" value="Удалить файл ('.basename($file).')"/>
                    <input type="submit" name="no" value="Отмена"/>
                    </form></div>';
                } else {
                    header('Location: '.$this->redirect);
                }
            }
            elseif (isset($_GET['edit'])) {
                $strow->execute(array($_GET['edit'], $this->type, $this->did));
                $row = $strow->fetch();
                if ($row && $row['read'] == 0 && $row['uid'] == $this->user['id']) {
                    $file = GlobFiles::findById($_GET['edit'], GlobFiles::Files, GlobFiles::MaskComment);
                    if (isset($_POST['yes'])) {
                        $error = '';
                        if (empty($_POST['text'])) {
                            $error.= 'Введите сообщение!<br/>';
                        }
                        elseif (mb_strlen($_POST['text']) < 2 || mb_strlen($_POST['text']) > 2500) {
                            $error.= 'Текст должен содержать не менее 2 символов и не более 2500 символов!<br/>';
                        }
                        if ($attach && file_exists($_FILES['filename']['tmp_name'])) {
                            if (!BeforeUpload::AttachIMG($_FILES['filename'])) {
                                $error.= 'Неверный тип файла!<br/>';
                            }
                            if ($_FILES['filename']['size'] > $this->sys['system']['upload_chat']) {
                                $error.= 'Максимальный размер файла - '.byte_conv($this->sys['system']['upload_chat']).'!<br/>';
                            }
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {
                            $stmt = $this->connect->prepare("update `comments` set `text` = ? where `id` = ?");
                            if ($stmt->execute(array($_POST['text'], $_GET['edit']))) {
                                // Загрузка файла
                                if ($attach && file_exists($_FILES['filename']['tmp_name'])) {
                                    $files = $_GET['edit']."_comment_".random_int(11111, 99999)."_".$_FILES['filename']['name'];
                                    move_uploaded_file($_FILES['filename']['tmp_name'], $_SERVER["DOCUMENT_ROOT"]."/files/".$files);
                                    if ($file)
                                        unlink($file);
                                }
                                header('Location: '.$this->redirect);
                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }
                    }
                    elseif (isset($_POST['no'])) {
                        header('Location: '.$this->redirect);
                    }
                    echo '<div class="menu">
                    <form action="" method="POST" enctype="multipart/form-data">
                    Сообщение:<br/><textarea data-select-range id="message" name="text" rows="5" cols="25">'.$row['text'].'</textarea><br/>
                    '.($attach ? 'Прикрепить изображение:<br/><input type="file" name="filename"><br/>
                    '.($file ? 'Старое изображение: '.iconFile($file).'<a data-noajax href="/files/'.basename($file).'">'.basename($file).'</a> ('.get_filesize($file).')<br/>' : '') : '').'
                    <input type="submit" name="yes" value="Сохранить ('.intval($_GET['edit']).')"/>
                    <input type="submit" name="no" value="Отмена"/>
                    </form></div>';
                } else {
                    header('Location: '.$this->redirect);
                }
            }
            elseif (isset($_GET['cit'])) {
                $strow->execute(array($_GET['cit'], $this->type, $this->did));
                $row = $strow->fetch();
                if ($row) {
                    $file = GlobFiles::findById($_GET['cit'], GlobFiles::Files, GlobFiles::MaskComment);
                    $cit = str_replace(['[cit]', '[/cit]'], null, '[u]'.(($row_u = user($row['uid'])) ? $row_u['login'] : 'DELETED').'[/u] ('.date('d.m.Y H:i', $row['date']).')[br]'.$row['text'].($file ? '[br]Файл: [url='.ROOT.'/files/'.basename($file).']'.basename($file).'[/url] ('.get_filesize($file).')' : ''));
                    if (isset($_POST['yes'])) {
                        $error = '';
                        if ($this->user['datereg'] > time() - 60 * $this->sys['system']['fludtime'] && $this->user['admin'] == 0) {
                            $error.= 'Для возможности отправлять сообщения с момента регистрации должно пройти: '.restime(60 * $this->sys['system']['fludtime']).'!<br/>';
                        }
                        elseif (isset($_SESSION['guest_add']) && $_SESSION['guest_add'] > time() - $this->sys['system']['antiflud']) {
                            $error.= 'Антифлуд! Лимит - '.quantDec($this->sys['system']['antiflud'], ['секунда', 'секунды', 'секунд']).'!<br/>';
                        }
                        elseif (mb_strlen($_POST['text']) > 2500) {
                            $error.= 'Текст должен содержать не более 2500 символов!<br/>';
                        }
                        if ($attach && file_exists($_FILES['filename']['tmp_name'])) {
                            if (!BeforeUpload::AttachIMG($_FILES['filename'])) {
                                $error.= 'Неверный тип файла!<br/>';
                            }
                            if ($_FILES['filename']['size'] > $this->sys['system']['upload_chat']) {
                                $error.= 'Максимальный размер файла - '.byte_conv($this->sys['system']['upload_chat']).'!<br/>';
                            }
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {
                            $message = '[cit]'.$cit.'[/cit][br]'.$_POST['text'];
                            if ($in_comment->execute(array(time(), $this->user['id'], $message, $this->did, $this->type))) {
                                // Загрузка файла
                                if ($attach && file_exists($_FILES['filename']['tmp_name'])) {
                                    $lid = $this->connect->LastInsertId();
                                    $files = $lid."_comment_".random_int(11111, 99999)."_".$_FILES['filename']['name'];
                                    move_uploaded_file($_FILES['filename']['tmp_name'], $_SERVER["DOCUMENT_ROOT"]."/files/".$files);
                                }
                                if ($this->author && $this->author != $this->user['id'])
                                    notification($insert_notif, $this->author);
                                if ($row['uid'] != $this->user['id'] && $row['uid'] != $this->author)
                                    notification($cit_notif, $row['uid']);
                                ratingUser($this->sys['rating']['chat'], $this->user['id']);
                                $_SESSION['guest_add'] = time();
                                header('Location: '.$this->redirect);
                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }
                    }
                    elseif (isset($_POST['no'])) {
                        header('Location: '.$this->redirect);
                    }
                    echo '<div class="menu">
                    <form action="" method="POST" enctype="multipart/form-data">
                    <div class="cit">'.nl2br(smiles(bb(bblinks($cit)))).'</div>
                    Сообщение:<br/><textarea data-select-range id="message" name="text" rows="5" cols="25"></textarea><br/>
                    '.($attach ? 'Прикрепить изображение:<br/><input type="file" name="filename"><br/>' : '').'
                    <input type="submit" name="yes" value="Цитировать ('.intval($_GET['cit']).')"/>
                    <input type="submit" name="no" value="Отмена"/>
                    </form></div>';
                } else {
                    header('Location: '.$this->redirect);
                }
            } else {
                if (isset($_POST['refresh'])) {
                    header('Location: '.$this->redirect);
                }
                elseif (isset($_POST['addmess'])) {
                    $error = '';
                    if ($this->user['datereg'] > time() - 60 * $this->sys['system']['fludtime'] && $this->user['admin'] == 0) {
                        $error.= 'Для возможности отправлять сообщения с момента регистрации должно пройти: '.restime(60 * $this->sys['system']['fludtime']).'!<br/>';
                    }
                    elseif (isset($_SESSION['guest_add']) && $_SESSION['guest_add'] > time() - $this->sys['system']['antiflud']) {
                        $error.= 'Антифлуд! Лимит - '.quantDec($this->sys['system']['antiflud'], ['секунда', 'секунды', 'секунд']).'!<br/>';
                    }
                    elseif (empty($_POST['text'])) {
                        $error.= 'Введите сообщение!<br/>';
                    }
                    elseif (mb_strlen($_POST['text']) < 2 || mb_strlen($_POST['text']) > 2500) {
                        $error.= 'Текст должен содержать не менее 2 символов и не более 2500 символов!<br/>';
                    }
                    if ($attach && file_exists($_FILES['filename']['tmp_name'])) {
                        if (!BeforeUpload::AttachIMG($_FILES['filename'])) {
                            $error.= 'Неверный тип файла!<br/>';
                        }
                        if ($_FILES['filename']['size'] > $this->sys['system']['upload_chat']) {
                            $error.= 'Максимальный размер файла - '.byte_conv($this->sys['system']['upload_chat']).'!<br/>';
                        }
                    }
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {
                        if ($in_comment->execute(array(time(), $this->user['id'], $_POST['text'], $this->did, $this->type))) {
                            // Загрузка файла
                            if ($attach && file_exists($_FILES['filename']['tmp_name'])) {
                                $lid = $this->connect->LastInsertId();
                                $files = $lid."_comment_".random_int(11111, 99999)."_".$_FILES['filename']['name'];
                                move_uploaded_file($_FILES['filename']['tmp_name'], $_SERVER["DOCUMENT_ROOT"]."/files/".$files);
                            }
                            if ($this->author && $this->author != $this->user['id'])
                                notification($insert_notif, $this->author);
                            if (isset($_GET['ans']) && user($_GET['ans']) && $_GET['ans'] != $this->user['id'] && $_GET['ans'] != $this->author)
                                notification($ans_notif, $_GET['ans']);
                            ratingUser($this->sys['rating']['chat'], $this->user['id']);
                            $_SESSION['guest_add'] = time();
                            header('Location: '.$this->redirect);
                        } else {
                            echo '<div class="menu">Ошибка при добавлении сообщения!</div>';
                        }
                    }
                }
                echo '<div class="menu">
                <form action="" method="POST" enctype="multipart/form-data">
                Сообщение:<br/><textarea data-select-range id="message" name="text" rows="5" cols="25">'.(isset($_GET['ans']) && ($row_u = user($_GET['ans'])) && $_GET['ans'] != $this->user['login'] ? '[b]'.$row_u['login'].'[/b], ' : '').'</textarea><br/>
                '.($attach ? 'Прикрепить изображение:<br/><input type="file" name="filename"><br/>' : '').'
                <input type="submit" name="addmess" value="Написать"/>
                <input type="submit" name="refresh" value="Обновить">
                </form></div>';

            }

        }

    }

    /* Для модератора */

    public function moder() {

        // prepared
        $stmt_num = $this->connect->prepare("select count(*) from `comments` where `id` = ? and `type` = ? and `did` = ?");

        if ($this->adm) {
            if (isset($_GET['del'])) {
                $stmt_num->execute(array($_GET['del'], $this->type, $this->did));
                if ($stmt_num->fetchColumn()) {
                    if (isset($_POST['yes'])) {
                        if (self::Del($_GET['del'])) {
                            header('Location: '.$this->redirect);
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                    elseif (isset($_POST['no'])) {
                        header('Location: '.$this->redirect);
                    }
                    echo '<div class="menu">
                    <form action="" method="POST">
                    <input type="submit" name="yes" value="Удалить ('.intval($_GET['del']).')"/>
                    <input type="submit" name="no" value="Отмена"/>
                    </form></div>';
                } else {
                    header('Location: '.$this->redirect);
                }
            }
            elseif ($this->count_comm > 0) {
                if (isset($_GET['clear'])) {
                    if (isset($_POST['yes'])) {
                        if (self::DelMess($this->did, $this->type)) {
                            header('Location: '.$this->redirect);
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                    elseif (isset($_POST['no'])) {
                        header('Location: '.$this->redirect);
                    }
                    echo '<div class="menu">
                    <form action="" method="POST">
                    <input type="submit" name="yes" value="Подтвердить очистку комментариев"/>
                    <input type="submit" name="no" value="Отмена"/>
                    </form></div>';
                } else {
                    echo '<div class="forlink"><a href="?clear" class="links"><img src="/img/clear.png" alt="clear">Очистить комментарии</a></div>'; 
                }
            }
        }

    }

    /* Вывод комментариев */

    public function output() {

        if ($this->count_comm == 0) {
            echo '<div class="menu">Комментариев нет!</div>';
        } else {

            // прочитано кем-то
            $read = $this->connect->prepare("update `comments` set `read` = ? where `did` = ? and `type` = ? and `read` = ? and `uid` != ?");
            $read->execute(array(1, $this->did, $this->type, 0, ($this->user['id'] ?? 0)));

            $page = new Pagination($this->count_comm, 10);

            $data = $this->connect->prepare("select * from `comments` where `did` = :did and `type` = :type order by `id` desc limit :start, 10");
            $data->bindValue(':did', $this->did, PDO::PARAM_INT);
            $data->bindValue(':type', $this->type, PDO::PARAM_INT);
            $data->bindValue(':start', $page->start, PDO::PARAM_INT);
            $data->execute();
            $sql = $data->fetchAll();

            foreach ($sql as $row) {

                $file = GlobFiles::findById($row['id'], GlobFiles::Files, GlobFiles::MaskComment);

                $row_u = user($row['uid']);

                echo '<div class="menu">'.profileLink($row_u).' ('.daytime($row['date']).')<span class="online">'.online($row['uid']).'</span>
                <div class="butt1">
                '.(isset($this->user) ? ($row_u && $row_u['id'] != $this->user['id'] ? '<a href="?ans='.$row_u['id'].'">Отв.</a>' : '').'
                <a href="?cit='.$row['id'].'">Цит.</a>
                '.($row['read'] == 0 && $row['uid'] == $this->user['id'] ? '<a href="?edit='.$row['id'].'">Ред.</a>' : '') : '').
                ($this->adm ? '<a href="?del='.$row['id'].'">Уд.</a>' : '').'
                </div><hr/>'.nl2br(smiles(bb(bblinks($row['text'])))).
                ($file ? '<hr/>Файл: '.iconFile($file).'<a data-noajax href="/files/'.basename($file).'">'.basename($file).'</a> ('.get_filesize($file).')'.($this->adm || (isset($this->user) && $row['uid'] == $this->user['id']) ? '<a href="?file='.$row['id'].'"><img src="/img/delete.png" alt="delete"></a>' : '') : '').'</div>';

            }

            $page->navigation();

        }

    }

}