<?php

// Лайки

class Respect {

    // Настройки и т. п.
    public $connect, $user;

    // установки
    public $plus, $minus, $respect, $userLike = false;
    private $to, $type;

    function __construct($to, $type) {

        global $connect, $user;

        // установки
        $this->to = $to;
        $this->type = $type;

        // Настройки
        $this->connect = $connect;

        // Юзер
        if (isset($user)) {

            $this->user = $user;

            /* Что поставил юзер? */

            $strow = $this->connect->prepare("select * from `respect` where `from` = ? and `to` = ? and `type` = ?");
            $strow->execute(array($this->user['id'], $this->to, $this->type));
            $this->userLike = $strow->fetch();

        }

        /* Лайки */

        $like = $this->connect->prepare("select count(*) from `respect` where `to` = ? and `type` = ? and `review` = ?");

        $like->execute(array($this->to, $this->type, 1));
        $this->plus = $like->fetchColumn();

        $like->execute(array($this->to, $this->type, 0));
        $this->minus = $like->fetchColumn();

        $this->respect = $this->plus - $this->minus;

    }

    /* Оценка */

    public function Like($like = true) {

        if (isset($this->user)) {

            $review = $like ? 1 : 0;

            if ($this->user['id'] == $this->to)

                return false; // Ставить лайки самому себе нельзя :)

            if ($this->userLike) {

                if ($this->userLike['review'] == $review) {

                    /* Убираем оценку */

                    $remove = $this->connect->prepare("delete from `respect` where `from` = ? and `to` = ? and `type` = ?");

                    return $remove->execute(array($this->user['id'], $this->to, $this->type));

                } else {

                    /* Меняем оценку */

                    $reLike = $this->connect->prepare("update `respect` set `review` = ? where `from` = ? and `to` = ? and `type` = ?");

                    return $reLike->execute(array($review, $this->user['id'], $this->to, $this->type));

                }

            } else {

                /* Ставим оценку */

                $like = $this->connect->prepare("insert into `respect` set `from` = ?, `to` = ?, `type` = ?, `review` = ?");

                return $like->execute(array($this->user['id'], $this->to, $this->type, $review));

            }

        } else
            return false;

    }

    /* Вывод счетчиков и кнопок */

    public function OutputLikes($like = '?respect=1', $dislike = '?respect=0', $return = true) {

        $output = '<div class="butt9">
                   <a href="'.$like.'">
                       '.($this->userLike && $this->userLike['review'] == 1 ? '<span class="wa-span-green"><img src="/img/thumb-up.png" alt="thumb-up">'.$this->plus.'</span>' : '<span class="wa-span-gray"><img src="/img/thumb-up-nc.png" alt="thumb-up-nc">'.$this->plus.'</span>').'
                   </a>
                   <a href="'.$dislike.'">
                       '.($this->userLike && $this->userLike['review'] == 0 ? '<span class="wa-span-red"><img src="/img/thumb-down.png" alt="thumb-down">'.$this->minus.'</span>' : '<span class="wa-span-gray"><img src="/img/thumb-down-nc.png" alt="thumb-down-nc">'.$this->minus.'</span>').'
                   </a>
                   </div>';

        if ($return) {

            return $output;

        } else {

            echo $output;

        }

    }

    /* Удаляем все лайки */

    public function removeLikes() {

        $removeLikes = $this->connect->prepare("delete from `respect` where `to` = ? and `type` = ?");

        return $removeLikes->execute(array($this->to, $this->type));

    }

    /* Удаляем все лайки, которые ставил юзер */

    public static function removeLikesFromUser($uid) {

        global $connect;

        $removeLikesFromUser = $connect->prepare("delete from `respect` where `from` = ?");

        return $removeLikesFromUser->execute(array($uid));

    }

}