<?php
// Изменение размера изображения
class SimpleImage {

    private $image, $image_type;
    public $width, $height;

    function __construct($filename = false) {

        if ($filename) {

            $this->load($filename);

        }

    }

    public function load($filename) {

        $image_info = getimagesize($filename);
        $this->image_type = $image_info[2];

        if ($this->image_type == IMAGETYPE_JPEG) {

            $this->image = imagecreatefromjpeg($filename);

        } elseif ($this->image_type == IMAGETYPE_GIF) {

            $this->image = imagecreatefromgif($filename);

        } elseif ($this->image_type == IMAGETYPE_PNG) {

            $this->image = imagecreatefrompng($filename);

        }

        $this->width = imagesx($this->image);
        $this->height = imagesy($this->image);

   }

    public function save($filename, $image_type = IMAGETYPE_JPEG, $compression = 75, $permissions = null) {

        if ($image_type == IMAGETYPE_JPEG) {

            imagejpeg($this->image, $filename, $compression);

        } elseif ($image_type == IMAGETYPE_GIF) {

            imagegif($this->image, $filename);

        } elseif ($image_type == IMAGETYPE_PNG) {

            imagepng($this->image, $filename);

        }

        if ($permissions != null) {

            chmod($filename, $permissions);

        }

    }

    public function output($image_type = IMAGETYPE_PNG) {

        if ($image_type == IMAGETYPE_JPEG) {

            header("Content-type: image/jpeg");

            imagejpeg($this->image);

        } elseif ($image_type == IMAGETYPE_GIF) {

            header("Content-type: image/gif");

            imagegif($this->image);

        } elseif ($image_type == IMAGETYPE_PNG) {

            header("Content-type: image/png");

            imagepng($this->image);

        }

    }

    public function resizeToHeight($height) {

        $ratio = $height / $this->height;
        $width = $this->width * $ratio;
        $this->resize($width, $height);

    }

    public function resizeToWidth($width) {

        $ratio = $width / $this->width;
        $height = $this->height * $ratio;
        $this->resize($width, $height);

    }

    public function scale($scale) {

        $width = $this->width * $scale / 100;
        $height = $this->height * $scale / 100;
        $this->resize($width, $height);

    }

    public function resize($width, $height) {

        $new_image = imagecreatetruecolor($width, $height);
        imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->width, $this->height);
        $this->image = $new_image;

    }

}