<?php

/* Голосования */

class Vote {

    // Настройки и т. п.
    public $sys, $connect, $user;

    // установки
    public $row, $count_choice, $choice, $count_ans;
    private $did, $type, $adm, $redirect;

    function __construct($did, $type, $adm, $redirect) {

        global $sys, $connect, $user;

        // установки
        $this->did = $did;
        $this->type = $type;
        // Доступ для админки
        $this->adm = $adm;
        // Адрес перенаправления
        $this->redirect = $redirect;

        // Настройки
        $this->sys = $sys;
        $this->connect = $connect;

        // Юзер
        if (isset($user))
            $this->user = $user;

        // Голосование
        $strow = $this->connect->prepare("select * from `vote` where `did` = ? and `type` = ?");
        $strow->execute(array($did, $type));
        $this->row = $strow->fetch();

        if (isset($this->user) && $this->row) {

            // Голоса
            $stmt_choices = $this->connect->prepare("select count(*) from `choice` where `vid` = ?");
            $stmt_choices->execute(array($this->row['id']));
            $this->count_choice = $stmt_choices->fetchColumn();

            // Голос юзера
            $stmt_choice = $this->connect->prepare("select * from `choice` where `uid` = ? and `vid` = ?");
            $stmt_choice->execute(array($this->user['id'], $this->row['id']));
            $this->choice = $stmt_choice->fetch();

            // Варианты ответа
            $stmt_ans = $this->connect->prepare("select count(*) from `answers` where `vid` = ?");
            $stmt_ans->execute(array($this->row['id']));
            $this->count_ans = $stmt_ans->fetchColumn();

        }

    }

    /* Список проголосовавших */

    public function WhoVoted($ans) {

        global $connect;

        if (!isset($this->row))
                        return false;

        $congestion = [];

        $data = $connect->prepare("select * from `choice` where `vid` = :vid and `ans` = :ans order by `id` desc");
        $data->bindValue(':vid', $this->row['id'], PDO::PARAM_INT);
        $data->bindValue(':ans', $ans, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            if (user($row['uid']))
                $congestion[] = $row['uid'];

        }

        return $congestion;

    }

    /* Удаление опроса */

    public static function Delete($did, $type) {

        global $connect;

        // Голосование
        $strow = $connect->prepare("select * from `vote` where `did` = ? and `type` = ?");
        $strow->execute(array($did, $type));
        $row = $strow->fetch();

        if ($row) {

            $del = $connect->prepare("delete from `vote` where `id` = ?");
            $del_ans = $connect->prepare("delete from `answers` where `vid` = ?");
            $del_choice = $connect->prepare("delete from `choice` where `vid` = ?");

            return ($del->execute(array($row['id'])) &&
                    $del_ans->execute(array($row['id'])) &&
                    $del_choice->execute(array($row['id'])));

        } else
            return true;

    }

    /* Вывод опроса */

    public function output() {

        // prepared
        $add_answer = $this->connect->prepare("insert into `answers` set `text` = ?, `vid` = ?");

        if ($this->row) {

            if (isset($this->user)) {

                // prepared
                $stmt_answer = $this->connect->prepare("select * from `answers` where `vid` = ? and `id` = ?");

                if ($this->adm) {
                    if ($this->count_choice == 0) {
                        if (isset($_GET['add_ans']) && $this->count_ans < 25) {
                            if (isset($_POST['cancel'])) {
                                header('Location: '.$this->redirect);
                            }
                            elseif (isset($_POST['add_ans'])) {
                                $error = '';
                                if (empty($_POST['ans'])) {
                                    $error.= 'Укажите варианты ответа!<br/>';
                                }
                                elseif (!is_array($_POST['ans'])) {
                                    $error.= 'Неверный формат данных!<br/>';
                                } else {
                                    foreach ($_POST['ans'] as $key => $value) {
                                        if (empty($value)) {
                                            unset($_POST['ans'][$key]);
                                            continue;
                                        }
                                        if (mb_strlen($value) < 2 || mb_strlen($value) > 250) {
                                            $error.= 'Один вариант ответа должен содержать не менее 2 и не более 250 символов!<br/>';
                                            break;
                                        }
                                    }
                                    if (count($_POST['ans']) < 1 || count($_POST['ans']) > 25 - $this->count_ans) {
                                        $error.= 'Количество вариантов должно быть не менее 1 и не более '.(25 - $this->count_ans).'!<br/>';
                                    }
                                }
                                if ($error) {
                                    echo '<div class="menu">'.$error.'</div>';
                                } else {
                                    foreach ($_POST['ans'] as $value)
                                        $add_answer->execute(array($value, $this->row['id']));
                                    header('Location: '.$this->redirect);
                                }
                            }
                            echo '<div class="menu">
                            <form action="" method="POST">
                            Варианты [2-250]:<br/>
                            <div id="inpContText">
                            <input type="text" name="ans[]" id="ans"><br/>
                            <input type="text" name="ans[]" id="ans"><br/>
                            </div>
                            <div class="butt1"><a href="javascript:AddAnswer()">Добавить еще</a></div><br/>
                            <input type="submit" name="add_ans" value="Добавить новые варианты">
                            <input type="submit" name="cancel" value="Отмена">
                            </form></div>';
                        }
                        elseif (isset($_GET['edit_ans'])) {
                            $stmt_answer->execute(array($this->row['id'], $_GET['edit_ans']));
                            $answer = $stmt_answer->fetch();
                            if ($answer) {
                                if (isset($_POST['cancel'])) {
                                    header('Location: '.$this->redirect);
                                }
                                elseif (isset($_POST['red'])) {
                                    $error = '';
                                    if (empty($_POST['ans'])) {
                                        $error.= 'Введите текст варианта!<br/>';
                                    }
                                    elseif (mb_strlen($_POST['ans']) < 2 || mb_strlen($_POST['ans']) > 250) {
                                        $error.= 'Текст варианта должен содержать не менее 2 и не более 250 символов!<br/>';
                                    }
                                    if ($error) {
                                        echo '<div class="menu">'.$error.'</div>';
                                    } else {
                                        $stmt = $this->connect->prepare("update `answers` set `text` = ? where `id` = ?");
                                        if ($stmt->execute(array($_POST['ans'], $_GET['edit_ans']))) {
                                            header('Location: '.$this->redirect);
                                        } else {
                                            echo '<div class="menu">Произошла ошибка!</div>';
                                        }
                                    }
                                }
                                echo '<div class="menu">
                                <form action="" method="POST">
                                Вариант ответа [2-250]:<br/><input type="text" name="ans" value="'.$answer['text'].'"><br/>
                                <input type="submit" name="red" value="Сохранить ('.intval($_GET['edit_ans']).')">
                                <input type="submit" name="cancel" value="Отмена">
                                </form></div>';
                            } else {
                                header('Location: '.$this->redirect);
                            }
                        }
                        elseif (isset($_GET['del_ans'])) {
                            $stmt_answer->execute(array($this->row['id'], $_GET['del_ans']));
                            $answer = $stmt_answer->fetch();
                            if ($answer && $this->count_ans > 2) {
                                if (isset($_POST['ok'])) {
                                    $del = $this->connect->prepare("delete from `answers` where `id` = ?");
                                    if ($del->execute(array($_GET['del_ans']))) { 
                                        header('Location: '.$this->redirect);
                                    } else {
                                        echo '<div class="menu">Произошла ошибка!</div>';
                                    }
                                }
                                elseif (isset($_POST['cancel'])) {
                                    header('Location: '.$this->redirect);
                                }
                                echo '<div class="menu">
                                <form action="" method="POST">
                                <input type="submit" name="ok" value="Удалить вариант ответа ('.intval($_GET['del_ans']).')">
                                <input type="submit" name="cancel" value="Отмена">
                                </form></div>';
                            } else {
                                header('Location: '.$this->redirect);
                            }
                        }
                        elseif (isset($_GET['edit_vote'])) {
                            if (isset($_POST['cancel'])) {
                                header('Location: '.$this->redirect);
                            }
                            elseif (isset($_POST['edit'])) {
                                $error = '';
                                if (empty($_POST['text'])) {
                                    $error.= 'Введите содержание опроса!<br/>';
                                }
                                elseif (mb_strlen($_POST['text']) < 5 || mb_strlen($_POST['text']) > 500) {
                                    $error.= 'Содержание опроса должно быть не меньше 5 и не больше 500 символов!<br/>';
                                }
                                if ($error) {
                                    echo '<div class="menu">'.$error.'</div>';
                                } else {
                                    $stmt = $this->connect->prepare("update `vote` set `text` = ?, `anon` = ? where `id` = ?");
                                    if ($stmt->execute(array($_POST['text'], isset($_POST['anon']) ? 1 : 0, $this->row['id']))) {
                                        header('Location: '.$this->redirect);
                                    } else {
                                        echo '<div class="menu">Произошла ошибка!</div>';
                                    }
                                }
                            }
                            echo '<div class="menu">
                            <form action="" method="POST">
                            Опрос [5-500]:<br/><input type="text" name="text" value="'.$this->row['text'].'"><br/>
                            <input type="checkbox" '.($this->row['anon'] == 1 ? 'checked' : '').' name="anon" value="1">Анонимное голосование<br/>
                            <input type="submit" name="edit" value="Сохранить">
                            <input type="submit" name="cancel" value="Отмена">
                            </form></div>';
                        }
                    }
                    if (isset($_GET['del_vote'])) {
                        if (isset($_POST['ok'])) {
                            if (self::Delete($this->did, $this->type)) {
                                header('Location: '.$this->redirect);
                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }
                        elseif (isset($_POST['cancel'])) {
                            header('Location: '.$this->redirect);
                        }
                        echo '<div class="menu">
                        <form action="" method="POST">
                        <input type="submit" name="ok" value="Удалить опрос">
                        <input type="submit" name="cancel" value="Отмена">
                        </form></div>';
                    }
                }

                echo '<div class="menu">
                <form action="" method="POST">
                <img src="/img/megaphone.png" alt="megaphone">'.$this->row['text'] . ($this->adm ? ($this->count_choice == 0 ? '<a href="?edit_vote"><img src="/img/edit.png" alt="edit"></a><a href="?add_ans"><img src="/img/add.png" alt="add"></a>' : '').'<a href="?del_vote"><img src="/img/del.png" alt="del"></a>' : '').'<br/>
                <div class="chi">'.($this->row['anon'] == 1 ? 'Анонимное голосование' : 'Открытое голосование').'</div>
                <div class="vote">';

                if (isset($_POST['vote']) && !$this->choice) {
                    $error = '';
                    $stmt_answer->execute(array($this->row['id'], $_POST['choice']));
                    $answer = $stmt_answer->fetch();
                    if (empty($_POST['choice'])) {
                        $error.= 'Вы ничего не выбрали!<br/>';
                    }
                    elseif (!$answer) {
                        $error.= 'Этого варианта нет!<br/>';
                    }
                    if ($error) {
                        echo '<div class="red">'.$error.'</div>';
                    } else {
                        $stmt = $this->connect->prepare("insert into `choice` set `uid` = ?, `ans` = ?, `vid` = ?");
                        if ($stmt->execute(array($this->user['id'], $_POST['choice'], $this->row['id']))) {
                            header('Location: '.$this->redirect);
                        } else {
                            echo '<div class="red">Произошла ошибка!</div>';
                        }
                    }
                }

                $data = $this->connect->prepare("select * from `answers` where `vid` = :vid order by `id`");
                $data->bindValue(':vid', $this->row['id'], PDO::PARAM_INT);
                $data->execute();
                $sql = $data->fetchAll();

                foreach ($sql as $row) {

                    $voted = $this->WhoVoted($row['id']);
                    $ans = count($voted);

                    $percent = $this->count_choice > 0 && $ans > 0 ? round($ans / $this->count_choice * 100) : 0; // процент

                    echo '<div class="bottom">
                    '.($this->choice ? ($this->choice['ans'] == $row['id'] ? '<img src="/img/radio-on.png" alt="radio-on">' : '<img src="/img/radio-off.png" alt="radio-off">') . $row['text'] : '<input type="radio" name="choice" value="'.$row['id'].'">'.$row['text']).
                      ($this->count_choice == 0 && $this->adm ?
                        '<a href="?edit_ans='.$row['id'].'"><img src="/img/edit.png" alt="edit"></a>
                        '.($this->count_ans > 2 ? '<a href="?del_ans='.$row['id'].'"><img src="/img/del.png" alt="del"></a>' : '') : '').
                      (($this->choice || $this->adm) ?
                        '<div class="chi">'.$ans.' ('.$percent.'%)</div>
                        '.($this->row['anon'] == 0 && $ans > 0 ?
                        '<a href="javascript:$(\'#voted_'.$row['id'].'\').slideToggle(500)"><img src="/img/peoples.png" alt="peoples"></a>
                         <div style="display: none" class="vote" id="voted_'.$row['id'].'">'.congestionOutputLinks($voted).'</div>' : '') : '').'
                     </div>';

                }

                if (!$this->choice)
                    echo '<input type="submit" name="vote" value="Голосовать">';

                if ($this->choice || $this->adm)
                    echo '<div class="chi">Проголосовало: '.$this->count_choice.'</div>';

                echo '</div></form></div>';

            } else
                echo '<div class="menu"><div class="information">Авторизуйтесь, чтобы увидеть голосование.</div></div>';

        }
        elseif (isset($_GET['vote']) && $this->adm) {
            if (isset($_POST['cancel'])) {
                header('Location: '.$this->redirect);
            }
            elseif (isset($_POST['add_vote'])) {
                $error = '';
                if (empty($_POST['text'])) {
                    $error.= 'Введите содержание опроса!<br/>';
                }
                elseif (mb_strlen($_POST['text']) < 5 || mb_strlen($_POST['text']) > 500) {
                    $error.= 'Содержание опроса должно быть не меньше 5 и не больше 500 символов!<br/>';
                }
                if (empty($_POST['ans'])) {
                    $error.= 'Укажите варианты ответа!<br/>';
                }
                elseif (!is_array($_POST['ans'])) {
                    $error.= 'Неверный формат данных!<br/>';
                } else {
                    foreach ($_POST['ans'] as $key => $value) {
                        if (empty($value)) {
                            unset($_POST['ans'][$key]);
                            continue;
                        }
                        if (mb_strlen($value) < 2 || mb_strlen($value) > 250) {
                            $error.= 'Один вариант ответа должен содержать не менее 2 и не более 250 символов!<br/>';
                            break;
                        }
                    }
                    if (count($_POST['ans']) < 2 || count($_POST['ans']) > 25) {
                        $error.= 'Количество вариантов должно быть не менее 2 и не более 25!<br/>';
                    }
                }
                if ($error) {
                    echo '<div class="menu">'.$error.'</div>';
                } else {
                    $stmt = $this->connect->prepare("insert into `vote` set `text` = ?, `anon` = ?, `did` = ?, `type` = ?");
                    if ($stmt->execute(array($_POST['text'], isset($_POST['anon']) ? 1 : 0, $this->did, $this->type))) {
                        $lid = $this->connect->LastInsertId();
                        foreach ($_POST['ans'] as $value)
                            $add_answer->execute(array($value, $lid));
                        header('Location: '.$this->redirect);
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
            }

            echo '<div class="menu">
            <form action="" method="POST">
            Опрос [5-500]:<br/><input type="text" name="text"><br/>
            Варианты [2-250]:<br/>
            <div id="inpContText">
            <input type="text" name="ans[]" id="ans"><br/>
            <input type="text" name="ans[]" id="ans"><br/>
            </div>
            <div class="butt1"><a href="javascript:AddAnswer()">Добавить еще</a></div><br/>
            <input type="checkbox" name="anon" value="1">Анонимное голосование<br/>
            <input type="submit" name="add_vote" value="Создать опрос">
            <input type="submit" name="cancel" value="Отмена">
            </form></div>';

        }

    }

}