<?php

define('NEEDS_PHP', '7.0.0'); // Нужная версия PHP

define('NEEDS_EXT', array('Core', 'date', 'openssl', 'pcre', 'curl', 'dom', 'libxml', 'hash', 'filter', 'SPL', 'session', 'standard', 'mbstring', 'fileinfo', 'gd', 'exif', 'PDO', 'pdo_mysql', 'zip', 'rar')); // Расширения

$error = NULL;

/* Проверка версии PHP */

if (version_compare(PHP_VERSION, NEEDS_PHP, '<')) {

    $error .= 'Нужная версия PHP - <b>' . NEEDS_PHP . '</b> и выше, а у вас - <b>' . PHP_VERSION . '</b><br />';

}

/* Проверка расширений */

foreach (NEEDS_EXT as $name) {

    if (!extension_loaded($name)) {

        $error .= 'Включите расширение <b>' . $name . '</b><br />';

    }

}

/* Вывод предупреждений */

if ($error) {

    echo '<h2>ERROR</h2>';

    die($error);

}