<?php
// Сессия
session_name('SID') . session_start();
// Настройки сайта
define('FILE_CONFIG', __DIR__."/system.ini");
$sys = parse_ini_file(FILE_CONFIG, true);
// Отладка
ini_set('error_reporting', $sys['modules']['debug'] ? E_ALL : 0);
ini_set('display_errors', $sys['modules']['debug'] ? 1 : 0);
ini_set('display_startup_errors', $sys['modules']['debug'] ? 1 : 0);
// Настройки highlight
ini_set('highlight.keyword', $sys['system']['hl-keyword']);
ini_set('highlight.comment', $sys['system']['hl-comment']);
ini_set('highlight.string', $sys['system']['hl-string']);
ini_set('highlight.default', $sys['system']['hl-default']);
ini_set('highlight.html', $sys['system']['hl-html']);
// Ajax переходы
function shutdownHeaderLocation() {
    $_SESSION['X-AJAX-REQUEST-URL'] = null;
    foreach (headers_list() as $item) {
        if (stripos($item, 'Location:') !== false) {
            $_SESSION['X-AJAX-REQUEST-URL'] = 'X-AJAX-REQUEST-URL: ' . trim(substr($item, 9));
            break;
        }
    }
}
if(!empty($_SESSION['X-AJAX-REQUEST-URL']))
    header($_SESSION['X-AJAX-REQUEST-URL']);
register_shutdown_function('shutdownHeaderLocation');
// Подключение к БД
$connect = new PDO(

    // Хост, имя базы, кодировка
    'mysql:host=' . $sys['db']['db_host'] . ';dbname=' . $sys['db']['db_name'] . ';charset=utf8',

    // Юзер
    $sys['db']['db_user'],

    // Пароль
    $sys['db']['db_pass'],

    // Атрибуты
    [

        // Сообщения об ошибках
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,

        // Выборка данных по умолчанию
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,

        // Буферизованные запросы
        PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,

        // Эмуляция подготавливаемых запросов
        PDO::ATTR_EMULATE_PREPARES => true

    ]

);
// $_GET'ы
$id = isset($_GET['id']) ? intval($_GET['id']) : false;
$did = isset($_GET['did']) ? intval($_GET['did']) : false;
$act = $_GET['act'] ?? false;
$search = $_GET['search'] ?? NULL;
// Функции для работы с файлами
require_once(__DIR__."/file_function.php");
// Проверка файлов
require_once(__DIR__."/BeforeUpload.php");
// Фильтр данных
require_once(__DIR__."/data_filter.php");
// Постраничная навигация
require_once(__DIR__."/Pagination.php");
// Поиск файлов
require_once(__DIR__."/GlobFiles.php");
// Градиент
require_once(__DIR__."/Gradient.php"); 
// BB-коды
require_once(__DIR__."/bb.php");
// SimpleImage
require_once(__DIR__."/SimpleImage.php");
// Mobile Detect
require_once(__DIR__."/Mobile_Detect.php");
// Tools
require_once(__DIR__."/tools.php");
// Обработка времени
require_once(__DIR__."/daytime.php");
// Комментарии
require_once(__DIR__."/Comments.php");
// Голосования
require_once(__DIR__."/Vote.php");
// Лайки
require_once(__DIR__."/Respect.php");
// IP посетителя
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
// Определение реального браузера
$ua = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
// Кодировка
mb_internal_encoding('UTF-8');
// Корневая папка
define('ROOT', (isHttps() ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']);
// Все символы (REGEXP SQL)
define('RS_ALL_CHARS', '.*');
// Уровни пользователей
define('LEVELS', [
    'Пользователь',      // 0
    'Гл. администратор', // 1
    'Журналист газеты',  // 2
    'Модератор форума',  // 3
    'Tester',            // 4
    'Администратор',     // 5
    'Модератор'          // 6
]);

/* Функции */

// Валюта сайта
function rub($sum) {

    global $sys;

    $currency = explode(',', $sys['system']['currency']);

    if (count($currency) == 3)
        $rub = quantDec($sum, [$currency[0], $currency[1], $currency[2]]);
    else
        $rub = $sum . ' ' . $sys['system']['currency'];

    return $rub;

}
// Смайлы и BB-коды
function SmilesAndBB($to = '#message', $return = false) {

    $output = NULL;

    $smiles = GlobFiles::findByMask(GlobFiles::MaskSmiles, GlobFiles::Smiles, true);
    $count_smiles = count($smiles);

    $output .= '<div class="menu">
                <div class="dropdown">
                '.($count_smiles > 0 ? '
                <a href="#" class="dropdown-toggle dropdown-toggle-no-carret" data-toggle="dropdown"><img src="/img/bb/smileys.gif" alt="smiles"></a>' : '').'
                <a href="javascript:$(\''.$to.'\').bbCode(\'[b]\', \'[/b]\')"><img src="/img/bb/bold.gif" alt="bold"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[i]\', \'[/i]\')"><img src="/img/bb/italics.gif" alt="italics"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[u]\', \'[/u]\')"><img src="/img/bb/underline.gif" alt="underline"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[cit]\', \'[/cit]\')"><img src="/img/bb/quote.gif" alt="quote"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[del]\', \'[/del]\')"><img src="/img/bb/strike.gif" alt="strike"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[url=http://]\', \'[/url]\')"><img src="/img/bb/link.gif" alt="link"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[color=Цвет]\', \'[/color]\')"><img src="/img/bb/color.gif" alt="color"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[gradient=Цвет1,Цвет2]\', \'[/gradient]\')"><img src="/img/bb/color_bg.gif" alt="color_bg"></a>
                <a href="javascript:$(\''.$to.'\').bbCode(\'[php]\', \'[/php]\')"><img src="/img/bb/php.gif" alt="php"></a>
                <div class="dropdown-menu wa-smile-menu">';

    foreach ($smiles as $file) {

        $smile = basename($file);

        $output .= '<a href="javascript:$(\''.$to.'\').insertAtCaret(\':' . mb_substr($smile, 0, -4) . ':\')"><img src="/img/smiles/' . $smile . '" alt="smile"></a>';

    }

    $output .= '</div>
                </div>
                </div>';

    if ($return) {

        return $output;

    } else {

        echo $output;

    }

}

// Инфо о юзере
function user($user, $type = 0) {

    global $connect;

    if ($type == 1)
        $sql = "select * from `users` where `login` = ?";
    else
        $sql = "select * from `users` where `id` = ?";

    $result = $connect->prepare($sql);
    $result->execute(array($user));
    $info = $result->fetch();

    return $info;

}
// Инфо об авторизации юзера
function authlog($uid) {

    global $connect;

    $result = $connect->prepare("select * from `authlog` where `uid` = ? order by `lasttime` desc");
    $result->execute(array($uid));
    $info = $result->fetch();

    return $info;

}
// Статус онлайн
function online($uid) {

    $auth = is_array($uid) ? $uid : authlog($uid);

    if ($auth && $auth['status'] == 1 && $auth['lasttime'] > time() - 300) {

        $online = deviceIcon($auth['ua']);

        return $online;

    } else
        return false;

}
// Градиент ника
function gradientUser($user) {

    $row = is_array($user) ? $user : user($user, 1);

    if ($row) {

        if ($row['color1'] && $row['color2']) {

            $login = Gradient::make($row['login'], $row['color1'], $row['color2']);

            return $login;

        } else {

            return $row['login'];

        }

    } else
        return false;

}
// Иконка юзера
function iconUser($uid) {

    $row = is_array($uid) ? $uid : user($uid);

    if ($row) {

        $icon = GlobFiles::findById($row['id'], GlobFiles::UserIcon);

        if ($icon) {

           $img = '<img src="/files/icon/'.basename($icon).'" alt="icon">';

        } elseif ($row['ban'] > time()) {

            $img = '<img src="/img/user/ban.png" alt="ban">';

        } elseif ($row['admin'] == 0) {

            $img = $row['pol'] == 1 ? '<img src="/img/user/male.png" alt="male">' : '<img src="/img/user/female.png" alt="female">';

        } else {

            $img = $row['pol'] == 1 ? '<img src="/img/user/admin-male.png" alt="admin-male">' : '<img src="/img/user/admin-female.png" alt="admin-female">';

        }

    } else {

        $img = '<img src="/img/user/bot.png" alt="bot">';

    }

    return $img;

}
// Ссылка на профиль
function profileLink($uid) {

    global $connect;

    $row = is_array($uid) ? $uid : user($uid);

    if ($row) {

        /* Ссылка */

        $link = iconUser($row) . '<a href="/user/'.$row['id'].'" class="mlink">'.gradientUser($row).'</a>';

        /* Happy Birthsday */

        $birth = DateTime::createFromFormat('Y-m-d', $row['birth']);

        if ($birth && date('d.m') == $birth->format('d.m')) {

            $link .= '<img src="/img/cake.png" alt="cake">';

        }

    } else {

        $link = 'DELETED';

    }

    return $link;

}
// Приватная почта
function privateMail($from, $to) {

    global $connect;

    $row = is_array($from) ? $from : user($from);

    if ($row) {

        if ($row['fmail'] == 1) {

            $result = 1;

        } else {

            $count = $connect->prepare("select count(*) from `friend` where `status` = '1' and (`from` = :from and `to` = :to or `from` = :to and `to` = :from)");
            $count->bindValue(':from', $row['id'], PDO::PARAM_INT);
            $count->bindValue(':to', $to, PDO::PARAM_INT);
            $count->execute();
            $result = $count->fetchColumn();

        }

    }

    return ($result ?? false);

}
// Создаем уведомления
function notification($text, $uid) {

    global $connect;

    $stmt = $connect->prepare("insert into `notifications` set `time` = ?, `uid` = ?, `text` = ?");

    return $stmt->execute(array(time(), $uid, $text));

}
// Зачисление средств
function pay($sum, $uid) {

    global $connect;

    $pay = $connect->prepare("update  `users` set `money` = `money` + ? where `id` = ?");

    return $pay->execute(array($sum, $uid));

}
// Добавляем в контакты
function contact_add($from, $to) {

    global $connect;

    $count = $connect->prepare("select count(*) from `contacts` where `from` = :from and `to` = :to or `from` = :to and `to` = :from");
    $count->bindValue(':from', $from, PDO::PARAM_INT);
    $count->bindValue(':to', $to, PDO::PARAM_INT);
    $count->execute();

    if ($count->fetchColumn()) {

        $stmt = $connect->prepare("update `contacts` set `time` = :time where `from` = :from and `to` = :to or `from` = :to and `to` = :from");

        return $stmt->execute(array(':time' => time(), ':from' => $from, ':to' => $to));

    } else {

        $stmt = $connect->prepare("insert into `contacts` set `time` = ?, `from` = ?, `to` = ?");

        return $stmt->execute(array(time(), $from, $to));

    }

}
// Удаляем контакт
function contact_del($from, $to) {

    global $connect;

    // Удаляем контакт
    $del_contact = $connect->prepare("delete from `contacts` where `from` = :from and `to` = :to or `from` = :to and `to` = :from");
    $del_contact->execute(array(':from' => $from, ':to' => $to));

    /* Чистим мусор и удаляем сообщения */

    $del_mail = $connect->prepare("delete from `mail` where `id` = ?");

    $data = $connect->prepare("select * from `mail` where `from` = :from and `to` = :to or `from` = :to and `to` = :from order by `id` desc");
    $data->bindValue(':from', $from, PDO::PARAM_INT);
    $data->bindValue(':to', $to, PDO::PARAM_INT);
    $data->execute();
    $sql = $data->fetchAll();

    foreach ($sql as $row) {

        $file = GlobFiles::findById($row['id'], GlobFiles::Files, GlobFiles::MaskMail);

        if ($file) // чистим мусор
            unlink($file);

        $del_mail->execute(array($row['id'])); // удаляем сообщение

    }

    return true;

}
// Удаляем все сообщения юзера
function DelUserMail($uid) {

    global $connect;

    // Удаляем контакт
    $del_contact = $connect->prepare("delete from `contacts` where `from` = :user or `to` = :user");
    $del_contact->execute(array(':user' => $uid));

    /* Чистим мусор и удаляем сообщения */

    $del_mail = $connect->prepare("delete from `mail` where `id` = ?");

    $data = $connect->prepare("select * from `mail` where `from` = :user or `to` = :user order by `id` desc");
    $data->bindValue(':user', $uid, PDO::PARAM_INT);
    $data->execute();
    $sql = $data->fetchAll();

    foreach ($sql as $row) {

        $file = GlobFiles::findById($row['id'], GlobFiles::Files, GlobFiles::MaskMail);

        if ($file) // чистим мусор
            unlink($file);

        $del_mail->execute(array($row['id'])); // удаляем сообщение

    }

    return true;

}
// Очки дружбы
function friendPoint($from, $to, $col = 1) {

    global $connect;

    $friend = $connect->prepare("select count(*) from `friend` where `status` = '1' and (`from` = :from and `to` = :to or `from` = :to and `to` = :from)");
    $friend->bindValue(':from', $from, PDO::PARAM_INT);
    $friend->bindValue(':to', $to, PDO::PARAM_INT);
    $friend->execute();

    if ($friend->fetchColumn()) {

        $point = $connect->prepare("update `friend` set `point` = `point` + :col where `from` = :from and `to` = :to or `from` = :to and `to` = :from");

        return $point->execute(array(':col' => $col, ':from' => $from, ':to' => $to));

    } else
        return false;

}
// Рейтинг
function ratingUser($rating, $uid) {

    global $connect;

    $stmt = $connect->prepare("update `users` set `rating` = `rating` + ? where `id` = ?");

    return $stmt->execute(array($rating, $uid));

}
// Звание
function rankUser($rating) {

    global $connect;

    $sql = $connect->query("select * from `rank` order by `rating` desc");

    foreach ($sql as $row) {

        if ($rating >= $row['rating']) {

            $rank = $row['rank'] . ' | ' . $rating;

            break;

        }

    }

    return ($rank ?? $rating);

}
// Где юзер?
function whereUser($uid) {

    global $connect;

    $row = is_array($uid) ? $uid : user($uid);

    if ($row) {

        $wid = isset($_GET['id']) ? intval($_GET['id']) : 0;

        if (($row['where'] != $_SERVER['PHP_SELF'] || $row['wid'] != $wid) &&
            !in_array($_SERVER['PHP_SELF'], ['/js/data.php', '/page/mail/data.php'])) {

            $stmt = $connect->prepare("update `users` set `where` = ?, `wid` = ? where `id` = ?");

            return $stmt->execute(array($_SERVER['PHP_SELF'], $wid, $row['id']));

        } else
            return true;

    } else
        return false;

}
// Капча при авторизации
function CaptchaAuth($uid, $status = false) {

    global $connect;

    $row = is_array($uid) ? $uid : user($uid);

    if ($row) {

        $stmt = $connect->prepare("update `users` set `captcha` = ?, `attempts` = ? where `id` = ?");

        if ($status) {

            // Отключаем капчу

            return $stmt->execute(array(0, 0, $row['id']));

        } else {

            // Валючаем капчу

            return $stmt->execute(array(time(), $row['attempts'] + 1, $row['id']));

        }

    } else
        return false;

}
// Скопление юзеров
function congestion($where, $wid = 0) {

    global $connect;

    $congestion = [];

    $data = $connect->prepare("select * from `users` where `where` = :where and `wid` = :wid order by `admin` desc, `rating` desc");
    $data->bindValue(':where', $where);
    $data->bindValue(':wid', $wid, PDO::PARAM_INT);
    $data->execute();
    $sql = $data->fetchAll();

    foreach ($sql as $row) {

        // Если онлайн, то добавляем в список
        if (online($row['id']))
            $congestion[] = $row['id'];

    }

    return $congestion;

}
// Список получивших бонус
function WhoGotBonus($bid) {

    global $connect;

    $congestion = [];

    $data = $connect->prepare("select * from `bonus_rec` where `bid` = :bid order by `time`");
    $data->bindValue(':bid', $bid, PDO::PARAM_INT);
    $data->execute();
    $sql = $data->fetchAll();

    foreach ($sql as $row) {

        if (user($row['uid']))
            $congestion[] = $row['uid'];

    }

    return $congestion;

}
// Вывод юзеров через запятую
function congestionOutputLinks($congestion, $limit = false) {

    $res = NULL;

    foreach ($congestion as $key => $uid) {

        $res .= profileLink($uid).', ';

        // Лимит
        if ($limit && $key >= $limit + 1)
            break;

    }

    $res = trim($res, ', ');

    if ($limit && count($congestion) > $limit)
        $res .= '...';

    return $res;

}
// Черный список
function in_blacklist($uid, $black) {

    global $connect;

    $black_r = $connect->prepare("select count(*) from `blacklist` where `uid` = ? and `black` = ?");
    $black_r->execute(array($uid, $black));

    return $black_r->fetchColumn();

}
// Проверка браузера в серфинге
function is_forbid_browser($link) {

    global $ua, $connect;

    $data = $connect->prepare("select * from `forbid_browser` where `link` = :link order by `id` desc");
    $data->bindValue(':link', $link, PDO::PARAM_INT);
    $data->execute();
    $sql = $data->fetchAll();

    foreach ($sql as $row) {

        if ($row['browser'] != NULL && stristr($ua, $row['browser'])) {

            $result = 1;

            break;

        }

    }

    return ($result ?? false);

}
// Иконка товара
function iconShop($pid) {

    global $sys;

    if ($icon = GlobFiles::findById($pid, GlobFiles::Files, GlobFiles::MaskShopIcon)) {

        $img = '/files/'.basename($icon);

    }
    elseif ($screen = GlobFiles::findById($pid, GlobFiles::Files, GlobFiles::MaskScreen)) {

        $img = '/files/'.basename($screen);

    } else {

        $img = '/img/no_screen.png';

    }

    return '<img src="/preview/'.$sys['system']['icon_wscr'].'/'.base64_encode($img).'" alt="screen">';

}
// Ссылка на товар
function linkShop($pid, $text = false) {

    global $connect, $sys;

    if (is_array($pid)) {

        $row = $pid;

    } else {

        $strow = $connect->prepare("select * from `shop` where `id` = ?");
        $strow->execute(array($pid));
        $row = $strow->fetch();

    }

    if ($row) {

        return '<div class="forlink">
                <a href="/shop/product/'.$row['id'].'" class="links">
                <div class="wa-shop">
                <div class="wa-screen">'.iconShop($row['id']).'</div>
                </div>
                <div class="wa-shop wa-shop-info">
                <div class="wa-shop-title">'.$row['name'].'<span class="wa-shop-price">'.($row['time'] <= time() ? ($row['status'] == 1 ? ($row['free'] == 1 ? 'Бесплатно' : rub($row['cena'])) : 'На модерации') : ($row['comment'] ? $row['comment'] : 'Скоро')).'</span></div>
                <div class="wa-shop-text">'.($row['time'] > time() ? 'Релиз запланирован на: '.daytime($row['time']) : shortText($row['text'], $sys['system']['shop_text_s'])).'</div>
                '.($row['time'] <= time() && $row['time'] > mktime(0, 0, 0) ? '<div class="orange">Новинка!</div>' : '').
                  ($text ? $text : '').'
                </div>
                </a></div>';

    } else
        return false;

}
// Счетчик загрузок
function downloadCounterPlus($who, $did, $type) {

    global $connect;

    $downloads = $connect->prepare("insert into `downloads` set `who` = ?, `did` = ?, `type` = ?");

    $num_loaded = $connect->prepare("select count(*) from `downloads` where `who` = ? and `did` = ? and `type` = ?");
    $num_loaded->execute(array($who, $did, $type));

    return ($num_loaded->fetchColumn() ? true : $downloads->execute(array($who, $did, $type)));

}
// Можно ли юзеру собирать донаты?
function DonatesAllowed($uid, $s_count = false, $u_sett = true) {

    global $sys, $connect, $stmt_user_shop;

    $row = is_array($uid) ? $uid : user($uid);

    // если юзера нет
    if (!$row) return false;

    // если модуль отключён
    if ($sys['modules']['donat_s'] == 0) return false;

    // если разрешил админ
    if ($row['donation'] == 1) return true;

    // если запретил админ
    if ($row['donation'] == 2) return false;

    // если юзер сам отключил
    if ($u_sett && ($row['donation'] == 3
                 || $row['donation'] == 4)) return false;

    // если всем разрешено
    if ($sys['modules']['donat_s'] == 2) return true;

    if ($sys['modules']['donat_s'] == 1 &&
        $sys['modules']['shop'] == 1) {

        // товары юзера
        $s_count = is_numeric($s_count) ? $s_count : (($stmt_user_shop->execute(array($row['id']))) ? $stmt_user_shop->fetchColumn() : 0);

        // если юзер - продавец, то можно
        if ($s_count > 0) return true;

    }

    return false; // нельзя

}

// Авторизация
if (isset($_COOKIE['user_id']) && isset($_COOKIE['pass']) && isset($_COOKIE['auth'])) {
    // hash
    $authash = md5(md5($_COOKIE['auth']));
    // проверяем авторизацию
    $authcheck = $connect->prepare("select count(*) from `authlog` where `status` = ? and `uid` = ? and `key` = ?");
    $authcheck->execute(array(1, $_COOKIE['user_id'], $authash));
    // ищем юзера в базе
    $user = user($_COOKIE['user_id']);
    if ($user && $user['pass'] == $_COOKIE['pass'] && $authcheck->fetchColumn()) {
        // Юзер авторизован
        $active = 1;
        // Онлайн
        $authup = $connect->prepare("update `authlog` set `lasttime` = ? where `key` = ?");
        $authup->execute(array(time(), $authash));
        // Где юзер?
        whereUser($user);
        // authlog
        $user_auth = authlog($user['id']);
    } else {
        // Удаляем на всякий случай :)
        unset($user);
        // сбрасываем куки
        setcookie('user_id', null, time() - 3600, '/');
        setcookie('pass', null, time() - 3600, '/');
        setcookie('auth', null, time() - 3600, '/');
    }
}

// Временная зона
$timezone = empty($user['timezone']) ? $sys['system']['timezone'] : $user['timezone'];
if (isAvailableTimezone($timezone))
    date_default_timezone_set($timezone);

// админ
$adm_id = $user['admin'] ?? false;

// Игры
$game_status = ($sys['modules']['game_loto'] == 1
             || $sys['modules']['game_num'] == 1
             || $sys['modules']['game_prmd'] == 1);