<?php

/*
 * RekmixaCMS - The Newest Multifunctional Content Management System
 * Author - rekmixa
 * E-mail - rekmixa@gmail.com
 * Site - http://wordads.ru
 */

require(__DIR__."/checker.php");

// Проверяем install
if (is_dir($_SERVER["DOCUMENT_ROOT"]."/install"))
    exit(header('Location: /install'));
// Функции, сессия и т. п.
require_once(__DIR__."/function.php");
// Защита от CSRF-атак
require_once(__DIR__."/CSRF-secure.php");
// Счетчики и т. п.
require(__DIR__."/counters.php");
// Заголовок
$title = isset($title) ? $sys['system']['project'] . ' | ' . $title : $sys['system']['project'];
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<?=($sys['system']['keywords'] ? '<meta name="keywords" content="'.$sys['system']['keywords'].'"/>' : '').
   ($sys['system']['description'] ? '<meta name="description" content="'.$sys['system']['description'].'"/>' : '');?>
<title><?=$title;?></title>
<link rel="shortcut icon" href="/favicon.ico"/>
<link rel="stylesheet" href="/style/bootstrap/css/bootstrap.min.css" type="text/css"/>
<link rel="stylesheet" href="/style/default.css" type="text/css"/>
<link rel="stylesheet" href="/js/loadingBar.css" type="text/css"/>
<script src="/js/jquery-3.3.1.min.js"></script>
<script src="/style/bootstrap/js/bootstrap.min.js"></script>
<script src="/style/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="/js/jquery.ajaxRequest.js"></script>
<script src="/js/jquery.timers.min.js"></script>
<script src="/js/jquery.plugins.js"></script>
<script src="/js/function.js"></script>
<script src="/js/main.ajaxRequest.js"></script>
</head>
<body>
<div id="loading-bar"><dd></dd><dt></dt></div>
<div id="loading-content">
<?
// Работа сайта
if ($sys['modules']['work'] == 0 && $adm_id != 1 && $adm_id != 4)
    exit('<div class="wa-content">
            <div class="menu">
              <div class="forbidden">На сайте ведутся технические работы.</div>
            </div>
          </div>');
// бан
if (isset($active) && $user['ban'] > time() && $adm_id != 1)
    exit('<div class="wa-content">
            <div class="menu">
              <div class="forbidden">Ваш аккаунт заблокирован до '.date('d.m.Y H:i', $user['ban']).'!</div>
            </div>
          </div>');
// Верхняя панель
$logoSite = GlobFiles::findByMask('logo_*', GlobFiles::SiteLogo); // logo
echo '<div class="wa-nav-pos">
<div class="logo"><a href="/">' . ($logoSite ? '<img src="/img/' . basename($logoSite) . '" alt="logo" class="img-responsive">' : '<h2>' . $sys['system']['project'] . '</h2>') . '</a></div>';
if (isset($active)) {

    echo '<div class="wa-nav-header">';

    // Админка
    if (($adm_id == 1 || $adm_id == 5 || $adm_id == 6))
        echo '<div class="forlink-logo"><a href="/adm" class="adm"><img src="/img/adm.png" alt="adm">Панель управления<div class="chi" id="admNotif">'.$new_adm.'</div></a></div>';

    echo '<div class="wa-nav-link wa-img-no-margin">
    <a data-noajax href="#" wa-drop-menu="#notifications"><img src="/img/nav-notif.png" alt="nav"><span id="notNotif">'.$new_not.'</span></a>
    <a href="/friends"><img src="/img/nav-friend.png" alt="nav"><span id="reqNotif">'.$new_req.'</span></a>
    <a href="/mail"><img src="/img/nav-mail.png" alt="nav"><span id="mailNotif">'.$new_mail.'</span></a>
    <a href="/chat"><img src="/img/nav-chat.png" alt="nav"><span id="chatNotif">'.$new_chat.'</span></a>
    <a data-noajax href="#" wa-drop-menu="#exit"><img src="/img/nav-exit.png" alt="nav"></a>
    </div>
    <div id="notifications" class="wa-drop-menu wa-drop-style wa-drop-left"></div>
    <div id="exit" class="wa-drop-menu wa-drop-style wa-drop-right">';

    if ($sys['modules']['work'] == 1) {

        if (isset($_POST['exit'])) {

            $reset_auth = $connect->prepare("update `authlog` set `status` = ? where `uid` = ? and `key` = ?");

            $reset_auth->execute(array(0, $user['id'], $authash));

            setcookie('user_id', null, time() - 3600, '/');
            setcookie('pass', null, time() - 3600, '/');
            setcookie('auth', null, time() - 3600, '/');

            header('Location: /');

        }

        echo '<form action="" method="POST">
        Вы действительно хотите выйти с аккаунта?<br/>
        <input type="submit" name="exit" value="Да, выйти">
        </form>';

    } else
        echo '<div class="forbidden">Вы не можете выйти с аккаунта пока сайт закрыт!</div>';

    echo '</div>';
}
echo '</div>
<div class="wa-content">';
// Предупреждение, если отключен JavaScript
echo '<noscript><div class="menu"><div class="danger">Для корректной работы сайта включите JavaScript!</div></div></noscript>';
// Активация аккаунта
include(__DIR__."/active.php");
// Бонус
include(__DIR__."/bonus.php");
// Меню сайта
echo '<div class="d-none d-md-block">
<div class="wa-left-block">';
    include(__DIR__."/menu.php");
    include(__DIR__."/advert.php");
echo '</div>
</div>
<div class="wa-center-block">';