-- 
-- Структура таблицы `bonus`
-- 
DROP TABLE IF EXISTS `bonus`;
CREATE TABLE IF NOT EXISTS `bonus` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `comment` varchar(500) NOT NULL,
  `date` varchar(50) NOT NULL,
  `start` varchar(50) NOT NULL,
  `end` varchar(50) NOT NULL,
  `min` float(11,2) NOT NULL,
  `max` float(11,2) NOT NULL,
  `limit` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `bonus_rec`
-- 
DROP TABLE IF EXISTS `bonus_rec`;
CREATE TABLE IF NOT EXISTS `bonus_rec` (
  `time` bigint(11) NOT NULL,
  `bid` bigint(20) NOT NULL,
  `uid` bigint(20) NOT NULL,
  `sum` float(11,2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `authlog`
-- 
DROP TABLE IF EXISTS `authlog`;
CREATE TABLE IF NOT EXISTS `authlog` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `key` text NOT NULL,
  `time` bigint(11) NOT NULL,
  `lasttime` bigint(11) NOT NULL,
  `ip` varchar(50) NOT NULL,
  `ua` varchar(250) NOT NULL,
  `attempts` int(11) NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `speedpass`
-- 
DROP TABLE IF EXISTS `speedpass`;
CREATE TABLE IF NOT EXISTS `speedpass` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `key` text NOT NULL,
  `time` bigint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `rank`
-- 
DROP TABLE IF EXISTS `rank`;
CREATE TABLE IF NOT EXISTS `rank` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `rating` float(11,1) NOT NULL,
  `rank` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `vote`
-- 
DROP TABLE IF EXISTS `vote`;
CREATE TABLE IF NOT EXISTS `vote` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `text` varchar(500) NOT NULL,
  `did` bigint(20) UNSIGNED NOT NULL,
  `type` tinyint(3) NOT NULL,
  `anon` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `answers`
-- 
DROP TABLE IF EXISTS `answers`;
CREATE TABLE IF NOT EXISTS `answers` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `text` varchar(250) NOT NULL,
  `vid` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `choice`
-- 
DROP TABLE IF EXISTS `choice`;
CREATE TABLE IF NOT EXISTS `choice` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `ans` bigint(20) UNSIGNED NOT NULL,
  `vid` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `rek`
-- 
DROP TABLE IF EXISTS `rek`;
CREATE TABLE IF NOT EXISTS `rek` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `expire` bigint(11) NOT NULL,
  `days` int(11) NOT NULL,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `url` varchar(2500) NOT NULL,
  `name` varchar(250) NOT NULL,
  `comment` varchar(500) NOT NULL,
  `color` varchar(15) NOT NULL,
  `sum` float(11,2) NOT NULL,
  `status` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `notifications`
-- 
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `text` text NOT NULL,
  `time` bigint(11) NOT NULL,
  `new` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `respect`
-- 
DROP TABLE IF EXISTS `respect`;
CREATE TABLE IF NOT EXISTS `respect` (
  `from` bigint(20) UNSIGNED NOT NULL,
  `to` bigint(20) UNSIGNED NOT NULL,
  `review` tinyint(3) NOT NULL,
  `type` tinyint(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `blacklist`
-- 
DROP TABLE IF EXISTS `blacklist`;
CREATE TABLE IF NOT EXISTS `blacklist` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `black` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `shop`
-- 
DROP TABLE IF EXISTS `shop`;
CREATE TABLE IF NOT EXISTS `shop` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `seller` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `text` text NOT NULL,
  `tags` text NOT NULL,
  `kat` bigint(20) UNSIGNED NOT NULL,
  `cena` float(11,2) NOT NULL,
  `col` int(11) NOT NULL,
  `limit` tinyint(3) NOT NULL,
  `uid` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL,
  `free` tinyint(3) NOT NULL,
  `selling` tinyint(3) NOT NULL DEFAULT '1',
  `upd` bigint(11) NOT NULL,
  `time` bigint(11) NOT NULL,
  `comment` varchar(75) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `downloads`
-- 
DROP TABLE IF EXISTS `downloads`;
CREATE TABLE IF NOT EXISTS `downloads` (
  `who` varchar(50) NOT NULL,
  `did` bigint(20) UNSIGNED NOT NULL,
  `type` tinyint(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `purchase`
-- 
DROP TABLE IF EXISTS `purchase`;
CREATE TABLE IF NOT EXISTS `purchase` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `seller` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `sum` float(11,2) NOT NULL,
  `pid` bigint(20) UNSIGNED NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `time` bigint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `discounts`
-- 
DROP TABLE IF EXISTS `discounts`;
CREATE TABLE IF NOT EXISTS `discounts` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `sum` float(11,2) NOT NULL,
  `pid` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `basket`
-- 
DROP TABLE IF EXISTS `basket`;
CREATE TABLE IF NOT EXISTS `basket` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `pid` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `task`
-- 
DROP TABLE IF EXISTS `task`;
CREATE TABLE IF NOT EXISTS `task` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `time` bigint(11) NOT NULL,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `text` text NOT NULL,
  `cena` float(11,2) NOT NULL,
  `col` int(11) NOT NULL,
  `memory` int(11) NOT NULL,
  `status` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `task_ans`
-- 
DROP TABLE IF EXISTS `task_ans`;
CREATE TABLE IF NOT EXISTS `task_ans` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `text` text NOT NULL,
  `tid` bigint(20) UNSIGNED NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `time` bigint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `link`
-- 
DROP TABLE IF EXISTS `link`;
CREATE TABLE IF NOT EXISTS `link` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `time` bigint(11) NOT NULL,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `url` varchar(2500) NOT NULL,
  `name` varchar(2500) NOT NULL,
  `click` int(11) NOT NULL,
  `memory` int(11) NOT NULL,
  `cena` float(11,2) NOT NULL,
  `status` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `click`
-- 
DROP TABLE IF EXISTS `click`;
CREATE TABLE IF NOT EXISTS `click` (
  `link` bigint(20) UNSIGNED NOT NULL,
  `time` bigint(11) NOT NULL,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `ua` varchar(200) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `forbid_browser`
-- 
DROP TABLE IF EXISTS `forbid_browser`;
CREATE TABLE IF NOT EXISTS `forbid_browser` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `link` bigint(20) UNSIGNED NOT NULL,
  `browser` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `loto`
-- 
DROP TABLE IF EXISTS `loto`;
CREATE TABLE IF NOT EXISTS `loto` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `win_loto`
-- 
DROP TABLE IF EXISTS `win_loto`;
CREATE TABLE IF NOT EXISTS `win_loto` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `sum` float(11,2) NOT NULL,
  `time` bigint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `num`
-- 
DROP TABLE IF EXISTS `num`;
CREATE TABLE IF NOT EXISTS `num` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `cash` float(11,2) NOT NULL,
  `num` tinyint(3) NOT NULL,
  `time` bigint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `prmd`
-- 
DROP TABLE IF EXISTS `prmd`;
CREATE TABLE IF NOT EXISTS `prmd` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `sum` float(11,2) NOT NULL,
  `time` bigint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `win_prmd`
-- 
DROP TABLE IF EXISTS `win_prmd`;
CREATE TABLE IF NOT EXISTS `win_prmd` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `sum` float(11,2) NOT NULL,
  `time` bigint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `news`
-- 
DROP TABLE IF EXISTS `news`;
CREATE TABLE IF NOT EXISTS `news` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `time` bigint(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `text` text NOT NULL, 
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `topic`
-- 
DROP TABLE IF EXISTS `topic`;
CREATE TABLE IF NOT EXISTS `topic` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `time` bigint(11) NOT NULL,
  `up` bigint(11) NOT NULL,
  `top` bigint(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `text` text NOT NULL,
  `kat` bigint(20) UNSIGNED NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `kat`
-- 
DROP TABLE IF EXISTS `kat`;
CREATE TABLE IF NOT EXISTS `kat` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(75) NOT NULL,
  `type` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `comments`
-- 
DROP TABLE IF EXISTS `comments`;
CREATE TABLE IF NOT EXISTS `comments` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `date` bigint(11) NOT NULL,
  `read` tinyint(3) NOT NULL DEFAULT '0',
  `uid` bigint(20) UNSIGNED NOT NULL,
  `text` text NOT NULL,
  `did` bigint(20) UNSIGNED NOT NULL,
  `type` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `friend`
-- 
DROP TABLE IF EXISTS `friend`;
CREATE TABLE IF NOT EXISTS `friend` (
  `from` bigint(20) UNSIGNED NOT NULL,
  `to` bigint(20) UNSIGNED NOT NULL,
  `point` int(11) NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `contacts`
-- 
DROP TABLE IF EXISTS `contacts`;
CREATE TABLE IF NOT EXISTS `contacts` (
  `from` bigint(20) UNSIGNED NOT NULL,
  `to` bigint(20) UNSIGNED NOT NULL,
  `time` bigint(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `mail`
-- 
DROP TABLE IF EXISTS `mail`;
CREATE TABLE IF NOT EXISTS `mail` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `from` bigint(20) UNSIGNED NOT NULL,
  `to` bigint(20) UNSIGNED NOT NULL,
  `text` text NOT NULL,
  `time` bigint(11) NOT NULL,
  `read` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `plus`
-- 
DROP TABLE IF EXISTS `plus`;
CREATE TABLE IF NOT EXISTS `plus` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `donater` bigint(20) UNSIGNED NOT NULL,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `sum` float(11,2) NOT NULL,
  `num` int(11) NOT NULL,
  `time` bigint(11) NOT NULL,
  `type` tinyint(3) NOT NULL,
  `status` tinyint(3) NOT NULL,
  `thanks` tinyint(3) NOT NULL,
  `comment` varchar(500) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `payment`
-- 
DROP TABLE IF EXISTS `payment`;
CREATE TABLE IF NOT EXISTS `payment` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) UNSIGNED NOT NULL,
  `money` float(11,2) NOT NULL,
  `wmr` varchar(13) NOT NULL,
  `time` bigint(11) NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Структура таблицы `users`
-- 
DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `datereg` bigint(11) NOT NULL,
  `login` varchar(25) NOT NULL,
  `pass` text NOT NULL,
  `email` varchar(35) NOT NULL,
  `active` tinyint(3) NOT NULL,
  `captcha` bigint(11) NOT NULL,
  `attempts` int(11) NOT NULL,
  `where` varchar(250) NOT NULL,
  `wid` bigint(20) NOT NULL,
  `timezone` varchar(99) NOT NULL,
  `status` varchar(250) NOT NULL,
  `birth` varchar(50) NOT NULL,
  `hd` tinyint(3) NOT NULL DEFAULT '1',
  `info` varchar(250) NOT NULL,
  `pol` tinyint(3) NOT NULL,
  `name` varchar(75) NOT NULL,
  `wmr` varchar(15) NOT NULL,
  `wmid` varchar(15) NOT NULL,
  `admin` tinyint(3) NOT NULL DEFAULT '0',
  `adm_pos` varchar(150) NOT NULL,
  `color1` varchar(25) NOT NULL,
  `color2` varchar(25) NOT NULL,
  `fmail` tinyint(3) NOT NULL DEFAULT '1',
  `ban` bigint(11) NOT NULL,
  `ref` bigint(20) UNSIGNED NOT NULL,
  `money` float(11,2) NOT NULL,
  `rating` float(11,1) NOT NULL,
  `memory_serf` int(11) NOT NULL,
  `memory_task` int(11) NOT NULL,
  `chatlog` bigint(11) NOT NULL,
  `donation` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;