<?php
$title = 'Покупка рекламы';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['ads'] == 1) {

    echo '<div class="title">Покупка рекламы</div>';

    if ($active_rek + $c_mod_rek >= $sys['system']['rek_limit']) {

        echo '<div class="menu">
        Все рекламные места заняты!<br/>
        Следующее место освободится: '.($c_mod_rek > 0 ? 'Неизвестно' : daytime($last_rek['expire'])).'<br/>
        Всего мест: '.$sys['system']['rek_limit'].'
        </div>';

    } else {

        $add = $connect->prepare("insert into `rek` set `url` = ?, `name` = ?, `comment` = ?, `color` = ?, `sum` = ?, `uid` = ?, `days` = ?, `expire` = ?, `status` = ?");

        if (isset($_POST['submit'])) {

            $error = '';

            $status = ($adm_id == 1 || $sys['modules']['mod_a'] == 1) ? 1 : 3;
            $days = intval(abs($_POST['days']));
            $expire = $status == 1 ? time() + 3600 * 24 * $days : 0;

            if (empty($_POST['color']))
                $sys['system']['rek_color'] = 0;

            if (empty($_POST['comment']))
                $sys['system']['rek_comm'] = 0;

            $sum = $days * $sys['system']['rek_cena'] + $sys['system']['rek_color'] + $sys['system']['rek_comm'];

            if (empty($_POST['url'])) {
                $error.= 'Введите URL!<br/>';
            }
            elseif (mb_strlen($_POST['url']) < 5 || mb_strlen($_POST['url']) > 250) {
                $error.= 'URL должен содержать от 5 до 250 символов!<br/>';
            }
            elseif (!isSiteAvailable($_POST['url'])) {
                $error.= 'URL недоступен или введен не правильно!<br/>';
            }
            if (empty($_POST['name'])) {
                $error.= 'Введите название!<br/>';
            }
            elseif (mb_strlen($_POST['name']) < 5 || mb_strlen($_POST['name']) > 75) {
                $error.= 'Название должно содержать от 5 до 75 символов!<br/>';
            }
            if (!empty($_POST['comment']) && (mb_strlen($_POST['comment']) < 5 || mb_strlen($_POST['comment']) > 250)) {
                $error.= 'Комментарий к ссылке должен содержать от 5 до 250 символов!<br/>';
            }
            if ($days < 1) {
                $error.= 'Минимальное количество дней - 1!<br/>';
            }
            if ($user['money'] < $sum) {
                $error.= 'Недостаточно средств!<br/>';
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {
                if (pay(-$sum, $user['id']) && $add->execute(array($_POST['url'], $_POST['name'], $_POST['comment'], $_POST['color'], $sum, $user['id'], $days, $expire, $status))) {
                    header('Location: /ads');
                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
        }

        echo '<div class="menu">
        <form action="" method="POST">
        URL-адрес [5-250]:<br/><input type="text" name="url" value="http://"><br/>
        Название [5-75]:<br/><input type="text" name="name"><br/>
        Комментарий к ссылке [5-250]:<br/><input type="text" name="comment"><br/>
        Цвет ссылки:<br/><input type="text" name="color"><br/>
        Количество дней:<br/><input type="text" name="days" value="5"><br/>
        <input type="submit" name="submit" value="Продолжить">
        <div class="dash">
        Всего мест: '.$sys['system']['rek_limit'].'<br/>
        Стоимость рекламы: '.rub($sys['system']['rek_cena']).' в день<br/>
        Добавление комментария: +'.rub($sys['system']['rek_comm']).'<br/>
        Добавление цвета: +'.rub($sys['system']['rek_color']).'
        </div>
        </form></div>';

    }

    echo '<div class="forlink"><a href="/ads" class="links"><img src="/img/dvr.png" alt="dvr">Моя реклама</a></div>';

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>