<?php
$title = 'Восстановление пароля';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");

echo '<div class="title">Восстановление пароля</div>';

if (isset($active)) {

    header('Location: /');

} else {

    if (isset($_POST['forgot'])) {

        $error = '';

        $user = user($_POST['login'], 1);

        if (empty($_POST['code'])) {
            $error.= 'Введите код с картинки!<br/>';
        }
        elseif ($_SESSION['code'] != $_POST['code']) {
            $error.= 'Код с картинки введен неверно!<br/>';
        }
        elseif (empty($_POST['login'])) {
            $error.= 'Введите логин в системе!<br/>';
        }
        elseif (mb_strlen($_POST['login']) < 3 or mb_strlen($_POST['login']) > 15) {
            $error.= 'Логин должен содержать от 3 до 15 символов!<br/>';
        }
        elseif (!$user) {
            $error.= 'Пользователь с таким логином не найден в системе!<br/>';
        }
        elseif (empty($_POST['email'])) {
            $error.= 'Поле e-mail обязательно для заполнения!<br/>';
        }
        elseif (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
            $error.= 'Поле e-mail заполнено неверно!<br/>';
        }
        elseif ($user['email'] != $_POST['email']) {
            $error.= 'Указан не тот E-mail!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            $key = bin2hex(random_bytes($sys['system']['spkey']));

            $stmt = $connect->prepare("insert into `speedpass` set `time` = ?, `uid` = ?, `key` = ?");

            if ($stmt->execute(array(time(), $user['id'], md5(md5($key))))) {
 
                mailto(
                    $_POST['email'],
                    'Восстановление пароля',
                    'Вы запросили восстановления пароля для аккаунта '.$_POST['login'].'!<br/>
                     Перейдите по этой ссылке: '.ROOT.'/sp/'.$key,
                    $sys['system']['mail']
                );

                echo '<div class="menu">Письмо с инструкцией выслано на указанный вами E-mail.</div>';

            } else {
                echo '<div class="menu">Ошибка при восстановлении пароля!</div>';
            }
        }
    }

    echo '<div class="menu">
    <form action="" method="POST">
    Логин:<br/><input type="text" name="login"><br/>
    E-mail:<br/><input type="email" name="email" maxlength="35"><br/>
    Код с картинки:<img id="captcha" src="/img/code.php" alt="check" onClick="UpCaptcha()"><br/>
    <input type="text" name="code"><br/>
    <input type="submit" name="forgot" value="Восстановить">
    </form></div>';

}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");

?>