<?php
$title = 'Пользователи';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");

if (isset($active)) {

    echo '<div class="title">Пользователи</div>
    <div class="menu">
    <form action="" method="GET">
    <input type="text" name="search" value="'.$search.'">
    <input type="submit" value="Поиск">
    </form></div>';

    $keywords = $search ? preg_replace("/[\s,]+/", "|", $search) : RS_ALL_CHARS;

    $stmt_num = $connect->prepare("select count(*) from `users` where `login` rlike :keywords or `name` rlike :keywords or `wmr` rlike :adm or `email` rlike :adm");
    $stmt_num->bindValue(':keywords', $keywords);
    $stmt_num->bindValue(':adm', ($adm_id == 1 || $adm_id == 5) ? $keywords : RS_ALL_CHARS);
    $stmt_num->execute();
    $count_res = $stmt_num->fetchColumn();

    if ($count_res == 0) {
        echo '<div class="menu">NONE</div>';
    } else {

        $page = new Pagination($count_res, 10);

        if ($search) {

            $page->setLink('?search=' . $search . '&');

            echo '<div class="menu">Найдено по запросу: '.$count_res.'</div>';

        }

        $data = $connect->prepare("select * from `users` where `login` rlike :keywords or `name` rlike :keywords or `wmr` rlike :adm or `email` rlike :adm order by `rating` desc limit :start, 10");
        $data->bindValue(':keywords', $keywords);
        $data->bindValue(':adm', ($adm_id == 1 || $adm_id == 5) ? $keywords : RS_ALL_CHARS);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            echo '<div class="user-forlink">'.profileLink($row).'<div class="chi">'.rankUser($row['rating']).'</div><span class="online">'.online($row['id']).'</span></div>';

        }

        $page->navigation();

    }

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>