<?php
$title = 'Вывод средств';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active)) {

    echo '<div class="title">Вывод средств</div>'; 

    $stmt_num = $connect->prepare("select count(*) from `payment` where `status` = '0' and `uid` = ?");
    $stmt_num->execute(array($user['id']));
 
    if ($adm_id == 1) {

        echo '<div class="menu"><div class="information">Администратор не может выводить средства!</div></div>';

    } elseif ($user['money'] < $sys['system']['cash']) {

        echo '<div class="menu"><div class="information">Недостаточно средств для вывода!</div></div>';

    } elseif ($stmt_num->fetchColumn()) {

        echo '<div class="menu"><div class="information">Подождите, пока старая заявка будет обработана!</div></div>';

    } else {

        if (isset($_POST['col'])) {

            $error = '';

            if (empty($user['wmr'])) {
                $error.= 'Вы не заполнили свой WMR-кошелек!<br/>';
            }
            elseif (empty($_POST['col'])) {
                $error.= 'Введите сумму для вывода средств!<br/>';
            }
            elseif (!is_numeric($_POST['col'])) {
                $error.= 'Неверное значение!<br/>';
            }
            elseif ($_POST['col'] < $sys['system']['cash']) {
                $error.= 'Минимальная сумма для вывода - '.rub($sys['system']['cash']).'!<br/>';
            }
            elseif ($user['money'] <= 0) {
                $error.= 'У вас нет средств на балансе!<br/>';
            }
            elseif ($user['money'] < $_POST['col']) {
                $error.= 'На вашем балансе нет такой суммы!<br/>';
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $cash = intval($_POST['col']);
                $summa = $cash - $cash / 100 * $sys['system']['kom'];
                $payment = $connect->prepare("insert into `payment` set `uid` = ?, `money` = ?, `wmr` = ?");

                if ($payment->execute(array($user['id'], $summa, $user['wmr'])) && pay(-$cash, $user['id'])) {

                    echo '<div class="menu">Заявка на вывод средств успешно отправлена!</div>';

                    header('Refresh: 1');

                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
        }

        echo '<div class="menu">
        <form action="" method="POST">
        Сумма:<br/><input type="text" name="col" value="'.intval($user['money']).'"/><br/>
        <input type="submit" value="Вывод средств"/><br/>
        <div class="chi">Комиссия: '.$sys['system']['kom'].'%</div>
        </form></div>';

    }

    echo '<div class="menu">
    Кошелек: '.(empty($user['wmr']) ? 'Не заполнен' : '<img src="/img/wmr.png" alt="wmr">'.$user['wmr']).'<br/>
    Баланс: '.rub($user['money']).'<br/>
    Минимальная сумма для вывода: '.rub($sys['system']['cash']).'
    </div>';

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>