<?php
$title = 'Магазин скриптов';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if ($sys['modules']['shop'] == 1) {

    $strow = $connect->prepare("select * from `kat` where `id` = ?");
    $strow->execute(array($id));
    $krow = $strow->fetch();

    if ($krow) {

        echo '<div class="title">'.$krow['name'].'</div>
        <div class="menu">
        <form action="" method="GET">
        <input type="text" name="search" value="'.$search.'">
        <input type="submit" value="Поиск">
        </form></div>';

        $keywords = $search ? preg_replace("/[\s,]+/", "|", $search) : RS_ALL_CHARS;

        $stmt_num = $connect->prepare("select count(*) from `shop` where `status` = '1' and `kat` = :kat and (`name` rlike :keywords or `text` rlike :keywords or `tags` rlike :keywords)");
        $stmt_num->bindValue(':kat', $id, PDO::PARAM_INT); 
        $stmt_num->bindValue(':keywords', $keywords);
        $stmt_num->execute();
        $count_res = $stmt_num->fetchColumn();

        if ($count_res == 0) {
            echo '<div class="menu">Товаров нет!</div>';
        } else {

            $page = new Pagination($count_res, 10);

            if ($search) {

                $page->setLink('?search=' . $search . '&');

                echo '<div class="menu">Найдено по запросу: '.$count_res.'</div>';

            }

            $data = $connect->prepare("select * from `shop` where `status` = '1' and `kat` = :kat and (`name` rlike :keywords or `text` rlike :keywords or `tags` rlike :keywords) order by `id` desc limit :start, 10");
            $data->bindValue(':kat', $id, PDO::PARAM_INT);
            $data->bindValue(':keywords', $keywords);
            $data->bindValue(':start', $page->start, PDO::PARAM_INT);
            $data->execute();
            $sql = $data->fetchAll();

            foreach ($sql as $row) {

                echo linkShop($row);

            }

            $page->navigation();

        }

        if (!isset($active))
            echo '<div class="menu"><div class="information">Авторизуйтесь, чтобы была возможность купить товар.</div></div>';

        echo '<div class="forlink"><a href="/shop" class="links"><img src="/img/shop.png" alt="">Магазин скриптов</a></div>';

    } else {
        header('Location: /shop');
    }
} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>