<?php
$title = 'Список покупателей';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['shop'] == 1) {

    $stmt_row = $connect->prepare("select * from `shop` where `id` = ?");
    $stmt_row->execute(array($id));
    $row_s = $stmt_row->fetch();

    if ($row_s && $row_s['free'] == 0) {

        if ($row_s['seller'] == $user['id'] || $adm_id == 1) {

            // Количество покупок
            $stmt_purch = $connect->prepare("select count(*) from `purchase` where `pid` = ?");
            $stmt_purch->execute(array($id));
            $purch = $stmt_purch->fetchColumn();
            // На сумму
            $stmt_sum = $connect->prepare("select sum(`sum`) from `purchase` where `pid` = ?");
            $stmt_sum->execute(array($id));
            $sum_purch = $stmt_sum->fetchColumn() ?? 0;
 
            echo '<div class="title">Список покупателей: '.$row_s['name'].' ('.$purch.')</div>';

            $stmt_num = $connect->prepare("select count(*) from `purchase` where `pid` = ? and `id` = ?");
            $strow_p = $connect->prepare("select * from `purchase` where `id` = ?");

            if (isset($_GET['back'])) {
                $stmt_num->execute(array($id, $_GET['back']));
                if ($stmt_num->fetchColumn()) {
                    $strow_p->execute(array($_GET['back']));
                    $p_row = $strow_p->fetch();
                    if ($p_row['status'] == 1) {
                        header('Location: /shop/pays/'.$id);
                    } else {
                        if (isset($_POST['cancel'])) {
                            header('Location: /shop/pays/'.$id);
                        }
                        elseif (isset($_POST['yes'])) {
                            $del = $connect->prepare("delete from `purchase` where `id` = ?");
                            if (pay($p_row['sum'], $p_row['uid']) && $del->execute(array($_GET['back']))) {
                                notification('Возврат средств - '.rub($p_row['sum']).'!', $p_row['uid']);
                                header('Location: /shop/pays/'.$id);
                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }
                        echo '<div class="menu">
                        <form action="" method="POST">
                        <input type="submit" name="yes" value="Подтвердить возврат ('.intval($_GET['back']).')">
                        <input type="submit" name="cancel" value="Отмена">
                        </form></div>';
                    }
                } else {
                    header('Location: /shop/pays/'.$id);
                }
            }

            if ($purch == 0) {
                echo '<div class="menu">Покупателей нет.</div>';
            } else {

                echo '<div class="menu">
                Продаж за все время: '.$purch.'<br/>
                На сумму: '.rub($sum_purch).'
                </div>';

                $page = new Pagination($purch, 10);

                $data = $connect->prepare("select * from `purchase` where `pid` = :pid order by `id` desc limit :start, 10");
                $data->bindValue(':pid', $id, PDO::PARAM_INT);
                $data->bindValue(':start', $page->start, PDO::PARAM_INT);
                $data->execute();
                $sql = $data->fetchAll();

                foreach ($sql as $row) {

                    $buyer = user($row['uid']);

                    echo '<div class="menu">
                    Покупатель: '.profileLink($buyer).'<br/>
                    Сумма: '.rub($row['sum']).'<br/>
                    Дата: '.daytime($row['time']).'<br/>
                    '.($buyer && $buyer['wmid'] && $buyer['wmr'] ?

                        'WMID: <a href="//passport.webmoney.ru/asp/certview.asp?wmid='.$buyer['wmid'].'">'.$buyer['wmid'].'</a><br/>
                         BL: <img src="//bl.wmtransfer.com/img/bl/'.$buyer['wmid'].'?w=45&h=18&bg=0XDBE2E9.png" alt="bl"><br/>
                         Претензии/Отзывы/Иски: <a href="//arbitrage.webmoney.ru/asp/claims.asp?wmid='.$buyer['wmid'].'"><img src="//arbitrage.webmoney.ru/xml/AL2.aspx?wmid='.$buyer['wmid'].'" alt="arb"></a><br/>
                         Кошелек: <img src="/img/wmr.png" alt="wmr">'.$buyer['wmr'].'<br/>' :

                        '<div class="danger">Реквизиты не заполнены!</div>'

                    ).
                    ($row['status'] == 1 ? '<div class="good">Средства перечислены на баланс!</div>' : ($row['status'] == 2 ? '<div class="danger">Средства временно заморожены!</div>' : '<div class="information">Средства станут доступны '.daytime($row['time'] + 3600 * 24 * $sys['system']['sdays']).'!</div>') . '<div class="butt2"><a href="?back='.$row['id'].'">Возврат средств</a></div>').'
                    </div>';

                }

                $page->navigation();

            }

            echo '<div class="forlink"><a href="/shop/product/'.$id.'" class="links"><img src="/img/product.png" alt="">Вернуться к товару</a></div>';

        } else {
            header('Location: /shop');
        }
    } else {
        header('Location: /shop');
    }
} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>