<?php
$title = 'Просмотр товара';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if ($sys['modules']['shop'] == 1) {

    $strow = $connect->prepare("select * from `shop` where `id` = ?");
    $strow->execute(array($id));
    $row = $strow->fetch();

    if ($row) {

        // Автор
        $seller = user($row['seller']);

        // Лайки
        $like = new Respect($id, 1);
        // комментарии
        $type = 2;
        $count_comm = Comments::CountMess($id, $type);

        // категория
        $stmt_kat = $connect->prepare("select * from `kat` where `type` = '1' and `id` = ?");
        $stmt_kat->execute(array($row['kat']));
        $krow = $stmt_kat->fetch();

        // продано копий
        $stmt_purch = $connect->prepare("select count(*) from `purchase` where `pid` = ?");
        $stmt_purch->execute(array($id));
        $purch = $stmt_purch->fetchColumn();

        // Файл
        $fileshop = GlobFiles::findById($id, GlobFiles::FileShop);

        // Теги
        $count_tags = count(tagSearch($row['tags']));

        // скрины
        $screens = GlobFiles::findById($id, GlobFiles::Files, GlobFiles::MaskScreen, true);
        $count_screen = count($screens);

        // иконка
        $icon = GlobFiles::findById($id, GlobFiles::Files, GlobFiles::MaskShopIcon);

        if ($row['free'] == 1) { // если бесплатный

            // Количество скачиваний
            $num_downloads->execute(array($id, 1));
            $count_downloads = $num_downloads->fetchColumn();

        } else {

            $type = $row['uid'] == 0 ? 'универсальный' : 'заказ для '.profileLink($row['uid']);
            $col = $row['limit'] == 0 ? 'не ограничено' : $row['col'];

            // корзина
            $stmt_num_bk = $connect->prepare("select count(*) from `basket` where `pid` = ?");
            $stmt_num_bk->execute(array($id));
            $num_bk = $stmt_num_bk->fetchColumn();

        }

        if (isset($active)) {

            if ($row['free'] == 0) {

                /* Скидка */

                $stmt_dis = $connect->prepare("select * from `discounts` where `pid` = ? and `uid` = ?");
                $stmt_dis->execute(array($id, $user['id']));
                $discount = $stmt_dis->fetch();

                if ($discount) {
                    if ($discount['sum'] < $row['cena'] && $row['uid'] == 0) {
                        $row['cena'] -= $discount['sum'];
                    } else {
                        unset($discount);
                    }
                }

                // наличие в покупках юзера
                $stmt_purchase = $connect->prepare("select count(*) from `purchase` where `pid` = ? and `uid` = ?");
                $stmt_purchase->execute(array($id, $user['id']));
                $user_purchase = $stmt_purchase->fetchColumn();
                // корзина
                $stmt_bk->execute(array($id, $user['id']));
                $bk = $stmt_bk->fetchColumn();

            }

            if (isset($_GET['ban']) && ($adm_id == 1 || $adm_id == 5 || $adm_id == 6)) {

                echo '<div class="title">Модерация товара</div>';

                if (isset($_POST['cancel'])) {
                    header('Location: /shop/product/'.$id);
                }
                elseif (isset($_POST['done']) || isset($_POST['block'])) {

                    $status = isset($_POST['block']) ? 2 : 1;
                    $message = !empty($_POST['message']) ? '[br]Примечание: '.$_POST['message'] : '';
                    $stmt = $connect->prepare("update `shop` set `time` = ?, `status` = ? where `id` = ?");

                    if ($stmt->execute(array(time(), $status, $id))) {

                        if ($row['seller'] != $user['id'])
                            notification('Ваш товар [url='.ROOT.'/shop/product/'.$row['id'].']'.$row['name'].'[/url] '.($status == 1 ? '[color=green]одобрен[/color]' : '[color=red]не одобрен[/color]').' для участия в продажах.'.$message, $row['seller']);

                        header('Location: /shop/product/'.$id);

                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }

                echo '<div class="menu">
                <form action="" method="POST">
                Примечание:<br/><textarea name="message"></textarea><br/>
                <input type="submit" name="done" value="Одобрить">
                <input type="submit" name="block" value="Запретить размещение">
                <input type="submit" name="cancel" value="Отмена">
                </form></div>';

            }

            if ($adm_id == 1 || $row['seller'] == $user['id']) {

                if (isset($_GET['del'])) {

                    echo '<div class="title">Удаление товара</div>';

                    // платежи
                    $stmt_p = $connect->prepare("select count(*) from `purchase` where `status` != '1' and `pid` = ?");
                    $stmt_p->execute(array($id));

                    if (!$stmt_p->fetchColumn()) {
                        if (isset($_POST['cancel'])) {
                            header('Location: /shop/product/'.$id);
                        }
                        elseif (isset($_POST['del'])) {

                            $del_shop = $connect->prepare("delete from `shop` where `id` = ?");
                            $del_basket = $connect->prepare("delete from `basket` where `pid` = ?");
                            $del_dis = $connect->prepare("delete from `discounts` where `pid` = ?");

                            if ($del_shop->execute(array($id)) &&
                                $del_basket->execute(array($id)) &&
                                $del_dis->execute(array($id)) &&
                                $del_downloads->execute(array($id, 1)) &&
                                Comments::DelMess($id, $type) &&
                                $like->removeLikes()) {

                                /* Чистим мусор */

                                GlobFiles::DelAllById($id, GlobFiles::Files, GlobFiles::MaskScreen);

                                if (!$purch && $fileshop)
                                    unlink($fileshop);

                                if ($icon)
                                    unlink($icon);

                                header('Location: /shop');

                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }

                        echo '<div class="menu">
                        <form action="" method="POST">
                        <input type="submit" name="del" value="Подтвердить удаление">
                        <input type="submit" name="cancel" value="Отмена">
                        </form></div>';

                    } else {
                        header('Location: /shop/product/'.$id);
                    }
                }
                elseif (isset($_GET['edit'])) {

                    echo '<div class="title">Редактирование товара</div>';

                    if (isset($_POST['cancel'])) {
                        header('Location: /shop/product/'.$id);
                    }
                    elseif (isset($_POST['edit'])) {

                        $error = '';

                        if (empty($_POST['name'])) {
                            $error.= 'Введите название товара!<br/>';
                        }
                        elseif (mb_strlen($_POST['name']) < 5 || mb_strlen($_POST['name']) > 250) {
                            $error.= 'Название должно содержать от 5 до 250 символов!<br/>';
                        }
                        if (empty($_POST['text'])) {
                            $error.= 'Введите описание товара!<br/>';
                        }
                        elseif (mb_strlen($_POST['text']) < 15 || mb_strlen($_POST['text']) > 15000) {
                            $error.= 'Описание должно содержать от 15 до 15000 символов!<br/>';
                        }
                        if (count(tagSearch($_POST['tags'])) > $sys['system']['stags']) {
                            $error.= 'Максимальное количество тегов - '.$sys['system']['stags'].'!<br/>';
                        }
                        if (empty($_POST['kat'])) {
                            $error.= 'Выберите категорию товара!<br/>';
                        }
                        if (empty($_POST['free']) || $sys['modules']['shop_free'] == 0) {
                            if (empty($_POST['cena'])) {
                                $error.= 'Введите стоимость товара!<br/>';
                            }
                            elseif ($_POST['cena'] < $sys['system']['scena']) {
                                $error.= 'Минимальная стоимость товара - '.rub($sys['system']['scena']).'!<br/>';
                            }
                            if ($_POST['uid'] != 0 && !user($_POST['uid'])) {
                                $error.= 'Пользователь с таким ID не найден в системе!<br/>';
                            }
                            elseif ($_POST['uid'] == $user['id']) {
                                $error.= 'Нельзя продавать самому себе!<br/>';
                            }
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {

                            $free = (!empty($_POST['free']) && $sys['modules']['shop_free'] == 1 ? 1 : 0);
                            $uid = intval($_POST['uid']);
                            $col = $uid == 0 ? intval(abs($_POST['col'])) : 1;
                            $cena = floatval($_POST['cena']);
                            $limit = $col == 0 ? 0 : 1;
                            if ($free == 1)
                                $uid = $col = $cena = $limit = 0;
                            $status = ($adm_id == 1 || $sys['modules']['mod_p'] == 1) ? $row['status'] : 3;

                            $stmt = $connect->prepare("update `shop` set `status` = ?, `name` = ?, `text` = ?, `tags` = ?, `kat` = ?, `cena` = ?, `col` = ?, `limit` = ?, `uid` = ?, `free` = ? where `id` = ?");

                            if ($stmt->execute(array($status, $_POST['name'], $_POST['text'], $_POST['tags'], $_POST['kat'], $cena, $col, $limit, $uid, $free, $id))) {

                                if ($uid != 0)
                                    notification('В магазине опубликован [url='.ROOT.'/shop/product/'.$id.']товар[/url] специально для Вас!', $uid);

                                header('Location: /shop/product/'.$id);

                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }
                    }

                    echo '<div class="menu">
                    <form action="" method="POST">
                    Название товара [5-250]:<br/><input type="text" name="name" value="'.$row['name'].'"><br/>
                    Описание товара [15-15000]:<br/><textarea name="text" rows="3" cols="20">'.$row['text'].'</textarea><br/>
                    Теги (через запятую):<br/><input type="text" name="tags" value="'.$row['tags'].'"><br/>
                    Категория:<br/><select name="kat">';

                    $sql = $connect->query("select * from `kat` where `type` = '1' order by `id` desc")->fetchAll();

                    foreach ($sql as $kat_row) {

                        echo '<option ' . ($row['kat'] == $kat_row['id'] ? 'selected' : '') . ' value="'.$kat_row['id'].'">'.$kat_row['name'].'</option>';

                    }

                    echo '</select><br/>
                    '.($sys['modules']['shop_free'] == 1 ?
                   'Тип:<br/><select id="free" name="free">
                    <option value="0">Платный</option>
                    <option '.($row['free'] == 1 ? 'selected' : '').' value="1">Бесплатный</option>
                    </select><br/>' : '').'
                    <div id="paid" class="'.($row['free'] == 1 ? 'wa-hidden' : 'wa-block').'">
                    Стоимость товара:<br/><input type="text" name="cena" value="'.$row['cena'].'"><br/>
                    Количество копий (0 - без ограничений):<br/><input type="text" name="col" value="'.$row['col'].'"><br/>
                    ID покупателя (0 - доступен всем):<br/><input type="text" name="uid" value="'.$row['uid'].'"><br/>
                    </div>
                    <input type="submit" name="edit" value="Сохранить">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                    ?>
                    <script>
                        $(function() {
                            var free = $('#free');
                            free.change(function() {
                                if (free.val() == 1) {
                                    $('#paid').hide();
                                } else {
                                    $('#paid').show();
                                }
                            });
                        });
                    </script>
                    <?

                }

            }

            if ($row['seller'] == $user['id']) {

                if (isset($_GET['screen']) && $count_screen < $sys['system']['shop_attach']) {

                    echo '<div class="title">Загрузка скриншотов</div>';

                    if (isset($_POST['cancel'])) {
                        header('Location: /shop/product/'.$id);
                    }
                    elseif (isset($_POST['upload_screen'])) {

                        $error = '';

                        $reFiles = reArrayFiles($_FILES['filename']);

                        foreach ($reFiles as $key => $file) {
                            if (file_exists($file['tmp_name'])) {
                                if (!BeforeUpload::AttachPicture($file)) {
                                    $error.= $file['name'] . ': неверный тип файла!<br/>';
                                }
                                if ($file['size'] > 1024 * 1024) {
                                    $error.= $file['name'] . ': максимальный размер файла - 1 Mb!<br/>';
                                }
                            } else {
                                unset($reFiles[$key]);
                            }
                        }
                        if ($count_screen + count($reFiles) > $sys['system']['shop_attach']) {
                            $error.= 'Максимальное количество прикреплённых файлов - '.$sys['system']['shop_attach'].'!<br/>';
                        }
                        elseif (count($reFiles) == 0) {
                            $error.= 'Выберите хотя бы 1 файл!<br/>';
                        }
                        elseif (count($reFiles) > 10) {
                            $error.= 'Нельзя загружать более 10 файлов одновременно!<br/>';
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {

                            $path = $_SERVER["DOCUMENT_ROOT"]."/files/";

                            foreach ($reFiles as $key => $file) {
                                if (file_exists($file['tmp_name'])) {
                                    $files = $id."_".$key."_screen_".random_int(11111, 99999)."_".$file['name'];
                                    $full_path = $path . $files;
                                    move_uploaded_file($file['tmp_name'], $full_path);
                                }
                            }

                            header('Location: /shop/product/'.$id);

                        }

                    }

                    echo '<div class="menu">
                    <form action="" method="POST" enctype="multipart/form-data">
                    <div id="inpContFile">
                    <input type="file" name="filename[]" id="file"><br/>
                    <input type="file" name="filename[]" id="file"><br/>
                    <input type="file" name="filename[]" id="file"><br/>
                    <input type="file" name="filename[]" id="file"><br/>
                    <input type="file" name="filename[]" id="file"><br/>
                    </div>
                    <div class="butt1"><a href="javascript:AddFile()">Добавить еще</a></div><br/>
                    <input type="submit" name="upload_screen" value="Загрузить">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                }
                elseif (isset($_GET['upd'])) {

                    echo '<div class="title">Замена архива</div>';

                    if (isset($_POST['cancel'])) {
                        header('Location: /shop/product/'.$id);
                    }
                    elseif (isset($_POST['uploadnew'])) {

                        $error = '';

                        if (!file_exists($_FILES['filename']['tmp_name'])) {
                            $error.= 'Вы не выбрали файл!<br/>';
                        }
                        elseif (!BeforeUpload::AttachArchive($_FILES['filename'])) {
                            $error.= 'Неверный тип файла: разрешено загружать только ZIP/RAR/7Z!<br/>';
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {

                            $status = ($adm_id == 1 || $sys['modules']['mod_p'] == 1) ? $row['status'] : 3;
                            $upd = $row['time'] > time() ? 0 : time();
                            $update = $connect->prepare("update `shop` set `status` = ?, `upd` = ? where `id` = ?");

                            if ($update->execute(array($status, $upd, $id))) {

                                if ($fileshop)
                                    unlink($fileshop);
 
                                $files = $id."_".md5_file($_FILES['filename']['tmp_name'])."_".$_FILES['filename']['name'];
                                $full_path = $_SERVER["DOCUMENT_ROOT"]."/files/shop/".$files;

                                move_uploaded_file($_FILES['filename']['tmp_name'], $full_path);
                                chmod($full_path, 0444);

                                header('Location: /shop/product/'.$id);

                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }

                        }

                    }

                    echo '<div class="menu">
                    <form action="" method="POST" enctype="multipart/form-data">
                    Файл:<br/><input type="file" name="filename"><br/>
                    <input type="submit" name="uploadnew" value="Заменить">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                }
                elseif (isset($_GET['icon'])) {

                    echo '<div class="title">Иконка товара</div>';

                    if (isset($_POST['cancel'])) {
                        header('Location: /shop/product/'.$id);
                    }
                    elseif (isset($_POST['new_icon'])) {

                        $error = '';

                        if (!file_exists($_FILES['filename']['tmp_name'])) {
                            $error.= 'Вы не выбрали файл!<br/>';
                        }
                        elseif (!BeforeUpload::AttachPicture($_FILES['filename'])) {
                            $error.= 'Неверный тип файла!<br/>';
                        }
                        if ($_FILES['filename']['size'] > 1024 * 256) {
                            $error.= 'Максимальный размер файла - 256 Kb!<br/>';
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {

                            $files = $id."_shopIcon_".random_int(11111, 99999)."_".$_FILES['filename']['name'];
                            $full_path = $_SERVER["DOCUMENT_ROOT"]."/files/".$files;
                            move_uploaded_file($_FILES['filename']['tmp_name'], $full_path);

                            if ($icon)
                                unlink($icon);

                            header('Location: /shop/product/'.$id);

                        }

                    }

                    echo '<div class="menu">
                    <form name="form" action="" method="POST" enctype="multipart/form-data">
                    Прикрепить файл:<br/><input type="file" name="filename"><br/>
                    <input type="submit" name="new_icon" value="Загрузить">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                    if ($icon) {

                        if (isset($_POST['del_icon'])) {

                            unlink($icon);

                            header('Location: /shop/product/'.$id);

                        }

                        echo '<div class="menu">
                        <form action="" method="POST">
                        <div class="wa-screen"><img src="/preview/'.$sys['system']['icon_wscr'].'/'.base64_encode('/files/'.basename($icon)).'" alt="icon"></div><br/>
                        <input type="submit" name="del_icon" value="Удалить иконку"><div class="chi">'.basename($icon).' ('.get_filesize($icon).')</div>
                        </form></div>';

                    }

                }
                elseif (isset($_GET['release']) && $row['time'] > time()) {

                    echo '<div class="title">Релиз</div>';

                    if (isset($_POST['cancel'])) {
                        header('Location: /shop/product/'.$id);
                    }
                    elseif (isset($_POST['later'])) {

                        $error = '';

                        if (!empty($_POST['release'])) {
                            $release = validateDate($_POST['date'] . $_POST['time'], 'Y-m-dH:i');
                            if (empty($_POST['date']) || empty($_POST['time'])) {
                                $error.= 'Укажите дату и время релиза!<br/>';
                            }
                            elseif (!$release) {
                                $error.= 'Некорректный формат даты релиза!<br/>';
                            }
                            elseif ($release < time()) {
                                $error.= 'Дата релиза не может быть в прошедшем времени!<br/>';
                            }
                            if (!empty($_POST['comment']) && mb_strlen($_POST['comment']) > 75) {
                                $error.= 'Примечание должно содержать не более 75 символов!<br/>';
                            }
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {
                            $time = !empty($_POST['release']) ? $release : time();
                            $comment = !empty($_POST['release']) ? $_POST['comment'] : '';
                            $stmt = $connect->prepare("update `shop` set `time` = ?, `comment` = ? where `id` = ?");
                            if ($stmt->execute(array($time, $comment, $id))) {
                                header('Location: /shop/product/'.$id);
                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }
                    }

                    echo '<div class="menu">
                    <form action="" method="POST">
                    Релиз:<br/><select id="release" name="release">
                    <option selected value="1">Позже</option>
                    <option value="0">Прямо сейчас</option>
                    </select><br/>
                    <div id="latter">
                    Дата релиза: <small>ГГГГ-ММ-ДД</small><br/><input type="date" name="date" value="'.date('Y-m-d', $row['time']).'"><br/>
                    Время релиза: <small>ЧЧ:ММ</small><br/><input type="text" name="time" value="'.date('H:i', $row['time']).'"><br/>
                    Примечание [75]:<br/><input type="text" name="comment" value="'.$row['comment'].'"><br/>
                    </div>
                    <input type="submit" name="later" value="Продолжить">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                    ?>
                    <script>
                        $(function() {
                            var release = $('#release');
                            release.change(function() {
                                if (release.val() == 1) {
                                    $('#latter').show();
                                } else {
                                    $('#latter').hide();
                                }
                            });
                        });
                    </script>
                    <?

                }
                elseif (isset($_GET['selling']) && $row['status'] == 1 && $row['free'] == 0 && $row['uid'] == 0 && $row['col'] > 0) {

                    echo '<div class="title">Продажи</div>';

                    if (isset($_POST['cancel'])) {
                        header('Location: /shop/product/'.$id);
                    }
                    elseif (isset($_POST['selling'])) {
                        $selling = $row['selling'] == 1 ? 0 : 1;
                        $stmt = $connect->prepare("update `shop` set `selling` = ? where `id` = ?");
                        if ($stmt->execute(array($selling, $id))) {
                            header('Location: /shop/product/'.$id);
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }

                    echo '<div class="menu">
                    <form action="" method="POST">
                    <input type="submit" name="selling" value="'.($row['selling'] == 1 ? 'Приостановить' : 'Продолжить').'">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                }

            }

        }

        echo '<div class="title">Просмотр товара: '.$row['name'].'</div>';

        if ($row['time'] > time())
            echo '<div class="menu">Релиз запланирован на: '.daytime($row['time']).'</div>';

        if (isset($active)) {

            if (isset($_GET['bk']) && $row['free'] == 0 && $row['selling'] == 1 && $row['seller'] != $user['id'] && !$user_purchase) {

                if (isset($_POST['cancel'])) {
                    header('Location: /shop/product/'.$id);
                }
                elseif (isset($_POST['yes'])) {

                    if (!$bk) {

                        notification('[b]'.$user['login'].'[/b] добавил ваш товар [url='.ROOT.'/shop/product/'.$id.']'.$row['name'].'[/url] в корзину.', $row['seller']);

                        $in_basket->execute(array($id, $user['id']));

                    } else {

                        $del_basket->execute(array($id, $user['id']));

                    }

                    header('Location: /shop/product/'.$id);

                }

                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="yes" value="'.(!$bk ? 'Добавить в корзину' : 'Удалить из корзины').'">
                <input type="submit" name="cancel" value="Отмена">
                </form></div>';

            }
            elseif (isset($_GET['respect'])) {

                $review = ($_GET['respect'] == 1);

                $like->Like($review);

                header('Location: /shop/product/'.$id);

            }
            elseif (isset($_GET['dsc']) && isset($screens[$_GET['dsc']]) && $row['seller'] == $user['id']) {

                $filescreen = $screens[$_GET['dsc']];

                if ($filescreen) {

                    if (isset($_POST['cancel'])) {

                        header('Location: /shop/product/'.$id);

                    }
                    elseif (isset($_POST['yes'])) {

                        unlink($filescreen);

                        header('Location: /shop/product/'.$id);

                    }

                    echo '<div class="menu">
                    <form action="" method="POST">
                    <input type="submit" name="yes" value="Удалить скриншот ('.basename($filescreen).')">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                } else {

                    header('Location: /shop/product/'.$id);

                }

            }
            elseif (isset($_GET['dsc_all']) && $row['seller'] == $user['id']) {

                if ($screens) {

                    if (isset($_POST['cancel'])) {

                        header('Location: /shop/product/'.$id);

                    }
                    elseif (isset($_POST['yes'])) {

                        GlobFiles::DelAllById($id, GlobFiles::Files, GlobFiles::MaskScreen);

                        header('Location: /shop/product/'.$id);

                    }

                    echo '<div class="menu">
                    <form action="" method="POST">
                    <input type="submit" name="yes" value="Удалить все скриншоты ('.$count_screen.')">
                    <input type="submit" name="cancel" value="Отмена">
                    </form></div>';

                } else {

                    header('Location: /shop/product/'.$id);

                }

            }

        }

        /* Скрины */

        if ($screens) {

            $page = new Pagination($count_screen, 1);

            $page->setGET('scr');

            $pda = $page->pageDataArray($screens);

            foreach ($pda as $file) {

                $indScr = $page->page - 1;

                $screen = '/files/'.basename($file);

                echo '<div class="menu">
                <div class="wa-screen">
                <img src="/preview/'.$sys['system']['wscr'].'/'.base64_encode($screen).'" alt="preview" data-toggle="modal" data-target="#screen">
                '.(isset($active) && $row['seller'] == $user['id'] ? '<div class="butt1"><a href="?dsc='.$indScr.'">Удалить скриншот</a></div>' : '').'
                </div></div>
                <div id="screen" class="modal fade" tabindex="-1">
                  <div class="modal-dialog">
                    <img src="'.$screen.'" alt="screen" class="img-thumbnail" data-dismiss="modal">
                  </div>
                </div>';

            }

            $page->navigation();

        }

        /* Описание и т. п. */

        echo ($row['time'] <= time() ? '<div class="menu">'.nl2br(smiles(bb(bbyoutube(bblinks($row['text']))))).'</div>' : '').'
        <div class="menu">
        Автор: '.profileLink($seller).'<br/>
        '.($row['time'] <= time() ?
          ($row['free'] == 1 ?
          'Загрузок: '.$count_downloads :
          'Количество копий: '.$col.'<br/>
          Продано копий: '.$purch.'<br/>
          Добавили в корзину: '.$num_bk.' чел.<br/>
          Тип: '.$type).'<br/>
          Размер файла: '.get_filesize($fileshop).'<br/>
          Дата добавления: '.daytime($row['time']).'<br/>
          '.($row['upd'] ? 'Последнее обновление: '.daytime($row['upd']).'<br/>' : '').'
          Стоимость: '.($row['free'] == 1 ? '<span class="wa-span-green">Бесплатно</span>' : (isset($discount['sum']) ? '<span class="wa-span-red"><del>'.($row['cena'] + $discount['sum']).'</del></span> ' : '').rub($row['cena'])).'<br/>'
        : '').
        $like->OutputLikes().'
        </div>';

        if ($row['tags'] && $count_tags > 0)
            echo '<div class="menu">Теги: '.taglink($row['tags'], '/shop/search?search=').'</div>';

        /* Управление */

        echo '<div class="menu">'.($row['status'] == 3 ? '<div class="information">На модерации!</div>' : ($row['status'] == 2 ? '<div class="forbidden">Товар не одобрен!</div>' : '<div class="good">Товар одобрен!</div>')).'</div>
        <div class="menu">
        <div class="butt2">
        <a href="/shop/seller/'.$row['seller'].'">Все товары автора</a><br/>
        <a href="/shop/comments/'.$id.'">Комментарии ('.$count_comm.')</a>
        '.(isset($active) ? ($row['seller'] == $user['id'] ? '
        <br/>
        '.($count_screen < $sys['system']['shop_attach'] ? '<a href="?screen">Загрузить скриншоты</a>' : '').
        ($screens ? '<a href="?dsc_all">Удалить все скриншоты ('.$count_screen.')</a><br/>' : '').'
        <a href="?icon">Иконка товара ('.($icon ? basename($icon) : 'none').')</a><br/>
        <a href="?upd">Замена архива</a>
        '.($row['status'] == 1 && $row['free'] == 0 && $row['uid'] == 0 && $row['col'] > 0 ? '<a href="?selling">'.($row['selling'] == 1 ? 'Приостановить продажи' : 'Продолжить продажи').'</a>' : '').
          ($row['time'] > time() ? '<a href="?release">Релиз</a>' : '').'<br/>
        '.($row['free'] == 0 && $row['uid'] == 0 ? '<a href="/shop/discounts/'.$id.'">Скидки на товар</a>' : '') :
          ($row['free'] == 0 && $row['selling'] == 1 && !$user_purchase ? '<a href="?bk">'.(!$bk ? 'В корзину' : 'Удалить из корзины').'</a>' : '')).
          (($adm_id == 1 || $row['seller'] == $user['id']) ? ($row['free'] == 0 ? '<a href="/shop/pays/'.$id.'">Покупатели ('.$purch.')</a><br/>' : '').'
        <a href="?del">Удалить</a>
        <a href="?edit">Редактировать</a>' : '').
        (($adm_id == 1 || $adm_id == 5 || $adm_id == 6) ? '<a href="?ban">Модерация</a>' : '') : '').'
        </div></div>';

        if ($row['time'] <= time() || $row['seller'] == $user['id']) {

            /* Ссылка на скачивание */

            if ($row['free'] == 1 // если бесплатно
             || (isset($active) && ($user_purchase // если куплено
             || $row['seller'] == $user['id']))) { // если юзер - автор

                echo '<div class="forlink"><a data-noajax href="/shop/download/'.$id.'" class="links"><img src="/img/download.png" alt="download">Скачать<div class="chi">'.get_filesize($fileshop).'</div></a></div>';

            }

            /* Донат */

            if ($row['seller'] != $user['id'] &&
                $row['free'] == 1 &&
                DonatesAllowed($seller))
                echo '<div class="forlink"><a href="/donation/'.$row['seller'].'" class="links"><img src="/img/donat.png" alt="donat">Поддержать автора<div class="chi">Отправить донат</div></a></div>';

            /* Покупка */

            if ($row['free'] == 0) {

                if ($row['selling'] == 1) {

                    if (isset($active)) {

                        if ($row['seller'] != $user['id'] && $row['status'] == 1 && !$user_purchase) {

                            if ($row['limit'] == 1 && $row['col'] <= 0) {

                                echo '<div class="menu"><div class="information">Все копии распроданы!</div></div>';

                            } elseif ($row['uid'] != 0 && $row['uid'] != $user['id']) {

                                echo '<div class="menu"><div class="information">Этот товар не для вас!</div></div>';

                            } elseif ($sys['modules']['wmid_buy'] == 1 && (!$user['wmid'] || !$user['wmr']) && $sys['payment']['wmr'] && $sys['payment']['hash']) {

                                echo '<div class="menu"><div class="danger"><a href="/settings/wmid">Подтвердите реквизиты</a>, чтобы была возможность купить товар!</div></div>';

                            } elseif ($user['money'] < $row['cena']) {

                                echo '<div class="menu"><div class="information">Недостаточно средств для покупки!</div></div>';

                            } elseif (isset($_GET['buy'])) {

                                if (isset($_POST['cancel'])) {

                                    header('Location: /shop/product/'.$id);

                                }
                                elseif (isset($_POST['yes'])) {

                                    // покупка
                                    $buy = $connect->prepare("insert into `purchase` set `time` = ?, `pid` = ?, `name` = ?, `uid` = ?, `seller` = ?, `sum` = ?");
                                    $stmt = $connect->prepare("update `shop` set `col` = `col` - '1' where `id` = ?");
                                    $del_discount = $connect->prepare("delete from `discounts` where `id` = ?");

                                    if (pay(-$row['cena'], $user['id']) && $buy->execute(array(time(), $id, $row['name'], $user['id'], $row['seller'], $row['cena']))) {

                                        notification('[b]'.$user['login'].'[/b] купил ваш товар [url='.ROOT.'/shop/product/'.$id.']'.$row['name'].'[/url]', $row['seller']);

                                        ratingUser($sys['rating']['buy'], $user['id']);

                                        if ($row['limit'] == 1)
                                            $stmt->execute(array($id));

                                        if ($bk)
                                            $del_basket->execute(array($id, $user['id']));

                                        if (isset($discount['id']))
                                            $del_discount->execute(array($discount['id']));

                                        header('Location: /shop/purchase');

                                    } else {

                                        echo '<div class="menu">Произошла ошибка!</div>';

                                    }

                                } else {

                                    echo '<div class="menu">
                                    <form action="" method="POST">
                                    <div class="wa-sm-text">Скидка: '.(isset($discount['sum']) ? '<font color="#4cae4c">'.rub($discount['sum']).'</font>' : '<font color="#d8544f">Нет</font>').'</div>
                                    <input type="submit" name="yes" value="Подтвердить покупку ('.rub($row['cena']).')">
                                    <input type="submit" name="cancel" value="Отмена">
                                    </form></div>';

                                }

                            } else {

                                echo '<div class="forlink"><a href="?buy" class="links"><img src="/img/money.png" alt="buy">Купить<div class="chi">'.rub($row['cena']).'</div></a></div>';

                            }

                        }

                    } else {

                        echo '<div class="menu"><div class="information">Авторизуйтесь, чтобы была возможность купить товар.</div></div>';

                    }

                } else {

                    echo '<div class="menu"><div class="information">Продажи приостановлены!</div></div>';

                }

            }

        }

        if ($krow)
            echo '<div class="forlink"><a href="/shop/category/'.$krow['id'].'" class="links"><img src="/img/folder.png" alt="folder">'.$krow['name'].'</a></div>';

        echo '<div class="forlink"><a href="/shop" class="links"><img src="/img/shop.png" alt="">Магазин скриптов</a></div>';

    } else {
        header('Location: /');
    }
} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>