<?php
$title = 'Профиль';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");

$row = user($id);

if ($row) {

    echo '<div class="title">Профиль<span class="white-right-block-txt">'.iconUser($row) . gradientUser($row).'</span></div>';

    // prepared
    $del_black = $connect->prepare("delete from `blacklist` where `uid` = ? and `black` = ?");
    $in_black = $connect->prepare("insert into `blacklist` set `uid` = ?, `black` = ?");
    $in_friend = $connect->prepare("insert into `friend` set `from` = ?, `to` = ?");

    // Авторизация
    $auth = authlog($id);
    $online = online($auth);

    // Лайки
    $like = new Respect($id, 0);

    // Рефералы
    $stmt_ref->execute(array($id));
    $ref = $stmt_ref->fetchColumn();

    // Друзья
    $stmt_friends->bindValue(':user', $id, PDO::PARAM_INT);
    $stmt_friends->execute();
    $count_fr = $stmt_friends->fetchColumn();

    // ЧС
    $inMyBlacklist = in_blacklist($user['id'], $id);
    $inHisBlacklist = in_blacklist($id, $user['id']);
    $eachBlacklist = ($inMyBlacklist || $inHisBlacklist);

    // Иконка пользователя
    $icon = GlobFiles::findById($id, GlobFiles::UserIcon);

    // Аватарка пользователя
    $avatar = GlobFiles::findById($id, GlobFiles::UserAvatar);

    // День рождения
    $birth = DateTime::createFromFormat('Y-m-d', $row['birth']);

    if (isset($active)) {
        if (isset($_GET['black']) && $id != $user['id']) {
            if (isset($_POST['cancel'])) {
                header('Location: /user/'.$id); 
            }
            elseif (isset($_POST['yes'])) {

                if ($inMyBlacklist) {

                    if ($del_black->execute(array($user['id'], $id))) {

                        header('Location: /user/'.$id);

                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }

                } else {

                    if ($in_black->execute(array($user['id'], $id)) &&
                        contact_del($user['id'], $id)) {

                        header('Location: /user/'.$id);

                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }

                }
            }

            echo '<div class="menu">
            <form action="" method="POST">
            <input type="submit" name="yes" value="'.($out_blacklist ? 'Удалить из ЧС' : 'Добавить в ЧС').'">
            <input type="submit" name="cancel" value="Отмена">
            </form></div>';

        }
        elseif (isset($_GET['respect']) && $id != $user['id'] && !$inHisBlacklist) {
            if ($like->userLike) {
                header('Location: /user/'.$id);
            } else {
                $review = ($_GET['respect'] == 1);
                $like->Like($review);
                notification('[b]'.$user['login'].'[/b] '.($review ? '[color=green]повысил[/color]' : '[color=red]понизил[/color]').' вам репутацию.', $id);
                header('Location: /user/'.$id);
            }
        }
    }

    if (isset($active) && $id != $user['id'] && !$eachBlacklist) {

        /* Добавление/удаление из друзей */

        $strow_fr = $connect->prepare("select * from `friend` where `from` = :from and `to` = :to or `from` = :to and `to` = :from");
        $strow_fr->bindValue(':from', $id, PDO::PARAM_INT);
        $strow_fr->bindValue(':to', $user['id'], PDO::PARAM_INT);
        $strow_fr->execute();
        $friend = $strow_fr->fetch(PDO::FETCH_ASSOC);

        if (isset($_GET['friend']) && (($friend && ($friend['status'] == 1 || $friend['status'] == 0 && $friend['from'] == $user['id'])) || !$friend)) {

            if (!$friend) {

                $in_friend->execute(array($user['id'], $id));

            } elseif ($friend['status'] == 1 || $friend['status'] == 0 && $friend['from'] == $user['id']) {

                if ($friend['status'] == 1)
                    notification('[b]'.$user['login'].'[/b] удалил вас из друзей.', $id);

                $del_friend->execute(array(':from' => $id, ':to' => $user['id']));

            }

            header('Location: /user/'.$id);

        }

    }

    echo '<div class="menu">
    <div class="wa-user-block">
    <div class="wa-user-col-top">
    '.($birth && date('d.m') == $birth->format('d.m') ?
       '<div class="menu"><img src="/img/cake.png" alt="cake">Сегодня у '.($row['pol'] == 1 ? 'него' : 'неё').' День рождения!</div>' : '').
      (!$online && $auth ?
       '<div class="menu">Последний визит: '.daytime($auth['lasttime']).deviceIcon($auth['ua']).'</div>' : '').'
    </div></div>
    <div class="wa-user-block">
    <div class="wa-user-col-left">
    <div class="menu">
    '.($row['ban'] > time() ? '<div class="danger">Этот пользователь заблокирован (До '.date('d.m.Y H:i', $row['ban']).')</div>' : '').
    ($avatar ? '<img src="/preview/'.$sys['system']['wava'].'/'.base64_encode('/files/avatar/'.basename($avatar)).'" alt="preview" data-toggle="modal" data-target="#avatar">
        <div id="avatar" class="modal fade" tabindex="-1">
          <div class="modal-dialog">
            <img src="/files/avatar/'.basename($avatar).'" alt="avatar" class="img-thumbnail" data-dismiss="modal">
          </div>
        </div>' :
       '<img src="/files/avatar/no_avatar.png" alt="no_avatar">').'
    </div></div>
    <div class="wa-user-col-right">
    <div class="menu">
    <span class="online">'.$online.'</span>
    '.($row['admin'] != 0 && isset(LEVELS[$row['admin']]) ? '<div class="'.($row['admin'] == 1 ? 'green-block-txt' : 'orange-block-txt').'">'.($row['adm_pos'] ? $row['adm_pos'] : LEVELS[$row['admin']]).'</div><br/>' : '').
    ($row['name'] ? 'Имя: '.$row['name'].'<br/>' : '').
    ($row['info'] ? 'О себе: '.$row['info'].'<br/>' : '').'
    Пол: '.($row['pol'] == 1 ? 'Мужской' : 'Женский').'<br/>
    '.($birth ? ($row['hd'] == 1 ? 'День рождения: '.$birth->format('d.m') : 'Дата рождения: '.$birth->format('d.m.Y')) : '').'
    </div>
    '.($row['status'] ? '<div class="menu">'.nl2br(smiles(bb($row['status']))).'</div>' : '').'
    </div></div>
    <div class="wa-user-block">
    <div class="wa-user-col-bottom">
    '.(isset($active) && $id != $user['id'] && !$eachBlacklist ?
       '<div class="menu">
        <div class="wa-table">
        '.(privateMail($row, $user['id']) ? '<div class="wa-table-column" width="50%"><a href="/mail/read/'.$id.'" class="wa-table-butt">Написать сообщение</a></div>' : '').
          (($friend && ($friend['status'] == 1 || $friend['status'] == 0 && $friend['from'] == $user['id']) || !$friend) ?
           '<div class="wa-table-column" width="50%"><a href="?friend" class="wa-table-butt">'.($friend && $friend['status'] == 0 && $friend['from'] == $user['id'] ? 'Отменить заявку' : ($friend && $friend['status'] == 1 ? 'Удалить из друзей' : 'Добавить в друзья')).'</a></div>' : '').'
        </div></div>' : '').'
    </div></div></div>';

    echo '<div class="menu">
    Друзей: '.$count_fr.'<br/>
    Рефералов: '.$ref.'<br/>
    '.(($row_ref = user($row['ref'])) ? 'Пригласил: '.profileLink($row_ref).'<br/>' : '').'
    Рейтинг: '.rankUser($row['rating']).'<br/>
    <div class="butt9">
    <a href="?respect=1"><span class="wa-span-green"><img src="/img/trending-up.png" alt="trending-up">'.$like->plus.'</span></a>
    <a href="?respect=0"><span class="wa-span-red"><img src="/img/trending-down.png" alt="trending-down">'.$like->minus.'</span></a>
    </div>
    </div>
    <div class="menu">
    Дата регистрации: '.daytime($row['datereg']).'<br/>
    ID: '.$row['id'].'
    </div>';

    if ($id != $user['id'] &&
        DonatesAllowed($row))
        echo '<div class="forlink"><a href="/donation/'.$id.'" class="links"><img src="/img/donat.png" alt="donat">Отправить донат</a></div>';

    if (isset($active)) {

        if ($id != $user['id'])
            echo '<div class="forlink"><a href="?black" class="links"><img src="/img/nonotif.png" alt="nonotif">'.($inMyBlacklist ? 'Удалить из ЧС' : 'Добавить в ЧС').'</a></div>';

    }

    if ($adm_id == 1 || $adm_id == 5) {

        echo '<div class="title">Управление</div>';

        // Выплачено юзеру
        $stmt_user_payment->execute(array($id));
        $u_payment = $stmt_user_payment->fetchColumn() ?? 0;

        // Пополнено юзером
        $stmt_user_plus->execute(array(0, $id));
        $u_plus = $stmt_user_plus->fetchColumn() ?? 0;

        if (isset($_GET['donation']) && $sys['modules']['donat_s'] != 0 && $adm_id == 1) {
            if (isset($_POST['cancel'])) {
                header('Location: /user/'.$id);
            } 
            elseif (isset($_POST['yes'])) {

                $select = $_POST['donation'] ?? 0;

                $donation = $select == 0 ? (in_array($row['donation'], [0, 3]) ? $row['donation'] : 0) :
                           ($select == 1 ? (in_array($row['donation'], [1, 4]) ? $row['donation'] : 1) : 2);

                $stmt = $connect->prepare("update `users` set `donation` = ? where `id` = ?");

                if ($stmt->execute(array($donation, $id))) {
                    header('Location: /user/'.$id);
                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
            echo '<div class="menu">
            <form action="" method="POST">
            Сбор донатов:<br><select name="donation">
            <option value="0">По умолчанию</option>
            <option '.(($row['donation'] == 1 || $row['donation'] == 4) ? 'selected' : '').' value="1">Всегда разрешать</option>
            <option '.($row['donation'] == 2 ? 'selected' : '').' value="2">Всегда запрещать</option>
            </select><br/>
            <input type="submit" name="yes" value="Сохранить"/> 
            <input type="submit" name="cancel" value="Отмена"/>
            </form></div>';
        }
        elseif (isset($_GET['active']) && $id != $user['id']) {
            if (isset($_POST['cancel'])) {
                header('Location: /user/'.$id);
            } 
            elseif (isset($_POST['yes'])) {
                $status = $row['active'] == 1 ? 0 : 1;
                if ($active_user->execute(array($status, $id))) {
                    header('Location: /user/'.$id);
                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
            echo '<div class="menu">
            <form action="" method="POST">
            <input type="submit" name="yes" value="'.($row['active'] == 1 ? 'Деактивировать аккаунт' : 'Активировать аккаунт').'"/> 
            <input type="submit" name="cancel" value="Отмена"/>
            </form></div>';
        }
        elseif (isset($_GET['edit']) && $adm_id == 1) {
            if (isset($_POST['cancel'])) {
                header('Location: /user/'.$id);
            }
            elseif (isset($_POST['red'])) {
                $error = '';
                if (empty($_POST['login'])) {
                    $error.= 'Введите логин!<br/>';
                }
                elseif (mb_strlen($_POST['login']) < 3 || mb_strlen($_POST['login']) > 15) {
                    $error.= 'Логин должен содержать от 3 до 15 символов!<br/>';
                }
                elseif (!preg_match("#^[a-z0-9_-]{1,15}$#i", $_POST['login'])) {
                    $error.= 'Логин должен состоять из латинских букв и/или цифр!<br />';
                }
                elseif ($_POST['login'] != $row['login'] && user($_POST['login'], 1)) {
                    $error.= 'Этот логин занят!<br/>';
                }
                if (!is_numeric($_POST['money'])) {
                    $error.= 'Баланс заполнен неверно!<br/>';
                }
                if (!is_numeric($_POST['rating'])) {
                    $error.= 'Рейтинг заполнен неверно!<br/>';
                }
                if (empty($_POST['email'])) {
                    $error.= 'Поле e-mail обязательно для заполнения!<br/>';
                }
                elseif (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
                    $error.= 'Поле e-mail заполнено неверно!<br/>';
                }
                elseif ($_POST['wmid'] != NULL && !preg_match("#^[0-9]{12}$#i", $_POST['wmid'])) {
                    $error.= 'Неверно введен WMID: вводить нужно 12 цифр!<br/>';
                }
                elseif ($_POST['wmr'] != NULL && !preg_match("#^R[0-9]{12}$#i", $_POST['wmr'])) {
                    $error.= 'Неверно введен WMR-кошелек: вводить нужно, начиная с R!<br/>';
                }
                if ($error) {
                    echo '<div class="menu">'.$error.'</div>';
                } else {
                    $stmt = $connect->prepare("update `users` set `login` = ?, `money` = ?, `rating` = ?, `wmid` = ?, `wmr` = ?, `email` = ? where `id` = ?");
                    if ($stmt->execute(array($_POST['login'], $_POST['money'], $_POST['rating'], $_POST['wmid'], $_POST['wmr'], $_POST['email'], $id))) {
                        header('Location: /user/'.$id);
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
            }
            echo '<div class="menu">
            <form action="" method="POST">
            Логин:<br/><input type="text" name="login" value="'.$row['login'].'"><br/>
            Баланс:<br/><input type="text" name="money" value="'.$row['money'].'"><br/>
            Рейтинг:<br/><input type="text" name="rating" value="'.$row['rating'].'"><br/>
            E-mail:<br/><input type="email" name="email" value="'.$row['email'].'"><br/>
            WMID:<br/><input type="text" name="wmid" value="'.$row['wmid'].'"><br/> 
            R-кошелек:<br/><input type="text" name="wmr" value="'.$row['wmr'].'"><br/> 
            <input type="submit" name="red" value="Сохранить">
            <input type="submit" name="cancel" value="Отмена">
            </form></div>';
        }
        elseif (isset($_GET['adm']) && $id != $user['id'] && $adm_id == 1) {
            if (isset($_POST['cancel'])) {
                header('Location: /user/'.$id);
            }
            elseif (isset($_POST['ok'])) {
                $error = '';
                if (!isset(LEVELS[$_POST['status']])) {
                    $error.= 'Данного уровня пользователя нет!<br/>';
                }
                if ($error) {
                    echo '<div class="menu">'.$error.'</div>';
                } else {
                    $stmt = $connect->prepare("update `users` set `admin` = ?, `adm_pos` = ? where `id` = ?");
                    if ($stmt->execute(array($_POST['status'], ($_POST['status'] != 0 ? $_POST['adm_pos'] : ''), $id))) {
                        header('Location: /user/'.$id);
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
            }

            echo '<div class="menu">
            <form action="" method="POST">
            Должность:<br/><input type="text" name="adm_pos" value="'.$row['adm_pos'].'"><br/>
            Уровень:<br/><select name="status">';

            foreach (LEVELS as $key => $value) {

                echo '<option ' . ($row['admin'] == $key ? 'selected' : '') . ' value="'.$key.'">'.$value.'</option>'; 

            }

            echo '</select><br/> 
            <input type="submit" name="ok" value="Назначить">
            <input type="submit" name="cancel" value="Отмена">
            </form></div>';
        } 
        elseif (isset($_GET['ban']) && $id != $user['id'] && $row['admin'] == 0) {
            $ban = $connect->prepare("update `users` set `ban` = ? where `id` = ?"); 
            if ($row['ban'] > time()) {
                if (isset($_POST['cancel'])) {
                    header('Location: /user/'.$id);
                }
                elseif (isset($_POST['ok'])) {
                    if ($ban->execute(array(0, $id))) {
                        header('Location: /user/'.$id);
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                } 
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="ok" value="Разблокировать аккаунт">
                <input type="submit" name="cancel" value="Отмена">
                </form></div>';
            } else {
                if (isset($_POST['cancel'])) {
                    header('Location: /user/'.$id);
                }
                elseif (isset($_POST['ok'])) {
                    $error = '';
                    if (empty($_POST['hours'])) {
                        $error.= 'Введите количество часов!<br/>';
                    } 
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {
                        $hours = intval(abs($_POST['hours']));
                        $time = time() + 3600 * $hours;
                        if ($ban->execute(array($time, $id))) {
                            header('Location: /user/'.$id);
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                }
                echo '<div class="menu">
                <form action="" method="POST">
                Количество часов:<br/><input type="text" name="hours"><br/>
                <input type="submit" name="ok" value="Заблокировать аккаунт">
                <input type="submit" name="cancel" value="Отмена">
                </form></div>';
            }
        }
        elseif (isset($_GET['del']) && $id != $user['id'] && $adm_id == 1) {
            if (isset($_POST['cancel'])) {
                header('Location: /user/'.$id);
            } 
            elseif (isset($_POST['yes'])) {

                // Удаляем юзера
                $del = $connect->prepare("delete from `users` where `id` = ?");
                // Удаляем друзей
                $del_friend = $connect->prepare("delete from `friend` where `from` = :uid or `to` = :uid");
                // Чистим логи авторизаций
                $del_authlog = $connect->prepare("delete from `authlog` where `uid` = ?");
                // Чистим логи пополнений
                $del_plus = $connect->prepare("delete from `plus` where `type` = ? and `uid` = ?");

                if ($del->execute(array($id)) &&
                    $del_friend->execute(array(':uid' => $id)) &&
                    $del_authlog->execute(array($id)) &&
                    $del_plus->execute(array(0, $id)) &&
                    $like->removeLikes() &&
                    DelUserMail($id)) {

                    // удаляем аватарку
                    if ($avatar)
                        unlink($avatar);

                    // удаляем иконку
                    if ($icon)
                        unlink($icon);

                    header('Location: /');

                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }

            echo '<div class="menu">
            <form action="" method="POST">
            <input type="submit" name="yes" value="Удалить аккаунт"/> 
            <input type="submit" name="cancel" value="Отмена"/>
            </form></div>';

        }
        elseif (isset($_GET['chatlog']) && $row['admin'] == 0) {
            if (isset($_POST['cancel'])) {
                header('Location: /user/'.$id);
            } 
            elseif (isset($_POST['yes'])) {
                if (Comments::DelUserMess($id) &&
                    DelUserMail($id)) {

                    header('Location: /user/'.$id);

                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }

            echo '<div class="menu">
            <form action="" method="POST">
            <input type="submit" name="yes" value="Очистить историю сообщений"/> 
            <input type="submit" name="cancel" value="Отмена"/>
            </form></div>';

        }

        // Говорим админу, что юзера атакуют

        if ($row['captcha'] && $row['attempts']) {

            echo '<div class="menu">
            <div class="danger">Возможно этот акаунт пытались взломать!
              <div class="red">
                Время: '.daytime($row['captcha']).'<br/>
                Ошибочных попыток ввода пароля: '.$row['attempts'].'
              </div>
            </div>
            </div>';

        }

        echo '<div class="menu">
        Баланс: '.rub($row['money']).'<br/>
        Выплачено: '.rub($u_payment).'<br/>
        Пополнено: '.rub($u_plus).'<br/>
        WMID: '.($row['wmid'] ?
            '<a data-noajax href="//passport.webmoney.ru/asp/certview.asp?wmid='.$row['wmid'].'">'.$row['wmid'].'</a><br/>
             BL: <img src="//bl.wmtransfer.com/img/bl/'.$row['wmid'].'?w=45&h=18&bg=0XDBE2E9.png" alt="bl"><br/>
             Претензии/Отзывы/Иски: <a data-noajax href="//arbitrage.webmoney.ru/asp/claims.asp?wmid='.$row['wmid'].'"><img src="//arbitrage.webmoney.ru/xml/AL2.aspx?wmid='.$row['wmid'].'" alt="arb"></a>'
          : 'Не заполнен').'<br/>
        Кошелек: '.($row['wmr'] ? '<img src="/img/wmr.png" alt="wmr">'.$row['wmr'] : 'Не заполнен').'<br/>
        E-mail: '.($sys['modules']['email_verify'] == 1 ? ($row['active'] == 1 ? '<font color="#4cae4c">'.$row['email'].'</font>' : '<font color="#d8544f">'.$row['email'].'</font>') : $row['email']).'<br/>
        '.($auth ? 'IP: <a href="/adm/ip?ip='.$auth['ip'].'">'.$auth['ip'].'</a><br/>
        UA: '.$auth['ua'].'<br/>' : '').'
        Временная зона: '.($row['timezone'] ? $row['timezone'] : 'DEFAULT').'
        <div class="butt2">
        '.($adm_id == 1 ? ($id != $user['id'] ? '<a href="?del">Удалить аккаунт</a>
        <a href="?adm">Должность пользователя</a>' : '').
        ($sys['modules']['email_verify'] == 1 && $id != $user['id'] ? '<a href="?active">'.($row['active'] == 1 ? 'Деактивировать аккаунт' : 'Активировать аккаунт').'</a>' : '').'
        <a href="?edit">Редактировать аккаунт</a><br/>' : '').
        ($id != $user['id'] && $row['admin'] == 0 ? '<a href="?ban">'.($row['ban'] > time() ? 'Разблокировать аккаунт' : 'Заблокировать аккаунт').'</a>' : '').
        ($row['admin'] == 0 ? '<a href="?chatlog">Очистить историю сообщений</a>' : '').
        ($sys['modules']['donat_s'] != 0 && $adm_id == 1 ? '<a href="?donation">Настройки сбора донатов</a>' : '').'
        </div>
        </div>';

        /* Быстрое уведомление */

        echo '<div class="menu">
        <div class="menu-title">Быстрое уведомление</div>';

        if (isset($_POST['notif'])) {

            $error = '';

            if (empty($_POST['text'])) {
                $error.= 'Введите текст уведомления!<br/>';
            }
            if ($error) {
                echo '<div class="red">'.$error.'</div>';
            } else {
                notification($_POST['text'], $id);
                echo '<div class="green">Уведомление отправлено!</div>';
            }
        }

        echo '<form action="" method="POST">
        Уведомление:<br/><input type="text" name="text"><br/>
        <input type="submit" name="notif" value="Отправить">
        </form>
        </div>';

        /* Логи входов */

        $stmt_auth->execute(array($id));
        $count_auth = $stmt_auth->fetchColumn();

        echo '<div class="title">История авторизаций ('.$count_auth.')</div>';

        if ($count_auth == 0) {
            echo '<div class="menu">Записей нет!</div>';
        } else {

            $page = new Pagination($count_auth, 5);

            $data = $connect->prepare("select * from `authlog` where `uid` = :uid order by `id` desc limit :start, 5");
            $data->bindValue(':uid', $id, PDO::PARAM_INT);
            $data->bindValue(':start', $page->start, PDO::PARAM_INT);
            $data->execute();
            $sql = $data->fetchAll();

            foreach ($sql as $row) {
                echo '<div class="menu">
                Время: '.date('d.m.Y H:i', $row['time']).'<br/>
                Последнее посещение: '.date('d.m.Y H:i', $row['lasttime']).deviceIcon($row['ua']).'<br/>
                IP: <a href="/adm/ip?ip='.$row['ip'].'">'.$row['ip'].'</a><br/>
                UA: '.$row['ua'].
                ($row['status'] == 0 ? '<div class="forbidden">Авторизация сброшена!</div>' : '').'
                </div>';
            }

            $page->navigation();

        }

    }

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>