<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';

user_access('adm_log_read', null, 'index.php?' . SID);

adm_check();

$set['title'] = __('Действия администрации');

include_once '../sys/inc/thead.php';

title();
err();
aut();

if (isset($_GET['id'])) {
    $ank = get_user($_GET['id']);
} else {
    $ank = false;
}

if ($ank && user_access('adm_log_read') && ($ank['id'] == $user['id'] || $ank['level'] < $user['level'])) {
    echo "<a href='/info.php?id=$ank[id]'>$ank[nick]</a> (" . __($ank['group_name']) . ")<br />\n";

    $adm_log_c_all = dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `id_user` = '$ank[id]'"), 0);
    $mes = mktime(0, 0, 0, date('m') - 1); // время месяц назад
    $adm_log_c_mes = dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `id_user` = '$ank[id]' AND `time` > '$mes'"), 0);

    echo "<div class='ui warning message'>";
    echo __('Вся активность') . ": $adm_log_c_all<br />\n";
    echo __('Активность за месяц') . ": $adm_log_c_mes<br />\n";
    echo "</div>";
} else {
    $adm_log_c_all = dbresult(dbquery("SELECT COUNT(*) FROM `admin_log`"), 0);
    $mes = mktime(0, 0, 0, date('m') - 1); // время месяц назад
    $adm_log_c_mes = dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `time` > '$mes'"), 0);

    echo "<div class='ui warning message'>";
    echo __('Вся активность') . ": $adm_log_c_all<br />\n";
    echo __('Активность за месяц') . ": $adm_log_c_mes<br />\n";
    echo "</div>";
}

echo "<div class='ui segments'>\n";

if (isset($_GET['id_mod']) && isset($_GET['id_act']) && dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `mod` = '" . intval($_GET['id_mod']) . "' AND `act` = '" . intval($_GET['id_act']) . "'" . ($ank ? " AND `id_user` = '$ank[id]'" : null)), 0) != 0) {
    $mod = dbassoc(dbquery("SELECT * FROM `admin_log_mod` WHERE `id` = '" . intval($_GET['id_mod']) . "' LIMIT 1"));
    $act = dbassoc(dbquery("SELECT * FROM `admin_log_act` WHERE `id` = '" . intval($_GET['id_act']) . "' LIMIT 1"));
    $k_post = dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `mod` = '$mod[id]' AND `act` = '$act[id]'" . ($ank ? " AND `admin_log`.`id_user` = '$ank[id]'" : null)), 0);
    $k_page = k_page($k_post, $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];

    if ($k_post == 0) {
        echo "<div class='ui segment'>\n";
        echo __('Нет действий');
        echo "</div>\n";
    }

    $q = dbquery("SELECT * FROM `admin_log` WHERE `mod` = '$mod[id]' AND `act` = '$act[id]'" . ($ank ? " AND `admin_log`.`id_user` = '$ank[id]'" : null) . " ORDER BY id DESC LIMIT $start, $set[p_str]");

    while ($post = dbassoc($q)) {
        $ank2 = get_user($post['id_user']);

        echo "<div class='ui segment'>\n";
        echo "<a href='/info.php?id=$ank2[id]'>$ank2[nick]</a>" . online($ank2['id']) . " (" . vremja($post['time']) . ")<br />\n";

        echo output_text($post['opis']) . "\n";
        echo "</div>\n";
    }


    if ($k_page > 1) {
        str('?id_mod=' . $mod['id'] . '&amp;id_act=' . $act['id'] . '&amp;', $k_page, $page);
    } // Вывод страниц

    echo "<div class='ui segment'>\n";
    echo "<a href='?id_mod=$mod[id]" . ($ank ? "&amp;id=$ank[id]" : null) . "'><i class='mdi mdi-chevron-double-left'></i> " . __('Список действий') . "</a>\n";
    echo "</div>\n";

    echo "<div class='ui segment'>\n";
    echo "<a href='?$passgen" . ($ank ? "&amp;id=$ank[id]" : null) . "'><i class='mdi mdi-chevron-double-left'></i> " . __('Список модулей') . "</a>\n";
    echo "</div>\n";
} elseif (isset($_GET['id_mod']) && dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `mod` = '" . intval($_GET['id_mod']) . "'" . ($ank ? " AND `id_user` = '$ank[id]'" : null)), 0) != 0) {

// действия в модуле
    $mod = dbassoc(dbquery("SELECT * FROM `admin_log_mod` WHERE `id` = '" . intval($_GET['id_mod']) . "' LIMIT 1"));
    $q = dbquery("SELECT `admin_log_act`.`name`, `admin_log_act`.`id`, COUNT(`admin_log`.`id`) AS `count` FROM `admin_log` LEFT JOIN `admin_log_act` ON `admin_log`.`act` = `admin_log_act`.`id` WHERE `admin_log`.`mod` = '$mod[id]'" . ($ank ? " AND `admin_log`.`id_user` = '$ank[id]'" : null) . " GROUP BY `admin_log`.`act`");

    echo "<div class='ui segment'>\n";

    if (dbrows($q) == 0) {
        echo __('Нет действий в модуле') . " " . __($mod['name']);
    }

    while ($act = dbassoc($q)) {
        echo "<span style='float: right'>$act[count]</span>";
        echo "<a href='?id_mod=$mod[id]&amp;id_act=$act[id]" . ($ank ? "&amp;id=$ank[id]" : null) . "'><i class='mdi mdi-chevron-right'></i> " . __($act['name']) . "</a>\n";
    }

    echo "</div>\n";
    echo "<div class='ui segment'>\n";
    echo "<a href='?$passgen" . ($ank ? "&amp;id=$ank[id]" : null) . "'><i class='mdi mdi-chevron-double-left'></i> " . __('Список модулей') . "</a>\n";
    echo "</div>\n";
} else {

// действия по модулям
    $q = dbquery("SELECT `admin_log_mod`.`name`, `admin_log_mod`.`id`, COUNT(`admin_log`.`id`) AS `count` FROM `admin_log` LEFT JOIN `admin_log_mod` ON `admin_log`.`mod` = `admin_log_mod`.`id`" . ($ank ? " WHERE `admin_log`.`id_user` = '$ank[id]'" : null) . " GROUP BY `admin_log`.`mod`");

    if (dbrows($q) == 0) {
        echo "<div class='ui segment'>\n";
        echo __('Нет действий в модулях');
        echo "</div>\n";
    }

    while ($mod = dbassoc($q)) {
        echo "<div class='ui segment'>\n";
        echo "<span style='float: right'>$mod[count]</span>";
        echo "<a href='?id_mod=$mod[id]" . ($ank ? "&amp;id=$ank[id]" : null) . "'><i class='mdi mdi-chevron-right'></i> " . __($mod['name']) . "</a>\n";
        echo "</div>\n";
    }
}

if (user_access('adm_panel_show')) {
    if (user_access('adm_show_adm')) {
        echo "<div class='ui segment'>\n";
        echo "<a href='administration.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Администрация') . "</a>\n";
        echo "</div>\n";
    }

    echo "<div class='ui secondary segment'>\n";
    echo "<a href='/adm_panel/'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>\n";
    echo "</div>\n";
}
echo "</div>\n"; //ui segments

include_once '../sys/inc/tfoot.php';
?>