<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';

user_access('adm_show_adm', null, 'index.php?' . SID);
adm_check();

$set['title'] = __('Администрация'); // заголовок страницы

include_once '../sys/inc/thead.php';

title();
aut();

$k_post = dbresult(dbquery("SELECT COUNT(`user`.`id`) FROM `user` LEFT JOIN `user_group` ON `user`.`group_access` = `user_group`.`id` WHERE `user_group`.`level` != 0 AND `user_group`.`level` IS NOT NULL"), 0);
$k_page = k_page($k_post, $set['p_str']);
$page = page($k_page);
$start = $set['p_str'] * $page - $set['p_str'];

echo "<div class='ui segments'>\n";

if ($k_post == 0) {
    echo "<div class='ui segment'>\n";
    echo __('Нет результатов');
    echo "</div>\n";
}

$q = dbquery("SELECT `user`.`id` FROM `user` LEFT JOIN `user_group` ON `user`.`group_access` = `user_group`.`id` WHERE `user_group`.`level` != 0 AND `user_group`.`level` IS NOT NULL ORDER BY `user_group`.`level` DESC LIMIT $start, $set[p_str]");

while ($ank = dbassoc($q)) {
    $ank = get_user($ank['id']);

    echo "<div class='ui segment'>\n";

    if (user_access('adm_log_read') && $ank['level'] != 0 && ($ank['id'] == $user['id'] || $ank['level'] < $user['level'])) {
        echo "<a href='adm_log.php?id=$ank[id]'>$ank[nick]</a> (" . __($ank['group_name']) . ") " . online($ank['id']) . "\n";
    } else {
        echo "<a href='/info.php?id=$ank[id]'>$ank[nick]</a> (" . __($ank['group_name']) . ")" . online($ank['id']) . "\n";
    }

    echo "<br />";
    echo __('Пол') . ": " . (($ank['pol'] == 1) ? __('Мужской') : __('Женский')) . "<br />\n";

    $adm_log_c_all = dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `id_user` = '$ank[id]'"), 0);
    $mes = mktime(0, 0, 0, date('m') - 1); // время месяц назад
    $adm_log_c_mes = dbresult(dbquery("SELECT COUNT(*) FROM `admin_log` WHERE `id_user` = '$ank[id]' AND `time` > '$mes'"), 0);

    echo __('Вся активность') . ": $adm_log_c_all<br />\n";
    echo __('Активность за месяц') . ": $adm_log_c_mes<br />\n";
    echo __('Посл. посещение') . ": " . vremja($ank['date_last']) . "<br />\n";

    if (isset($user) && ($user['level'] > $ank['level'] || $user['level'] == 4)) {
        echo "<a href='/adm_panel/user.php?id=$ank[id]'>" . __('Редактировать профиль') . "</a>\n";
    }

    echo "</div>\n";
}

echo "</div>\n"; //ui segments

if ($k_page > 1) {
    str("?", $k_page, $page);
} // Вывод страниц

if (user_access('adm_panel_show')) {
    echo "<div class='ui secondary segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}

include_once '../sys/inc/tfoot.php';
