<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';

user_access('adm_ban_ip', null, 'index.php?' . SID);

$opsos = NULL;
$set['title'] = __('Бан по IP');

include_once '../sys/inc/thead.php';

title();

if (isset($_POST['min']) && isset($_POST['max'])) {
    if (!preg_match("#^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$#", $_POST['min'])) {
        $err[] = __('Неверный формат IP-адреса');
    }

    if (!preg_match("#^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$#", $_POST['max'])) {
        $err[] = __('Неверный формат IP-адреса');
    }

    $min = ip2long($_POST['min']);
    $max = ip2long($_POST['max']);

    if (ip2long($ip) >= $min && ip2long($ip) <= $max) {
        $err[] = __('Ваш IP входит в заданный диапазон');
    } elseif (!isset($err)) {
        dbquery("INSERT INTO `ban_ip` (`min`, `max`) values('$min', '$max')", $db);
        msg(__('Диапазон успешно забанен'));
        header("Location: ?");
        exit;
    }
}

if (isset($_GET['delmin']) && isset($_GET['delmax']) && dbresult(dbquery("SELECT COUNT(*) FROM `ban_ip` WHERE `min` = '" . $_GET['delmin'] . "' AND `max` = '" . $_GET['delmax'] . "' LIMIT 1", $db), 0) != 0) {
    dbquery("DELETE FROM `ban_ip` WHERE `min` = '" . $_GET['delmin'] . "' AND `max` = '" . $_GET['delmax'] . "' LIMIT 1");
    dbquery("OPTIMIZE TABLE `ban_ip`");

    msg(__('Диапазон успешно удален'));
    header("Location: ?");
    exit;
}

err();
aut();

$k_post = dbresult(dbquery("SELECT COUNT(*) FROM `ban_ip`"), 0);
$k_page = k_page($k_post, $set['p_str']);
$page = page($k_page);
$start = $set['p_str'] * $page - $set['p_str'];
$q = dbquery("SELECT * FROM `ban_ip` LIMIT $start, $set[p_str]");

echo "<div class='ui segments'>\n";

if ($k_post == 0) {
    echo "<div class='ui segment'>\n";
    echo "<i class='mdi mdi-layers-outline'></i> ".__('Нет результатов');
    echo "</div>\n";
}

while ($post = dbassoc($q)) {
    echo "<div class='ui segment'>\n";
    echo long2ip($post['min']) . ' - ' . long2ip($post['max']);
    echo "<br />";
    echo "<a href='?page=$page&amp;delmin=$post[min]&amp;delmax=$post[max]'>" . __('Удалить') . "</a>\n";
    echo "</div>\n";
}


if ($k_page > 1) {
    str('?', $k_page, $page);
} // Вывод страниц

$min = NULL;
$max = NULL;

if (isset($_GET['min']) && preg_match("#^([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3})$#", long2ip($_GET['min']))) {
    echo "<div class='ui segment'>";
    echo "HOST: " . gethostbyaddr(long2ip($_GET['min'])) . "<br />\n";
    echo "</div>";
    $min = long2ip($_GET['min']);
    $max = long2ip($_GET['min']);

    if (isset($_GET['max']) && preg_match("#^([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3})$#", long2ip($_GET['max']))) {
        $max = long2ip($_GET['max']);
    }
}

echo "<form method='post' class='ui form segment' action='?ban=$passgen'>\n";
echo "<div class='field'>\n";
echo "<label>" . __('Начало') . ":</label>";
echo "<input name='min' value='$min' required type='text' />\n";
echo "</div>\n";
echo "<div class='field'>\n";
echo "<label>" . __('Конец') . ":</label>";
echo "<input name='max' value='$max' required type='text' />\n";
echo "</div>\n";
echo "<div class='field'>\n";
echo "<button class='ui compact blue labeled icon button'><i class='mdi mdi-check icon'></i> " . __('Забанить') . "</button>\n";
echo "</div>\n";
echo "</form>\n";

if (user_access('adm_panel_show')) {
    echo "<div class='ui secondary segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}
echo "</div>\n";

include_once '../sys/inc/tfoot.php';
?>