<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';
include_once '../sys/inc/icons.php'; // Иконки главного меню

user_access('adm_cabinet', null, 'index.php?' . SID);
adm_check();

$set['title'] = __('Кабинет');

include_once '../sys/inc/thead.php';

title();

if (isset($_POST['add']) && isset($_POST['name']) && $_POST['name'] != NULL && isset($_POST['url']) && $_POST['url'] != NULL && isset($_POST['counter'])) {
    $name = esc(stripcslashes(htmlspecialchars($_POST['name'])));
    $url = esc(stripcslashes(htmlspecialchars($_POST['url'])));
    $counter = esc(stripcslashes(htmlspecialchars($_POST['counter'])));
    $pos = dbresult(dbquery("SELECT MAX(`pos`) FROM `cabinet`"), 0) + 1;
    $icon = preg_replace('#[^a-z0-9 _\-\.]#i', null, $_POST['icon']);
    $type = esc($_POST['type']);

    dbquery("INSERT INTO `cabinet` (`name`, `url`, `counter`, `pos`, `icon`, `type`) VALUES ('$name', '$url', '$counter', '$pos', '$icon', '$type')");

    msg(__('Ссылка успешно добавлена'));
    exit(header('Location: ?'));
}

if (isset($_POST['add']) && isset($_POST['name']) && $_POST['name'] != NULL && isset($_POST['counter']) && isset($_POST['type']) && $_POST['type'] == 'razd') {
    $name = esc(stripcslashes(htmlspecialchars($_POST['name'])));
    $url = esc(stripcslashes(htmlspecialchars($_POST['url'])));
    $counter = esc(stripcslashes(htmlspecialchars($_POST['counter'])));
    $pos = dbresult(dbquery("SELECT MAX(`pos`) FROM `cabinet`"), 0) + 1;
    $icon = preg_replace('#[^a-z0-9 _\-\.]#i', null, $_POST['icon']);

    dbquery("INSERT INTO `cabinet` (`type`, `name`, `url`, `counter`, `pos`, `icon`) VALUES ('razd', '$name', '$url', '$counter', '$pos', '$icon')");

    msg(__('Ссылка успешно добавлена'));
    exit(header('Location: ?'));
}

if (isset($_POST['change']) && isset($_GET['id']) && isset($_POST['name']) && $_POST['name'] != NULL && isset($_POST['url']) && isset($_POST['counter'])) {
    $id = intval($_GET['id']);
    $name = esc(stripcslashes(htmlspecialchars($_POST['name'])));
    $url = esc(stripcslashes(htmlspecialchars($_POST['url'])));
    $counter = esc(stripcslashes(htmlspecialchars($_POST['counter'])));
    $icon = preg_replace('#[^a-z0-9 _\-\.]#i', null, $_POST['icon']);

    dbquery("UPDATE `cabinet` SET `name` = '$name', `url` = '$url', `counter` = '$counter', `icon` = '$icon' WHERE `id` = '$id' LIMIT 1");

    msg(__('Изменения сохранены'));
    exit(header('Location: ?'));
}

if (isset($_GET['id']) && isset($_GET['act']) && dbresult(dbquery("SELECT COUNT(*) FROM `cabinet` WHERE `id` = '" . intval($_GET['id']) . "'"), 0)) {
    $cabinet = dbassoc(dbquery("SELECT * FROM `cabinet` WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1"));

    if ($_GET['act'] == 'up') {
        dbquery("UPDATE `cabinet` SET `pos` = '" . ($cabinet['pos']) . "' WHERE `pos` = '" . ($cabinet['pos'] - 1) . "' LIMIT 1");
        dbquery("UPDATE `cabinet` SET `pos` = '" . ($cabinet['pos'] - 1) . "' WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

        msg(__('Пункт сдвинут на позицию вверх'));
        exit(header('Location: ?'));
    }

    if ($_GET['act'] == 'down') {
        dbquery("UPDATE `cabinet` SET `pos` = '" . ($cabinet['pos']) . "' WHERE `pos` = '" . ($cabinet['pos'] + 1) . "' LIMIT 1");
        dbquery("UPDATE `cabinet` SET `pos` = '" . ($cabinet['pos'] + 1) . "' WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

        msg(__('Пункт сдвинут на позицию вниз'));
        exit(header('Location: ?'));
    }

    if ($_GET['act'] == 'del') {
        dbquery("DELETE FROM `cabinet` WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

        msg(__('Пункт удален'));
        exit(header('Location: ?'));
    }
}

err();
aut();

echo "<div class='ui segments'>\n";

$q = dbquery("SELECT * FROM `cabinet` ORDER BY `pos` ASC");

while ($post = dbassoc($q)) {
    echo "<div class='ui segment'>\n";

    if (!isset($post['icon'])) {
        dbquery('ALTER TABLE `cabinet` ADD `icon` VARCHAR( 32 ) NULL DEFAULT NULL');
    }

    if (!isset($post['type'])) {
        dbquery("ALTER TABLE  `cabinet` ADD  `type` ENUM('link', 'razd') NOT NULL DEFAULT 'link' AFTER `id`");
    }


    echo icons($post['icon'], 'code');

    echo "$post[pos]) " . __($post['name']) . " " . ($post['type'] == 'link' ? "($post[url])" : null);

    echo "<br />";

    if (isset($_GET['id']) && $_GET['id'] == $post['id'] && isset($_GET['act']) && $_GET['act'] == 'edit') {
        echo "<form action=\"?id=$post[id]\" method=\"post\" class='ui form'>";
        echo __('Тип') . ": " . ($post['type'] == 'link' ? 'Ссылка' : 'Разделитель') . "<br />\n";
        echo __('Название') . ":<br />\n";
        echo "<input type='text' name='name' value=\"$post[name]\" /><br />\n";

        if ($post['type'] == 'link') {
            echo __('Ссылка') . ":<br />\n";
            echo "<input type='text' name='url' value='$post[url]' /><br />\n";
        } else {
            echo "<input type='hidden' name='url' value='' />\n";
        }

        echo __('Счетчик') . ":<br />\n";
        echo "<input type='text' name='counter' value='$post[counter]' /><br />\n";

        if ($post['type'] == 'link') {
            echo "<b>" . __('Иконка') . ":</b> <a href='https://materialdesignicons.com'>" . __('посмотреть иконки') . "</a> <br />\n";
            echo "<input type='text' name='icon' value='$post[icon]' /><br /><br />\n";
        } else {
            echo "<input type='hidden' name='icon' value='$post[icon]' /><br /><br />\n";
        }

        echo "<button class='ui compact blue labeled icon button' name='change'><i class='mdi mdi-check icon'></i> " . __('Сохранить') . "</button>\n";
        echo "<a class='ui compact basic button' href='?'>" . __('Отмена') . "</a>\n";

        echo "</form>";
    } else {
        echo __('Счетчик') . ": " . ($post['counter'] == null ? __('отсутствует') : $post['counter']) . "<br />\n";
        echo "<a href='?id=$post[id]&amp;act=up&amp;$passgen'>" . __('Выше') . "</a> &ensp; ";
        echo "<a href='?id=$post[id]&amp;act=down&amp;$passgen'>" . __('Ниже') . "</a> &ensp; ";
        echo "<a href='?id=$post[id]&amp;act=edit&amp;$passgen'>" . __('Редактировать') . " </a> &ensp; ";
        echo "<a href='?id=$post[id]&amp;act=del&amp;$passgen'>" . __('Удалить') . " </a>";
    }

    echo "</div>\n";
}

$adm_cabinet = dbresult(dbquery("SELECT COUNT(*) FROM `cabinet` WHERE `pos`"), 0);

if (empty($adm_cabinet)) {
    echo "<div class='ui segment'>";
    echo "<i class='mdi mdi-layers-outline'></i> " . __('Нет результатов');
    echo "</div>";
}


if (isset($_GET['add'])) {
    echo "<form action='?add=$passgen' class='ui form segment' method=\"post\">";
    echo __('Тип') . ":<br />\n";
    echo "<select name='type'>\n";
    echo "<option value='link'>" . __('Ссылка') . " (1)</option>\n";
    echo "<option value='razd'>" . __('Раздел') . " (2)</option>\n";
    echo "</select>\n";
    echo __('Название') . " (1,2):<br />\n";
    echo "<input type=\"text\" name=\"name\" value=\"\"/><br />\n";
    echo __('Ссылка') . "(1):<br />\n";
    echo "<input type=\"text\" name=\"url\" value=\"\"/><br />\n";
    echo __('Счетчик') . " (1,2):<br />\n";
    echo "<input type=\"text\" name=\"counter\" value=\"\"/><br />\n";
    echo __('Иконка') . " (1):<br />\n";
    echo "<input type=\"text\" name=\"icon\" value=\"\"/><br /><br />\n";

    echo "<button class='ui compact blue labeled icon button' name='add'><i class='mdi mdi-check icon'></i> " . __('Добавить') . "</button>\n";
    echo "<a class='ui compact basic button' href='?$passgen'>" . __('Отмена') . "</a>\n";
    echo "</form>";
} else {
    echo "<div class='ui segment'>";
    echo "<a href='?add=$passgen' class='ui compact blue labeled icon button'><i class='mdi mdi-plus icon'></i> " . __('Добавить пункт') . "</a>\n";
    echo "</div>\n";
}

if (user_access('adm_panel_show')) {
    echo "<div class='ui secondary segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}
echo "</div>\n";

include_once '../sys/inc/tfoot.php';
?>