<?php

require_once '../sys/inc/start.php';
require_once H . 'sys/inc/compress.php';
require_once H . 'sys/inc/sess.php';
require_once H . 'sys/inc/settings.php';
$temp_set = $set;
require_once H . 'sys/inc/db_connect.php';
require_once H . 'sys/inc/ipua.php';
require_once H . 'sys/inc/fnc.php';
require_once H . 'sys/inc/adm_check.php';
require_once H . 'sys/inc/user.php';

user_access('guest_settings', null, 'index.php?' . SID);
adm_check();

$set['title'] = __('Настройки гостевой');

require_once H . 'sys/inc/thead.php';

if (isset($_POST['save'])) {
    $temp_set['guest_max_post'] = intval($_POST['guest_max_post']);

    if (save_settings($temp_set)) {
        admin_log('Настройки', 'Гостевая', "Изменение настроек гостевой");
        $_SESSION['message'] = __('Изменения сохранены');

        header("Location: ?");
        exit();
    } else {
        $err = __('Нет прав для изменения файла настроек');
    }
}

title();
aut();
err();

echo "<form class='ui form segment' method='post' action='?'>";

echo "<small class='grey'>" . __('Длина максимального сообщения в чате') . ": (max 20000)</small><br />";
echo "<input type='number' name='guest_max_post' value='$temp_set[guest_max_post]'  /><br /><br />";

echo "<button class='ui compact blue labeled icon button' name='save'><i class='mdi mdi-check icon'></i> " . __('Сохранить') . "</button>\n";
echo "</form>\n";

if (user_access('adm_panel_show')) {
    echo "<div class='ui segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}

require_once H . 'sys/inc/tfoot.php';
