<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';

user_access('adm_ref', null, 'index.php?' . SID);

adm_check();

$set['title'] = __('Рефералы'); // заголовок страницы

include_once '../sys/inc/thead.php';

title();
aut();

$k_post = dbresult(dbquery("SELECT COUNT(distinct(`url`)) FROM `user_ref`"), 0);
$k_page = k_page($k_post, $set['p_str']);
$page = page($k_page);
$start = $set['p_str'] * $page - $set['p_str'];

echo "<div class='ui segments'>\n";

if ($k_post == 0) {
    echo "<div class='ui segment'>\n";
    echo __('Нет рефералов');
    echo "</div>\n";
}

$q = dbquery("SELECT COUNT(`url`) AS `count`, MAX(`time`) AS `time`, `url` FROM `user_ref` GROUP BY `url` ORDER BY `count` DESC LIMIT $start, $set[p_str]");

while ($ref = dbassoc($q)) {
    echo "<div class='ui segment'>\n";
    echo "URL: <a target='_blank' href='/go.php?go=" . base64_encode("http://$ref[url]") . "'>" . htmlentities($ref['url']) . "</a><br />\n";
    echo "<br />\n";
    echo __('Переходов') . ": $ref[count]<br />\n";
    echo __('Последний') . ": " . vremja($ref['time']) . "\n";
    echo "</div>\n";
}


if ($k_page > 1) {
    str("?", $k_page, $page);
} // Вывод страниц

if (user_access('adm_panel_show')) {
    echo "<div class='ui secondary segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}
echo "</div>\n"; //ui segments

include_once '../sys/inc/tfoot.php';
?>