<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';

$temp_set = $set;

include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';

user_access('adm_set_foto', null, 'index.php?' . SID);

adm_check();

$set['title'] = __('Настройки фотогалереи');

include_once '../sys/inc/thead.php';

title();

if (isset($_POST['save'])) {
    $temp_set['max_upload_foto_x'] = intval($_POST['max_upload_foto_x']);
    $temp_set['max_upload_foto_y'] = intval($_POST['max_upload_foto_y']);

    if (save_settings($temp_set)) {
        admin_log(__('Настройки'), __('Фотогалерея'), __('Изменение настроек фотогалереи'));

        msg(__('Настройки успешно приняты'));
    } else {
        $err = __('Нет прав для изменения файла настроек');
    }
}

err();
aut();

echo "<form method=\"post\" class='ui form segment' action=\"?\">\n";
echo __('Ширина фото') . " (max):<br />\n<input type='text' name='max_upload_foto_x' value='$temp_set[max_upload_foto_x]' /><br />\n";
echo __('Высота фото') . " (max):<br />\n<input type='text' name='max_upload_foto_y' value='$temp_set[max_upload_foto_y]' /><br /><br />\n";
echo "<button class='ui compact green labeled icon button' name='save'><i class='mdi mdi-check icon'></i> " . __('Сохранить') . "</button>\n";
echo "</form>\n";

if (user_access('adm_panel_show')) {
    echo "<div class='ui secondary segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}

include_once '../sys/inc/tfoot.php';
?>