<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
$temp_set = $set;
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';
user_access('adm_set_sys', null, 'index.php?' . SID);
adm_check();

$set['title'] = __('Настройки системы');
include_once '../sys/inc/thead.php';

title();

if (isset($_POST['save'])) {

    $temp_set['title'] = esc(stripcslashes(htmlspecialchars($_POST['title'])), 1);
    $temp_set['mail_backup'] = esc($_POST['mail_backup']);
    $temp_set['p_str'] = intval($_POST['p_str']);
    $temp_set['timeadmin'] = intval($_POST['timeadmin']);

    dbquery("ALTER TABLE `user` CHANGE `set_p_str` `set_p_str` INT( 11 ) DEFAULT '$temp_set[p_str]'");

    if (!preg_match('#\.\.#', $_POST['set_them']) && is_dir(H . 'style/themes/' . $_POST['set_them'])) {
        $temp_set['set_them'] = $_POST['set_them'];
        dbquery("ALTER TABLE `user` CHANGE `set_them` `set_them` VARCHAR( 32 ) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '$temp_set[set_them]'");
    }

    if (!preg_match('#\.\.#', $_POST['set_them2']) && is_dir(H . 'style/themes/' . $_POST['set_them2'])) {
        $temp_set['set_them2'] = $_POST['set_them2'];
        dbquery("ALTER TABLE `user` CHANGE `set_them2` `set_them2` VARCHAR( 32 ) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '$temp_set[set_them2]'");
    }

    if ($_POST['show_err_php'] == 1 || $_POST['show_err_php'] == 0) {
        $temp_set['show_err_php'] = intval($_POST['show_err_php']);
    }

    if (isset($_POST['antidos']) && $_POST['antidos'] == 1) {
        $temp_set['antidos'] = 1;
    } else {
        $temp_set['antidos'] = 0;
    }

    if (isset($_POST['antimat']) && $_POST['antimat'] == 1) {
        $temp_set['antimat'] = 1;
    } else {
        $temp_set['antimat'] = 0;
    }

    $temp_set['meta_keywords'] = esc(stripcslashes(htmlspecialchars($_POST['meta_keywords'])), 1);
    $temp_set['meta_description'] = esc(stripcslashes(htmlspecialchars($_POST['meta_description'])), 1);
    $temp_set['job'] = intval($_POST['job']);

    if (save_settings($temp_set)) {
        admin_log(__('Настройки'), __('Система'), __('Изменение системных настроек'));
        $_SESSION['message'] = __('Изменения сохранены');
        exit(header('Location: ?'));
    } else {
        $err = __('Нет прав для изменения файла настроек');
    }
}
err();
aut();

echo "<form method=\"post\" class='ui form segment' action=\"?\">\n";

echo "<div class='field'>";
echo "<label>" . __('Название сайта') . "</label><input name=\"title\" value=\"$temp_set[title]\" type=\"text\" />";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Пунктов на страницу') . ":</label><input name=\"p_str\" value=\"$temp_set[p_str]\" type=\"text\" />\n";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Время сессии панели управления') . ":</label><input name=\"timeadmin\" value='$temp_set[timeadmin]' type=\"text\" />\n";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Тема') . " (WAP):</label><select name='set_them'>\n";
$opendirthem = opendir(H . 'style/themes');
while ($themes = readdir($opendirthem)) {
// пропускаем корневые папки и файлы
    if ($themes == '.' || $themes == '..' || !is_dir(H . "style/themes/$themes")) {
        continue;
    }
// пропускаем темы для web браузеров
    if (file_exists(H . "style/themes/$themes/.only_for_web")) {
        continue;
    }
    echo "<option value='$themes'" . ($temp_set['set_them'] == $themes ? " selected='selected'" : null) . ">" . trim(file_get_contents(H . 'style/themes/' . $themes . '/them.name')) . "</option>\n";
}
closedir($opendirthem);
echo "</select>\n";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Тема') . " (WEB):</label><select name='set_them2'>\n";
$opendirthem = opendir(H . 'style/themes');

while ($themes = readdir($opendirthem)) {
// пропускаем корневые папки и файлы
    if ($themes == '.' || $themes == '..' || !is_dir(H . "style/themes/$themes")) {
        continue;
    }
// пропускаем темы для wap браузеров
    if (file_exists(H . "style/themes/$themes/.only_for_wap")) {
        continue;
    }
    echo "<option value='$themes'" . ($temp_set['set_them2'] == $themes ? " selected='selected'" : null) . ">" . trim(file_get_contents(H . 'style/themes/' . $themes . '/them.name')) . "</option>\n";
}
closedir($opendirthem);
echo "</select>\n";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Работа сайта') . ":</label>";
echo "<select name='job'>
  <option " . (setget('job', 1) == 1 ? " selected " : null) . " value='1'>Включено</option>
  <option " . (setget('job', 1) == 0 ? " selected " : null) . " value='0'>Выключено</option>
</select>";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Ключевые слова') . " (META):</label>";
echo "<textarea name='meta_keywords'>$temp_set[meta_keywords]</textarea>\n";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Описание') . " (META):</label>";
echo "<textarea name='meta_description'>$temp_set[meta_description]</textarea>\n";
echo "</div>";

echo "<div class='inline field'>";
echo "<div class='field'>";
echo "<div class='ui checkbox'>";
echo "<input type='checkbox'" . ($temp_set['antidos'] ? " checked='checked'" : null) . " name='antidos' value='1' /> \n";
echo "<label>Анти-Dos*</label>";
echo "</div>";
echo "</div>";
echo "</div>";

echo "<div class='inline field'>";
echo "<div class='field'>";
echo "<div class='ui checkbox'>";
echo "<input type='checkbox'" . ($temp_set['antimat'] ? " checked='checked'" : null) . " name='antimat' value='1' />\n";
echo "<label>Анти-Мат</label>";
echo "</div>";
echo "</div>";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('Ошибки интерпретатора') . ":</label><select name=\"show_err_php\">\n";
echo "<option value='0'" . ($temp_set['show_err_php'] == 0 ? " selected='selected'" : null) . ">" . __('Скрывать') . "</option>\n";
echo "<option value='1'" . ($temp_set['show_err_php'] == 1 ? " selected='selected'" : null) . ">" . __('Показывать администрации') . "</option>\n";
echo "</select>\n";
echo "</div>";

echo "<div class='field'>";
echo "<label>" . __('E-mail для BackUp') . ":</label><input type='text' name='mail_backup' value='$temp_set[mail_backup]'  />\n";
echo "</div>";

echo "* Анти-Dos - " . __('защита от частых запросов с одного IP-адреса') . "<br /><br />\n";

echo "<button class='ui compact blue labeled icon button' name='save'><i class='mdi mdi-content-save icon'></i> " . __('Сохранить') . "</button>\n";

echo "</form>\n";

if (user_access('adm_panel_show')) {
    echo "<div class='ui secondary segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}
include_once '../sys/inc/tfoot.php';
?>