<?php
include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/adm_check.php';
include_once '../sys/inc/user.php';
include_once '../sys/inc/icons.php'; // Иконки главного меню

user_access('widget', null, 'index.php?' . SID);
adm_check();

$set['title'] = __('Виджеты');

include_once '../sys/inc/thead.php';

title();

if (isset($_POST['add']) && isset($_POST['name']) && $_POST['name'] != NULL && isset($_POST['widget'])) {
    $name = esc(stripcslashes(htmlspecialchars($_POST['name'])));
    $widget = esc(stripcslashes(htmlspecialchars($_POST['widget'])));
    $pos = dbresult(dbquery("SELECT MAX(`pos`) FROM `widget`"), 0) + 1;
    $icon = preg_replace('#[^a-z0-9 _\-\.]#i', null, $_POST['icon']);

    dbquery("INSERT INTO `widget` (`name`, `widget`, `pos`, `icon`) VALUES ('$name', '$widget', '$pos', '$icon')");

    msg(__('Виджет успешно добавлен'));
    exit(header('Location: ?'));
}

if (isset($_POST['change']) && isset($_GET['id']) && isset($_POST['name']) && $_POST['name'] != NULL && isset($_POST['widget'])) {
    $id = intval($_GET['id']);
    $name = esc(stripcslashes(htmlspecialchars($_POST['name'])));
    $widget = esc(stripcslashes(htmlspecialchars($_POST['widget'])));
    $icon = preg_replace('#[^a-z0-9 _\-\.]#i', null, $_POST['icon']);
    $on = intval($_POST['on']);

    dbquery("UPDATE `widget` SET `name` = '$name', `widget` = '$widget', `icon` = '$icon', `on` = '$on' WHERE `id` = '$id' LIMIT 1");

    msg(__('Изменения сохранены'));
    exit(header('Location: ?'));
}

if (isset($_GET['id']) && isset($_GET['act']) && dbresult(dbquery("SELECT COUNT(*) FROM `widget` WHERE `id` = '" . intval($_GET['id']) . "'"), 0)) {
    $widget = dbassoc(dbquery("SELECT * FROM `widget` WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1"));

    if ($_GET['act'] == 'up') {
        dbquery("UPDATE `widget` SET `pos` = '" . ($widget['pos']) . "' WHERE `pos` = '" . ($widget['pos'] - 1) . "' LIMIT 1");
        dbquery("UPDATE `widget` SET `pos` = '" . ($widget['pos'] - 1) . "' WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

        msg(__('Виджет сдвинут на позицию вверх'));
        exit(header('Location: ?'));
    }

    if ($_GET['act'] == 'down') {
        dbquery("UPDATE `widget` SET `pos` = '" . ($widget['pos']) . "' WHERE `pos` = '" . ($widget['pos'] + 1) . "' LIMIT 1");
        dbquery("UPDATE `widget` SET `pos` = '" . ($widget['pos'] + 1) . "' WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

        msg(__('Виджет сдвинут на позицию вниз'));
        exit(header('Location: ?'));
    }

    if ($_GET['act'] == 'del') {
        dbquery("DELETE FROM `widget` WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

        msg(__('Виджет удален'));
        exit(header('Location: ?'));
    }
}

err();
aut();

echo "<div class='ui segments'>\n";

$k_post = dbresult(dbquery("SELECT COUNT(*) FROM `widget`"), 0);

if ($k_post == null) {
    echo "<div class='ui center aligned segment'><br /><i class='mdi mdi-layers-outline mdi-48px'></i><br /> " . __('Нет результатов') . "</div>";
}

$q = dbquery("SELECT * FROM `widget` ORDER BY `pos` ASC");

while ($post = dbassoc($q)) {
    echo "<div class='ui segment'>\n";

    if (!isset($post['icon'])) {
        dbquery('ALTER TABLE `widget` ADD `icon` VARCHAR( 32 ) NULL DEFAULT NULL');
    }

    echo "<span style='float:right'>";
    echo "<a href='?id=$post[id]&amp;act=edit&amp;$passgen' title='" . __('Настройки') . "'><i class='mdi mdi-cog'></i></a>";
    echo "</span>";

    echo icons($post['icon'], 'code');

    echo "$post[pos]) " . __($post['name']);

    echo "<br />";

    if ($post['on'] == 0) {
        echo "<b>" . __('Доступ') . ":</b> <span style='color:green'>" . __('Активен') . "</span><br />";
    } else {
        echo "<b>" . __('Доступ') . ":</b> <span style='color:red'>" . __('Не активен') . "</span><br />";
    }


    if (isset($_GET['id']) && $_GET['id'] == $post['id'] && isset($_GET['act']) && $_GET['act'] == 'edit') {
        echo "<form action=\"?id=$post[id]\" method=\"post\" class='ui form'>";
        echo "<b>" . __('Название виджета') . ":</b><br />\n";
        echo "<input type='text' name='name' value=\"$post[name]\" /><br />\n";

        echo "<b>" . __('Путь виджета') . ":</b><br />\n";
        echo "<input type='text' name='widget' value='$post[widget]' /><br />\n";

        echo "<b>" . __('Иконка виджета') . ":</b> <a href='https://materialdesignicons.com'>" . __('посмотреть иконки') . "</a> <br />\n";
        echo "<input type='text' name='icon' value='$post[icon]' /><br /><br />\n";
        ?>
        <div class="inline fields">
            <label><?= __('Доступ к виджету') ?></label>
            <div class="field">
                <div class="ui radio checkbox">
                    <input type="radio" name="on" value="0" <?= ($post['on'] == 0 ? ' checked="checked"' : null) ?>>
                    <label> <?= __('Вкл') ?></label>
                </div>
            </div>
            <div class="field">
                <div class="ui radio checkbox">
                    <input type="radio" name="on" value="1" <?= ($post['on'] == 1 ? ' checked="checked"' : null) ?>>
                    <label><?= __('Выкл') ?></label>
                </div>
            </div>
        </div>
        <?php
        echo "<button class='ui compact blue labeled icon button' name='change'><i class='mdi mdi-content-save icon'></i> " . __('Сохранить') . "</button>\n";
        echo "<a class='ui compact basic button' href='?'>" . __('Отмена') . "</a>\n";

        echo "</form>";
    } else {
        echo "<b>" . __('Путь виджета') . ":</b> " . ($post['widget'] == null ? __('отсутствует') : $post['widget']) . "<br />\n";
        echo "<a href='?id=$post[id]&amp;act=up&amp;$passgen'>" . __('Выше') . "</a> &ensp; ";
        echo "<a href='?id=$post[id]&amp;act=down&amp;$passgen'>" . __('Ниже') . "</a> &ensp; ";
        echo "<a href='?id=$post[id]&amp;act=del&amp;$passgen'>" . __('Удалить') . " </a>";
    }

    echo "</div>\n";
}


if (isset($_GET['add'])) {
    echo "<form action='?add=$passgen' class='ui form segment' method=\"post\">";
    echo __('Название виджета') . " (1,2):<br />\n";
    echo "<input type=\"text\" name=\"name\" value=\"\"/><br />\n";
    echo __('Путь к виджету') . " (1,2):<br />\n";
    echo "<input type=\"text\" name=\"widget\" value=\"\"/><br />\n";
    echo __('Иконка виджета') . " (1):<br />\n";
    echo "<input type=\"text\" name=\"icon\" value=\"\"/><br /><br />\n";

    echo "<button class='ui compact blue labeled icon button' name='add'><i class='mdi mdi-check icon'></i> " . __('Добавить виджет') . "</button>\n";
    echo "<a class='ui compact basic button' href='?$passgen'>" . __('Отмена') . "</a>\n";
    echo "</form>";
} else {
    echo "<div class='ui segment'>";
    echo "<a href='?add=$passgen' class='ui compact blue labeled icon button'><i class='mdi mdi-plus icon'></i> " . __('Добавить виджет') . "</a>\n";
    echo "</div>\n";
}

if (user_access('adm_panel_show')) {
    echo "<div class='ui secondary segment'>\n";
    echo "<a href='index.php'><i class='mdi mdi-chevron-double-left'></i> " . __('Панель управления') . "</a>";
    echo "</div>\n";
}
echo "</div>\n";

include_once '../sys/inc/tfoot.php';
?>