<?php

function br($msg, $br = '<br />') {
    return preg_replace("#((<br( ?/?)>)|\n|\r)+#i", $br, $msg);
}

ini_set('display_errors', 'On'); // сообщения с ошибками будут показываться
error_reporting(E_ALL); // E_ALL - отображаем ВСЕ ошибки
#переносы строк
#Вырезает все нечитаемые символы

function esc($text, $br = NULL) {
    if ($br != NULL) {
        for ($i = 0; $i <= 31; $i++) {
            $text = str_replace(chr($i), NULL, $text);
        }
    } else {
        for ($i = 0; $i < 10; $i++) {
            $text = str_replace(chr($i), NULL, $text);
        }
        for ($i = 11; $i < 20; $i++) {
            $text = str_replace(chr($i), NULL, $text);
        }
        for ($i = 21; $i <= 31; $i++) {
            $text = str_replace(chr($i), NULL, $text);
        }
    }
    return $text;
}

function output_text($str, $br = true, $html = true, $smiles = true, $links = true, $bbcode = true) {
    if ($html == true) {
        $str = htmlentities($str, ENT_QUOTES, 'UTF-8');
    } #преобразуем все к нормальному перевариванию браузером


    if ($br == true) {
        $str = br($str); #переносы строк
        $str = esc($str); #вырезаем все нечитаемые символы, которые могут нам подпортить разметку :)
    } else {
        //$str=br($str, ' '); #пробелы вместо переносов
        $str = esc($str); #вырезаем все нечитаемые символы, которые могут нам подпортить разметку :)
    }
    return $str; #возвращаем обработанную строку
}

#вывод сообщений

function msg($msg) {
    echo "<div class = 'ui success message'>$msg</div>\n";
}

function passgen($len = 32) {
    $password = '';
    $small = 'abcdefghijklmnopqrstuvwxyz';
    $large = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $numbers = '1234567890';

    for ($i = 0; $i < $len; $i++) {
        switch (mt_rand(1, 3)) {
            case 3 :
                $password .= $large [mt_rand(0, 25)];
                break;
            case 2 :
                $password .= $small [mt_rand(0, 25)];
                break;
            case 1 :
                $password .= $numbers [mt_rand(0, 9)];
                break;
        }
    }
    return $password;
}

$passgen = passgen();

#сохранение настроек системы

function save_settings($set) {
    if ($fopen = @fopen(H . 'sys/ini/settings.ini', 'w')) {
        $ini_file = array('[SYSTEM]');
        foreach ($set as $key => $value) {
            $ini_file[] = $key . '="' . htmlentities((string) $value, ENT_QUOTES, 'UTF-8') . '";';
        }
        fputs($fopen, implode("\r\n", $ini_file));
        fclose($fopen);
        return true;
    } else {
        return false;
    }
}

#рекурсивное удаление папки

function delete_dir($dir) {
    if (is_dir($dir)) {
        $od = opendir($dir);
        while ($rd = readdir($od)) {
            if ($rd == '.' || $rd == '..') {
                continue;
            }
            if (is_dir("$dir/$rd")) {
                @chmod("$dir/$rd", 0777);
                delete_dir("$dir/$rd");
            } else {
                @chmod("$dir/$rd", 0777);
                @unlink("$dir/$rd");
            }
        }
        closedir($od);
        @chmod("$dir", 0777);
        return @rmdir("$dir");
    } else {
        @chmod("$dir", 0777);
        @unlink("$dir");
    }
}

function utf8_strlen($str) {
    if (USE_MBSTRING) {
        return mb_strlen($str);
    } elseif (USE_ICONV) {
        return iconv_strlen($str);
    } else {
        #извращенный способ при отсутствии библиотек
        static $rus;
        if (!isset($rus)) {
            $rus = array('й', 'ц', 'у', 'к', 'е', 'н', 'г', 'ш', 'щ', 'з', 'х', 'ъ', 'ф', 'ы', 'в', 'а', 'п', 'р', 'о', 'л', 'д', 'ж', 'э', 'я', 'ч', 'с', 'м', 'и', 'т', 'ь', 'б', 'ю', 'Й', 'Ц', 'У', 'К', 'Е', 'Н', 'Г', 'Ш', 'Щ', 'З', 'Х', 'Ъ', 'Ф', 'Ы', 'В', 'А', 'П', 'Р', 'О', 'Л', 'Д', 'Ж', 'Э', 'Я', 'Ч', 'С', 'М', 'И', 'Т', 'Ь', 'Б', 'Ю');
        }
        return strlen(str_replace($rus, '0', $str));
    }
}
