<?php
user_access('adm_news', null, 'index.php?' . SID);

// Переменные по умолчанию
if (isset($_POST['view'])) {
    $news['title'] = $_POST['title'];
    $news['msg'] = $_POST['msg'];
    $news['link'] = $_POST['link'];
    $news['id_user'] = $user['id'];
} else {
    $news['title'] = null;
    $news['msg'] = null;
    $news['link'] = null;
    $news['id_user'] = null;
}

if (isset($_POST['title']) && isset($_POST['msg']) && isset($_POST['link']) && isset($_POST['ok'])) {
    $title = esc($_POST['title'], 1);
    $link = esc($_POST['link'], 1);
    $msg = esc($_POST['msg'], 1);

    if ($link != NULL && !preg_match('#^https?://#', $link) && !preg_match('#^/#i', $link)) {
        $link = '/' . $link;
    }

    if (strlen2($title) > 100) {
        $err = __('Слишком большой заголовок новости');
    }
    if (strlen2($title) < 3) {
        $err = __('Короткий заголовок');
    }
    $mat = antimat($title);
    if ($mat) {
        $err[] = __('В заголовке новости обнаружен мат') . ': ' . $mat;
    }

    if (strlen2($msg) > 10024) {
        $err = __('Содержиние новости слишком большое');
    }
    if (strlen2($msg) < 2) {
        $err = __('Новость слишком короткая');
    }
    $mat = antimat($msg);
    if ($mat) {
        $err[] = __('В содержании обнаружен мат') . ': ' . $mat;
    }

    if (isset($_POST['tags']) && $_POST['tags'] != NULL) {
        $tags = esc(stripcslashes(htmlspecialchars($_POST['tags'])));

        if (strlen2($tags) < 2) {
            $err = __('Слишком короткие теги');
        }
        if (strlen2($tags) > 128) {
            $err = __('Слишком длинные теги');
        }

        $mat = antimat($tags);

        if ($mat) {
            $err = __('В тегах обнаружен мат') . ': ' . $mat;
        }
        $tags = $tags;
    } else {
        $tags = NULL;
    }

    $title = my_esc($_POST['title']);
    $msg = my_esc($_POST['msg']);
    $close = intval($_POST['close']);

    if (!isset($err)) {
        $ch = intval($_POST['ch']);
        $mn = intval($_POST['mn']);
        $main_time = time() + $ch * $mn * 60 * 60 * 24;

        if ($main_time <= time()) {
            $main_time = 0;
        }

        dbquery("INSERT INTO `news` (`id_user`,`time`, `msg`, `title`, `main_time`, `link`, `avtor`, `close`, `tags`) values('" . $user['id'] . "','$time', '" . $msg . "', '$title', '$main_time', '$link', '$user[nick]', '$close', '$tags')");
        dbquery("update `user` set `news_read` = '0'");

        $news['id'] = mysql_insert_id();
        dbquery("OPTIMIZE TABLE `news`");
        dbquery("UPDATE `user` SET `news_read` = '0'");

        if (isset($_POST['mail'])) { // Расслылка новостей на майл
            $q = dbquery("SELECT `ank_mail` FROM `user` WHERE `set_news_to_mail` = '1' AND `ank_mail` <> ''");
            while ($ank = dbassoc($q)) {
                dbquery("INSERT INTO `mail_to_send` (`mail`, `them`, `msg`) values('$ank[ank_mail]', 'Новости', '" . trim(br(bbcode(links(stripcslashes(htmlspecialchars($msg)))))) . "')");
            }
        }

        $_SESSION['message'] = __('Новость успешно создана');
        header("Location: index.php?news=$news[id]");
        exit;
    }
}

$set['title'] = __('Создание новости');
include_once '../sys/inc/thead.php';

err();

echo '<form class="ui form segment" method="post" name="message" action="?add">';
echo __('Заголовок новости') . ':<br /><input name="title" required value="' . text($news['title']) . '" type="text" /><br />';

$msg2 = text($news['msg']);

echo __('Сообщение') . ': <textarea required name="msg">' . $msg2 . '</textarea><br />';

echo __('Ссылка') . ':<br /><input name="link" size="16" maxlength="64" value="' . text($news['link']) . '" type="text" /><br />';
?>
<div class='ui field'>
    <label><?= __('Ключевые слова') ?></label>
    <input type="text" name="tags" value="">
</div>
<div class="inline fields">
    <label><?= __('Комментарии') ?></label><br />
    <div class="field">
        <div class="ui radio checkbox">
            <input type="radio" name="close" value="0" checked="checked">
            <label> <?= __('Вкл') ?></label>
        </div>
    </div>
    <div class="field">
        <div class="ui radio checkbox">
            <input type="radio" name="close" value="1">
            <label><?= __('Выкл') ?></label>
        </div>
    </div>
</div>
<?php
echo '<div class="two fields">';
echo '<div class="field">';
echo "<label>" . __('Показывать на главной') . ":</label>";
echo '<input type="text" name="ch" size="3" value="' . (isset($_POST['ch']) ? "" . intval($_POST['ch']) . "" : "1") . '" />';
echo "</div>";
echo '<div class="field">';
echo "<label>&ensp; " . __('Выбрать') . ":</label>";

echo '<select name="mn">';
echo '  <option value="1" ' . (isset($_POST['mn']) && $_POST['mn'] == 1 ? "selected='selected'" : null) . '>' . __('Дней') . '</option>';
echo '  <option value="7" ' . (isset($_POST['mn']) && $_POST['mn'] == 7 ? "selected='selected'" : null) . '>' . __('Недель') . '</option>';
echo '  <option value="31" ' . (isset($_POST['mn']) && $_POST['mn'] == 31 ? "selected='selected'" : null) . '>' . __('Месяцев') . '</option>';
echo '</select>';
echo "</div>";
echo "</div>";

echo "<button class='ui compact blue labeled icon button' name='ok'><i class='mdi mdi-check icon'></i> " . __('Опубликовать') . "</button>\n";

echo '</form>';

echo '<div class="ui segment">';
echo '<a href="index.php"><i class="mdi mdi-chevron-double-left"></i> ' . __('Новости') . '</a>';
echo '</div>';

include_once '../sys/inc/tfoot.php';
?>