<?php
include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/user.php';

user_access('adm_news', null, 'index.php?' . SID);

if (!isset($_GET['edit']) && !is_numeric($_GET['edit'])) {
    header("Location: index.php?" . SID);
    exit;
}

if (dbresult(dbquery("SELECT COUNT(*) FROM `news` WHERE `id` = '" . intval($_GET['edit']) . "' LIMIT 1", $db), 0) == 0) {
    header("Location: index.php?" . SID);
    exit;
}
$news = dbassoc(dbquery("SELECT * FROM `news` WHERE `id` = '" . intval($_GET['edit']) . "' LIMIT 1"));

if (isset($_GET['img'])) {
    if (isset($_GET['img']) && isset($_POST['add'])) {
        if (isset($_FILES['file'])) {
            $type = $_FILES['file']['type'];
            if ($type !== 'image/jpeg' && $type !== 'image/jpg' && $type !== 'image/gif' && $type !== 'image/png') {
                $err[] = __('Это не изображение');
            }
        }
        if (!isset($err)) {
            $tmp = $_FILES['file']['tmp_name'];
            unlink(H . 'news/images/' . $news['id'] . '.png');
            move_uploaded_file($tmp, H . 'news/images/' . $news['id'] . '.png');
            chmod(H . 'news/images/' . $news['id'] . '.png', 0777);
            header("location: ?edit=$news[id]");
        }
    }
    err();
    ?>

    <div class='ui segments'>

        <div class='ui secondary segment'><?= __('Редактирование новости') ?></div>

        <form class='ui form segment' method='POST' action='?edit=<?= $news['id'] ?>&amp;img' enctype='multipart/form-data'>

            <div class='ui field'>
                <label><?= __('Изображение') ?></label>
                <input type="file" name="file" required>
            </div>

            <div class='ui field'>
                <button class='ui compact blue labeled icon button' name='add'><i class='mdi mdi-attachment icon'></i> <?= __('Прикрепить') ?></button>
            </div>

        </form>

        <div class='ui segment'><a href='<?= DIR_NEWS ?>?news=<?= $news['id'] ?>'><i class='mdi mdi-arrow-left'></i> <?= utf8_substr($news['title'], 30) ?></a></div>
        <div class='ui segment'><a href='<?= DIR_NEWS ?>'><i class='mdi mdi-arrow-left'></i> <?= __('Новости') ?></a></div>

    </div>

    <?php
} else {

    if (isset($_POST['view'])) {
        $news['title'] = $_POST['title'];
        $news['msg'] = $_POST['msg'];
        $news['link'] = $_POST['link'];
        $news['id_user'] = $user['id'];
    }

    if (isset($_POST['title']) && isset($_POST['msg']) && isset($_POST['link']) && isset($_POST['ok'])) {
        $title = esc($_POST['title'], 1);
        $link = esc($_POST['link'], 1);

        if ($link != NULL && !preg_match('#^https?://#', $link) && !preg_match('#^/#i', $link)) {
            $link = '/' . $link;
        }

        $msg = esc($_POST['msg']);
        if (strlen2($title) > 100) {
            $err = __('Слишком большой заголовок новости');
        }
        if (strlen2($title) < 3) {
            $err = __('Короткий заголовок');
        }
        $mat = antimat($title);
        if ($mat) {
            $err[] = __('В заголовке новости обнаружен мат') . ': ' . $mat;
        }
        if (strlen2($msg) > 10024) {
            $err = __('Содержиние новости слишком большое');
        }
        if (strlen2($msg) < 2) {
            $err = __('Новость слишком короткая');
        }
        $mat = antimat($msg);
        if ($mat) {
            $err[] = __('В содержании обнаружен мат') . ': ' . $mat;
        }

        if (isset($_POST['tags']) && $_POST['tags'] != NULL) {
            $tags = esc(stripcslashes(htmlspecialchars($_POST['tags'])));

            if (strlen2($tags) < 2) {
                $err = __('Слишком короткие теги');
            }
            if (strlen2($tags) > 128) {
                $err = __('Слишком длинные теги');
            }

            $mat = antimat($tags);

            if ($mat) {
                $err = __('В тегах обнаружен мат') . ': ' . $mat;
            }
            $tags = $tags;
        } else {
            $tags = NULL;
        }

        $title = my_esc($_POST['title']);
        $msg = my_esc($_POST['msg']);
        $news['close'] = intval($_POST['close']);

        dbquery("UPDATE `news` SET `close` = '" . $news['close'] . "' WHERE `id` = '$news[id]' LIMIT 1");

        if (!isset($err)) {
            $ch = intval($_POST['ch']);
            $mn = intval($_POST['mn']);
            $main_time = time() + $ch * $mn * 60 * 60 * 24;

            if ($main_time <= time()) {
                $main_time = 0;
            }

            dbquery("UPDATE `news` SET `title` = '$title', `msg` = '$msg', `tags` = '$tags', `time_edit` = '$time', `link` = '$link', `main_time` = '$main_time', `time` = '$time' WHERE `id` = '$news[id]' LIMIT 1");
            dbquery("UPDATE `user` SET `news_read` = '0'");

            $_SESSION['message'] = __('Изменения сохранены');

            header("Location: index.php?news=$news[id]");
            exit;
        }
    }

    $set['title'] = __('Новости') . ' - ' . __('редактирование');
    include_once '../sys/inc/thead.php';

    if (isset($_GET['del_img']) && is_file(H . 'news/images/' . $news['id'] . '.png')) {
        unlink(H . 'news/images/' . $news['id'] . '.png');
        header("Location:?edit=$news[id]");
    }

    if (isset($_POST['view']) && !isset($err)) {

        echo '<div class="ui segments">';
        echo '<div class="ui segment"><h3>';
        echo text($news['title']);
        echo '</h3></div>';

        echo '<div class="ui segment">';
        echo output_text($news['msg']) . '<br />';

        echo '</div>';

        if ($news['link'] != NULL) {
            echo '<div class="main">';
            echo '<a href="' . htmlentities($news['link'], ENT_QUOTES, 'UTF-8') . '">' . __('Подробности') . ' &rarr;</a><br />';
            echo '</div>';
        }
        echo '</div>';
    }

    echo '<form class="ui form segment" method="post" name="message" action="index.php?edit=' . $news['id'] . '">';
    echo __('Заголовок новости') . ':<br /><input name="title" size="16" maxlength="100" value="' . text($news['title']) . '" type="text" /><br /><br />';

    $insert = text($news['msg']);

    echo __('Сообщение') . ': <textarea name="msg">' . $insert . '</textarea><br /><br />';

    echo __('Ссылка') . ':<br /><input name="link" size="16" maxlength="64" value="' . text($news['link']) . '" type="text" /><br /><br />';

    echo __('Файл') . ": ";
    if (is_file(H . 'news/images/' . $news['id'] . '.png')) {
        echo "<a href='?edit=$news[id]&amp;img'><small>" . __('Заменить') . "</small></a> | ";
        echo "<a href='?edit=$news[id]&amp;del_img'><small>" . __('Удалить') . "</small></a>";
    } else {
        echo "<a href='?edit=$news[id]&amp;img' title='" . __('Прикрепить изображение') . "'><i class='mdi mdi-attachment'></i> " . __('Прикрепить') . "</a>";
    }

    if (is_file(H . 'news/images/' . $news['id'] . '.png')) {
        echo "<br /><img src='" . DIR_NEWS . "images/$news[id].png' style = 'border: 1px solid #CCDDED; padding: 2px; border-radius: 5px; max-width: 150px;' />";
    }
    ?>
    <div class='ui field'>
        <label><?= __('Ключевые слова') ?></label>
        <input type="text" name="tags" value="<?= $news['tags'] ?>">
    </div>
    <div class="inline fields">
        <label><?= __('Комментарии') ?></label><br />
        <div class="field">
            <div class="ui radio checkbox">
                <input type="radio" name="close" value="0" <?= ($news['close'] == 0 ? ' checked="checked"' : null) ?>>
                <label> <?= __('Вкл') ?></label>
            </div>
        </div>
        <div class="field">
            <div class="ui radio checkbox">
                <input type="radio" name="close" value="1" <?= ($news['close'] == 1 ? ' checked="checked"' : null) ?>>
                <label><?= __('Выкл') ?></label>
            </div>
        </div>
    </div>
    <?php
    echo '<div class="two fields">';
    echo '<div class="field">';
    echo "<label>" . __('Показывать на главной') . ":</label>";
    echo '<input type="text" name="ch" size="3" value="' . (isset($_POST['ch']) ? intval($_POST['ch']) : "1") . '" />';
    echo "</div>";
    echo '<div class="field">';
    echo "<label>&ensp; " . __('Выбрать') . ":</label>";
    echo '<select name="mn">';
    echo '  <option value="0" ' . (isset($_POST['mn']) && $_POST['mn'] == 0 ? "selected='selected'" : null) . '>' . __('Не показывать') . '</option>';
    echo '  <option value="1" ' . (isset($_POST['mn']) && $_POST['mn'] == 1 ? "selected='selected'" : null) . '>' . __('Дней') . '</option>';
    echo '  <option value="7" ' . (isset($_POST['mn']) && $_POST['mn'] == 7 ? "selected='selected'" : null) . '>' . __('Недель') . '</option>';
    echo '  <option value="31" ' . (isset($_POST['mn']) && $_POST['mn'] == 31 ? "selected='selected'" : null) . '>' . __('Месяцев') . '</option>';
    echo '</select>';
    echo "</div>";
    echo "</div>";

    echo "<button class='ui compact blue labeled icon button' name='view'><i class='mdi mdi-eye icon'></i> " . __('Просмотр') . "</button>\n";
    echo "<button class='ui compact blue labeled icon button' name='ok'><i class='mdi mdi-check icon'></i> " . __('Сохранить') . "</button>\n";
    echo '</form>';

    echo'<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="index.php">' . __('Новости') . '</a> | <a href="index.php?news=' . $news['id'] . '">' . text($news['title']) . '</a><br />';
    echo '</div>';
}
include_once '../sys/inc/tfoot.php';
?>