<?php

include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/user.php';

// Заголовок
$set['title'] = __('Новости');

include_once '../sys/inc/thead.php';
title();
aut();

#Путь папки новостей
define('DIR_NEWS', "/news/");

#Сокращаем пути
if (isset($_GET['edit'])) {
    require_once H . DIR_NEWS . 'edit.php';
} elseif (isset($_GET['delete'])) {
    require_once H . DIR_NEWS . 'delete.php';
} elseif (isset($_GET['add'])) {
    require_once H . DIR_NEWS . 'add.php';
} elseif (isset($_GET['settings'])) {
    require_once H . DIR_NEWS . 'settings.php';
} elseif (isset($_GET['edit_komm'])) {
    require_once H . DIR_NEWS . 'edit_komm.php';
} elseif (isset($_GET['news'])) {
    require_once H . DIR_NEWS . 'news.php';
} elseif (isset($_GET['new_komm'])) {
    require_once H . DIR_NEWS . 'komm.php';
} elseif (isset($_GET['add'])) {
    require_once H . DIR_NEWS . 'add.php';
} else {
// Колличество новостей
    $k_post = dbresult(dbquery("SELECT COUNT(*) FROM `news`"), 0);
    $k_page = k_page($k_post, $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];

// Выборка новостей
    $q = dbquery("SELECT * FROM `news` ORDER BY `id` DESC LIMIT $start, $set[p_str]");

    echo '<div class="ui segments">';

    if (isset($user)) {
        echo "<div class='ui horizontal segments center'>";

        echo "<a href='/user/settings/news.php' class='ui center aligned segment'><i class='mdi mdi-cog'></i> " . __('Параметры') . "</a> ";
        echo "<a href='tags.php' class='ui center aligned segment'><i class='mdi mdi-tag'></i> " . __('Теги') . "</a> ";

        if (user_access('adm_news')) {
            echo " <a href='?add' class='ui center aligned segment'><i class='mdi mdi-newspaper-plus'></i> " . __('Создать') . "</a> ";
        }

        echo "</div>";
    }

    if ($k_post == 0) {
        echo '<div class="ui segment">';
        echo "<i class='mdi mdi-layers-outline'></i> " . __('Нет результатов');
        echo '</div>';
    }

    while ($post = dbassoc($q)) {
        echo '<div class="ui segment">';

        // Заголовок новости
        echo '<a id="link_menu" href="?news=' . $post['id'] . '"><h3><i class="mdi mdi-newspaper"></i> ' . text($post['title']) . '</h3></a>';

        // Часть текста
        echo '<div class="text">' . output_text($post['msg']) . '</div>';

        echo "<small style='color: #9197a3;'>";
        if ($post['time_edit']) {
            #Показываем последнее редактирование
            echo "<span style='float: right;color: green;'>" . __('обновлено') . " " . date::timek($post['time_edit']) . "</span>";
        }
        echo "<i class='mdi mdi-account'></i> $post[avtor] &#183; " . date::timek($post['time']);
        if ($post['link']) {
            echo " &#183; <a href='" . htmlentities($post['link'], ENT_QUOTES, 'UTF-8') . "'>" . __('Источник') . "</a>  ";
        }
        if ($post['close'] == 1) {
            echo " &#183; <i class='mdi mdi-lock grey'></i>";
        }
        echo ' &ensp; <i class="mdi mdi-thumb-up"></i> ' . dbresult(dbquery("SELECT COUNT(*) FROM `like_object` WHERE `id_object` = '$post[id]' AND `type` = 'news' AND `like` = '1'"), 0) . ' &#183; ';
        echo '<i class="mdi mdi-thumb-down"></i> ' . dbresult(dbquery("SELECT COUNT(*) FROM `like_object` WHERE `id_object` = '$post[id]' AND `type` = 'news' AND `like` = '0'"), 0) . '';

        echo "</small>";

        #По настройке пользователя выводим комментарии
        if ($user['set_news_comments'] == 1) {
            echo "<div class='ui horizontal divider header' style='margin: calc(1rem - 0.14285714em) 0em 1rem;'><small>" . __('Комментарии') . " &middot; " . dbresult(dbquery("SELECT COUNT(*) FROM `news_komm` WHERE `id_news` = '$post[id]'"), 0) . "</small></div>";

            $k_posts = dbresult(dbquery("SELECT COUNT(*) FROM `news_komm` WHERE `id_news` = '$post[id]'"), 0);
            $k_pages = k_page($k_posts, $set['p_str']);
            $pages = page($k_pages);
            $starts = $set['p_str'] * $pages - $set['p_str'];

            #Количество выводимых комментариев
            $qs = dbquery("SELECT * FROM `news_komm` WHERE `id_news` = '$post[id]' ORDER BY `id` DESC LIMIT 5");

            if ($k_posts == 0) {
                echo "<span style='color: #9197a3;'><i class='fa fa-comments fa-fw'></i> " . __('Еще не обсуждали') . "...</span>";
            }

            while ($posts = dbassoc($qs)) {
                $anks = get_user($posts['id_user']);

                echo "<small>";
                echo "<span style='float: right;color: #ccc;'>" . date::timek($posts['time']) . "</span>";
                echo "<b>$anks[nick]</b>: ";
                echo " " . output_text($posts['msg']);
                echo "</small><br />";
            }
        }
        echo '</div>';
    }


// Вывод страниц
    if ($k_page > 1) {
        str('index.php?', $k_page, $page);
    }

    echo '</div>';
}
include_once '../sys/inc/tfoot.php';
?>
