<?php
include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/user.php';

$set['title'] = __('Поиск по меткам'); // заголовок страницы
include_once H . 'sys/inc/thead.php';

$tag = NULL;
if (isset($_SESSION['tag'])) {
    $tag = $_SESSION['tag'];
}
if (isset($_GET['tag'])) {
    $tag = esc(urldecode($_GET['tag']));
}
$_SESSION['tag'] = $tag;

$tag = preg_replace("#( ){2,}#", " ", $tag);
$tag = preg_replace("#^( ){1,}|( ){1,}$#", "", $tag);

title();
aut();
err();

echo "<div class='ui segments'>";

echo "<div class='ui secondary segment'>" . __('Поиск по меткам') . "</div>";

if ($tag) {

    $q_tag = str_replace('%', '', $tag);
    $q_tag = str_replace(' ', '%', $q_tag);
    $q_tag = str_replace(',', '%', $q_tag);
    $k_post = dbresult(dbquery("SELECT COUNT(*) as count FROM `news` WHERE `tags` like '%" . $q_tag . "%'"), 0);
    $k_page = k_page($k_post, $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];

    if ($k_post == 0) {
        echo "<i class='mdi mdi-layers-outline'></i> " . __('Нет результатов');
    } else {

        echo "<div class='ui segment'>" . __('Найденные результаты') . " <b>$k_post</b></div>";

        $q = dbquery("SELECT * FROM `news` WHERE `tags` like '%" . $q_tag . "%' ORDER BY `id` DESC LIMIT $start, $set[p_str]");

        while ($post = dbassoc($q)) {
            $post['tags'] = str_replace("$tag", "<span style='color:red'>$tag</span>", $post['tags']);

            echo "<div class='ui segment'>";

            echo "<a href='/news/?news=$post[id]'><i class='mdi mdi-rss'></i> $post[title]</a> <small style='color: grey;'>" . date::time($post['time']) . "</small><br />";

            echo "<i class='mdi mdi-tag'></i> " . __('Метки') . ": $post[tags]<br />";
            echo "<i class='mdi mdi-account'></i> $post[avtor] &#183; " . date::timek($post['time']);
            echo "</div>";
        }

        if ($k_page > 1) {
            str("?", $k_page, $page);
        }
    }
} else {
    echo '<div class="ui segment">';
    echo __('Введите метку для поиска');
    echo '</div>';
}

$tag = stripcslashes(htmlspecialchars($tag));
?>
<form method="get" action="?" class="ui form segment">
    <div class='ui action input'>
        <input type='search' name='tag' required placeholder='<?= __('Метки') ?>' value="<?= $tag ?>">
        <button class='ui basic mdi button'><i class='mdi mdi-magnify'></i></button>
    </div>
</form>
<?php
echo "<div class='ui segment'><a href='/news/'><i class='mdi mdi-arrow-left'></i> " . __('Новости') . "</a></div>";

echo '</div>';

require_once H . 'sys/inc/tfoot.php';
