<?php

class date {

    static function number($num, $one, $two, $more) {
        $num = (int) $num;
        $l2 = substr($num, strlen($num) - 2, 2);

        if ($l2 >= 5 && $l2 <= 20) {
            return $more;
        }
        $l = substr($num, strlen($num) - 1, 1);
        switch ($l) {
            case 1:
                return $one;
                break;
            case 2:
                return $two;
                break;
            case 3:
                return $two;
                break;
            case 4:
                return $two;
                break;
            default:
                return $more;
                break;
        }
    }

    #читабельное представление времени с учетом часового пояса пользователя

    static function time($time = null, $adaptive = true) {
        if ($time > TIME) {
            $time -= TIME;
            $mes = 0;
            $day = 0;
            $hour = 0;
            $min = 0;
            $sec = 0;
            if ($time) {
                $sec = $time % 60;
            }
            if ($time >= 60) {
                $min = floor($time / 60 % 60);
            }
            if ($time >= 3600) {
                $hour = floor($time / 3600 % 24);
            }
            if ($time >= 86400) {
                $day = floor($time / 86400 % 30);
            }
            if ($time >= 2592000) {
                $mes = floor($time / 2592000 % 12);
            }

            if ($mes) {
                return $mes . ' месяц' . self::number($mes, '', 'а', 'ев') . ($day ? (', ' . $day . ' ' . self::number($day, 'день', 'дня', 'дней') . ($hour ? ' и ' . $hour . ' час' . self::number($hour, '', 'а', 'ов') : '')) : '');
            }
            if ($day) {
                return $day . ' ' . self::number($day, 'день', 'дня', 'дней') . ($hour ? (', ' . $hour . ' час' . self::number($hour, '', 'а', 'ов') . ($min ? ' и ' . $min . ' минут' . self::number($min, 'а', 'ы', '') : '')) : '');
            }
            if ($hour) {
                return $hour . ' час' . self::number($hour, '', 'а', 'ов') . ($min ? (', ' . $min . ' минут' . self::number($min, 'а', 'ы', '') . ($sec ? ' и ' . $sec . ' секунд' . self::number($sec, 'а', 'ы', '') : '')) : '');
            }
            if ($min) {
                return $min . ' минут' . self::number($min, 'а', 'ы', '') . ($sec ? ' и ' . $sec . ' секунд' . self::number($sec, 'а', 'ы', '') : '');
            }
            return $sec . ' секунд' . self::number($sec, 'а', 'ы', '');
        } else {
            global $user, $config;
            if (!$time) {
                $time = TIME;
            }
            if (isset($user)) {
            $time_shift = $user['time_shift'];
            } else {
                $time_shift = 0;
            }
            $time = $time + $time_shift * 3600;
            $vremja = date('j M в H:i', $time);
            $time_p[0] = date('j n Y', $time);
            $time_p[1] = date('H:i', $time);

            if ($adaptive && $time_p[0] == date('j n Y', TIME + $time_shift * 60 * 60)) {
                $vremja = date('H:i:s', $time);
            }

            if ($adaptive && $time_p[0] == date('j n Y', TIME - 60 * 60 * (24 - $time_shift))) {
                $vremja = __("Вчера в %s", $time_p[1]);
            }

            if ($adaptive && $time_p[0] == date('j n Y', TIME - 60 * 60 * (48 - $time_shift))) {
                $vremja = __("Позавчера в %s", $time_p[1]);
            }

            $vremja = str_replace('Jan', __('Янв'), $vremja);
            $vremja = str_replace('Feb', __('Фев'), $vremja);
            $vremja = str_replace('Mar', __('Марта'), $vremja);
            $vremja = str_replace('May', __('Мая'), $vremja);
            $vremja = str_replace('Apr', __('Апр'), $vremja);
            $vremja = str_replace('Jun', __('Июня'), $vremja);
            $vremja = str_replace('Jul', __('Июля'), $vremja);
            $vremja = str_replace('Aug', __('Авг'), $vremja);
            $vremja = str_replace('Sep', __('Сент'), $vremja);
            $vremja = str_replace('Oct', __('Окт'), $vremja);
            $vremja = str_replace('Nov', __('Ноября'), $vremja);
            $vremja = str_replace('Dec', __('Дек'), $vremja);
            return $vremja;
        }
    }

    static function timemini($time = null, $adaptive = true) {
        if ($time > TIME) {
            $time -= TIME;
            $mes = 0;
            $day = 0;
            $hour = 0;
            $min = 0;
            $sec = 0;
            if ($time) {
                $sec = $time % 60;
            }
            if ($time >= 60) {
                $min = floor($time / 60 % 60);
            }
            if ($time >= 3600) {
                $hour = floor($time / 3600 % 24);
            }
            if ($time >= 86400) {
                $day = floor($time / 86400 % 30);
            }
            if ($time >= 2592000) {
                $mes = floor($time / 2592000 % 12);
            }

            if ($mes) {
                return $mes . ' ' . self::number($mes, __('месяц'), __('месяца'), __('месяцев')) . ($day ? (', ' . $day . ' ' . self::number($day, __('день'), __('дня'), __('дней')) . ($hour ? ' ' . __('и') . ' ' . $hour . ' ' . self::number($hour, __('час'), __('часа'), __('часов')) : '')) : '');
            }
            if ($day) {
                return $day . ' ' . self::number($day, __('день'), __('дня'), __('дней')) . ($hour ? (', ' . $hour . ' ' . self::number($hour, __('час'), __('часа'), __('часов')) . ($min ? ' ' . __('и') . ' ' . $min . ' ' . self::number($min, __('минута'), __('минуты'), __('минут')) : '')) : '');
            }
            if ($hour) {
                return $hour . ' ' . self::number($hour, __('час'), __('часа'), __('часов')) . ($min ? (', ' . $min . ' ' . self::number($min, __('минута'), __('минуты'), __('минут')) . ($sec ? ' ' . __('и') . ' ' . $sec . ' ' . self::number($sec, __('секунда'), __('секунды'), __('секунд')) : '')) : '');
            }
            if ($min) {
                return $min . ' ' . self::number($min, __('минута'), __('минуты'), __('минут')) . ($sec ? ' и ' . $sec . ' ' . self::number($sec, __('секунда'), __('секунды'), __('секунд')) : '');
            }
            return $sec . ' ' . self::number($sec, __('секунда'), __('секунды'), __('секунд'));
        } else {
        global $user, $config;
            if (!$time) {
                $time = TIME;
            }
            if (isset($user)) {
                $time_shift = $config->time_shift;
            } else {
                $time_shift = 0;
            }
            $time = $time + $time_shift * 3600;
            $vremja = date('H:i', $time);
            $time_p[0] = date('j n Y', $time);
            $time_p[1] = date('H:i', $time);
            if ($adaptive && $time_p[0] == date('j n Y', TIME + $time_shift * 60 * 60)) {
                $vremja = date('H:i', $time);
            }
            if ($adaptive && $time_p[0] == date('j n Y', TIME - 60 * 60 * (24 - $time_shift))) {
                $vremja = "$time_p[1]";
            }
            if ($adaptive && $time_p[0] == date('j n Y', TIME - 60 * 60 * (48 - $time_shift))) {
                $vremja = "$time_p[1]";
            }

            $vremja = str_replace('Jan', __('Янв'), $vremja);
            $vremja = str_replace('Feb', __('Фев'), $vremja);
            $vremja = str_replace('Mar', __('Марта'), $vremja);
            $vremja = str_replace('May', __('Мая'), $vremja);
            $vremja = str_replace('Apr', __('Апр'), $vremja);
            $vremja = str_replace('Jun', __('Июня'), $vremja);
            $vremja = str_replace('Jul', __('Июля'), $vremja);
            $vremja = str_replace('Aug', __('Авг'), $vremja);
            $vremja = str_replace('Sep', __('Сент'), $vremja);
            $vremja = str_replace('Oct', __('Окт'), $vremja);
            $vremja = str_replace('Nov', __('Ноября'), $vremja);
            $vremja = str_replace('Dec', __('Дек'), $vremja);
            return $vremja;
        }
    }

    static function times($times) {
        global $set, $time;
        static $users;
        $lama = round(($time - $times) / 60);
        if ($lama < 1) {
            $lama = __("только что");
        }
        if ($lama >= 1 && $lama < 60) {
            $lama = sklon_text($lama, array(__('минуту'), __('минуты'), __('минут'))) . " " . __('назад') . "";
        }
        if ($lama >= 60 && $lama < 1440) {
            $lama = round($lama / 60);
            $lama = sklon_text($lama, array(__('час'), __('часа'), __('часов'))) . " " . __('назад') . "";
        }
        if ($lama >= 1440) {
            $lama = round($lama / 60 / 24);
            $lama = sklon_text($lama, array(__('день'), __('дня'), __('дней'))) . " " . __('назад') . "";
        }
        return $lama;
    }

    static function timek($times) {
        global $set, $time;
        static $users;
        $lama = round(($time - $times) / 60);
        if ($lama < 1) {
            $lama = __('только что');
        }
        if ($lama >= 1 && $lama < 60) {
            $lama = __('%s м. назад', $lama);
        }
        if ($lama >= 60 && $lama < 1440) {
            $lama = round($lama / 60);
            $lama = __('%s ч. назад', $lama);
        }
        if ($lama >= 1440) {
            $lama = round($lama / 60 / 24);
            $lama = __('%s д. назад', $lama);
        }
        return $lama;
    }

    static function sictime($timediff) {
        $oneMinute = 60;
        $oneHour = 60 * 60;
        $oneDay = 60 * 60 * 24;
        $dayfield = floor($timediff / $oneDay);
        $hourfield = floor(($timediff - $dayfield * $oneDay) / $oneHour);
        $minutefield = floor(($timediff - $dayfield * $oneDay - $hourfield * $oneHour) / $oneMinute);
        $secondfield = floor(($timediff - $dayfield * $oneDay - $hourfield * $oneHour - $minutefield * $oneMinute));
        $time_1 = "$hourfield ч. $minutefield м. $secondfield сек.";
        return $time_1;
    }

    #Вывод названия месяца

    static function rus_mes($num, $v = 1) {
        switch ($num) {
            case 1: return __('Январ' . ($v ? 'я' : 'ь'));
            case 2: return __('Феврал' . ($v ? 'я' : 'ь'));
            case 3: return __('Март' . ($v ? 'а' : ''));
            case 4: return __('Апрел' . ($v ? 'я' : 'ь'));
            case 5: return __('Ма' . ($v ? 'я' : 'й'));
            case 6: return __('Июн' . ($v ? 'я' : 'ь'));
            case 7: return __('Июл' . ($v ? 'я' : 'ь'));
            case 8: return __('Август' . ($v ? 'а' : ''));
            case 9: return __('Сентябр' . ($v ? 'я' : 'ь'));
            case 10: return __('Октябр' . ($v ? 'я' : 'ь'));
            case 11: return __('Ноябр' . ($v ? 'я' : 'ь'));
            case 12: return __('Декабр' . ($v ? 'я' : 'ь'));
            default: return false;
        }
    }

}
