<?php

#длина строки

function utf8_strlen($str) {
    if (USE_MBSTRING) {
        return mb_strlen($str);
    } elseif (USE_ICONV) {
        return iconv_strlen($str);
    } else {
        #извращенный способ при отсутствии библиотек
        static $rus;
        if (!isset($rus)) {
            $rus = array('й', 'ц', 'у', 'к', 'е', 'н', 'г', 'ш', 'щ', 'з', 'х', 'ъ', 'ф', 'ы', 'в', 'а', 'п', 'р', 'о', 'л', 'д', 'ж', 'э', 'я', 'ч', 'с', 'м', 'и', 'т', 'ь', 'б', 'ю', 'Й', 'Ц', 'У', 'К', 'Е', 'Н', 'Г', 'Ш', 'Щ', 'З', 'Х', 'Ъ', 'Ф', 'Ы', 'В', 'А', 'П', 'Р', 'О', 'Л', 'Д', 'Ж', 'Э', 'Я', 'Ч', 'С', 'М', 'И', 'Т', 'Ь', 'Б', 'Ю');
        }
        return strlen(str_replace($rus, '0', $str));
    }
}

// перекодирование в utf8 
function convert_to_utf8($str, $enc = 'windows-1251') {
    if (USE_ICONV) {
        return @iconv($enc, 'UTF-8//IGNORE', $str);
    } elseif (USE_MBSTRING) {
        return @mb_convert_encoding($str, 'UTF-8', $enc);
    } else {
        return $str;
    }
}

// перекодирование из utf8 
function convert_of_utf8($str, $enc = 'windows-1251') {
    if (USE_ICONV) {
        return @iconv('UTF-8', $enc . '//IGNORE', $str);
    } elseif (USE_MBSTRING) {
        return @mb_convert_encoding($str, $enc, 'UTF-8');
    } else {
        return $str;
    }
}
