<?php

$set = array(); // массив с настройками
$set_default = array();
$set_dinamic = array();
$set_replace = array();

#загрузка настроек по умолчанию. Позволяет исключить отсутствие неопределенных переменных
$default = @parse_ini_file(H . 'sys/ini/default.ini', true);
$set_default = @$default['DEFAULT'];
$set_replace = @$default['REPLACE'];

if (file_exists(H . 'sys/ini/settings.ini')) {
    $set_dinamic = @parse_ini_file(H . 'sys/ini/settings.ini', false);
    foreach ($set_dinamic as $key => $value) {
        $set_dinamic[$key] = html_entity_decode($value, ENT_QUOTES, 'UTF-8');
    }
} elseif (file_exists(H . 'install/index.php')) {
    header("Location: /install/");
    exit;
}

$set = @array_merge($set_default, $set_dinamic, $set_replace);
if ($set['show_err_php']) {
    error_reporting(E_ALL); // включаем показ ошибок
    ini_set('display_errors', true); // включаем показ ошибок
}

if (!empty($_SESSION['language']) && languages::exists($_SESSION['language'])) {
    // языковой пакет из сессии
    $user_language_pack = new language_pack($_SESSION['language']);
} else if ($set['language'] && languages::exists($set['language'])) {
    // системный языковой пакет
    $user_language_pack = new language_pack($set['language']);
}

if (isset($_SERVER["HTTP_USER_AGENT"]) && preg_match('#up-browser|blackberry|windows ce|symbian|android|ios|os|palm|nokia#i', $_SERVER["HTTP_USER_AGENT"])) {
    $webbrowser = false;
} elseif (isset($_SERVER["HTTP_USER_AGENT"]) && (preg_match('#windows#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#linux#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#bsd#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#x11#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#unix#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#macos#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#macintosh#i', $_SERVER["HTTP_USER_AGENT"]))) {
    $webbrowser = true;
} else {
    $webbrowser = false;
} // определение типа браузера

$set['web'] = false;

function setget($name, $default = null) {
    global $set;
    if (!isset($set[$name])) {
        if ($default === null) {
            $set[$name] = null;
        } else {
            $set[$name] = $default;
        }
    }
    return $set[$name];
}

function setset($name, $value = null) {
    global $set;
    $set[$name] = $value;
}
?>