<?php

require 'mysql2i.class.php';

#Проверяем версию PHP
version_compare(PHP_VERSION, '5.3', '>=') or die('Требуется PHP >= 5.3');

ini_set('display_errors', true); // сообщения с ошибками будут показываться
error_reporting(E_ALL); // E_ALL - отображаем ВСЕ ошибки
// Ставим ограничение для выполнения скрипта на 60 сек
if (function_exists('set_time_limit'))
    @set_time_limit(60);
if (function_exists('ini_set')) {

    ini_set('display_errors', true); // отключаем показ ошибок
    ini_set('register_globals', false); // вырубаем глобальные переменные
    ini_set('session.use_cookies', true); // используем куки для сессий
    ini_set('session.use_trans_sid', true); // используем url для передачи сессий
    ini_set('arg_separator.output', "&amp;"); // разделитель переменных в url (для соответствия с xml)
}

#Запущено ли на винде
define('IS_WINDOWS', strtoupper(substr(PHP_OS, 0, 3)) === 'WIN');
define("H", $_SERVER["DOCUMENT_ROOT"] . '/');
define('TIME_TODAY', mktime(0, 0, 0)); #на начало текущих суток
define('SET_TIME_LIMIT', function_exists('set_time_limit'));
#автоматическая загрузка классов

/**
 * автоматическая загрузка классов
 * @param string $class_name имя класса
 */
function dcmsAutoload($class_name) {
    $path = H . 'sys/classes/' . strtolower($class_name) . '.class.php';
    if (file_exists($path)) {
        include_once ($path);
    }
}

spl_autoload_register('dcmsAutoload');

// принудительно вырубаем глобальные переменные
if (ini_get('register_globals')) {
    $allowed = array('_ENV' => 1, '_GET' => 1, '_POST' => 1, '_COOKIE' => 1, '_FILES' => 1, '_SERVER' => 1, '_REQUEST' => 1, 'GLOBALS' => 1);
    foreach ($GLOBALS as $key => $value) {
        if (!isset($allowed[$key])) {
            unset($GLOBALS[$key]);
        }
    }
}

list($msec, $sec) = explode(chr(32), microtime()); // время запуска скрипта
$conf['headtime'] = $sec + $msec;
$time = time();

$phpvervion = explode('.', phpversion());
$conf['phpversion'] = $phpvervion[0];

$upload_max_filesize = ini_get('upload_max_filesize');
if (preg_match('#([0-9]*)([a-z]*)#i', $upload_max_filesize, $varrs)) {
    if ($varrs[2] == 'M')
        $upload_max_filesize = $varrs[1] * 1048576;
    elseif ($varrs[2] == 'K')
        $upload_max_filesize = $varrs[1] * 1024;
    elseif ($varrs[2] == 'G')
        $upload_max_filesize = $varrs[1] * 1024 * 1048576;
}

function fiera($msg) {
    $msg = str_replace("script", "sсript", $msg);
    $msg = str_replace("javаscript:", "javаscript:", $msg);
    if ($_SERVER['PHP_SELF'] != '/adm_panel/mysql.php')
        $msg = addslashes(stripslashes(trim($msg)));
    return $msg;
}

define('USE_MBSTRING', function_exists('mb_get_info'));
define('TIME', time());
define('TEMP', H . '/sys/tmp'); //TEMP временная папка
define('CACHE', H . '/sys/cache'); //CACHE папка кэша
define('URL', urlencode($_SERVER ['REQUEST_URI'])); //URL текущая страница.
// Полночь
$ftime = mktime(0, 0, 0);

/**
 * @global \language_pack $user_language_pack Текущий языковой пакет
 */
$user_language_pack = new language_pack(false);

/**
 * Локализация текстовой строки.
 * ВНИМАНИЕ!!! не использовать динамические строки
 * @global language_pack $user_language_pack
 * @return string Локализованная строка
 */
function __() {
    $args = func_get_args();
    $args_num = count($args);
    if (!$args_num) {
        // нет ни строки ни параметров, вообще нихрена
        return '';
    }

    global $user_language_pack;
    $string = $user_language_pack->getString($args[0]);

    if ($args_num == 1) {
        // строка без параметров
        return $string;
    }

// строка с параметрами
    $args4eval = array();
    for ($i = 1; $i < $args_num; $i++) {
        $args4eval[] = '$args[' . $i . ']';
    }
    return eval('return sprintf($string,' . implode(',', $args4eval) . ');');
}

?>