<?php

include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';

only_reg();
only_level(3);

$width = ($webbrowser == 'web' ? '100' : '70'); // Размер подарков при выводе в браузер

/* Редактирование подарков */
if (isset($_GET['edit_gift']) && isset($_GET['category'])) {
    $category = dbassoc(dbquery("SELECT * FROM `gift_categories` WHERE `id` = '" . intval($_GET['category']) . "' LIMIT 1"));
    $gift = dbassoc(dbquery("SELECT * FROM `gift_list` WHERE `id` = '" . intval($_GET['edit_gift']) . "' LIMIT 1"));

    if (!$category || !$gift) {
        $_SESSION['message'] = __('Нет такой категории или подарка');

        header("Location: ?");
        exit;
    }

    if (isset($_POST['name']) && isset($_POST['money'])) { // Редактирование записи
        $name = my_esc($_POST['name']);
        $money = intval($_POST['money']);

        if ($money < 1) {
            $err = __('Укажите стоимость подарка');
        }

        if (strlen2($name) < 2) {
            $err = __('Короткое название');
        }

        if (strlen2($name) > 128) {
            $err = ('Длина названия превышает предел в 128 символов');
        }

        if (!isset($err)) {
            dbquery("UPDATE `gift_list` SET `name` = '$name' , `money` = '$money', `id_category` = '$category[id]' WHERE `id` = '$gift[id]'");

            $_SESSION['message'] = __('Подарок успешно отредактирован');

            header('Location: ?category=' . $category['id'] . '&page=' . intval($_GET['page']));
            exit;
        }
    }

    if (isset($_GET['delete'])) { // Удаление подарка
        unlink(H . 'sys/gift/' . $gift['id'] . '.png');

        dbquery("DELETE FROM `gift_list` WHERE `id` = '$gift[id]'");
        dbquery("DELETE FROM `gifts_user` WHERE `id_gift` = '$gift[id]'");

        $_SESSION['message'] = __('Подарок успешно удален');

        header("Location: ?category=$category[id]&page=" . intval($_GET['page']));
        exit;
    }

    $set['title'] = __('Редактирование подарка');

    include_once '../../sys/inc/thead.php';

    title();
    aut();
    err();

    echo '<div class="ui segment">';
    echo '<a href="?"><i class="mdi mdi-chevron-double-left"></i> ' . __('Категории') . '</a> |  <a href="?category=' . $category['id'] . '">' . htmlspecialchars($category['name']) . '</a> | <b>' . __('Добавление подарка') . '</b>';
    echo '</div>';

// Форма редактирования подарка
    echo '<form class="ui form segment" method="post" enctype="multipart/form-data"  action="?category=' . $category['id'] . '&amp;edit_gift=' . $gift['id'] . '&amp;page=' . intval($_GET['page']) . '">';
    echo '<img src="/sys/gift/' . $gift['id'] . '.png" style="max-width:' . $width . 'px;" alt="*" /><br />';
    echo __('Название') . ':<br /><input type="text" name="name" value="' . htmlspecialchars($gift['name']) . '" /><br />';
    echo __('Цена') . ': (' . __('Валюта сайта') . ')<br /><input type="text" name="money" value="' . $gift['money'] . '" /><br /><br />';
    echo "<button class='ui compact blue labeled icon button'><i class='mdi mdi-check icon'></i> " . __('Сохранить') . "</button>\n";
    echo '</form>';

    echo '<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="?">' . __('Категории') . '</a> |  <a href="?category=' . $category['id'] . '">' . htmlspecialchars($category['name']) . '</a> | <b>Добавление подарка</b><br />';
    echo '</div>';
} else

/* Добавление подарков */

if (isset($_GET['add_gift']) && isset($_GET['category'])) {
    $category = dbassoc(dbquery("SELECT * FROM `gift_categories` WHERE `id` = '" . intval($_GET['category']) . "' LIMIT 1"));

    if (!$category) {
        $_SESSION['message'] = __('Нет такой категории');

        header("Location: ?");
        exit;
    }

    if (isset($_POST['name']) && isset($_POST['money']) && isset($_FILES['gift'])) { // Создание записи
        $name = my_esc($_POST['name']);
        $money = intval($_POST['money']);

        if ($money < 1) {
            $err = __('Укажите стоимость подарка');
        }

        if (strlen2($name) < 2) {
            $err = __('Короткое название');
        }

        if (strlen2($name) > 128) {
            $err = __('Длина названия превышает предел в 128 символов');
        }

        if (!isset($err)) {
            dbquery("INSERT INTO `gift_list` (`name`, `money`, `id_category`) values('$name', '$money', '$category[id]')");

            $file_id = mysql_insert_id();

            copy($_FILES['gift']['tmp_name'], H . 'sys/gift/' . $file_id . '.png');
            @chmod(H . 'sys/gift/' . $file_id . '.png', 0777);

            $_SESSION['message'] = __('Подарок успешно добавлен');

            header("Location: ?category=" . $category['id']);
            exit;
        }
    }

    $set['title'] = __('Добавление подарка');

    include_once '../../sys/inc/thead.php';

    title();
    aut();
    err();

    echo '<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="?">' . __('Категории') . '</a> |  <a href="?category=' . $category['id'] . '">' . htmlspecialchars($category['name']) . '</a> | <b>Добавление подарка</b><br />';
    echo '</div>';

// Форма создания категории
    echo '<form class="ui form segment" method="post" enctype="multipart/form-data"  action="?category=' . $category['id'] . '&amp;add_gift">';
    echo __('Название') . ':<br /><input type="text" name="name" value="" required/><br />';
    echo __('Цена') . ': (' . __('Валюта сайта') . ')<br /><input type="text" name="money" value="" required/><br />';
    echo __('Подарок') . ': (' . __('Выберите изображение') . ')<br /><input name="gift" accept="image/*,image/png" required type="file" /><br /><br />';
    echo "<button class='ui compact blue labeled icon button'><i class='mdi mdi-check icon'></i> " . __('Добавить') . "</button>\n";
    echo '</form>';

    echo '<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="?">' . __('Категории') . '</a> |  <a href="?category=' . $category['id'] . '">' . htmlspecialchars($category['name']) . '</a> | <b>Добавление подарка</b><br />';
    echo '</div>';
} else

/* Вывод подарков */

if (isset($_GET['category'])) {

    $category = dbassoc(dbquery("SELECT * FROM `gift_categories` WHERE `id` = '" . intval($_GET['category']) . "' LIMIT 1"));

    if (!$category) {
        $_SESSION['message'] = __('Нет такой категории');

        header("Location: ?");
        exit;
    }

    $set['title'] = __('Список подарков');

    include_once '../../sys/inc/thead.php';

    title();
    aut();
    err();

    echo '<div class="ui segments">';
    echo '<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="?">' . __('Категории') . '</a> | <b>' . htmlspecialchars($category['name']) . '</b><br />';
    echo '</div>';

// Список подарков
    $k_post = dbresult(dbquery("SELECT COUNT(id) FROM `gift_list`  WHERE `id_category` = '$category[id]'"), 0);

    if ($k_post == 0) {
        echo '<div class="ui segment">';
        echo "<i class='mdi mdi-layers-outline'></i> " . __('Нет результатов');
        echo '</div>';
    }

    $k_page = k_page($k_post, $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];
    $q = dbquery("SELECT name,id,money FROM `gift_list` WHERE `id_category` = '$category[id]' ORDER BY `id` LIMIT $start, $set[p_str]");

    while ($post = dbassoc($q)) {
        echo '<div class="ui segment">';
        echo "<span style='float:right'>";
        echo ' <a href="create.php?category=' . $category['id'] . '&amp;edit_gift=' . $post['id'] . '&amp;page=' . $page . '" class="ui basic label"><i class="mdi mdi-cog"></i></a> ';
        echo ' <a href="create.php?category=' . $category['id'] . '&amp;edit_gift=' . $post['id'] . '&amp;page=' . $page . '&amp;delete" class="ui basic label"><i class="mdi mdi-delete"></i></a> ';
        echo '</span>';
        echo '<img src="/sys/gift/' . $post['id'] . '.png" style="max-width:' . $width . 'px;" alt="*" /><br />';
        echo '<b>' . htmlspecialchars($post['name']) . '</b> ';
        echo '(' . $post['money'] . ' ' . $sMonet[0] . ')';
        echo '</div>';
    }

    if ($k_page > 1) {
        str('create.php?category=' . intval($_GET['category']) . '&amp;', $k_page, $page);
    } // Вывод страниц

    echo '<div class="ui segment">';
    echo '<a href="?category=' . $category['id'] . '&amp;add_gift" class="ui basic label"><i class="mdi mdi-plus"></i> ' . __('Добавить подарок') . '</a>';
    echo '</div>';

    echo '<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="?">' . __('Категории') . '</a> | <b>' . htmlspecialchars($category['name']) . '</b><br />';
    echo '</div>';

    echo '</div>';
} else

/* Создание категорий */

if (isset($_GET['add_category'])) {
    if (isset($_POST['name']) && $_POST['name'] != NULL) { // Создание записи
        $name = my_esc($_POST['name']);

        if (strlen2($name) < 2) {
            $err = __('Короткое название');
        }

        if (strlen2($name) > 128) {
            $err = __('Длина названия превышает предел в 128 символов');
        }

        if (!isset($err)) {
            dbquery("INSERT INTO `gift_categories` (`name`) values('$name')");

            $_SESSION['message'] = __('Категория успешно добавлена');

            header("Location: ?");
            exit;
        }
    }

    $set['title'] = __('Создание категорий');

    include_once '../../sys/inc/thead.php';

    title();
    aut();
    err();

    echo '<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="?">' . __('Категории') . '</a><br />';
    echo '</div>';

    // Форма создания категории
    echo '<form class="ui form segment" method="post" action="?add_category">';
    echo __('Название') . ':<br /><input type="text" name="name" value="" required/><br /><br />';
    echo "<button class='ui compact blue labeled icon button'><i class='mdi mdi-check icon'></i> " . __('Добавить') . "</button>\n";
    echo '</form>';

    echo '<div class="ui segment">';
    echo '<i class="mdi mdi-chevron-double-left"></i> <a href="?">' . __('Категории') . '</a><br />';
    echo '</div>';
} else

/* Редактирование категорий */
if (isset($_GET['edit_category'])) {
    $category = dbassoc(dbquery("SELECT * FROM `gift_categories` WHERE `id` = '" . intval($_GET['edit_category']) . "' LIMIT 1"));

    if (!$category) {
        $_SESSION['message'] = __('Нет такой категории');

        header("Location: ?");
        exit;
    }

    if (isset($_POST['name']) && $_POST['name'] != NULL) { // Создание записи
        $name = my_esc($_POST['name']);

        if (strlen2($name) < 2) {
            $err = __('Короткое название');
        }

        if (strlen2($name) > 128) {
            $err = __('Длина названия превышает предел в 128 символов');
        }

        if (!isset($err)) {
            dbquery("UPDATE `gift_categories` SET `name` = '$name' WHERE `id` = '$category[id]'");

            $_SESSION['message'] = __('Категория успешно переименована');

            header("Location: ?");
            exit;
        }
    }

    if (isset($_GET['delete'])) { // Удаление категории
        $q = dbquery("SELECT id FROM `gift_list` WHERE `id_category` = '$category[id]'");

        while ($post = dbassoc($q)) {
            unlink(H . 'sys/gift/' . $post['id'] . '.png');
            dbquery("DELETE FROM `gifts_user` WHERE `id_gift` = '$post[id]'");
        }

        dbquery("DELETE FROM `gift_list` WHERE `id_category` = '$category[id]'");
        dbquery("DELETE FROM `gift_categories` WHERE `id` = '$category[id]' LIMIT 1");

        $_SESSION['message'] = __('Категория успешно удалена');

        header("Location: ?");
        exit;
    }

    $set['title'] = __('Редактирование категории');

    include_once '../../sys/inc/thead.php';

    title();
    aut();
    err();

    // Форма редактирования категории
    echo '<form class="ui form segment" method="post" action="?edit_category=' . $category['id'] . '">';
    echo __('Название') . ':<br /><input type="text" name="name" value="' . htmlspecialchars($category['name']) . '" required/><br /><br />';
    echo "<button class='ui compact blue labeled icon button'><i class='mdi mdi-check icon'></i> " . __('Сохранить') . "</button>\n";
    echo '</form>';
} else {
    $set['title'] = __('Список категорий');

    include_once '../../sys/inc/thead.php';

    title();
    aut();
    err();

    echo '<div class="ui segments">';

// Список категорий	
    $k_post = dbresult(dbquery("SELECT COUNT(id) FROM `gift_categories`"), 0);

    if ($k_post == 0) {
        echo '<div class="ui segment">';
        echo "<i class='mdi mdi-layers-outline'></i> " . __('Нет результатов');
        echo '</div>';
    }

    $q = dbquery("SELECT name,id FROM `gift_categories` ORDER BY `id`");

    while ($post = dbassoc($q)) {
        echo '<div class="ui segment">';
        echo "<span style='float:right'>";
        echo ' <a href="create.php?edit_category=' . $post['id'] . '" class="ui basic label"><i class="mdi mdi-cog"></i></a> ';
        echo ' <a href="create.php?edit_category=' . $post['id'] . '&amp;delete" class="ui basic label"><i class="mdi mdi-delete"></i></a> ';
        echo '</span>';
        echo '<a href="create.php?category=' . $post['id'] . '"><i class="mdi mdi-folder"></i> ' . htmlspecialchars($post['name']) . '</a> ';
        echo '(' . dbresult(dbquery("SELECT COUNT(id) FROM `gift_list` WHERE `id_category` = '$post[id]'"), 0) . ')';

        echo '</div>';
    }

    echo '<div class="ui segment">';
    echo "<a href='?add_category' class='ui compact blue labeled icon button'><i class='mdi mdi-check icon'></i> " . __('Создать категорию') . "</a>\n";
    echo '</div>';
    echo '</div>';
}

include_once '../../sys/inc/tfoot.php';
?>