<?php
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/adm_check.php';
include_once '../../sys/inc/user.php';

only_reg();

$set['title'] = __('Сменить логин');

include_once H . 'sys/inc/thead.php';

title();
err();
aut();

if (isset($_POST['save']) && isset($_POST['name'])) {

    if (isset($user) && $user['money'] <= $set['login_shop']) {
        $_SESSION['err'] = __('У Вас недостаточно на счету');

        header("Location: ?");
        exit();
    } else {
        $nick = esc($_POST['name']);

        if (!preg_match("#^([A-z0-9\-\_])+$#ui", $nick)) {
            $_SESSION['err'] = __('В логине присутствуют запрещенные символы');

            header("Location: ?");
            exit();
        } elseif (preg_match("#[a-z]+#ui", $nick) && preg_match("#[а-я]+#ui", $nick)) {
            $_SESSION['err'] = __('Разрешается использовать символы только английского алфавита и цифр');

            header("Location: ?");
            exit();
        } elseif (preg_match("#(^\ )|(\ $)#ui", $nick)) {
            $_SESSION['err'] = __('Запрещено использовать пробел в начале и конце логина');

            header("Location: ?");
            exit();
        } elseif (strlen2($nick) < 3) {
            $_SESSION['err'] = __('Короткий логин');

            header("Location: ?");
            exit();
        } elseif (strlen2($nick) > 32) {
            $_SESSION['err'] = __('Длина логина превышает 32 символа');

            header("Location: ?");
            exit();
        }
        if (dbresult(dbquery("SELECT COUNT(*) FROM `user` WHERE `nick` = '" . $nick . "'"), 0)) {
            $_SESSION['err'] = __('Выбранный Вами логин уже занят');

            header("Location: ?");
            exit();
        } else {
            dbquery("UPDATE `user` SET `money` = '" . ($user['money'] - $set['login_shop']) . "' WHERE `id` = '$user[id]' LIMIT 1");

            if ($user['nick'] != $nick) {
                dbquery("INSERT INTO `history_login` SET `login_last` = '$user[nick]', `login_new` = '$nick', `user_id` = '$user[id]', `who` = '$user[id]', `time` = '$time'");
            }

            dbquery("UPDATE `user` SET `nick` = '$nick' WHERE `id` = '$user[id]' LIMIT 1");

            $msgs = 'Вы сменили логин [red]-' . $set['login_shop'] . '[/red] монет';
            dbquery("INSERT INTO `money_out` (`id_u`, `ank`, `msg`, `time`) values('$user[id]', '$user[id]', '$msgs', '$time')");

            $_SESSION['message'] = __('Изменения сохранены');

            header("Location: ?");
            exit();
        }
    }
}
?>
<div class='ui segments'>

    <div class='ui segment'>
        <i class='mdi mdi-chevron-double-left'></i> <a href='/info.php'><?= $user['nick'] ?></a> | <?= __('Сменить логин') ?>
    </div>

    <div class='ui segment' style='color: green'><i class='mdi mdi-account-cash-outline'></i> <?= __('У вас %s ' . date::number($user['money'], 'монета', 'монеты', 'монет'), $user['money']) ?></div>

    <form method='POST' class='ui form segment'>
        <div class="field">
            <label><?= __('Логин') ?></label>
            <input type='text' name='name' value='<?= $user['nick'] ?>' required>
        </div>

        <div class="ui info message">Разрешено использовать буквы латиницы, символ "_" и цифры.</div>

        <div class='ui field'>
            <?php
            if ($user['money'] < $set['login_shop']) {
                echo "<button class='ui compact blue labeled icon disabled button' name='save'><i class='mdi mdi-content-save icon'></i> " . __('Сохранить') . "</button>\n";
            } else {
                echo "<button class='ui compact blue labeled icon button' name='save'><i class='mdi mdi-content-save icon'></i> " . __('Сохранить') . "</button>\n";
            }
            ?>
            <div class='ui compact red basic button'><i class='mdi mdi-account-cash-outline'></i> -<?= $set['login_shop'] ?></div>
        </div>
    </form>
    <div class='ui segment'><a href='/user/money/'><i class='mdi mdi-arrow-left'></i> <?= __('Магазин') ?></a></div>

</div>
<?php
include_once H . 'sys/inc/tfoot.php';

