<?php

include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';

$set['title'] = __('Настройки языка');
include_once H . 'sys/inc/thead.php';

err();
aut();
title();


if (!empty($_GET['set_lang'])) {
    if (!languages::exists($_GET['set_lang'])) {
        $err = __('Запрашиваемый языковой пакет не найден');
    } else {
        $user_language_pack = new language_pack($_GET['set_lang']);

        if (isset($user)) {
            $user['language'] = $user_language_pack->code;
            dbquery("UPDATE `user` SET `language` = '$user[language]' WHERE `id` = '$user[id]' LIMIT 1");
        } else {
            $_SESSION['language'] = $user_language_pack->code;
        }

        if (!isset($err)) {
            $_SESSION['message'] = __('Языковой пакет %s (%s) успешно выбран', $user_language_pack->name, $user_language_pack->enname);
            header("Location: ?");
            exit;
        }
    }
}

$languages = languages::getList();

echo "<div class=\"ui segments\">\n";
echo "<div class=\"ui secondary segment\">" . __('Выберите язык') . "</div>";
foreach ($languages as $key => $l) {
    $langUrl = new url(null, array('set_lang' => $key));

    if (isset($user)) {
        $lang = ($user_language_pack->code == $user['language'] ? "<b>$l[name]</b>" : $l['name']);
    } else {
        $lang = $l['name'];
    }

    echo "<div class=\"ui segment\">\n";
    echo "<a href='$langUrl'>" . ($user_language_pack->code == $key ? "<i class='$l[icon] flag'></i> $lang" : "<i class='$l[icon] flag'></i> $l[enname]") . "</a>";
    echo "</div>\n";
}

if (isset($user)) {
    echo "<div class='ui segment'><a href='index.php'><i class='mdi mdi-keyboard-backspace'></i> " . __('Настройки') . "</a></div>";
} else {
    echo "<div class='ui segment'><a href='/index.php'><i class='mdi mdi-home-circle-outline'></i> " . __('Главная') . "</a></div>";
}

echo "</div>\n";



include_once H . 'sys/inc/tfoot.php';
