<?php
include_once '../sys/inc/start.php';
include_once '../sys/inc/compress.php';
include_once '../sys/inc/sess.php';
include_once '../sys/inc/home.php';
include_once '../sys/inc/settings.php';
include_once '../sys/inc/db_connect.php';
include_once '../sys/inc/ipua.php';
include_once '../sys/inc/fnc.php';
include_once '../sys/inc/user.php';

$set['title'] = __('Пользователи'); // заголовок страницы

include_once '../sys/inc/thead.php';

title();
aut();

$sort = 'id';
$por = 'DESC';

if (isset($_GET['ASC'])) {
    $por = 'ASC';
} // прямой порядок

if (isset($_GET['DESC'])) {
    $por = 'DESC';
} // обратный порядок

$act_balls = null;
$act_rating = null;
$act_pol = null;
$act_id = null;
$act_new = null;

switch (@$_GET['sort']) {
    case 'balls':
        $sql_sort = '`user`.`balls`';
        $sort = 'balls'; #рубли
        $act_balls = 'basic';
        break;
    case 'rating':
        $sql_sort = '`user`.`rating`';
        $sort = 'rating'; #рейтинг
        $act_rating = 'basic';
        break;
    case 'pol':
        $sql_sort = '`user`.`pol`';
        $sort = 'pol'; #пол
        $act_pol = 'basic';
        break;
    case 'new':
        $sql_sort = '`user`.`id`';
        $sort = 'id'; #пол
        $act_new = 'basic';
        break;
    default:
        $sql_sort = '`user`.`id`';
        $sort = 'id'; #ID
        $act_id = 'basic';
        break;
}

echo "<div class='ui horizontal segments'>";
echo "<div class='ui center aligned segment'>";
echo "<a href='/users/'><b>" . __('Пользователи') . "</b></a>";
echo "</div>";
echo "<div class='ui center aligned segment'>";
echo "<a href='/users/online.php'>" . __('Онлайн') . "</a>";
echo "</div>";
echo "<div class='ui center aligned segment'>";
echo "<a href='/users/guest.php'>" . __('Гости') . "</a>";
echo "</div>";
echo "</div>";

if (!isset($_GET['go'])) {
echo "<div class='ui segments'>";
    $k_post = dbresult(dbquery("SELECT COUNT(*) FROM `user`"), 0);
    $k_page = k_page($k_post, $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];

    echo "<div class='ui segment'>";
    echo "<a class='ui $act_id label' href='?sort=id&amp;ASC&amp;page=$page'>ID</a>";
    echo "<a class='ui $act_balls label' href='?sort=balls&amp;DESC&amp;page=$page'>" . __('Баллы') . "</a>";
    echo "<a class='ui $act_rating label' href='?sort=rating&amp;DESC&amp;page=$page'>" . __('Рейтинг') . "</a>";
    echo "<a class='ui $act_pol label' href='?sort=pol&amp;DESC&amp;page=$page'>" . __('Пол') . "</a>";
    echo "<a class='ui $act_new label' href='?sort=new&amp;DESC&amp;page=$page'>" . __('Новые') . "</a>";
    echo "</div>";

    if ($k_post == 0) {
        echo '<div class="ui segment">';
        echo "<i class='mdi mdi-layers-outline'></i> " . __('Нет результатов');
        echo '</div>';
    }

    $q = dbquery("SELECT `user`.`id` FROM `user` LEFT JOIN `user_group` ON `user`.`group_access` = `user_group`.`id` ORDER BY $sql_sort $por LIMIT $start, $set[p_str]");

    echo '<div class="ui segment">';
    echo '<div class="ui large middle aligned divided list">';

    while ($ank = dbassoc($q)) {

        $ank = get_user($ank['id']);

        echo '<div class="item">';

        echo '<div class="right floated content">';
        echo "<small style='float:right'>" . (($ank['pol'] == 1) ? __('Был') : __('Была')) . " " . date::times($ank['date_last']) . "</small>\n";
        echo '</div>';

        echo user::avatar($ank['id'], 0, 'ui avatar image');

        echo '<div class="content">';

        echo group($ank['id']);
        echo " <a href='/info.php?id=$ank[id]'>$ank[nick]</a> \n";

        echo "" . medal($ank['id']) . " " . online($ank['id']) . "<br />";

        if ($sort == 'rating') {
            echo __('Рейтинг') . ": $ank[rating]<br />\n";
        }

        if ($sort == 'balls') {
            echo __('Баллы') . ": $ank[balls]<br />\n";
        }

        if ($sort == 'pol') {
            echo __('Пол') . ": " . (($ank['pol'] == 1) ? __('Мужской') : __('Женский')) . "<br />\n";
        }

        if ($sort == 'id') {
            echo __('ID') . ": " . $ank['id'] . "\n";
        }


        echo '</div>';
        echo '</div>';
    }

    echo '</div>';

    echo '</div>';
    if ($k_page > 1) {
        str("index.php?sort=$sort&amp;$por&amp;", $k_page, $page);
    } // Вывод страниц
    echo '</div>';
}

$usearch = NULL;

if (isset($_SESSION['usearch'])) {
    $usearch = $_SESSION['usearch'];
}

if (isset($_POST['usearch'])) {
    $usearch = $_POST['usearch'];
}

if ($usearch == NULL) {
    unset($_SESSION['usearch']);
} else {
    $_SESSION['usearch'] = $usearch;
}

$usearch = preg_replace("#( ){1,}#", "", $usearch);


if (isset($_GET['go']) && $usearch != NULL) {
    $k_post = dbresult(dbquery("SELECT COUNT(*) FROM `user` WHERE `nick` like '%" . mysql_real_escape_string($usearch) . "%' OR `id` = '" . intval($usearch) . "'"), 0);
    $k_page = k_page($k_post, $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];

echo "<div class='ui segments'>";
    echo "<div class='ui segment'>";
    echo "<a class='ui $act_id label' href='?sort=id&amp;ASC&amp;page=$page'>ID</a>";
    echo "<a class='ui $act_balls label' href='?sort=balls&amp;DESC&amp;page=$page'>" . __('Баллы') . "</a>";
    echo "<a class='ui $act_rating label' href='?sort=rating&amp;DESC&amp;page=$page'>" . __('Рейтинг') . "</a>";
    echo "<a class='ui $act_pol label' href='?sort=pol&amp;DESC&amp;page=$page'>" . __('Пол') . "</a>";
    echo "<a class='ui $act_new label' href='?sort=new&amp;DESC&amp;page=$page'>" . __('Новые') . "</a>";
    echo "</div>";

    if ($k_post == 0) {
        echo '<div class="ui segment">';
        echo "<i class='mdi mdi-layers-outline'></i> " . __('Нет результатов');
        echo '</div>';
    }

    $q = dbquery("SELECT `id` FROM `user` WHERE `nick` like '%" . mysql_real_escape_string($usearch) . "%' OR `id` = '" . intval($usearch) . "' ORDER BY `$sort` $por LIMIT $start, $set[p_str]");

    echo '<div class="ui segment">';
    echo '<div class="ui large middle aligned divided list">';

    while ($ank = dbassoc($q)) {
        $ank = get_user($ank['id']);

        echo '<div class="item">';

        echo '<div class="right floated content">';
        echo " <small style='float:right'>" . (($ank['pol'] == 1) ? __('Был') : __('Была')) . " " . date::times($ank['date_last']) . "</small>\n";
        echo '</div>';

        echo user::avatar($ank['id'], 0, 'ui avatar image');

        echo '<div class="content">';
        echo group($ank['id']) . "<a href='/info.php?id=$ank[id]'>$ank[nick]</a>\n";
        echo "" . medal($ank['id']) . " " . online($ank['id']) . "<br />";

        if ($sort == 'rating') {
            echo __('Рейтинг') . ": $ank[rating]<br />\n";
        }

        if ($sort == 'balls') {
            echo __('Баллы') . " $ank[balls]<br />\n";
        }

        if ($sort == 'pol') {
            echo __('Пол') . ": " . (($ank['pol'] == 1) ? __('Мужской') : __('Женский')) . "<br />\n";
        }

        if ($sort == 'id') {
            echo __('Регистрация') . ": " . vremja($ank['date_reg']) . "<br />\n";
        }

        echo '</div>';
        echo '</div>';
    }
    echo '</div>';

    echo '</div>';
    if ($k_page > 1) {
        str("index.php?go&amp;sort=$sort&amp;$por&amp;", $k_page, $page);
    } // Вывод страниц
    echo '</div>';
} else {
echo "<div class='ui segments'>";
    echo "<div class=\"ui secondary segment\">" . __('Поиск') . "</div>\n";
}

echo "<form method=\"post\" class='ui form segment' action=\"?go&amp;sort=$sort&amp;$por\">";

$usearch = stripcslashes(htmlspecialchars($usearch));
?>
<div class="ui action input">
    <input type="text" name="usearch" value="<?= $usearch ?>" required placeholder="<?= __('Введите id или логин пользователя') ?>">
    <button class="ui icon button">
        <i class="mdi mdi-magnify icon"></i>
    </button>
</div>
<?php
echo "</form>\n";

echo '<div class="ui segment">';
echo "<a href='other.php'><i class='mdi mdi-menu'></i> " . __('Дополнительно') . "</a>";
echo "</div>\n";
echo "</div>\n"; // ui segments

include_once '../sys/inc/tfoot.php';
?>