<?php
session_start();
require 'config.php';

$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    header("Location: ?view=login");
    exit;
}

// Get current user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

$tab = $_GET['tab'] ?? 'edit';
$success = false;
$error = null;

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($tab === 'edit') {
        $username = trim($_POST['username'] ?? '');
        $full_name = trim($_POST['full_name'] ?? '');
        $bio = trim($_POST['bio'] ?? '');
        
        // Validate
        if (empty($username)) {
            $error = "Ім'я користувача обов'язкове";
        } else {
            // Check if username is taken by another user
            $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? AND id != ?");
            $stmt->execute([$username, $user_id]);
            if ($stmt->fetch()) {
                $error = "Це ім'я користувача вже зайняте";
            } else {
                // Update user
                $stmt = $pdo->prepare("UPDATE users SET username = ?, full_name = ?, bio = ? WHERE id = ?");
                $stmt->execute([$username, $full_name, $bio, $user_id]);
                $success = true;
                
                // Refresh user data
                $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
                $stmt->execute([$user_id]);
                $user = $stmt->fetch();
            }
        }
    } elseif ($tab === 'password') {
        $old_pass = $_POST['old_password'] ?? '';
        $new_pass = $_POST['new_password'] ?? '';
        $confirm_pass = $_POST['confirm_password'] ?? '';
        
        if (empty($old_pass) || empty($new_pass) || empty($confirm_pass)) {
            $error = "Будь ласка, заповніть усі поля";
        } elseif (!password_verify($old_pass, $user['password'])) {
            $error = "Старий пароль невірний";
        } elseif ($new_pass !== $confirm_pass) {
            $error = "Нові паролі не співпадають";
        } elseif (strlen($new_pass) < 6) {
            $error = "Пароль повинен містити не менше 6 символів";
        } else {
            // Update password
            $hash = password_hash($new_pass, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
            $stmt->execute([$hash, $user_id]);
            $success = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="uk">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Налаштування - UAgram</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        .settings-page-container {
            width: 100%;
        }
        @media (min-width: 768px) { .settings-page-container { margin-left: 72px; } }
        @media (min-width: 1264px) { .settings-page-container { margin-left: 245px; } }
    </style>
</head>
<body style="background: var(--bg-body);">
    <!-- Navigation -->
    <?php include 'sidebar.php'; ?>

    <div class="settings-page-container">
        <div class="settings-wrapper" style="display: flex; max-width: 935px; margin: 0 auto; min-height: 100vh;">
            <!-- Sidebar -->
            <aside class="settings-sidebar" style="width: 236px; border-right: 1px solid var(--border-color); padding: 30px 0;">
            <h2 style="padding: 0 20px 20px; font-size: 24px; font-weight: 700;">Налаштування</h2>
            <nav>
                <a href="?tab=edit" class="settings-nav-item <?php echo $tab=='edit'?'active':''; ?>" style="display: flex; align-items: center; padding: 16px 20px; cursor: pointer; border-left: 2px solid <?php echo $tab=='edit'?'white':'transparent'; ?>; font-weight: 600; text-decoration: none; color: <?php echo $tab=='edit'?'white':'var(--text-secondary)'; ?>;">
                    <svg aria-label="Редагувати профіль" fill="currentColor" height="18" viewBox="0 0 24 24" width="18" style="margin-right: 12px;"><path d="M12.001.504a11.5 11.5 0 1 0 11.5 11.5 11.513 11.513 0 0 0-11.5-11.5Zm7.5 11.5a7.5 7.5 0 1 1-7.5-7.5 7.509 7.509 0 0 1 7.5 7.5Z"></path><circle cx="12.001" cy="12.004" r="3"></circle></svg>
                    Редагувати профіль
                </a>
                <a href="?tab=password" class="settings-nav-item <?php echo $tab=='password'?'active':''; ?>" style="display: flex; align-items: center; padding: 16px 20px; cursor: pointer; border-left: 2px solid <?php echo $tab=='password'?'white':'transparent'; ?>; font-weight: 600; text-decoration: none; color: <?php echo $tab=='password'?'white':'var(--text-secondary)'; ?>;">
                    <svg aria-label="Пароль" fill="currentColor" height="18" viewBox="0 0 24 24" width="18" style="margin-right: 12px;"><path d="M17 9V7a5 5 0 0 0-10 0v2H5v13h14V9h-2Zm-8-2a3 3 0 0 1 6 0v2H9V7Zm10 13H7V11h12v9Z"></path><circle cx="12" cy="15.5" r="1.5"></circle></svg>
                    Змінити пароль
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main style="flex: 1; padding: 30px 60px;">
            <?php if ($success): ?>
                <div style="background: #1db954; color: white; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px;">
                    ✓ <?php echo $tab=='password' ? 'Пароль успішно змінено!' : 'Профіль успішно оновлено!'; ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div style="background: #ed4956; color: white; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px;">
                    ✕ <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <?php if ($tab === 'edit'): ?>
                <form method="POST" style="max-width: 600px;">
                    <!-- Avatar Section -->
                    <div style="display: flex; align-items: center; margin-bottom: 30px; padding-bottom: 30px; border-bottom: 1px solid var(--border-color);">
                        <img src="<?php echo !empty($user['avatar']) ? htmlspecialchars($user['avatar']) : 'assets/default_avatar.svg'; ?>" 
                             style="width: 56px; height: 56px; border-radius: 50%; object-fit: cover; margin-right: 20px;">
                        <div>
                            <div style="font-weight: 600; margin-bottom: 4px;"><?php echo htmlspecialchars($user['username']); ?></div>
                            <button type="button" class="btn-primary" style="padding: 5px 12px; font-size: 14px;">Змінити фото</button>
                        </div>
                    </div>

                    <!-- Username -->
                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-weight: 600; margin-bottom: 8px;">Ім'я користувача</label>
                        <input type="text" name="username" value="<?php echo htmlspecialchars($user['username']); ?>" 
                               required
                               style="width: 100%; padding: 10px 12px; background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 6px; color: white; font-size: 14px;">
                    </div>

                    <!-- Full Name -->
                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-weight: 600; margin-bottom: 8px;">Повне ім'я</label>
                        <input type="text" name="full_name" value="<?php echo htmlspecialchars($user['full_name'] ?? ''); ?>" 
                               style="width: 100%; padding: 10px 12px; background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 6px; color: white; font-size: 14px;">
                    </div>

                    <!-- Bio -->
                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-weight: 600; margin-bottom: 8px;">Біографія</label>
                        <textarea name="bio" rows="3" 
                                  style="width: 100%; padding: 10px 12px; background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 6px; color: white; font-size: 14px; resize: vertical;"><?php echo htmlspecialchars($user['bio'] ?? ''); ?></textarea>
                    </div>

                    <!-- Buttons -->
                    <div style="display: flex; gap: 12px;">
                        <button type="submit" class="btn-primary" style="padding: 8px 24px;">Зберегти</button>
                        <a href="profile.php?id=<?php echo $user_id; ?>" class="btn-secondary" style="padding: 8px 24px; text-decoration: none;">Скасувати</a>
                    </div>
                </form>

            <?php elseif ($tab === 'password'): ?>
                <form method="POST" style="max-width: 600px;">
                    <div style="display: flex; align-items: center; margin-bottom: 30px; padding-bottom: 30px; border-bottom: 1px solid var(--border-color);">
                        <img src="<?php echo !empty($user['avatar']) ? htmlspecialchars($user['avatar']) : 'assets/default_avatar.svg'; ?>" 
                             style="width: 56px; height: 56px; border-radius: 50%; object-fit: cover; margin-right: 20px;">
                        <div>
                            <div style="font-size: 24px; font-weight: 400;"><?php echo htmlspecialchars($user['username']); ?></div>
                        </div>
                    </div>

                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-weight: 600; margin-bottom: 8px;">Старий пароль</label>
                        <input type="password" name="old_password" required
                               style="width: 100%; padding: 10px 12px; background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 6px; color: white; font-size: 14px;">
                    </div>

                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-weight: 600; margin-bottom: 8px;">Новий пароль</label>
                        <input type="password" name="new_password" required
                               style="width: 100%; padding: 10px 12px; background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 6px; color: white; font-size: 14px;">
                    </div>

                    <div style="margin-bottom: 30px;">
                        <label style="display: block; font-weight: 600; margin-bottom: 8px;">Підтвердьте новий пароль</label>
                        <input type="password" name="confirm_password" required
                               style="width: 100%; padding: 10px 12px; background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 6px; color: white; font-size: 14px;">
                    </div>

                    <div style="display: flex; gap: 12px;">
                        <button type="submit" class="btn-primary" style="padding: 8px 24px;">Змінити пароль</button>
                        <a href="profile.php?id=<?php echo $user_id; ?>" class="btn-secondary" style="padding: 8px 24px; text-decoration: none;">Скасувати</a>
                    </div>
                </form>
            <?php endif; ?>
        </main>
        </div>
    </div>
</body>
</html>
