<?php
// Ensure $view and $user_id are available. 
$current_view = isset($view) ? $view : ($_GET['view'] ?? '');
if (!isset($user_id)) {
    $user_id = $_SESSION['user_id'] ?? null;
}
?>
<nav class="sidebar-left <?php echo $current_view=='direct'?'sidebar-collapsed':''; ?>">
    <a href="index.php?view=home" class="logo-icon">
        <svg aria-label="UAgram" fill="currentColor" height="24" viewBox="0 0 24 24" width="24">
            <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069ZM12 0C8.741 0 8.333.014 7.053.072 2.695.272.273 2.69.073 7.052.014 8.333 0 8.741 0 12c0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98C8.333 23.986 8.741 24 12 24c3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98C15.668.014 15.259 0 12 0Zm0 5.838a6.162 6.162 0 1 0 0 12.324 6.162 6.162 0 0 0 0-12.324ZM12 16a4 4 0 1 1 0-8 4 4 0 0 1 0 8Zm6.406-11.845a1.44 1.44 0 1 0 0 2.881 1.44 1.44 0 0 0 0-2.881Z"></path>
        </svg>
    </a>
    <a href="index.php?view=home" class="brand-logo">UAgram</a>
    
    <a href="index.php?view=home" class="nav-row <?php echo $current_view=='home'?'active':''; ?>">
        <svg aria-label="Головна" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><path d="M22 23h-6.001a1 1 0 0 1-1-1v-5.455a2.997 2.997 0 1 0-5.993 0V22a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V11.543a1.002 1.002 0 0 1 .31-.724l10-9.543a1.001 1.001 0 0 1 1.38 0l10 9.543a1.002 1.002 0 0 1 .31.724V22a1 1 0 0 1-1 1Z"></path></svg>
        <span>Головна</span>
    </a>
    
    <div class="nav-row" onclick="toggleSearch()">
        <svg aria-label="Пошук" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><path d="M18.5 10.5a8 8 0 1 1-8-8 8 8 0 0 1 8 8Zm1.657 5.7L24 20.1 20.1 24l-3.9-3.9a10 10 0 1 0 3.957-3.9ZM10 16a6 6 0 1 0-6-6 6 6 0 0 0 6 6Z"></path></svg>
        <span>Пошук</span>
    </div>
    
    <a href="index.php?view=explore" class="nav-row <?php echo $current_view=='explore'?'active':''; ?>">
        <svg aria-label="Цікаве" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><polygon points="13.941 13.953 7.581 16.424 10.06 10.056 16.42 7.585 13.941 13.953"></polygon><path d="M12 2a10 10 0 1 0 10 10A10.011 10.011 0 0 0 12 2Zm0 18a8 8 0 1 1 8-8 8.009 8.009 0 0 1-8 8Z"></path></svg>
        <span>Цікаве</span>
    </a>
    
    <a href="index.php?view=reels" class="nav-row <?php echo $current_view=='reels'?'active':''; ?>">
            <svg aria-label="Reels" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><line x1="2.049" x2="21.95" y1="7.002" y2="7.002"></line><line x1="13.504" x2="16.362" y1="2.001" y2="7.002"></line><line x1="7.207" x2="10.002" y1="2.11" y2="7.002"></line><path d="M2 12.001v3.449c0 2.849.698 4.006 1.606 4.945.94.908 2.098 1.607 4.946 1.607h6.896c2.848 0 4.006-.699 4.946-1.607.908-.939 1.606-2.096 1.606-4.945V8.552c0-2.848-.698-4.006-1.606-4.945C19.454 2.699 18.296 2 15.448 2H8.552c-2.848 0-4.006.699-4.946 1.607C2.698 4.546 2 5.704 2 8.552Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path><path d="M9.763 17.664a.908.908 0 0 1-.454-.787V11.63a.909.909 0 0 1 1.364-.788l4.545 2.624a.909.909 0 0 1 0 1.575l-4.545 2.624a.91.91 0 0 1-.91 0Z" fill-rule="evenodd"></path></svg>
        <span>Reels</span>
    </a>
    
    <a href="index.php?view=direct" class="nav-row <?php echo $current_view=='direct'?'active':''; ?>">
        <svg aria-label="Повідомлення" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><path d="M12.003 2.001a9.705 9.705 0 1 1 0 19.41 10.61 10.61 0 0 1-1.479-.108l-5.698 1.626a.998.998 0 0 1-1.229-1.23l1.626-5.698a9.715 9.715 0 0 1-.108-1.479 9.771 9.771 0 0 1 2.887-7.252 9.771 9.771 0 0 1 3.996-2.269ZM6.903 14.887l-.462 1.62-.257.901.901-.257 1.62-.462.636.216a7.712 7.712 0 1 0 5.666-12.906 7.712 7.712 0 0 0-8.32 10.252l.216.636Zm8.513-4.223a.997.997 0 0 1 .485 1.838l-4.996 2.776a1.002 1.002 0 0 1-1.222-1.583l4.996-2.776a.987.987 0 0 1 .737-.255Z"></path></svg>
        <span>Повідомлення</span>
    </a>
    
    <div class="nav-row" onclick="toggleNotifications()">
        <svg aria-label="Сповіщення" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><path d="M16.792 3.904A4.989 4.989 0 0 1 21.5 9.122c0 3.072-2.652 4.959-5.197 7.222-2.512 2.243-3.865 3.469-4.303 3.752-.477-.309-2.143-1.823-4.303-3.752C5.141 14.072 2.5 12.167 2.5 9.122a4.989 4.989 0 0 1 4.708-5.218 4.21 4.21 0 0 1 3.675 1.941c.84 1.175.98 1.763 1.12 1.763s.278-.588 1.11-1.766a4.17 4.17 0 0 1 3.679-1.938m0-2a6.04 6.04 0 0 0-4.797 2.127 6.052 6.052 0 0 0-4.787-2.127A6.985 6.985 0 0 0 .5 9.122c0 3.61 2.55 5.827 5.015 7.97.283.246.569.494.853.747l1.027.918a44.998 44.998 0 0 0 3.518 3.018 2 2 0 0 0 2.174 0 45.263 45.263 0 0 0 3.626-3.115l.922-.824c.293-.26.59-.519.885-.774 2.334-2.025 4.98-4.32 4.98-7.94a6.985 6.985 0 0 0-6.708-7.218Z"></path></svg>
        <span>Сповіщення</span>
    </div>
    
    <div class="nav-row" onclick="openModal('post')">
        <svg aria-label="Створити" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><path d="M2 12v3.45c0 2.849.698 4.005 1.606 4.944.94.909 2.098 1.608 4.946 1.608h6.896c2.848 0 4.006-.7 4.946-1.608C21.302 19.455 22 18.3 22 15.45V8.552c0-2.849-.698-4.006-1.606-4.945C19.454 2.7 18.296 2 15.448 2H8.552c-2.848 0-4.006.699-4.946 1.607C2.698 4.547 2 5.703 2 8.552Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path><line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" x1="6.545" x2="17.455" y1="12.001" y2="12.001"></line><line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" x1="12.003" x2="12.003" y1="6.545" y2="17.455"></line></svg>
        <span>Створити</span>
    </div>
    
    <a href="index.php?view=profile" class="nav-row <?php echo $current_view=='profile'?'active':''; ?>">
        <?php 
            if (!isset($myAv)) {
                 $stmt = $pdo->prepare("SELECT avatar FROM users WHERE id = ?");
                 $stmt->execute([$user_id]);
                 $myAv = $stmt->fetchColumn();
            }
        ?>
        <img src="<?php echo !empty($myAv) ? htmlspecialchars($myAv) : 'assets/default_avatar.svg'; ?>" style="width:24px; height:24px; border-radius:50%; object-fit:cover; margin-right:16px;">
        <span>Профіль</span>
    </a>

    <div style="flex-grow: 1;"></div>
    
    <!-- MORE MENU POPOVER -->
    <div id="more-menu-popover" class="more-menu-popover">
        <a href="settings.php" class="more-menu-item">
            <svg aria-label="Налаштування" fill="currentColor" height="18" viewBox="0 0 24 24" width="18"><path d="M12.001.504a11.5 11.5 0 1 0 11.5 11.5 11.513 11.513 0 0 0-11.5-11.5Zm7.5 11.5a7.5 7.5 0 1 1-7.5-7.5 7.509 7.509 0 0 1 7.5 7.5Z"></path><circle cx="12.001" cy="12.004" r="3"></circle></svg>
            <span>Налаштування</span>
        </a>
        <a href="index.php?view=activity" class="more-menu-item">
            <svg aria-label="Ваша активність" fill="currentColor" height="18" viewBox="0 0 24 24" width="18"><path d="M12 1.505a10.5 10.5 0 1 1-7.424 17.924L12 11.005V1.505Z"></path><path d="M13.5 2.505v10l7.424 7.424A10.5 10.5 0 0 0 13.5 2.505Z" opacity=".4"></path></svg>
            <span>Ваша активність</span>
        </a>
        <a href="index.php?view=saved" class="more-menu-item">
            <svg aria-label="Збережено" fill="currentColor" height="18" viewBox="0 0 24 24" width="18"><polygon fill="none" points="20 21 12 13.44 4 21 4 3 20 3 20 21" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></polygon></svg>
            <span>Збережено</span>
        </a>
        <div class="more-menu-item" onclick="toggleTheme()">
             <svg aria-label="Змінити зовнішній вигляд" fill="currentColor" height="18" viewBox="0 0 24 24" width="18"><path d="M12.00018,4.5a1,1,0,0,0,1-1V2a1,1,0,0,0-2,0V3.5A1.00005,1.00005,0,0,0,12.00018,4.5ZM5.28241,6.69678A.99989.99989,0,1,0,6.69647,5.28271l-1.06054-1.061A.99989.99989,0,0,0,4.22186,5.63574ZM4.50018,12a1,1,0,0,0-1-1h-1.5a1,1,0,0,0,0,2h1.5A1,1,0,0,0,4.50018,12Zm.78223,5.30322-1.06055,1.061a.99989.99989,0,1,0,1.41407,1.41406l1.06054-1.061a.99989.99989,0,0,0-1.41406-1.41407ZM12.00018,19.5a1,1,0,0,0-1,1V22a1,1,0,0,0,2,0V20.5A1.00005,1.00005,0,0,0,12.00018,19.5Zm6.71729-2.19678a.99989.99989,0,0,0-1.41406,1.41407l1.06054,1.061A.99989.99989,0,0,0,19.778,18.36426ZM22.00018,11h-1.5a1,1,0,0,0,0,2h1.5a1,1,0,0,0,0-2ZM18.01044,6.98975a.996.996,0,0,0,.707-.293l1.06055-1.061A.99989.99989,0,0,0,18.364,4.22168l-1.06054,1.061a1,1,0,0,0,.707,1.707ZM12.00018,6a6,6,0,1,0,6,6A6.00657,6.00657,0,0,0,12.00018,6Zm0,10a4,4,0,1,1,4-4A4.00458,4.00458,0,0,1,12.00018,16Z"></path></svg>
            <span>Змінити зовнішній вигляд</span>
        </div>
        <div class="more-menu-item" onclick="reportProblem()">
            <svg aria-label="Повідомлення про проблему" fill="currentColor" height="18" viewBox="0 0 24 24" width="18"><path d="M12 1.505a10.5 10.5 0 1 1 0 21 10.5 10.5 0 0 1 0-21Zm0 2a8.5 8.5 0 1 0 0 17 8.5 8.5 0 0 0 0-17Zm0 10.5a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm0-7a1 1 0 0 1 1 1v5a1 1 0 1 1-2 0v-5a1 1 0 0 1 1-1Z"></path></svg>
            <span>Повідомлення про проблему...</span>
        </div>
        
        <div class="more-menu-separator"></div>
        
        <div class="more-menu-item" onclick="switchAccount()">
             <svg aria-label="Змінити обліковий запис" fill="currentColor" height="18" viewBox="0 0 24 24" width="18"><path d="M8 8.5a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm5 0a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm-10-7v15a2.5 2.5 0 0 0 2.5 2.5h13a2.5 2.5 0 0 0 2.5-2.5v-15a2.5 2.5 0 0 0-2.5-2.5h-13A2.5 2.5 0 0 0 3 1.5Zm2.5-.5h13a.5.5 0 0 1 .5.5v15a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 .5-.5Zm6.5 12a5.51 5.51 0 0 0-4.5 2.5h9a5.51 5.51 0 0 0-4.5-2.5Z"></path></svg>
            <span>Переключити акаунт</span>
        </div>
        <a href="?view=logout" class="more-menu-item">
            <svg aria-label="Вийти" fill="currentColor" height="18" viewBox="0 0 24 24" width="18"><path d="M21.001 2.5v19a2.5 2.5 0 0 1-2.5 2.5h-10a2.5 2.5 0 0 1-2.5-2.5v-5a1 1 0 1 1 2 0v5a.5.5 0 0 0 .5.5h10a.5.5 0 0 0 .5-.5v-19a.5.5 0 0 0-.5-.5h-10a.5.5 0 0 0-.5.5v5a1 1 0 1 1-2 0v-5a2.5 2.5 0 0 1 2.5-2.5h10a2.5 2.5 0 0 1 2.5 2.5ZM10.001 11.5H1a1 1 0 1 0 0 2h9.001l-2.293 2.293a1 1 0 1 0 1.414 1.414l4-4a1 1 0 0 0 0-1.414l-4-4a1 1 0 0 0-1.414 1.414l2.293 2.293Z"></path></svg>
            <span>Вийти</span>
        </a>
    </div>

    <div class="nav-row" onclick="toggleMoreMenu(event)">
        <svg aria-label="Більше" fill="currentColor" height="24" viewBox="0 0 24 24" width="24"><line x1="3" x2="21" y1="4" y2="4" stroke="currentColor" stroke-width="2"></line><line x1="3" x2="21" y1="12" y2="12" stroke="currentColor" stroke-width="2"></line><line x1="3" x2="21" y1="20" y2="20" stroke="currentColor" stroke-width="2"></line></svg>
        <span>Більше</span>
    </div>
</nav>
