<?php

namespace XF\Data;

class Emoji
{
	public function getEmojiListForDisplay($lazyLoad = false)
	{
		if (!\XF::config('fullUnicode'))
		{
			return [];
		}


		$list = $this->getDetailedEmojiList();
		$formatter = \XF::app()->stringFormatter()->getEmojiFormatter();

		$output = [];

		foreach ($list AS $key => $emoji)
		{
			if (in_array($emoji['shortname'], [':tm:', ':copyright:', ':registered:']))
			{
				// TODO: Known issue in EmojiOne library see: https://github.com/emojione/emojione/issues/617
				continue;
			}

			if ($emoji['diversity'])
			{
				// TODO: Support skin-tone modifiers
				unset($list[$key]);
				continue;
			}

			if (!$emoji['gender'] && $emoji['genders'])
			{
				// this removes items that are essentially duplicates
				// e.g. person_raising_hand is the same as woman_raising_hand
				unset($list[$key]);
				continue;
			}

			$emoji['html'] = $formatter->getImageFromShortname($emoji['shortname'], $lazyLoad);

			$output[$emoji['shortname']] = $emoji;
		}

		return $output;
	}

	//###### GENERATED CODE START ######
	public function getDetailedEmojiList()
	{
		return [
			'1f600' => [
				'name' => \XF::phrase('emoji.grinning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grinning:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'grin'],
			],
			'1f603' => [
				'name' => \XF::phrase('emoji.smiley'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiley:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'mouth', 'open', 'smile'],
			],
			'1f604' => [
				'name' => \XF::phrase('emoji.smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smile:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'face', 'mouth', 'open', 'smile'],
			],
			'1f601' => [
				'name' => \XF::phrase('emoji.grin'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'face', 'grin', 'smile'],
			],
			'1f606' => [
				'name' => \XF::phrase('emoji.laughing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':laughing:',
				'shortname_alternates' => [':satisfied:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'laugh', 'mouth', 'open', 'satisfied', 'smile'],
			],
			'1f605' => [
				'name' => \XF::phrase('emoji.sweat_smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sweat_smile:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'face', 'open', 'smile', 'sweat'],
			],
			'1f602' => [
				'name' => \XF::phrase('emoji.joy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':joy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'joy', 'laugh', 'tear'],
			],
			'1f923' => [
				'name' => \XF::phrase('emoji.rofl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rofl:',
				'shortname_alternates' => [':rolling_on_the_floor_laughing:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'floor', 'laugh', 'rolling'],
			],
			'263a' => [
				'name' => \XF::phrase('emoji.relaxed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':relaxed:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'outlined', 'relaxed', 'smile'],
			],
			'1f60a' => [
				'name' => \XF::phrase('emoji.blush'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blush:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blush', 'eye', 'face', 'smile'],
			],
			'1f607' => [
				'name' => \XF::phrase('emoji.innocent'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':innocent:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angel', 'face', 'fairy tale', 'fantasy', 'halo', 'innocent', 'smile'],
			],
			'1f642' => [
				'name' => \XF::phrase('emoji.slight_smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':slight_smile:',
				'shortname_alternates' => [':slightly_smiling_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'smile'],
			],
			'1f643' => [
				'name' => \XF::phrase('emoji.upside_down'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':upside_down:',
				'shortname_alternates' => [':upside_down_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'upside-down'],
			],
			'1f609' => [
				'name' => \XF::phrase('emoji.wink'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wink:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'wink'],
			],
			'1f60c' => [
				'name' => \XF::phrase('emoji.relieved'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':relieved:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'relieved'],
			],
			'1f60d' => [
				'name' => \XF::phrase('emoji.heart_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_eyes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'face', 'love', 'smile'],
			],
			'1f618' => [
				'name' => \XF::phrase('emoji.kissing_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'kiss'],
			],
			'1f970' => [
				'name' => \XF::phrase('emoji.smiling_face_with_3_hearts'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_face_with_3_hearts:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f617' => [
				'name' => \XF::phrase('emoji.kissing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'kiss'],
			],
			'1f619' => [
				'name' => \XF::phrase('emoji.kissing_smiling_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_smiling_eyes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'face', 'kiss', 'smile'],
			],
			'1f61a' => [
				'name' => \XF::phrase('emoji.kissing_closed_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_closed_eyes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['closed', 'eye', 'face', 'kiss'],
			],
			'1f60b' => [
				'name' => \XF::phrase('emoji.yum'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':yum:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['delicious', 'face', 'savouring', 'smile', 'um', 'yum'],
			],
			'1f61b' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'tongue'],
			],
			'1f61d' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue_closed_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue_closed_eyes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'face', 'horrible', 'taste', 'tongue'],
			],
			'1f61c' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue_winking_eye'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue_winking_eye:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'face', 'joke', 'tongue', 'wink'],
			],
			'1f92a' => [
				'name' => \XF::phrase('emoji.zany_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zany_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'large', 'small'],
			],
			'1f928' => [
				'name' => \XF::phrase('emoji.face_with_raised_eyebrow'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_raised_eyebrow:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9d0' => [
				'name' => \XF::phrase('emoji.face_with_monocle'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_monocle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f913' => [
				'name' => \XF::phrase('emoji.nerd'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nerd:',
				'shortname_alternates' => [':nerd_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'geek', 'nerd'],
			],
			'1f60e' => [
				'name' => \XF::phrase('emoji.sunglasses'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sunglasses:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bright', 'cool', 'eye', 'eyewear', 'face', 'glasses', 'smile', 'sun', 'sunglasses'],
			],
			'1f929' => [
				'name' => \XF::phrase('emoji.star_struck'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':star_struck:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f973' => [
				'name' => \XF::phrase('emoji.partying_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':partying_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f60f' => [
				'name' => \XF::phrase('emoji.smirk'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smirk:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'smirk'],
			],
			'1f612' => [
				'name' => \XF::phrase('emoji.unamused'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':unamused:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'unamused', 'unhappy'],
			],
			'1f61e' => [
				'name' => \XF::phrase('emoji.disappointed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disappointed:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['disappointed', 'face'],
			],
			'1f614' => [
				'name' => \XF::phrase('emoji.pensive'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pensive:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dejected', 'face', 'pensive'],
			],
			'1f61f' => [
				'name' => \XF::phrase('emoji.worried'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':worried:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'worried'],
			],
			'1f615' => [
				'name' => \XF::phrase('emoji.confused'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':confused:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['confused', 'face'],
			],
			'1f641' => [
				'name' => \XF::phrase('emoji.slight_frown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':slight_frown:',
				'shortname_alternates' => [':slightly_frowning_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'frown'],
			],
			'2639' => [
				'name' => \XF::phrase('emoji.frowning2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':frowning2:',
				'shortname_alternates' => [':white_frowning_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'frown'],
			],
			'1f623' => [
				'name' => \XF::phrase('emoji.persevere'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':persevere:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'persevere'],
			],
			'1f616' => [
				'name' => \XF::phrase('emoji.confounded'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':confounded:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['confounded', 'face'],
			],
			'1f62b' => [
				'name' => \XF::phrase('emoji.tired_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tired_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'tired'],
			],
			'1f629' => [
				'name' => \XF::phrase('emoji.weary'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':weary:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'tired', 'weary'],
			],
			'1f622' => [
				'name' => \XF::phrase('emoji.cry'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cry:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cry', 'face', 'sad', 'tear'],
			],
			'1f62d' => [
				'name' => \XF::phrase('emoji.sob'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sob:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cry', 'face', 'sad', 'sob', 'tear'],
			],
			'1f624' => [
				'name' => \XF::phrase('emoji.triumph'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':triumph:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'triumph', 'won'],
			],
			'1f620' => [
				'name' => \XF::phrase('emoji.angry'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angry:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angry', 'face', 'mad'],
			],
			'1f621' => [
				'name' => \XF::phrase('emoji.rage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angry', 'face', 'mad', 'pouting', 'rage', 'red'],
			],
			'1f92c' => [
				'name' => \XF::phrase('emoji.face_with_symbols_over_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_symbols_over_mouth:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f92f' => [
				'name' => \XF::phrase('emoji.exploding_head'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':exploding_head:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['shocked'],
			],
			'1f633' => [
				'name' => \XF::phrase('emoji.flushed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':flushed:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dazed', 'face', 'flushed'],
			],
			'1f631' => [
				'name' => \XF::phrase('emoji.scream'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scream:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'fear', 'fearful', 'munch', 'scared', 'scream'],
			],
			'1f628' => [
				'name' => \XF::phrase('emoji.fearful'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fearful:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'fear', 'fearful', 'scared'],
			],
			'1f630' => [
				'name' => \XF::phrase('emoji.cold_sweat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cold_sweat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blue', 'cold', 'face', 'mouth', 'open', 'rushed', 'sweat'],
			],
			'1f975' => [
				'name' => \XF::phrase('emoji.hot_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hot_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f976' => [
				'name' => \XF::phrase('emoji.cold_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cold_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f97a' => [
				'name' => \XF::phrase('emoji.pleading_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pleading_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f625' => [
				'name' => \XF::phrase('emoji.disappointed_relieved'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disappointed_relieved:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['disappointed', 'face', 'relieved', 'whew'],
			],
			'1f613' => [
				'name' => \XF::phrase('emoji.sweat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sweat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'face', 'sweat'],
			],
			'1f917' => [
				'name' => \XF::phrase('emoji.hugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hugging:',
				'shortname_alternates' => [':hugging_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'hug', 'hugging'],
			],
			'1f914' => [
				'name' => \XF::phrase('emoji.thinking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thinking:',
				'shortname_alternates' => [':thinking_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'thinking'],
			],
			'1f92d' => [
				'name' => \XF::phrase('emoji.face_with_hand_over_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_hand_over_mouth:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f92b' => [
				'name' => \XF::phrase('emoji.shushing_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':shushing_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['quiet', 'shush'],
			],
			'1f925' => [
				'name' => \XF::phrase('emoji.lying_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lying_face:',
				'shortname_alternates' => [':liar:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'lie', 'pinocchio'],
			],
			'1f636' => [
				'name' => \XF::phrase('emoji.no_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':no_mouth:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'mouth', 'quiet', 'silent'],
			],
			'1f610' => [
				'name' => \XF::phrase('emoji.neutral_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':neutral_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['deadpan', 'face', 'neutral'],
			],
			'1f611' => [
				'name' => \XF::phrase('emoji.expressionless'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':expressionless:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['expressionless', 'face', 'inexpressive', 'unexpressive'],
			],
			'1f62c' => [
				'name' => \XF::phrase('emoji.grimacing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grimacing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'grimace'],
			],
			'1f644' => [
				'name' => \XF::phrase('emoji.rolling_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rolling_eyes:',
				'shortname_alternates' => [':face_with_rolling_eyes:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eyes', 'face', 'rolling'],
			],
			'1f62f' => [
				'name' => \XF::phrase('emoji.hushed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hushed:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'hushed', 'stunned', 'surprised'],
			],
			'1f626' => [
				'name' => \XF::phrase('emoji.frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':frowning:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'frown', 'mouth', 'open'],
			],
			'1f627' => [
				'name' => \XF::phrase('emoji.anguished'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':anguished:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['anguished', 'face'],
			],
			'1f62e' => [
				'name' => \XF::phrase('emoji.open_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_mouth:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'mouth', 'open', 'sympathy'],
			],
			'1f632' => [
				'name' => \XF::phrase('emoji.astonished'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astonished:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astonished', 'face', 'shocked', 'totally'],
			],
			'1f634' => [
				'name' => \XF::phrase('emoji.sleeping'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sleeping:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'sleep', 'zzz'],
			],
			'1f924' => [
				'name' => \XF::phrase('emoji.drooling_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':drooling_face:',
				'shortname_alternates' => [':drool:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['drooling', 'face'],
			],
			'1f62a' => [
				'name' => \XF::phrase('emoji.sleepy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sleepy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'sleep'],
			],
			'1f635' => [
				'name' => \XF::phrase('emoji.dizzy_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dizzy_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dizzy', 'face'],
			],
			'1f910' => [
				'name' => \XF::phrase('emoji.zipper_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zipper_mouth:',
				'shortname_alternates' => [':zipper_mouth_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'mouth', 'zipper'],
			],
			'1f974' => [
				'name' => \XF::phrase('emoji.woozy_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woozy_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f922' => [
				'name' => \XF::phrase('emoji.nauseated_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nauseated_face:',
				'shortname_alternates' => [':sick:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'nauseated', 'vomit'],
			],
			'1f92e' => [
				'name' => \XF::phrase('emoji.face_vomiting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_vomiting:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['sick', 'vomit'],
			],
			'1f927' => [
				'name' => \XF::phrase('emoji.sneezing_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sneezing_face:',
				'shortname_alternates' => [':sneeze:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'gesundheit', 'sneeze'],
			],
			'1f637' => [
				'name' => \XF::phrase('emoji.mask'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mask:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'doctor', 'face', 'mask', 'medicine', 'sick'],
			],
			'1f912' => [
				'name' => \XF::phrase('emoji.thermometer_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thermometer_face:',
				'shortname_alternates' => [':face_with_thermometer:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'ill', 'sick', 'thermometer'],
			],
			'1f915' => [
				'name' => \XF::phrase('emoji.head_bandage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':head_bandage:',
				'shortname_alternates' => [':face_with_head_bandage:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bandage', 'face', 'hurt', 'injury'],
			],
			'1f911' => [
				'name' => \XF::phrase('emoji.money_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':money_mouth:',
				'shortname_alternates' => [':money_mouth_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'money', 'mouth'],
			],
			'1f920' => [
				'name' => \XF::phrase('emoji.cowboy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cowboy:',
				'shortname_alternates' => [':face_with_cowboy_hat:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cowboy', 'cowgirl', 'face', 'hat'],
			],
			'1f608' => [
				'name' => \XF::phrase('emoji.smiling_imp'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_imp:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'fairy tale', 'fantasy', 'horns', 'smile'],
			],
			'1f47f' => [
				'name' => \XF::phrase('emoji.imp'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':imp:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['demon', 'devil', 'face', 'fairy tale', 'fantasy', 'imp'],
			],
			'1f479' => [
				'name' => \XF::phrase('emoji.japanese_ogre'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':japanese_ogre:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f47a' => [
				'name' => \XF::phrase('emoji.japanese_goblin'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':japanese_goblin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['creature', 'face', 'fairy tale', 'fantasy', 'monster'],
			],
			'1f921' => [
				'name' => \XF::phrase('emoji.clown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clown:',
				'shortname_alternates' => [':clown_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clown', 'face'],
			],
			'1f4a9' => [
				'name' => \XF::phrase('emoji.poop'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':poop:',
				'shortname_alternates' => [':shit:', ':hankey:', ':poo:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['comic', 'dung', 'face', 'monster', 'poo', 'poop'],
			],
			'1f47b' => [
				'name' => \XF::phrase('emoji.ghost'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ghost:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['creature', 'face', 'fairy tale', 'fantasy', 'monster'],
			],
			'1f480' => [
				'name' => \XF::phrase('emoji.skull'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':skull:',
				'shortname_alternates' => [':skeleton:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['death', 'face', 'fairy tale', 'monster'],
			],
			'2620' => [
				'name' => \XF::phrase('emoji.skull_crossbones'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':skull_crossbones:',
				'shortname_alternates' => [':skull_and_crossbones:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crossbones', 'death', 'face', 'monster', 'skull'],
			],
			'1f47d' => [
				'name' => \XF::phrase('emoji.alien'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':alien:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo'],
			],
			'1f47e' => [
				'name' => \XF::phrase('emoji.space_invader'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':space_invader:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['alien', 'creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo'],
			],
			'1f916' => [
				'name' => \XF::phrase('emoji.robot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':robot:',
				'shortname_alternates' => [':robot_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'monster', 'robot'],
			],
			'1f383' => [
				'name' => \XF::phrase('emoji.jack_o_lantern'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':jack_o_lantern:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'halloween', 'jack', 'lantern'],
			],
			'1f63a' => [
				'name' => \XF::phrase('emoji.smiley_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiley_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'face', 'mouth', 'open', 'smile'],
			],
			'1f638' => [
				'name' => \XF::phrase('emoji.smile_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smile_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'eye', 'face', 'grin', 'smile'],
			],
			'1f639' => [
				'name' => \XF::phrase('emoji.joy_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':joy_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'face', 'joy', 'tear'],
			],
			'1f63b' => [
				'name' => \XF::phrase('emoji.heart_eyes_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_eyes_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'eye', 'face', 'love', 'smile'],
			],
			'1f63c' => [
				'name' => \XF::phrase('emoji.smirk_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smirk_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'face', 'ironic', 'smile', 'wry'],
			],
			'1f63d' => [
				'name' => \XF::phrase('emoji.kissing_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'eye', 'face', 'kiss'],
			],
			'1f640' => [
				'name' => \XF::phrase('emoji.scream_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scream_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'face', 'oh', 'surprised', 'weary'],
			],
			'1f63f' => [
				'name' => \XF::phrase('emoji.crying_cat_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':crying_cat_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'cry', 'face', 'sad', 'tear'],
			],
			'1f63e' => [
				'name' => \XF::phrase('emoji.pouting_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pouting_cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'face', 'pouting'],
			],
			'1f932' => [
				'name' => \XF::phrase('emoji.palms_up_together'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f932-1f3fb', '1f932-1f3fc', '1f932-1f3fd', '1f932-1f3fe', '1f932-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f932-1f3fb' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone1:',
				'shortname_alternates' => [':palms_up_together_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'prayer'],
			],
			'1f932-1f3fc' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone2:',
				'shortname_alternates' => [':palms_up_together_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'prayer'],
			],
			'1f932-1f3fd' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone3:',
				'shortname_alternates' => [':palms_up_together_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium skin tone', 'prayer'],
			],
			'1f932-1f3fe' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone4:',
				'shortname_alternates' => [':palms_up_together_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'prayer'],
			],
			'1f932-1f3ff' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone5:',
				'shortname_alternates' => [':palms_up_together_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'prayer'],
			],
			'1f450' => [
				'name' => \XF::phrase('emoji.open_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f450-1f3fb', '1f450-1f3fc', '1f450-1f3fd', '1f450-1f3fe', '1f450-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'open'],
			],
			'1f450-1f3fb' => [
				'name' => \XF::phrase('emoji.open_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'light skin tone', 'open'],
			],
			'1f450-1f3fc' => [
				'name' => \XF::phrase('emoji.open_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'open'],
			],
			'1f450-1f3fd' => [
				'name' => \XF::phrase('emoji.open_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium skin tone', 'open'],
			],
			'1f450-1f3fe' => [
				'name' => \XF::phrase('emoji.open_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'open'],
			],
			'1f450-1f3ff' => [
				'name' => \XF::phrase('emoji.open_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hand', 'open'],
			],
			'1f64c' => [
				'name' => \XF::phrase('emoji.raised_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64c-1f3fb', '1f64c-1f3fc', '1f64c-1f3fd', '1f64c-1f3fe', '1f64c-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'raised'],
			],
			'1f64c-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'light skin tone', 'raised'],
			],
			'1f64c-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium-light skin tone', 'raised'],
			],
			'1f64c-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium skin tone', 'raised'],
			],
			'1f64c-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium-dark skin tone', 'raised'],
			],
			'1f64c-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'dark skin tone', 'gesture', 'hand', 'hooray', 'raised'],
			],
			'1f44f' => [
				'name' => \XF::phrase('emoji.clap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f44f-1f3fb', '1f44f-1f3fc', '1f44f-1f3fd', '1f44f-1f3fe', '1f44f-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clap', 'hand'],
			],
			'1f44f-1f3fb' => [
				'name' => \XF::phrase('emoji.clap_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clap', 'hand', 'light skin tone'],
			],
			'1f44f-1f3fc' => [
				'name' => \XF::phrase('emoji.clap_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clap', 'hand', 'medium-light skin tone'],
			],
			'1f44f-1f3fd' => [
				'name' => \XF::phrase('emoji.clap_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clap', 'hand', 'medium skin tone'],
			],
			'1f44f-1f3fe' => [
				'name' => \XF::phrase('emoji.clap_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clap', 'hand', 'medium-dark skin tone'],
			],
			'1f44f-1f3ff' => [
				'name' => \XF::phrase('emoji.clap_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clap', 'dark skin tone', 'hand'],
			],
			'1f91d' => [
				'name' => \XF::phrase('emoji.handshake'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake:',
				'shortname_alternates' => [':shaking_hands:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['agreement', 'hand', 'handshake', 'meeting', 'shake'],
			],
			'1f44d' => [
				'name' => \XF::phrase('emoji.thumbsup'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup:',
				'shortname_alternates' => [':+1:', ':thumbup:'],
				'diversity' => '',
				'diversities' => ['1f44d-1f3fb', '1f44d-1f3fc', '1f44d-1f3fd', '1f44d-1f3fe', '1f44d-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['+1', 'hand', 'thumb', 'up'],
			],
			'1f44d-1f3fb' => [
				'name' => \XF::phrase('emoji.thumbsup_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone1:',
				'shortname_alternates' => [':+1_tone1:', ':thumbup_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['+1', 'hand', 'light skin tone', 'thumb', 'up'],
			],
			'1f44d-1f3fc' => [
				'name' => \XF::phrase('emoji.thumbsup_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone2:',
				'shortname_alternates' => [':+1_tone2:', ':thumbup_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['+1', 'hand', 'medium-light skin tone', 'thumb', 'up'],
			],
			'1f44d-1f3fd' => [
				'name' => \XF::phrase('emoji.thumbsup_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone3:',
				'shortname_alternates' => [':+1_tone3:', ':thumbup_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['+1', 'hand', 'medium skin tone', 'thumb', 'up'],
			],
			'1f44d-1f3fe' => [
				'name' => \XF::phrase('emoji.thumbsup_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone4:',
				'shortname_alternates' => [':+1_tone4:', ':thumbup_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['+1', 'hand', 'medium-dark skin tone', 'thumb', 'up'],
			],
			'1f44d-1f3ff' => [
				'name' => \XF::phrase('emoji.thumbsup_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone5:',
				'shortname_alternates' => [':+1_tone5:', ':thumbup_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['+1', 'dark skin tone', 'hand', 'thumb', 'up'],
			],
			'1f44e' => [
				'name' => \XF::phrase('emoji.thumbsdown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown:',
				'shortname_alternates' => [':-1:', ':thumbdown:'],
				'diversity' => '',
				'diversities' => ['1f44e-1f3fb', '1f44e-1f3fc', '1f44e-1f3fd', '1f44e-1f3fe', '1f44e-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['-1', 'down', 'hand', 'thumb'],
			],
			'1f44e-1f3fb' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone1:',
				'shortname_alternates' => [':-1_tone1:', ':thumbdown_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['-1', 'down', 'hand', 'light skin tone', 'thumb'],
			],
			'1f44e-1f3fc' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone2:',
				'shortname_alternates' => [':-1_tone2:', ':thumbdown_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['-1', 'down', 'hand', 'medium-light skin tone', 'thumb'],
			],
			'1f44e-1f3fd' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone3:',
				'shortname_alternates' => [':-1_tone3:', ':thumbdown_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['-1', 'down', 'hand', 'medium skin tone', 'thumb'],
			],
			'1f44e-1f3fe' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone4:',
				'shortname_alternates' => [':-1_tone4:', ':thumbdown_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['-1', 'down', 'hand', 'medium-dark skin tone', 'thumb'],
			],
			'1f44e-1f3ff' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone5:',
				'shortname_alternates' => [':-1_tone5:', ':thumbdown_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['-1', 'dark skin tone', 'down', 'hand', 'thumb'],
			],
			'1f44a' => [
				'name' => \XF::phrase('emoji.punch'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f44a-1f3fb', '1f44a-1f3fc', '1f44a-1f3fd', '1f44a-1f3fe', '1f44a-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'punch'],
			],
			'1f44a-1f3fb' => [
				'name' => \XF::phrase('emoji.punch_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'light skin tone', 'punch'],
			],
			'1f44a-1f3fc' => [
				'name' => \XF::phrase('emoji.punch_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch'],
			],
			'1f44a-1f3fd' => [
				'name' => \XF::phrase('emoji.punch_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium skin tone', 'punch'],
			],
			'1f44a-1f3fe' => [
				'name' => \XF::phrase('emoji.punch_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch'],
			],
			'1f44a-1f3ff' => [
				'name' => \XF::phrase('emoji.punch_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'dark skin tone', 'fist', 'hand', 'punch'],
			],
			'270a' => [
				'name' => \XF::phrase('emoji.fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['270a-1f3fb', '270a-1f3fc', '270a-1f3fd', '270a-1f3fe', '270a-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'punch'],
			],
			'270a-1f3fb' => [
				'name' => \XF::phrase('emoji.fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'light skin tone', 'punch'],
			],
			'270a-1f3fc' => [
				'name' => \XF::phrase('emoji.fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch'],
			],
			'270a-1f3fd' => [
				'name' => \XF::phrase('emoji.fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium skin tone', 'punch'],
			],
			'270a-1f3fe' => [
				'name' => \XF::phrase('emoji.fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch'],
			],
			'270a-1f3ff' => [
				'name' => \XF::phrase('emoji.fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clenched', 'dark skin tone', 'fist', 'hand', 'punch'],
			],
			'1f91b' => [
				'name' => \XF::phrase('emoji.left_facing_fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist:',
				'shortname_alternates' => [':left_fist:'],
				'diversity' => '',
				'diversities' => ['1f91b-1f3fb', '1f91b-1f3fc', '1f91b-1f3fd', '1f91b-1f3fe', '1f91b-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'leftwards'],
			],
			'1f91b-1f3fb' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone1:',
				'shortname_alternates' => [':left_fist_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'leftwards', 'light skin tone'],
			],
			'1f91b-1f3fc' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone2:',
				'shortname_alternates' => [':left_fist_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'leftwards', 'medium-light skin tone'],
			],
			'1f91b-1f3fd' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone3:',
				'shortname_alternates' => [':left_fist_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'leftwards', 'medium skin tone'],
			],
			'1f91b-1f3fe' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone4:',
				'shortname_alternates' => [':left_fist_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'leftwards', 'medium-dark skin tone'],
			],
			'1f91b-1f3ff' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone5:',
				'shortname_alternates' => [':left_fist_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'fist', 'leftwards'],
			],
			'1f91c' => [
				'name' => \XF::phrase('emoji.right_facing_fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist:',
				'shortname_alternates' => [':right_fist:'],
				'diversity' => '',
				'diversities' => ['1f91c-1f3fb', '1f91c-1f3fc', '1f91c-1f3fd', '1f91c-1f3fe', '1f91c-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'rightwards'],
			],
			'1f91c-1f3fb' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone1:',
				'shortname_alternates' => [':right_fist_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'light skin tone', 'rightwards'],
			],
			'1f91c-1f3fc' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone2:',
				'shortname_alternates' => [':right_fist_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'medium-light skin tone', 'rightwards'],
			],
			'1f91c-1f3fd' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone3:',
				'shortname_alternates' => [':right_fist_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'medium skin tone', 'rightwards'],
			],
			'1f91c-1f3fe' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone4:',
				'shortname_alternates' => [':right_fist_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fist', 'medium-dark skin tone', 'rightwards'],
			],
			'1f91c-1f3ff' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone5:',
				'shortname_alternates' => [':right_fist_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'fist', 'rightwards'],
			],
			'1f91e' => [
				'name' => \XF::phrase('emoji.fingers_crossed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed:',
				'shortname_alternates' => [':hand_with_index_and_middle_finger_crossed:'],
				'diversity' => '',
				'diversities' => ['1f91e-1f3fb', '1f91e-1f3fc', '1f91e-1f3fd', '1f91e-1f3fe', '1f91e-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck'],
			],
			'1f91e-1f3fb' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone1:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cross', 'finger', 'hand', 'light skin tone', 'luck'],
			],
			'1f91e-1f3fc' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone2:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium-light skin tone'],
			],
			'1f91e-1f3fd' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone3:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium skin tone'],
			],
			'1f91e-1f3fe' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone4:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium-dark skin tone'],
			],
			'1f91e-1f3ff' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone5:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cross', 'dark skin tone', 'finger', 'hand', 'luck'],
			],
			'270c' => [
				'name' => \XF::phrase('emoji.v'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['270c-1f3fb', '270c-1f3fc', '270c-1f3fd', '270c-1f3fe', '270c-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'v', 'victory'],
			],
			'270c-1f3fb' => [
				'name' => \XF::phrase('emoji.v_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'light skin tone', 'v', 'victory'],
			],
			'270c-1f3fc' => [
				'name' => \XF::phrase('emoji.v_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'v', 'victory'],
			],
			'270c-1f3fd' => [
				'name' => \XF::phrase('emoji.v_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium skin tone', 'v', 'victory'],
			],
			'270c-1f3fe' => [
				'name' => \XF::phrase('emoji.v_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'v', 'victory'],
			],
			'270c-1f3ff' => [
				'name' => \XF::phrase('emoji.v_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hand', 'v', 'victory'],
			],
			'1f91f' => [
				'name' => \XF::phrase('emoji.love_you_gesture'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f91f-1f3fb', '1f91f-1f3fc', '1f91f-1f3fd', '1f91f-1f3fe', '1f91f-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ILY', 'hand'],
			],
			'1f91f-1f3fb' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone1:',
				'shortname_alternates' => [':love_you_gesture_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ILY', 'hand', 'light skin tone'],
			],
			'1f91f-1f3fc' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone2:',
				'shortname_alternates' => [':love_you_gesture_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ILY', 'hand', 'medium-light skin tone'],
			],
			'1f91f-1f3fd' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone3:',
				'shortname_alternates' => [':love_you_gesture_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ILY', 'hand', 'medium skin tone'],
			],
			'1f91f-1f3fe' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone4:',
				'shortname_alternates' => [':love_you_gesture_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ILY', 'hand', 'medium-dark skin tone'],
			],
			'1f91f-1f3ff' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone5:',
				'shortname_alternates' => [':love_you_gesture_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ILY', 'dark skin tone', 'hand'],
			],
			'1f918' => [
				'name' => \XF::phrase('emoji.metal'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal:',
				'shortname_alternates' => [':sign_of_the_horns:'],
				'diversity' => '',
				'diversities' => ['1f918-1f3fb', '1f918-1f3fc', '1f918-1f3fd', '1f918-1f3fe', '1f918-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'horns', 'rock-on'],
			],
			'1f918-1f3fb' => [
				'name' => \XF::phrase('emoji.metal_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone1:',
				'shortname_alternates' => [':sign_of_the_horns_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'horns', 'light skin tone', 'rock-on'],
			],
			'1f918-1f3fc' => [
				'name' => \XF::phrase('emoji.metal_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone2:',
				'shortname_alternates' => [':sign_of_the_horns_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'horns', 'medium-light skin tone', 'rock-on'],
			],
			'1f918-1f3fd' => [
				'name' => \XF::phrase('emoji.metal_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone3:',
				'shortname_alternates' => [':sign_of_the_horns_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'horns', 'medium skin tone', 'rock-on'],
			],
			'1f918-1f3fe' => [
				'name' => \XF::phrase('emoji.metal_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone4:',
				'shortname_alternates' => [':sign_of_the_horns_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'horns', 'medium-dark skin tone', 'rock-on'],
			],
			'1f918-1f3ff' => [
				'name' => \XF::phrase('emoji.metal_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone5:',
				'shortname_alternates' => [':sign_of_the_horns_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'horns', 'rock-on'],
			],
			'1f44c' => [
				'name' => \XF::phrase('emoji.ok_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f44c-1f3fb', '1f44c-1f3fc', '1f44c-1f3fd', '1f44c-1f3fe', '1f44c-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['OK', 'hand'],
			],
			'1f44c-1f3fb' => [
				'name' => \XF::phrase('emoji.ok_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['OK', 'hand', 'light skin tone'],
			],
			'1f44c-1f3fc' => [
				'name' => \XF::phrase('emoji.ok_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['OK', 'hand', 'medium-light skin tone'],
			],
			'1f44c-1f3fd' => [
				'name' => \XF::phrase('emoji.ok_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['OK', 'hand', 'medium skin tone'],
			],
			'1f44c-1f3fe' => [
				'name' => \XF::phrase('emoji.ok_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['OK', 'hand', 'medium-dark skin tone'],
			],
			'1f44c-1f3ff' => [
				'name' => \XF::phrase('emoji.ok_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['OK', 'dark skin tone', 'hand'],
			],
			'1f448' => [
				'name' => \XF::phrase('emoji.point_left'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f448-1f3fb', '1f448-1f3fc', '1f448-1f3fd', '1f448-1f3fe', '1f448-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point'],
			],
			'1f448-1f3fb' => [
				'name' => \XF::phrase('emoji.point_left_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point'],
			],
			'1f448-1f3fc' => [
				'name' => \XF::phrase('emoji.point_left_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point'],
			],
			'1f448-1f3fd' => [
				'name' => \XF::phrase('emoji.point_left_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point'],
			],
			'1f448-1f3fe' => [
				'name' => \XF::phrase('emoji.point_left_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point'],
			],
			'1f448-1f3ff' => [
				'name' => \XF::phrase('emoji.point_left_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point'],
			],
			'1f449' => [
				'name' => \XF::phrase('emoji.point_right'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f449-1f3fb', '1f449-1f3fc', '1f449-1f3fd', '1f449-1f3fe', '1f449-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point'],
			],
			'1f449-1f3fb' => [
				'name' => \XF::phrase('emoji.point_right_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point'],
			],
			'1f449-1f3fc' => [
				'name' => \XF::phrase('emoji.point_right_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point'],
			],
			'1f449-1f3fd' => [
				'name' => \XF::phrase('emoji.point_right_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point'],
			],
			'1f449-1f3fe' => [
				'name' => \XF::phrase('emoji.point_right_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point'],
			],
			'1f449-1f3ff' => [
				'name' => \XF::phrase('emoji.point_right_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point'],
			],
			'1f446' => [
				'name' => \XF::phrase('emoji.point_up_2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f446-1f3fb', '1f446-1f3fc', '1f446-1f3fd', '1f446-1f3fe', '1f446-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point', 'up'],
			],
			'1f446-1f3fb' => [
				'name' => \XF::phrase('emoji.point_up_2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'up'],
			],
			'1f446-1f3fc' => [
				'name' => \XF::phrase('emoji.point_up_2_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up'],
			],
			'1f446-1f3fd' => [
				'name' => \XF::phrase('emoji.point_up_2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'up'],
			],
			'1f446-1f3fe' => [
				'name' => \XF::phrase('emoji.point_up_2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up'],
			],
			'1f446-1f3ff' => [
				'name' => \XF::phrase('emoji.point_up_2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'up'],
			],
			'1f447' => [
				'name' => \XF::phrase('emoji.point_down'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f447-1f3fb', '1f447-1f3fc', '1f447-1f3fd', '1f447-1f3fe', '1f447-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'point'],
			],
			'1f447-1f3fb' => [
				'name' => \XF::phrase('emoji.point_down_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'light skin tone', 'point'],
			],
			'1f447-1f3fc' => [
				'name' => \XF::phrase('emoji.point_down_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium-light skin tone', 'point'],
			],
			'1f447-1f3fd' => [
				'name' => \XF::phrase('emoji.point_down_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium skin tone', 'point'],
			],
			'1f447-1f3fe' => [
				'name' => \XF::phrase('emoji.point_down_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point'],
			],
			'1f447-1f3ff' => [
				'name' => \XF::phrase('emoji.point_down_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'dark skin tone', 'down', 'finger', 'hand', 'index', 'point'],
			],
			'261d' => [
				'name' => \XF::phrase('emoji.point_up'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['261d-1f3fb', '261d-1f3fc', '261d-1f3fd', '261d-1f3fe', '261d-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'index', 'point', 'up'],
			],
			'261d-1f3fb' => [
				'name' => \XF::phrase('emoji.point_up_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'index', 'light skin tone', 'point', 'up'],
			],
			'261d-1f3fc' => [
				'name' => \XF::phrase('emoji.point_up_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up'],
			],
			'261d-1f3fd' => [
				'name' => \XF::phrase('emoji.point_up_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'index', 'medium skin tone', 'point', 'up'],
			],
			'261d-1f3fe' => [
				'name' => \XF::phrase('emoji.point_up_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up'],
			],
			'261d-1f3ff' => [
				'name' => \XF::phrase('emoji.point_up_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'index', 'point', 'up'],
			],
			'270b' => [
				'name' => \XF::phrase('emoji.raised_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['270b-1f3fb', '270b-1f3fc', '270b-1f3fd', '270b-1f3fe', '270b-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand'],
			],
			'270b-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'light skin tone'],
			],
			'270b-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-light skin tone'],
			],
			'270b-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium skin tone'],
			],
			'270b-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-dark skin tone'],
			],
			'270b-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hand'],
			],
			'1f91a' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand:',
				'shortname_alternates' => [':back_of_hand:'],
				'diversity' => '',
				'diversities' => ['1f91a-1f3fb', '1f91a-1f3fc', '1f91a-1f3fd', '1f91a-1f3fe', '1f91a-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'raised'],
			],
			'1f91a-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone1:',
				'shortname_alternates' => [':back_of_hand_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'light skin tone', 'raised'],
			],
			'1f91a-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone2:',
				'shortname_alternates' => [':back_of_hand_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'medium-light skin tone', 'raised'],
			],
			'1f91a-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone3:',
				'shortname_alternates' => [':back_of_hand_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'medium skin tone', 'raised'],
			],
			'1f91a-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone4:',
				'shortname_alternates' => [':back_of_hand_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'medium-dark skin tone', 'raised'],
			],
			'1f91a-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone5:',
				'shortname_alternates' => [':back_of_hand_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['backhand', 'dark skin tone', 'raised'],
			],
			'1f590' => [
				'name' => \XF::phrase('emoji.hand_splayed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed:'],
				'diversity' => '',
				'diversities' => ['1f590-1f3fb', '1f590-1f3fc', '1f590-1f3fd', '1f590-1f3fe', '1f590-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'splayed'],
			],
			'1f590-1f3fb' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone1:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'light skin tone', 'splayed'],
			],
			'1f590-1f3fc' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone2:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'splayed'],
			],
			'1f590-1f3fd' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone3:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium skin tone', 'splayed'],
			],
			'1f590-1f3fe' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone4:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'splayed'],
			],
			'1f590-1f3ff' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone5:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'splayed'],
			],
			'1f596' => [
				'name' => \XF::phrase('emoji.vulcan'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers:'],
				'diversity' => '',
				'diversities' => ['1f596-1f3fb', '1f596-1f3fc', '1f596-1f3fd', '1f596-1f3fe', '1f596-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'spock', 'vulcan'],
			],
			'1f596-1f3fb' => [
				'name' => \XF::phrase('emoji.vulcan_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone1:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'light skin tone', 'spock', 'vulcan'],
			],
			'1f596-1f3fc' => [
				'name' => \XF::phrase('emoji.vulcan_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone2:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'spock', 'vulcan'],
			],
			'1f596-1f3fd' => [
				'name' => \XF::phrase('emoji.vulcan_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone3:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium skin tone', 'spock', 'vulcan'],
			],
			'1f596-1f3fe' => [
				'name' => \XF::phrase('emoji.vulcan_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone4:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'spock', 'vulcan'],
			],
			'1f596-1f3ff' => [
				'name' => \XF::phrase('emoji.vulcan_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone5:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'spock', 'vulcan'],
			],
			'1f44b' => [
				'name' => \XF::phrase('emoji.wave'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f44b-1f3fb', '1f44b-1f3fc', '1f44b-1f3fd', '1f44b-1f3fe', '1f44b-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'wave', 'waving'],
			],
			'1f44b-1f3fb' => [
				'name' => \XF::phrase('emoji.wave_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'light skin tone', 'wave', 'waving'],
			],
			'1f44b-1f3fc' => [
				'name' => \XF::phrase('emoji.wave_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'wave', 'waving'],
			],
			'1f44b-1f3fd' => [
				'name' => \XF::phrase('emoji.wave_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium skin tone', 'wave', 'waving'],
			],
			'1f44b-1f3fe' => [
				'name' => \XF::phrase('emoji.wave_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'wave', 'waving'],
			],
			'1f44b-1f3ff' => [
				'name' => \XF::phrase('emoji.wave_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hand', 'wave', 'waving'],
			],
			'1f919' => [
				'name' => \XF::phrase('emoji.call_me'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me:',
				'shortname_alternates' => [':call_me_hand:'],
				'diversity' => '',
				'diversities' => ['1f919-1f3fb', '1f919-1f3fc', '1f919-1f3fd', '1f919-1f3fe', '1f919-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['call', 'hand'],
			],
			'1f919-1f3fb' => [
				'name' => \XF::phrase('emoji.call_me_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone1:',
				'shortname_alternates' => [':call_me_hand_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['call', 'hand', 'light skin tone'],
			],
			'1f919-1f3fc' => [
				'name' => \XF::phrase('emoji.call_me_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone2:',
				'shortname_alternates' => [':call_me_hand_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['call', 'hand', 'medium-light skin tone'],
			],
			'1f919-1f3fd' => [
				'name' => \XF::phrase('emoji.call_me_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone3:',
				'shortname_alternates' => [':call_me_hand_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['call', 'hand', 'medium skin tone'],
			],
			'1f919-1f3fe' => [
				'name' => \XF::phrase('emoji.call_me_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone4:',
				'shortname_alternates' => [':call_me_hand_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['call', 'hand', 'medium-dark skin tone'],
			],
			'1f919-1f3ff' => [
				'name' => \XF::phrase('emoji.call_me_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone5:',
				'shortname_alternates' => [':call_me_hand_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['call', 'dark skin tone', 'hand'],
			],
			'1f4aa' => [
				'name' => \XF::phrase('emoji.muscle'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f4aa-1f3fb', '1f4aa-1f3fc', '1f4aa-1f3fd', '1f4aa-1f3fe', '1f4aa-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'muscle'],
			],
			'1f4aa-1f3fb' => [
				'name' => \XF::phrase('emoji.muscle_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'light skin tone', 'muscle'],
			],
			'1f4aa-1f3fc' => [
				'name' => \XF::phrase('emoji.muscle_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'medium-light skin tone', 'muscle'],
			],
			'1f4aa-1f3fd' => [
				'name' => \XF::phrase('emoji.muscle_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'medium skin tone', 'muscle'],
			],
			'1f4aa-1f3fe' => [
				'name' => \XF::phrase('emoji.muscle_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'medium-dark skin tone', 'muscle'],
			],
			'1f4aa-1f3ff' => [
				'name' => \XF::phrase('emoji.muscle_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biceps', 'comic', 'dark skin tone', 'flex', 'muscle'],
			],
			'1f9b5' => [
				'name' => \XF::phrase('emoji.leg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b5-1f3fb', '1f9b5-1f3fc', '1f9b5-1f3fd', '1f9b5-1f3fe', '1f9b5-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b5-1f3fb' => [
				'name' => \XF::phrase('emoji.leg_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone1:',
				'shortname_alternates' => [':leg_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b5-1f3fc' => [
				'name' => \XF::phrase('emoji.leg_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone2:',
				'shortname_alternates' => [':leg_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b5-1f3fd' => [
				'name' => \XF::phrase('emoji.leg_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone3:',
				'shortname_alternates' => [':leg_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b5-1f3fe' => [
				'name' => \XF::phrase('emoji.leg_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone4:',
				'shortname_alternates' => [':leg_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b5-1f3ff' => [
				'name' => \XF::phrase('emoji.leg_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone5:',
				'shortname_alternates' => [':leg_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b6' => [
				'name' => \XF::phrase('emoji.foot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b6-1f3fb', '1f9b6-1f3fc', '1f9b6-1f3fd', '1f9b6-1f3fe', '1f9b6-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b6-1f3fb' => [
				'name' => \XF::phrase('emoji.foot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone1:',
				'shortname_alternates' => [':foot_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b6-1f3fc' => [
				'name' => \XF::phrase('emoji.foot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone2:',
				'shortname_alternates' => [':foot_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b6-1f3fd' => [
				'name' => \XF::phrase('emoji.foot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone3:',
				'shortname_alternates' => [':foot_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b6-1f3fe' => [
				'name' => \XF::phrase('emoji.foot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone4:',
				'shortname_alternates' => [':foot_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b6-1f3ff' => [
				'name' => \XF::phrase('emoji.foot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone5:',
				'shortname_alternates' => [':foot_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f595' => [
				'name' => \XF::phrase('emoji.middle_finger'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended:'],
				'diversity' => '',
				'diversities' => ['1f595-1f3fb', '1f595-1f3fc', '1f595-1f3fd', '1f595-1f3fe', '1f595-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand'],
			],
			'1f595-1f3fb' => [
				'name' => \XF::phrase('emoji.middle_finger_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone1:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'light skin tone'],
			],
			'1f595-1f3fc' => [
				'name' => \XF::phrase('emoji.middle_finger_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone2:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium-light skin tone'],
			],
			'1f595-1f3fd' => [
				'name' => \XF::phrase('emoji.middle_finger_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone3:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium skin tone'],
			],
			'1f595-1f3fe' => [
				'name' => \XF::phrase('emoji.middle_finger_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone4:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['finger', 'hand', 'medium-dark skin tone'],
			],
			'1f595-1f3ff' => [
				'name' => \XF::phrase('emoji.middle_finger_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone5:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand'],
			],
			'270d' => [
				'name' => \XF::phrase('emoji.writing_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['270d-1f3fb', '270d-1f3fc', '270d-1f3fd', '270d-1f3fe', '270d-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'write'],
			],
			'270d-1f3fb' => [
				'name' => \XF::phrase('emoji.writing_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'light skin tone', 'write'],
			],
			'270d-1f3fc' => [
				'name' => \XF::phrase('emoji.writing_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'write'],
			],
			'270d-1f3fd' => [
				'name' => \XF::phrase('emoji.writing_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium skin tone', 'write'],
			],
			'270d-1f3fe' => [
				'name' => \XF::phrase('emoji.writing_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'write'],
			],
			'270d-1f3ff' => [
				'name' => \XF::phrase('emoji.writing_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hand', 'write'],
			],
			'1f64f' => [
				'name' => \XF::phrase('emoji.pray'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64f-1f3fb', '1f64f-1f3fc', '1f64f-1f3fd', '1f64f-1f3fe', '1f64f-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks'],
			],
			'1f64f-1f3fb' => [
				'name' => \XF::phrase('emoji.pray_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'light skin tone', 'please', 'pray', 'thanks'],
			],
			'1f64f-1f3fc' => [
				'name' => \XF::phrase('emoji.pray_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-light skin tone', 'please', 'pray', 'thanks'],
			],
			'1f64f-1f3fd' => [
				'name' => \XF::phrase('emoji.pray_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium skin tone', 'please', 'pray', 'thanks'],
			],
			'1f64f-1f3fe' => [
				'name' => \XF::phrase('emoji.pray_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-dark skin tone', 'please', 'pray', 'thanks'],
			],
			'1f64f-1f3ff' => [
				'name' => \XF::phrase('emoji.pray_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ask', 'bow', 'dark skin tone', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks'],
			],
			'1f48d' => [
				'name' => \XF::phrase('emoji.ring'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ring:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['diamond'],
			],
			'1f484' => [
				'name' => \XF::phrase('emoji.lipstick'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lipstick:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cosmetics', 'makeup'],
			],
			'1f48b' => [
				'name' => \XF::phrase('emoji.kiss'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['kiss', 'lips'],
			],
			'1f444' => [
				'name' => \XF::phrase('emoji.lips'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lips:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lips'],
			],
			'1f445' => [
				'name' => \XF::phrase('emoji.tongue'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tongue:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body'],
			],
			'1f442' => [
				'name' => \XF::phrase('emoji.ear'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f442-1f3fb', '1f442-1f3fc', '1f442-1f3fd', '1f442-1f3fe', '1f442-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body'],
			],
			'1f442-1f3fb' => [
				'name' => \XF::phrase('emoji.ear_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'light skin tone'],
			],
			'1f442-1f3fc' => [
				'name' => \XF::phrase('emoji.ear_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'medium-light skin tone'],
			],
			'1f442-1f3fd' => [
				'name' => \XF::phrase('emoji.ear_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'medium skin tone'],
			],
			'1f442-1f3fe' => [
				'name' => \XF::phrase('emoji.ear_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'medium-dark skin tone'],
			],
			'1f442-1f3ff' => [
				'name' => \XF::phrase('emoji.ear_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'dark skin tone'],
			],
			'1f443' => [
				'name' => \XF::phrase('emoji.nose'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f443-1f3fb', '1f443-1f3fc', '1f443-1f3fd', '1f443-1f3fe', '1f443-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body'],
			],
			'1f443-1f3fb' => [
				'name' => \XF::phrase('emoji.nose_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'light skin tone'],
			],
			'1f443-1f3fc' => [
				'name' => \XF::phrase('emoji.nose_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'medium-light skin tone'],
			],
			'1f443-1f3fd' => [
				'name' => \XF::phrase('emoji.nose_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'medium skin tone'],
			],
			'1f443-1f3fe' => [
				'name' => \XF::phrase('emoji.nose_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'medium-dark skin tone'],
			],
			'1f443-1f3ff' => [
				'name' => \XF::phrase('emoji.nose_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body', 'dark skin tone'],
			],
			'1f463' => [
				'name' => \XF::phrase('emoji.footprints'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':footprints:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'footprint', 'print'],
			],
			'1f441' => [
				'name' => \XF::phrase('emoji.eye'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eye:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['body'],
			],
			'1f440' => [
				'name' => \XF::phrase('emoji.eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eyes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eye', 'face'],
			],
			'1f9e0' => [
				'name' => \XF::phrase('emoji.brain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':brain:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['intelligent'],
			],
			'1f9b4' => [
				'name' => \XF::phrase('emoji.bone'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b7' => [
				'name' => \XF::phrase('emoji.tooth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tooth:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f5e3' => [
				'name' => \XF::phrase('emoji.speaking_head'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':speaking_head:',
				'shortname_alternates' => [':speaking_head_in_silhouette:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'head', 'silhouette', 'speak', 'speaking'],
			],
			'1f464' => [
				'name' => \XF::phrase('emoji.bust_in_silhouette'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bust_in_silhouette:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bust', 'silhouette'],
			],
			'1f465' => [
				'name' => \XF::phrase('emoji.busts_in_silhouette'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':busts_in_silhouette:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bust', 'silhouette'],
			],
			'1f476' => [
				'name' => \XF::phrase('emoji.baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f476-1f3fb', '1f476-1f3fc', '1f476-1f3fd', '1f476-1f3fe', '1f476-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'young'],
			],
			'1f476-1f3fb' => [
				'name' => \XF::phrase('emoji.baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'light skin tone', 'young'],
			],
			'1f476-1f3fc' => [
				'name' => \XF::phrase('emoji.baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'medium-light skin tone', 'young'],
			],
			'1f476-1f3fd' => [
				'name' => \XF::phrase('emoji.baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'medium skin tone', 'young'],
			],
			'1f476-1f3fe' => [
				'name' => \XF::phrase('emoji.baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'medium-dark skin tone', 'young'],
			],
			'1f476-1f3ff' => [
				'name' => \XF::phrase('emoji.baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'dark skin tone', 'young'],
			],
			'1f467' => [
				'name' => \XF::phrase('emoji.girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f467-1f3fb', '1f467-1f3fc', '1f467-1f3fd', '1f467-1f3fe', '1f467-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Virgo', 'young', 'zodiac'],
			],
			'1f467-1f3fb' => [
				'name' => \XF::phrase('emoji.girl_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Virgo', 'light skin tone', 'young', 'zodiac'],
			],
			'1f467-1f3fc' => [
				'name' => \XF::phrase('emoji.girl_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Virgo', 'medium-light skin tone', 'young', 'zodiac'],
			],
			'1f467-1f3fd' => [
				'name' => \XF::phrase('emoji.girl_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Virgo', 'medium skin tone', 'young', 'zodiac'],
			],
			'1f467-1f3fe' => [
				'name' => \XF::phrase('emoji.girl_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Virgo', 'medium-dark skin tone', 'young', 'zodiac'],
			],
			'1f467-1f3ff' => [
				'name' => \XF::phrase('emoji.girl_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Virgo', 'dark skin tone', 'young', 'zodiac'],
			],
			'1f9d2' => [
				'name' => \XF::phrase('emoji.child'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d2-1f3fb', '1f9d2-1f3fc', '1f9d2-1f3fd', '1f9d2-1f3fe', '1f9d2-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9d2-1f3fb' => [
				'name' => \XF::phrase('emoji.child_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone1:',
				'shortname_alternates' => [':child_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'light skin tone', 'young'],
			],
			'1f9d2-1f3fc' => [
				'name' => \XF::phrase('emoji.child_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone2:',
				'shortname_alternates' => [':child_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'young'],
			],
			'1f9d2-1f3fd' => [
				'name' => \XF::phrase('emoji.child_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone3:',
				'shortname_alternates' => [':child_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'medium skin tone', 'young'],
			],
			'1f9d2-1f3fe' => [
				'name' => \XF::phrase('emoji.child_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone4:',
				'shortname_alternates' => [':child_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'young'],
			],
			'1f9d2-1f3ff' => [
				'name' => \XF::phrase('emoji.child_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone5:',
				'shortname_alternates' => [':child_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'gender-neutral', 'young'],
			],
			'1f466' => [
				'name' => \XF::phrase('emoji.boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f466-1f3fb', '1f466-1f3fc', '1f466-1f3fd', '1f466-1f3fe', '1f466-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'young'],
			],
			'1f466-1f3fb' => [
				'name' => \XF::phrase('emoji.boy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'light skin tone', 'young'],
			],
			'1f466-1f3fc' => [
				'name' => \XF::phrase('emoji.boy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'medium-light skin tone', 'young'],
			],
			'1f466-1f3fd' => [
				'name' => \XF::phrase('emoji.boy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'medium skin tone', 'young'],
			],
			'1f466-1f3fe' => [
				'name' => \XF::phrase('emoji.boy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'medium-dark skin tone', 'young'],
			],
			'1f466-1f3ff' => [
				'name' => \XF::phrase('emoji.boy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'dark skin tone', 'young'],
			],
			'1f469' => [
				'name' => \XF::phrase('emoji.woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb', '1f469-1f3fc', '1f469-1f3fd', '1f469-1f3fe', '1f469-1f3ff', '1f471-1f3fb-2640', '1f471-1f3fc-2640', '1f471-1f3fd-2640', '1f471-1f3fe-2640', '1f471-1f3ff-2640', '1f469-1f3fb-1f9b0', '1f469-1f3fc-1f9b0', '1f469-1f3fd-1f9b0', '1f469-1f3fe-1f9b0', '1f469-1f3ff-1f9b0', '1f469-1f3fb-1f9b1', '1f469-1f3fc-1f9b1', '1f469-1f3fd-1f9b1', '1f469-1f3fe-1f9b1', '1f469-1f3ff-1f9b1', '1f469-1f3fb-1f9b3', '1f469-1f3fc-1f9b3', '1f469-1f3fd-1f9b3', '1f469-1f3fe-1f9b3', '1f469-1f3ff-1f9b3', '1f469-1f3fb-1f9b2', '1f469-1f3fc-1f9b2', '1f469-1f3fd-1f9b2', '1f469-1f3fe-1f9b2', '1f469-1f3ff-1f9b2'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['woman'],
			],
			'1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'woman'],
			],
			'1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'woman'],
			],
			'1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium skin tone', 'woman'],
			],
			'1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'woman'],
			],
			'1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'woman'],
			],
			'1f9d1' => [
				'name' => \XF::phrase('emoji.adult'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d1-1f3fb', '1f9d1-1f3fc', '1f9d1-1f3fd', '1f9d1-1f3fe', '1f9d1-1f3ff', '1f471-1f3fb', '1f471-1f3fc', '1f471-1f3fd', '1f471-1f3fe', '1f471-1f3ff'],
				'gender' => '',
				'genders' => ['1f468', '1f469'],
				'keywords' => [''],
			],
			'1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.adult_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone1:',
				'shortname_alternates' => [':adult_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fb', '1f471-1f3fb-2642', '1f468-1f3fb-1f9b0', '1f468-1f3fb-1f9b1', '1f468-1f3fb-1f9b3', '1f468-1f3fb-1f9b2', '1f9d4-1f3fb', '1f469-1f3fb', '1f471-1f3fb-2640', '1f469-1f3fb-1f9b0', '1f469-1f3fb-1f9b1', '1f469-1f3fb-1f9b3', '1f469-1f3fb-1f9b2'],
				'keywords' => ['gender-neutral', 'light skin tone'],
			],
			'1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.adult_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone2:',
				'shortname_alternates' => [':adult_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fc', '1f471-1f3fc-2642', '1f468-1f3fc-1f9b0', '1f468-1f3fc-1f9b1', '1f468-1f3fc-1f9b3', '1f468-1f3fc-1f9b2', '1f9d4-1f3fc', '1f469-1f3fc', '1f471-1f3fc-2640', '1f469-1f3fc-1f9b0', '1f469-1f3fc-1f9b1', '1f469-1f3fc-1f9b3', '1f469-1f3fc-1f9b2'],
				'keywords' => ['gender-neutral', 'medium-light skin tone'],
			],
			'1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.adult_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone3:',
				'shortname_alternates' => [':adult_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fd', '1f471-1f3fd-2642', '1f468-1f3fd-1f9b0', '1f468-1f3fd-1f9b1', '1f468-1f3fd-1f9b3', '1f468-1f3fd-1f9b2', '1f9d4-1f3fd', '1f469-1f3fd', '1f471-1f3fd-2640', '1f469-1f3fd-1f9b0', '1f469-1f3fd-1f9b1', '1f469-1f3fd-1f9b3', '1f469-1f3fd-1f9b2'],
				'keywords' => ['gender-neutral', 'medium skin tone'],
			],
			'1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.adult_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone4:',
				'shortname_alternates' => [':adult_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fe', '1f471-1f3fe-2642', '1f468-1f3fe-1f9b0', '1f468-1f3fe-1f9b1', '1f468-1f3fe-1f9b3', '1f468-1f3fe-1f9b2', '1f9d4-1f3fe', '1f469-1f3fe', '1f471-1f3fe-2640', '1f469-1f3fe-1f9b0', '1f469-1f3fe-1f9b1', '1f469-1f3fe-1f9b3', '1f469-1f3fe-1f9b2'],
				'keywords' => ['gender-neutral', 'medium-dark skin tone'],
			],
			'1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.adult_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone5:',
				'shortname_alternates' => [':adult_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3ff', '1f471-1f3ff-2642', '1f468-1f3ff-1f9b0', '1f468-1f3ff-1f9b1', '1f468-1f3ff-1f9b3', '1f468-1f3ff-1f9b2', '1f9d4-1f3ff', '1f469-1f3ff', '1f471-1f3ff-2640', '1f469-1f3ff-1f9b0', '1f469-1f3ff-1f9b1', '1f469-1f3ff-1f9b3', '1f469-1f3ff-1f9b2'],
				'keywords' => ['dark skin tone', 'gender-neutral'],
			],
			'1f468' => [
				'name' => \XF::phrase('emoji.man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb', '1f468-1f3fc', '1f468-1f3fd', '1f468-1f3fe', '1f468-1f3ff', '1f471-1f3fb-2642', '1f471-1f3fc-2642', '1f471-1f3fd-2642', '1f471-1f3fe-2642', '1f471-1f3ff-2642', '1f468-1f3fb-1f9b0', '1f468-1f3fc-1f9b0', '1f468-1f3fd-1f9b0', '1f468-1f3fe-1f9b0', '1f468-1f3ff-1f9b0', '1f468-1f3fb-1f9b1', '1f468-1f3fc-1f9b1', '1f468-1f3fd-1f9b1', '1f468-1f3fe-1f9b1', '1f468-1f3ff-1f9b1', '1f468-1f3fb-1f9b3', '1f468-1f3fc-1f9b3', '1f468-1f3fd-1f9b3', '1f468-1f3fe-1f9b3', '1f468-1f3ff-1f9b3', '1f468-1f3fb-1f9b2', '1f468-1f3fc-1f9b2', '1f468-1f3fd-1f9b2', '1f468-1f3fe-1f9b2', '1f468-1f3ff-1f9b2', '1f9d4-1f3fb', '1f9d4-1f3fc', '1f9d4-1f3fd', '1f9d4-1f3fe', '1f9d4-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man'],
			],
			'1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'man'],
			],
			'1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone'],
			],
			'1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone'],
			],
			'1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone'],
			],
			'1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man'],
			],
			'1f471' => [
				'name' => \XF::phrase('emoji.blond_haired_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person:',
				'shortname_alternates' => [':person_with_blond_hair:'],
				'diversity' => '',
				'diversities' => ['1f471-1f3fb', '1f471-1f3fc', '1f471-1f3fd', '1f471-1f3fe', '1f471-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blond'],
			],
			'1f471-1f3fb' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone1:',
				'shortname_alternates' => [':person_with_blond_hair_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fb', '1f471-1f3fb-2642', '1f468-1f3fb-1f9b0', '1f468-1f3fb-1f9b1', '1f468-1f3fb-1f9b3', '1f468-1f3fb-1f9b2', '1f9d4-1f3fb', '1f469-1f3fb', '1f471-1f3fb-2640', '1f469-1f3fb-1f9b0', '1f469-1f3fb-1f9b1', '1f469-1f3fb-1f9b3', '1f469-1f3fb-1f9b2'],
				'keywords' => ['blond', 'light skin tone'],
			],
			'1f471-1f3fc' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone2:',
				'shortname_alternates' => [':person_with_blond_hair_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fc', '1f471-1f3fc-2642', '1f468-1f3fc-1f9b0', '1f468-1f3fc-1f9b1', '1f468-1f3fc-1f9b3', '1f468-1f3fc-1f9b2', '1f9d4-1f3fc', '1f469-1f3fc', '1f471-1f3fc-2640', '1f469-1f3fc-1f9b0', '1f469-1f3fc-1f9b1', '1f469-1f3fc-1f9b3', '1f469-1f3fc-1f9b2'],
				'keywords' => ['blond', 'medium-light skin tone'],
			],
			'1f471-1f3fd' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone3:',
				'shortname_alternates' => [':person_with_blond_hair_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fd', '1f471-1f3fd-2642', '1f468-1f3fd-1f9b0', '1f468-1f3fd-1f9b1', '1f468-1f3fd-1f9b3', '1f468-1f3fd-1f9b2', '1f9d4-1f3fd', '1f469-1f3fd', '1f471-1f3fd-2640', '1f469-1f3fd-1f9b0', '1f469-1f3fd-1f9b1', '1f469-1f3fd-1f9b3', '1f469-1f3fd-1f9b2'],
				'keywords' => ['blond', 'medium skin tone'],
			],
			'1f471-1f3fe' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone4:',
				'shortname_alternates' => [':person_with_blond_hair_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3fe', '1f471-1f3fe-2642', '1f468-1f3fe-1f9b0', '1f468-1f3fe-1f9b1', '1f468-1f3fe-1f9b3', '1f468-1f3fe-1f9b2', '1f9d4-1f3fe', '1f469-1f3fe', '1f471-1f3fe-2640', '1f469-1f3fe-1f9b0', '1f469-1f3fe-1f9b1', '1f469-1f3fe-1f9b3', '1f469-1f3fe-1f9b2'],
				'keywords' => ['blond', 'medium-dark skin tone'],
			],
			'1f471-1f3ff' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone5:',
				'shortname_alternates' => [':person_with_blond_hair_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f468-1f3ff', '1f471-1f3ff-2642', '1f468-1f3ff-1f9b0', '1f468-1f3ff-1f9b1', '1f468-1f3ff-1f9b3', '1f468-1f3ff-1f9b2', '1f9d4-1f3ff', '1f469-1f3ff', '1f471-1f3ff-2640', '1f469-1f3ff-1f9b0', '1f469-1f3ff-1f9b1', '1f469-1f3ff-1f9b3', '1f469-1f3ff-1f9b2'],
				'keywords' => ['blond', 'dark skin tone'],
			],
			'1f471-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f471-1f3fb-2640', '1f471-1f3fc-2640', '1f471-1f3fd-2640', '1f471-1f3fe-2640', '1f471-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['blonde', 'woman'],
			],
			'1f471-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone1:',
				'shortname_alternates' => [':blond-haired_woman_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['blonde', 'light skin tone', 'woman'],
			],
			'1f471-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone2:',
				'shortname_alternates' => [':blond-haired_woman_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['blonde', 'medium-light skin tone', 'woman'],
			],
			'1f471-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone3:',
				'shortname_alternates' => [':blond-haired_woman_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['blonde', 'medium skin tone', 'woman'],
			],
			'1f471-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone4:',
				'shortname_alternates' => [':blond-haired_woman_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['blonde', 'medium-dark skin tone', 'woman'],
			],
			'1f471-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone5:',
				'shortname_alternates' => [':blond-haired_woman_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['blonde', 'dark skin tone', 'woman'],
			],
			'1f471-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f471-1f3fb-2642', '1f471-1f3fc-2642', '1f471-1f3fd-2642', '1f471-1f3fe-2642', '1f471-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['blond', 'man'],
			],
			'1f471-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone1:',
				'shortname_alternates' => [':blond-haired_man_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['blond', 'light skin tone', 'man'],
			],
			'1f471-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone2:',
				'shortname_alternates' => [':blond-haired_man_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['blond', 'man', 'medium-light skin tone'],
			],
			'1f471-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone3:',
				'shortname_alternates' => [':blond-haired_man_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['blond', 'man', 'medium skin tone'],
			],
			'1f471-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone4:',
				'shortname_alternates' => [':blond-haired_man_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['blond', 'man', 'medium-dark skin tone'],
			],
			'1f471-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone5:',
				'shortname_alternates' => [':blond-haired_man_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['blond', 'dark skin tone', 'man'],
			],
			'1f469-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f9b0', '1f469-1f3fc-1f9b0', '1f469-1f3fd-1f9b0', '1f469-1f3fe-1f9b0', '1f469-1f3ff-1f9b0'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone1:',
				'shortname_alternates' => [':woman_red_haired_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone2:',
				'shortname_alternates' => [':woman_red_haired_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone3:',
				'shortname_alternates' => [':woman_red_haired_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone4:',
				'shortname_alternates' => [':woman_red_haired_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone5:',
				'shortname_alternates' => [':woman_red_haired_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f9b0', '1f468-1f3fd-1f9b0', '1f468-1f3fe-1f9b0', '1f468-1f3ff-1f9b0'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone1:',
				'shortname_alternates' => [':man_red_haired_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone2:',
				'shortname_alternates' => [':man_red_haired_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone3:',
				'shortname_alternates' => [':man_red_haired_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone4:',
				'shortname_alternates' => [':man_red_haired_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone5:',
				'shortname_alternates' => [':man_red_haired_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f9b1', '1f469-1f3fc-1f9b1', '1f469-1f3fd-1f9b1', '1f469-1f3fe-1f9b1', '1f469-1f3ff-1f9b1'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone1:',
				'shortname_alternates' => [':woman_curly_haired_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone2:',
				'shortname_alternates' => [':woman_curly_haired_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone3:',
				'shortname_alternates' => [':woman_curly_haired_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone4:',
				'shortname_alternates' => [':woman_curly_haired_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone5:',
				'shortname_alternates' => [':woman_curly_haired_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f9b1', '1f468-1f3fc-1f9b1', '1f468-1f3fd-1f9b1', '1f468-1f3fe-1f9b1', '1f468-1f3ff-1f9b1'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone1:',
				'shortname_alternates' => [':man_curly_haired_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone2:',
				'shortname_alternates' => [':man_curly_haired_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone3:',
				'shortname_alternates' => [':man_curly_haired_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone4:',
				'shortname_alternates' => [':man_curly_haired_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone5:',
				'shortname_alternates' => [':man_curly_haired_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f9b3', '1f469-1f3fc-1f9b3', '1f469-1f3fd-1f9b3', '1f469-1f3fe-1f9b3', '1f469-1f3ff-1f9b3'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone1:',
				'shortname_alternates' => [':woman_white_haired_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone2:',
				'shortname_alternates' => [':woman_white_haired_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone3:',
				'shortname_alternates' => [':woman_white_haired_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone4:',
				'shortname_alternates' => [':woman_white_haired_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone5:',
				'shortname_alternates' => [':woman_white_haired_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f9b3', '1f468-1f3fc-1f9b3', '1f468-1f3fd-1f9b3', '1f468-1f3fe-1f9b3', '1f468-1f3ff-1f9b3'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone1:',
				'shortname_alternates' => [':man_white_haired_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone2:',
				'shortname_alternates' => [':man_white_haired_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone3:',
				'shortname_alternates' => [':man_white_haired_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone4:',
				'shortname_alternates' => [':man_white_haired_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone5:',
				'shortname_alternates' => [':man_white_haired_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f9b2', '1f469-1f3fc-1f9b2', '1f469-1f3fd-1f9b2', '1f469-1f3fe-1f9b2', '1f469-1f3ff-1f9b2'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone1:',
				'shortname_alternates' => [':woman_bald_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone2:',
				'shortname_alternates' => [':woman_bald_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone3:',
				'shortname_alternates' => [':woman_bald_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone4:',
				'shortname_alternates' => [':woman_bald_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f469-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone5:',
				'shortname_alternates' => [':woman_bald_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f9b2', '1f468-1f3fc-1f9b2', '1f468-1f3fd-1f9b2', '1f468-1f3fe-1f9b2', '1f468-1f3ff-1f9b2'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone1:',
				'shortname_alternates' => [':man_bald_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone2:',
				'shortname_alternates' => [':man_bald_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone3:',
				'shortname_alternates' => [':man_bald_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone4:',
				'shortname_alternates' => [':man_bald_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f468-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone5:',
				'shortname_alternates' => [':man_bald_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9d4' => [
				'name' => \XF::phrase('emoji.bearded_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d4-1f3fb', '1f9d4-1f3fc', '1f9d4-1f3fd', '1f9d4-1f3fe', '1f9d4-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9d4-1f3fb' => [
				'name' => \XF::phrase('emoji.bearded_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone1:',
				'shortname_alternates' => [':bearded_person_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beard', 'light skin tone'],
			],
			'1f9d4-1f3fc' => [
				'name' => \XF::phrase('emoji.bearded_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone2:',
				'shortname_alternates' => [':bearded_person_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beard', 'medium-light skin tone'],
			],
			'1f9d4-1f3fd' => [
				'name' => \XF::phrase('emoji.bearded_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone3:',
				'shortname_alternates' => [':bearded_person_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beard', 'medium skin tone'],
			],
			'1f9d4-1f3fe' => [
				'name' => \XF::phrase('emoji.bearded_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone4:',
				'shortname_alternates' => [':bearded_person_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beard', 'medium-dark skin tone'],
			],
			'1f9d4-1f3ff' => [
				'name' => \XF::phrase('emoji.bearded_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone5:',
				'shortname_alternates' => [':bearded_person_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beard', 'dark skin tone'],
			],
			'1f475' => [
				'name' => \XF::phrase('emoji.older_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman:',
				'shortname_alternates' => [':grandma:'],
				'diversity' => '',
				'diversities' => ['1f475-1f3fb', '1f475-1f3fc', '1f475-1f3fd', '1f475-1f3fe', '1f475-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['old', 'woman'],
			],
			'1f475-1f3fb' => [
				'name' => \XF::phrase('emoji.older_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone1:',
				'shortname_alternates' => [':grandma_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'old', 'woman'],
			],
			'1f475-1f3fc' => [
				'name' => \XF::phrase('emoji.older_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone2:',
				'shortname_alternates' => [':grandma_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'old', 'woman'],
			],
			'1f475-1f3fd' => [
				'name' => \XF::phrase('emoji.older_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone3:',
				'shortname_alternates' => [':grandma_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium skin tone', 'old', 'woman'],
			],
			'1f475-1f3fe' => [
				'name' => \XF::phrase('emoji.older_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone4:',
				'shortname_alternates' => [':grandma_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'old', 'woman'],
			],
			'1f475-1f3ff' => [
				'name' => \XF::phrase('emoji.older_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone5:',
				'shortname_alternates' => [':grandma_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'old', 'woman'],
			],
			'1f9d3' => [
				'name' => \XF::phrase('emoji.older_adult'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d3-1f3fb', '1f9d3-1f3fc', '1f9d3-1f3fd', '1f9d3-1f3fe', '1f9d3-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9d3-1f3fb' => [
				'name' => \XF::phrase('emoji.older_adult_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone1:',
				'shortname_alternates' => [':older_adult_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'light skin tone', 'old'],
			],
			'1f9d3-1f3fc' => [
				'name' => \XF::phrase('emoji.older_adult_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone2:',
				'shortname_alternates' => [':older_adult_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'old'],
			],
			'1f9d3-1f3fd' => [
				'name' => \XF::phrase('emoji.older_adult_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone3:',
				'shortname_alternates' => [':older_adult_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'medium skin tone', 'old'],
			],
			'1f9d3-1f3fe' => [
				'name' => \XF::phrase('emoji.older_adult_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone4:',
				'shortname_alternates' => [':older_adult_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'old'],
			],
			'1f9d3-1f3ff' => [
				'name' => \XF::phrase('emoji.older_adult_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone5:',
				'shortname_alternates' => [':older_adult_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'gender-neutral', 'old'],
			],
			'1f474' => [
				'name' => \XF::phrase('emoji.older_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f474-1f3fb', '1f474-1f3fc', '1f474-1f3fd', '1f474-1f3fe', '1f474-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'old'],
			],
			'1f474-1f3fb' => [
				'name' => \XF::phrase('emoji.older_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'old'],
			],
			'1f474-1f3fc' => [
				'name' => \XF::phrase('emoji.older_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'old'],
			],
			'1f474-1f3fd' => [
				'name' => \XF::phrase('emoji.older_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'old'],
			],
			'1f474-1f3fe' => [
				'name' => \XF::phrase('emoji.older_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'old'],
			],
			'1f474-1f3ff' => [
				'name' => \XF::phrase('emoji.older_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'old'],
			],
			'1f472' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap:',
				'shortname_alternates' => [':man_with_gua_pi_mao:'],
				'diversity' => '',
				'diversities' => ['1f472-1f3fb', '1f472-1f3fc', '1f472-1f3fd', '1f472-1f3fe', '1f472-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gua pi mao', 'hat', 'man'],
			],
			'1f472-1f3fb' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone1:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gua pi mao', 'hat', 'light skin tone', 'man'],
			],
			'1f472-1f3fc' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone2:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium-light skin tone'],
			],
			'1f472-1f3fd' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone3:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium skin tone'],
			],
			'1f472-1f3fe' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone4:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium-dark skin tone'],
			],
			'1f472-1f3ff' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone5:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'gua pi mao', 'hat', 'man'],
			],
			'1f473' => [
				'name' => \XF::phrase('emoji.person_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban:',
				'shortname_alternates' => [':man_with_turban:'],
				'diversity' => '',
				'diversities' => ['1f473-1f3fb', '1f473-1f3fc', '1f473-1f3fd', '1f473-1f3fe', '1f473-1f3ff'],
				'gender' => '',
				'genders' => ['1f473-2642', '1f473-2640'],
				'keywords' => ['turban'],
			],
			'1f473-1f3fb' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone1:',
				'shortname_alternates' => [':man_with_turban_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f473-1f3fb-2642', '1f473-1f3fb-2640'],
				'keywords' => ['light skin tone', 'turban'],
			],
			'1f473-1f3fc' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone2:',
				'shortname_alternates' => [':man_with_turban_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f473-1f3fc-2642', '1f473-1f3fc-2640'],
				'keywords' => ['medium-light skin tone', 'turban'],
			],
			'1f473-1f3fd' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone3:',
				'shortname_alternates' => [':man_with_turban_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f473-1f3fd-2642', '1f473-1f3fd-2640'],
				'keywords' => ['medium skin tone', 'turban'],
			],
			'1f473-1f3fe' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone4:',
				'shortname_alternates' => [':man_with_turban_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f473-1f3fe-2642', '1f473-1f3fe-2640'],
				'keywords' => ['medium-dark skin tone', 'turban'],
			],
			'1f473-1f3ff' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone5:',
				'shortname_alternates' => [':man_with_turban_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f473-1f3ff-2642', '1f473-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'turban'],
			],
			'1f473-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f473-1f3fb-2640', '1f473-1f3fc-2640', '1f473-1f3fd-2640', '1f473-1f3fe-2640', '1f473-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['turban', 'woman'],
			],
			'1f473-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone1:',
				'shortname_alternates' => [':woman_wearing_turban_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'turban', 'woman'],
			],
			'1f473-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone2:',
				'shortname_alternates' => [':woman_wearing_turban_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'turban', 'woman'],
			],
			'1f473-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone3:',
				'shortname_alternates' => [':woman_wearing_turban_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'turban', 'woman'],
			],
			'1f473-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone4:',
				'shortname_alternates' => [':woman_wearing_turban_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'turban', 'woman'],
			],
			'1f473-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone5:',
				'shortname_alternates' => [':woman_wearing_turban_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'turban', 'woman'],
			],
			'1f473-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f473-1f3fb-2642', '1f473-1f3fc-2642', '1f473-1f3fd-2642', '1f473-1f3fe-2642', '1f473-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'turban'],
			],
			'1f473-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone1:',
				'shortname_alternates' => [':man_wearing_turban_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'turban'],
			],
			'1f473-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone2:',
				'shortname_alternates' => [':man_wearing_turban_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'turban'],
			],
			'1f473-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone3:',
				'shortname_alternates' => [':man_wearing_turban_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'turban'],
			],
			'1f473-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone4:',
				'shortname_alternates' => [':man_wearing_turban_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'turban'],
			],
			'1f473-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone5:',
				'shortname_alternates' => [':man_wearing_turban_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'turban'],
			],
			'1f9d5' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d5-1f3fb', '1f9d5-1f3fc', '1f9d5-1f3fd', '1f9d5-1f3fe', '1f9d5-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9d5-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone1:',
				'shortname_alternates' => [':woman_with_headscarf_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['headscarf', 'hijab', 'light skin tone', 'mantilla', 'tichel'],
			],
			'1f9d5-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone2:',
				'shortname_alternates' => [':woman_with_headscarf_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium-light skin tone', 'tichel'],
			],
			'1f9d5-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone3:',
				'shortname_alternates' => [':woman_with_headscarf_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium skin tone', 'tichel'],
			],
			'1f9d5-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone4:',
				'shortname_alternates' => [':woman_with_headscarf_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium-dark skin tone', 'tichel'],
			],
			'1f9d5-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone5:',
				'shortname_alternates' => [':woman_with_headscarf_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'headscarf', 'hijab', 'mantilla', 'tichel'],
			],
			'1f46e' => [
				'name' => \XF::phrase('emoji.police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer:',
				'shortname_alternates' => [':cop:'],
				'diversity' => '',
				'diversities' => ['1f46e-1f3fb', '1f46e-1f3fc', '1f46e-1f3fd', '1f46e-1f3fe', '1f46e-1f3ff'],
				'gender' => '',
				'genders' => ['1f46e-2642', '1f46e-2640'],
				'keywords' => ['cop', 'officer', 'police'],
			],
			'1f46e-1f3fb' => [
				'name' => \XF::phrase('emoji.police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone1:',
				'shortname_alternates' => [':cop_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f46e-1f3fb-2642', '1f46e-1f3fb-2640'],
				'keywords' => ['cop', 'light skin tone', 'officer', 'police'],
			],
			'1f46e-1f3fc' => [
				'name' => \XF::phrase('emoji.police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone2:',
				'shortname_alternates' => [':cop_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f46e-1f3fc-2642', '1f46e-1f3fc-2640'],
				'keywords' => ['cop', 'medium-light skin tone', 'officer', 'police'],
			],
			'1f46e-1f3fd' => [
				'name' => \XF::phrase('emoji.police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone3:',
				'shortname_alternates' => [':cop_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f46e-1f3fd-2642', '1f46e-1f3fd-2640'],
				'keywords' => ['cop', 'medium skin tone', 'officer', 'police'],
			],
			'1f46e-1f3fe' => [
				'name' => \XF::phrase('emoji.police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone4:',
				'shortname_alternates' => [':cop_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f46e-1f3fe-2642', '1f46e-1f3fe-2640'],
				'keywords' => ['cop', 'medium-dark skin tone', 'officer', 'police'],
			],
			'1f46e-1f3ff' => [
				'name' => \XF::phrase('emoji.police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone5:',
				'shortname_alternates' => [':cop_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f46e-1f3ff-2642', '1f46e-1f3ff-2640'],
				'keywords' => ['cop', 'dark skin tone', 'officer', 'police'],
			],
			'1f46e-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f46e-1f3fb-2640', '1f46e-1f3fc-2640', '1f46e-1f3fd-2640', '1f46e-1f3fe-2640', '1f46e-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cop', 'officer', 'police', 'woman'],
			],
			'1f46e-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone1:',
				'shortname_alternates' => [':woman_police_officer_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cop', 'light skin tone', 'officer', 'police', 'woman'],
			],
			'1f46e-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone2:',
				'shortname_alternates' => [':woman_police_officer_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cop', 'medium-light skin tone', 'officer', 'police', 'woman'],
			],
			'1f46e-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone3:',
				'shortname_alternates' => [':woman_police_officer_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cop', 'medium skin tone', 'officer', 'police', 'woman'],
			],
			'1f46e-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone4:',
				'shortname_alternates' => [':woman_police_officer_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cop', 'medium-dark skin tone', 'officer', 'police', 'woman'],
			],
			'1f46e-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone5:',
				'shortname_alternates' => [':woman_police_officer_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cop', 'dark skin tone', 'officer', 'police', 'woman'],
			],
			'1f46e-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f46e-1f3fb-2642', '1f46e-1f3fc-2642', '1f46e-1f3fd-2642', '1f46e-1f3fe-2642', '1f46e-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cop', 'man', 'officer', 'police'],
			],
			'1f46e-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone1:',
				'shortname_alternates' => [':man_police_officer_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cop', 'light skin tone', 'man', 'officer', 'police'],
			],
			'1f46e-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone2:',
				'shortname_alternates' => [':man_police_officer_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cop', 'man', 'medium-light skin tone', 'officer', 'police'],
			],
			'1f46e-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone3:',
				'shortname_alternates' => [':man_police_officer_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cop', 'man', 'medium skin tone', 'officer', 'police'],
			],
			'1f46e-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone4:',
				'shortname_alternates' => [':man_police_officer_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cop', 'man', 'medium-dark skin tone', 'officer', 'police'],
			],
			'1f46e-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone5:',
				'shortname_alternates' => [':man_police_officer_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cop', 'dark skin tone', 'man', 'officer', 'police'],
			],
			'1f477' => [
				'name' => \XF::phrase('emoji.construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f477-1f3fb', '1f477-1f3fc', '1f477-1f3fd', '1f477-1f3fe', '1f477-1f3ff'],
				'gender' => '',
				'genders' => ['1f477-2642', '1f477-2640'],
				'keywords' => ['construction', 'hat', 'worker'],
			],
			'1f477-1f3fb' => [
				'name' => \XF::phrase('emoji.construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f477-1f3fb-2642', '1f477-1f3fb-2640'],
				'keywords' => ['construction', 'hat', 'light skin tone', 'worker'],
			],
			'1f477-1f3fc' => [
				'name' => \XF::phrase('emoji.construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f477-1f3fc-2642', '1f477-1f3fc-2640'],
				'keywords' => ['construction', 'hat', 'medium-light skin tone', 'worker'],
			],
			'1f477-1f3fd' => [
				'name' => \XF::phrase('emoji.construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f477-1f3fd-2642', '1f477-1f3fd-2640'],
				'keywords' => ['construction', 'hat', 'medium skin tone', 'worker'],
			],
			'1f477-1f3fe' => [
				'name' => \XF::phrase('emoji.construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f477-1f3fe-2642', '1f477-1f3fe-2640'],
				'keywords' => ['construction', 'hat', 'medium-dark skin tone', 'worker'],
			],
			'1f477-1f3ff' => [
				'name' => \XF::phrase('emoji.construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f477-1f3ff-2642', '1f477-1f3ff-2640'],
				'keywords' => ['construction', 'dark skin tone', 'hat', 'worker'],
			],
			'1f477-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f477-1f3fb-2640', '1f477-1f3fc-2640', '1f477-1f3fd-2640', '1f477-1f3fe-2640', '1f477-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['construction', 'woman', 'worker'],
			],
			'1f477-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone1:',
				'shortname_alternates' => [':woman_construction_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['construction', 'light skin tone', 'woman', 'worker'],
			],
			'1f477-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone2:',
				'shortname_alternates' => [':woman_construction_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['construction', 'medium-light skin tone', 'woman', 'worker'],
			],
			'1f477-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone3:',
				'shortname_alternates' => [':woman_construction_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['construction', 'medium skin tone', 'woman', 'worker'],
			],
			'1f477-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone4:',
				'shortname_alternates' => [':woman_construction_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['construction', 'medium-dark skin tone', 'woman', 'worker'],
			],
			'1f477-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone5:',
				'shortname_alternates' => [':woman_construction_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['construction', 'dark skin tone', 'woman', 'worker'],
			],
			'1f477-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f477-1f3fb-2642', '1f477-1f3fc-2642', '1f477-1f3fd-2642', '1f477-1f3fe-2642', '1f477-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['construction', 'man', 'worker'],
			],
			'1f477-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone1:',
				'shortname_alternates' => [':man_construction_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['construction', 'light skin tone', 'man', 'worker'],
			],
			'1f477-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone2:',
				'shortname_alternates' => [':man_construction_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['construction', 'man', 'medium-light skin tone', 'worker'],
			],
			'1f477-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone3:',
				'shortname_alternates' => [':man_construction_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['construction', 'man', 'medium skin tone', 'worker'],
			],
			'1f477-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone4:',
				'shortname_alternates' => [':man_construction_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['construction', 'man', 'medium-dark skin tone', 'worker'],
			],
			'1f477-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone5:',
				'shortname_alternates' => [':man_construction_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['construction', 'dark skin tone', 'man', 'worker'],
			],
			'1f482' => [
				'name' => \XF::phrase('emoji.guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard:',
				'shortname_alternates' => [':guardsman:'],
				'diversity' => '',
				'diversities' => ['1f482-1f3fb', '1f482-1f3fc', '1f482-1f3fd', '1f482-1f3fe', '1f482-1f3ff'],
				'gender' => '',
				'genders' => ['1f482-2642', '1f482-2640'],
				'keywords' => ['guard'],
			],
			'1f482-1f3fb' => [
				'name' => \XF::phrase('emoji.guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone1:',
				'shortname_alternates' => [':guardsman_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f482-1f3fb-2642', '1f482-1f3fb-2640'],
				'keywords' => ['guard', 'light skin tone'],
			],
			'1f482-1f3fc' => [
				'name' => \XF::phrase('emoji.guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone2:',
				'shortname_alternates' => [':guardsman_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f482-1f3fc-2642', '1f482-1f3fc-2640'],
				'keywords' => ['guard', 'medium-light skin tone'],
			],
			'1f482-1f3fd' => [
				'name' => \XF::phrase('emoji.guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone3:',
				'shortname_alternates' => [':guardsman_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f482-1f3fd-2642', '1f482-1f3fd-2640'],
				'keywords' => ['guard', 'medium skin tone'],
			],
			'1f482-1f3fe' => [
				'name' => \XF::phrase('emoji.guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone4:',
				'shortname_alternates' => [':guardsman_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f482-1f3fe-2642', '1f482-1f3fe-2640'],
				'keywords' => ['guard', 'medium-dark skin tone'],
			],
			'1f482-1f3ff' => [
				'name' => \XF::phrase('emoji.guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone5:',
				'shortname_alternates' => [':guardsman_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f482-1f3ff-2642', '1f482-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'guard'],
			],
			'1f482-2640' => [
				'name' => \XF::phrase('emoji.woman_guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f482-1f3fb-2640', '1f482-1f3fc-2640', '1f482-1f3fd-2640', '1f482-1f3fe-2640', '1f482-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['guard', 'woman'],
			],
			'1f482-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone1:',
				'shortname_alternates' => [':woman_guard_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['guard', 'light skin tone', 'woman'],
			],
			'1f482-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone2:',
				'shortname_alternates' => [':woman_guard_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['guard', 'medium-light skin tone', 'woman'],
			],
			'1f482-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone3:',
				'shortname_alternates' => [':woman_guard_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['guard', 'medium skin tone', 'woman'],
			],
			'1f482-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone4:',
				'shortname_alternates' => [':woman_guard_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['guard', 'medium-dark skin tone', 'woman'],
			],
			'1f482-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone5:',
				'shortname_alternates' => [':woman_guard_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'guard', 'woman'],
			],
			'1f482-2642' => [
				'name' => \XF::phrase('emoji.man_guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f482-1f3fb-2642', '1f482-1f3fc-2642', '1f482-1f3fd-2642', '1f482-1f3fe-2642', '1f482-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['guard', 'man'],
			],
			'1f482-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone1:',
				'shortname_alternates' => [':man_guard_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['guard', 'light skin tone', 'man'],
			],
			'1f482-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone2:',
				'shortname_alternates' => [':man_guard_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['guard', 'man', 'medium-light skin tone'],
			],
			'1f482-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone3:',
				'shortname_alternates' => [':man_guard_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['guard', 'man', 'medium skin tone'],
			],
			'1f482-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone4:',
				'shortname_alternates' => [':man_guard_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['guard', 'man', 'medium-dark skin tone'],
			],
			'1f482-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone5:',
				'shortname_alternates' => [':man_guard_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'guard', 'man'],
			],
			'1f575' => [
				'name' => \XF::phrase('emoji.detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective:',
				'shortname_alternates' => [':spy:', ':sleuth_or_spy:'],
				'diversity' => '',
				'diversities' => ['1f575-1f3fb', '1f575-1f3fc', '1f575-1f3fd', '1f575-1f3fe', '1f575-1f3ff'],
				'gender' => '',
				'genders' => ['1f575-2642', '1f575-2640'],
				'keywords' => ['detective', 'sleuth', 'spy'],
			],
			'1f575-1f3fb' => [
				'name' => \XF::phrase('emoji.detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone1:',
				'shortname_alternates' => [':spy_tone1:', ':sleuth_or_spy_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f575-1f3fb-2642', '1f575-1f3fb-2640'],
				'keywords' => ['detective', 'light skin tone', 'sleuth', 'spy'],
			],
			'1f575-1f3fc' => [
				'name' => \XF::phrase('emoji.detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone2:',
				'shortname_alternates' => [':spy_tone2:', ':sleuth_or_spy_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f575-1f3fc-2642', '1f575-1f3fc-2640'],
				'keywords' => ['detective', 'medium-light skin tone', 'sleuth', 'spy'],
			],
			'1f575-1f3fd' => [
				'name' => \XF::phrase('emoji.detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone3:',
				'shortname_alternates' => [':spy_tone3:', ':sleuth_or_spy_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f575-1f3fd-2642', '1f575-1f3fd-2640'],
				'keywords' => ['detective', 'medium skin tone', 'sleuth', 'spy'],
			],
			'1f575-1f3fe' => [
				'name' => \XF::phrase('emoji.detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone4:',
				'shortname_alternates' => [':spy_tone4:', ':sleuth_or_spy_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f575-1f3fe-2642', '1f575-1f3fe-2640'],
				'keywords' => ['detective', 'medium-dark skin tone', 'sleuth', 'spy'],
			],
			'1f575-1f3ff' => [
				'name' => \XF::phrase('emoji.detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone5:',
				'shortname_alternates' => [':spy_tone5:', ':sleuth_or_spy_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f575-1f3ff-2642', '1f575-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'detective', 'sleuth', 'spy'],
			],
			'1f575-2640' => [
				'name' => \XF::phrase('emoji.woman_detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f575-1f3fb-2640', '1f575-1f3fc-2640', '1f575-1f3fd-2640', '1f575-1f3fe-2640', '1f575-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['detective', 'sleuth', 'spy', 'woman'],
			],
			'1f575-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone1:',
				'shortname_alternates' => [':woman_detective_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['detective', 'light skin tone', 'sleuth', 'spy', 'woman'],
			],
			'1f575-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone2:',
				'shortname_alternates' => [':woman_detective_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['detective', 'medium-light skin tone', 'sleuth', 'spy', 'woman'],
			],
			'1f575-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone3:',
				'shortname_alternates' => [':woman_detective_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['detective', 'medium skin tone', 'sleuth', 'spy', 'woman'],
			],
			'1f575-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone4:',
				'shortname_alternates' => [':woman_detective_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['detective', 'medium-dark skin tone', 'sleuth', 'spy', 'woman'],
			],
			'1f575-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone5:',
				'shortname_alternates' => [':woman_detective_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'detective', 'sleuth', 'spy', 'woman'],
			],
			'1f575-2642' => [
				'name' => \XF::phrase('emoji.man_detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f575-1f3fb-2642', '1f575-1f3fc-2642', '1f575-1f3fd-2642', '1f575-1f3fe-2642', '1f575-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['detective', 'man', 'sleuth', 'spy'],
			],
			'1f575-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone1:',
				'shortname_alternates' => [':man_detective_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['detective', 'light skin tone', 'man', 'sleuth', 'spy'],
			],
			'1f575-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone2:',
				'shortname_alternates' => [':man_detective_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['detective', 'man', 'medium-light skin tone', 'sleuth', 'spy'],
			],
			'1f575-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone3:',
				'shortname_alternates' => [':man_detective_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['detective', 'man', 'medium skin tone', 'sleuth', 'spy'],
			],
			'1f575-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone4:',
				'shortname_alternates' => [':man_detective_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['detective', 'man', 'medium-dark skin tone', 'sleuth', 'spy'],
			],
			'1f575-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone5:',
				'shortname_alternates' => [':man_detective_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'detective', 'man', 'sleuth', 'spy'],
			],
			'1f469-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-2695', '1f469-1f3fc-2695', '1f469-1f3fd-2695', '1f469-1f3fe-2695', '1f469-1f3ff-2695'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'nurse', 'therapist', 'woman'],
			],
			'1f469-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone1:',
				'shortname_alternates' => [':woman_health_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'light skin tone', 'nurse', 'therapist', 'woman'],
			],
			'1f469-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone2:',
				'shortname_alternates' => [':woman_health_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'medium-light skin tone', 'nurse', 'therapist', 'woman'],
			],
			'1f469-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone3:',
				'shortname_alternates' => [':woman_health_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'medium skin tone', 'nurse', 'therapist', 'woman'],
			],
			'1f469-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone4:',
				'shortname_alternates' => [':woman_health_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'medium-dark skin tone', 'nurse', 'therapist', 'woman'],
			],
			'1f469-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone5:',
				'shortname_alternates' => [':woman_health_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'doctor', 'healthcare', 'nurse', 'therapist', 'woman'],
			],
			'1f468-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-2695', '1f468-1f3fc-2695', '1f468-1f3fd-2695', '1f468-1f3fe-2695', '1f468-1f3ff-2695'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'nurse', 'therapist'],
			],
			'1f468-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone1:',
				'shortname_alternates' => [':man_health_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'light skin tone', 'man', 'nurse', 'therapist'],
			],
			'1f468-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone2:',
				'shortname_alternates' => [':man_health_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'medium-light skin tone', 'nurse', 'therapist'],
			],
			'1f468-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone3:',
				'shortname_alternates' => [':man_health_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'medium skin tone', 'nurse', 'therapist'],
			],
			'1f468-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone4:',
				'shortname_alternates' => [':man_health_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'medium-dark skin tone', 'nurse', 'therapist'],
			],
			'1f468-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone5:',
				'shortname_alternates' => [':man_health_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'doctor', 'healthcare', 'man', 'nurse', 'therapist'],
			],
			'1f469-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f33e', '1f469-1f3fc-1f33e', '1f469-1f3fd-1f33e', '1f469-1f3fe-1f33e', '1f469-1f3ff-1f33e'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'rancher', 'woman'],
			],
			'1f469-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone1:',
				'shortname_alternates' => [':woman_farmer_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'light skin tone', 'rancher', 'woman'],
			],
			'1f469-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone2:',
				'shortname_alternates' => [':woman_farmer_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'medium-light skin tone', 'rancher', 'woman'],
			],
			'1f469-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone3:',
				'shortname_alternates' => [':woman_farmer_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'medium skin tone', 'rancher', 'woman'],
			],
			'1f469-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone4:',
				'shortname_alternates' => [':woman_farmer_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'medium-dark skin tone', 'rancher', 'woman'],
			],
			'1f469-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone5:',
				'shortname_alternates' => [':woman_farmer_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'farmer', 'gardener', 'rancher', 'woman'],
			],
			'1f468-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f33e', '1f468-1f3fc-1f33e', '1f468-1f3fd-1f33e', '1f468-1f3fe-1f33e', '1f468-1f3ff-1f33e'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'rancher'],
			],
			'1f468-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone1:',
				'shortname_alternates' => [':man_farmer_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'light skin tone', 'man', 'rancher'],
			],
			'1f468-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone2:',
				'shortname_alternates' => [':man_farmer_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'medium-light skin tone', 'rancher'],
			],
			'1f468-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone3:',
				'shortname_alternates' => [':man_farmer_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'medium skin tone', 'rancher'],
			],
			'1f468-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone4:',
				'shortname_alternates' => [':man_farmer_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'medium-dark skin tone', 'rancher'],
			],
			'1f468-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone5:',
				'shortname_alternates' => [':man_farmer_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'farmer', 'gardener', 'man', 'rancher'],
			],
			'1f469-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f373', '1f469-1f3fc-1f373', '1f469-1f3fd-1f373', '1f469-1f3fe-1f373', '1f469-1f3ff-1f373'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'woman'],
			],
			'1f469-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone1:',
				'shortname_alternates' => [':woman_cook_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'light skin tone', 'woman'],
			],
			'1f469-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone2:',
				'shortname_alternates' => [':woman_cook_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'medium-light skin tone', 'woman'],
			],
			'1f469-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone3:',
				'shortname_alternates' => [':woman_cook_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'medium skin tone', 'woman'],
			],
			'1f469-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone4:',
				'shortname_alternates' => [':woman_cook_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'medium-dark skin tone', 'woman'],
			],
			'1f469-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone5:',
				'shortname_alternates' => [':woman_cook_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'dark skin tone', 'woman'],
			],
			'1f468-1f373' => [
				'name' => \XF::phrase('emoji.man_cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f373', '1f468-1f3fc-1f373', '1f468-1f3fd-1f373', '1f468-1f3fe-1f373', '1f468-1f3ff-1f373'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'man'],
			],
			'1f468-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone1:',
				'shortname_alternates' => [':man_cook_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'light skin tone', 'man'],
			],
			'1f468-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone2:',
				'shortname_alternates' => [':man_cook_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'man', 'medium-light skin tone'],
			],
			'1f468-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone3:',
				'shortname_alternates' => [':man_cook_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'man', 'medium skin tone'],
			],
			'1f468-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone4:',
				'shortname_alternates' => [':man_cook_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'man', 'medium-dark skin tone'],
			],
			'1f468-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone5:',
				'shortname_alternates' => [':man_cook_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chef', 'cook', 'dark skin tone', 'man'],
			],
			'1f469-1f393' => [
				'name' => \XF::phrase('emoji.woman_student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f393', '1f469-1f3fc-1f393', '1f469-1f3fd-1f393', '1f469-1f3fe-1f393', '1f469-1f3ff-1f393'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'student', 'woman'],
			],
			'1f469-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone1:',
				'shortname_alternates' => [':woman_student_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'light skin tone', 'student', 'woman'],
			],
			'1f469-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone2:',
				'shortname_alternates' => [':woman_student_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'medium-light skin tone', 'student', 'woman'],
			],
			'1f469-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone3:',
				'shortname_alternates' => [':woman_student_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'medium skin tone', 'student', 'woman'],
			],
			'1f469-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone4:',
				'shortname_alternates' => [':woman_student_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'medium-dark skin tone', 'student', 'woman'],
			],
			'1f469-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone5:',
				'shortname_alternates' => [':woman_student_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'graduate', 'student', 'woman'],
			],
			'1f468-1f393' => [
				'name' => \XF::phrase('emoji.man_student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f393', '1f468-1f3fc-1f393', '1f468-1f3fd-1f393', '1f468-1f3fe-1f393', '1f468-1f3ff-1f393'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'man', 'student'],
			],
			'1f468-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone1:',
				'shortname_alternates' => [':man_student_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'light skin tone', 'man', 'student'],
			],
			'1f468-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone2:',
				'shortname_alternates' => [':man_student_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'man', 'medium-light skin tone', 'student'],
			],
			'1f468-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone3:',
				'shortname_alternates' => [':man_student_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'man', 'medium skin tone', 'student'],
			],
			'1f468-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone4:',
				'shortname_alternates' => [':man_student_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['graduate', 'man', 'medium-dark skin tone', 'student'],
			],
			'1f468-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone5:',
				'shortname_alternates' => [':man_student_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'graduate', 'man', 'student'],
			],
			'1f469-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f3a4', '1f469-1f3fc-1f3a4', '1f469-1f3fd-1f3a4', '1f469-1f3fe-1f3a4', '1f469-1f3ff-1f3a4'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'rock', 'singer', 'star', 'woman'],
			],
			'1f469-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone1:',
				'shortname_alternates' => [':woman_singer_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'light skin tone', 'rock', 'singer', 'star', 'woman'],
			],
			'1f469-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone2:',
				'shortname_alternates' => [':woman_singer_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'medium-light skin tone', 'rock', 'singer', 'star', 'woman'],
			],
			'1f469-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone3:',
				'shortname_alternates' => [':woman_singer_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'medium skin tone', 'rock', 'singer', 'star', 'woman'],
			],
			'1f469-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone4:',
				'shortname_alternates' => [':woman_singer_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'medium-dark skin tone', 'rock', 'singer', 'star', 'woman'],
			],
			'1f469-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone5:',
				'shortname_alternates' => [':woman_singer_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'dark skin tone', 'entertainer', 'rock', 'singer', 'star', 'woman'],
			],
			'1f468-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f3a4', '1f468-1f3fc-1f3a4', '1f468-1f3fd-1f3a4', '1f468-1f3fe-1f3a4', '1f468-1f3ff-1f3a4'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'rock', 'singer', 'star'],
			],
			'1f468-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone1:',
				'shortname_alternates' => [':man_singer_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'light skin tone', 'man', 'rock', 'singer', 'star'],
			],
			'1f468-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone2:',
				'shortname_alternates' => [':man_singer_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'medium-light skin tone', 'rock', 'singer', 'star'],
			],
			'1f468-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone3:',
				'shortname_alternates' => [':man_singer_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'medium skin tone', 'rock', 'singer', 'star'],
			],
			'1f468-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone4:',
				'shortname_alternates' => [':man_singer_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'medium-dark skin tone', 'rock', 'singer', 'star'],
			],
			'1f468-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone5:',
				'shortname_alternates' => [':man_singer_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['actor', 'dark skin tone', 'entertainer', 'man', 'rock', 'singer', 'star'],
			],
			'1f469-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f3eb', '1f469-1f3fc-1f3eb', '1f469-1f3fd-1f3eb', '1f469-1f3fe-1f3eb', '1f469-1f3ff-1f3eb'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'professor', 'teacher', 'woman'],
			],
			'1f469-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone1:',
				'shortname_alternates' => [':woman_teacher_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'light skin tone', 'professor', 'teacher', 'woman'],
			],
			'1f469-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone2:',
				'shortname_alternates' => [':woman_teacher_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'medium-light skin tone', 'professor', 'teacher', 'woman'],
			],
			'1f469-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone3:',
				'shortname_alternates' => [':woman_teacher_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'medium skin tone', 'professor', 'teacher', 'woman'],
			],
			'1f469-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone4:',
				'shortname_alternates' => [':woman_teacher_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'medium-dark skin tone', 'professor', 'teacher', 'woman'],
			],
			'1f469-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone5:',
				'shortname_alternates' => [':woman_teacher_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'instructor', 'professor', 'teacher', 'woman'],
			],
			'1f468-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f3eb', '1f468-1f3fc-1f3eb', '1f468-1f3fd-1f3eb', '1f468-1f3fe-1f3eb', '1f468-1f3ff-1f3eb'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'man', 'professor', 'teacher'],
			],
			'1f468-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone1:',
				'shortname_alternates' => [':man_teacher_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'light skin tone', 'man', 'professor', 'teacher'],
			],
			'1f468-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone2:',
				'shortname_alternates' => [':man_teacher_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'man', 'medium-light skin tone', 'professor', 'teacher'],
			],
			'1f468-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone3:',
				'shortname_alternates' => [':man_teacher_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'man', 'medium skin tone', 'professor', 'teacher'],
			],
			'1f468-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone4:',
				'shortname_alternates' => [':man_teacher_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instructor', 'man', 'medium-dark skin tone', 'professor', 'teacher'],
			],
			'1f468-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone5:',
				'shortname_alternates' => [':man_teacher_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'instructor', 'man', 'professor', 'teacher'],
			],
			'1f469-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f3ed', '1f469-1f3fc-1f3ed', '1f469-1f3fd-1f3ed', '1f469-1f3fe-1f3ed', '1f469-1f3ff-1f3ed'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'woman', 'worker'],
			],
			'1f469-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone1:',
				'shortname_alternates' => [':woman_factory_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'light skin tone', 'woman', 'worker'],
			],
			'1f469-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone2:',
				'shortname_alternates' => [':woman_factory_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'medium-light skin tone', 'woman', 'worker'],
			],
			'1f469-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone3:',
				'shortname_alternates' => [':woman_factory_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'medium skin tone', 'woman', 'worker'],
			],
			'1f469-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone4:',
				'shortname_alternates' => [':woman_factory_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'medium-dark skin tone', 'woman', 'worker'],
			],
			'1f469-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone5:',
				'shortname_alternates' => [':woman_factory_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'dark skin tone', 'factory', 'industrial', 'woman', 'worker'],
			],
			'1f468-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f3ed', '1f468-1f3fc-1f3ed', '1f468-1f3fd-1f3ed', '1f468-1f3fe-1f3ed', '1f468-1f3ff-1f3ed'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'worker'],
			],
			'1f468-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone1:',
				'shortname_alternates' => [':man_factory_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'light skin tone', 'man', 'worker'],
			],
			'1f468-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone2:',
				'shortname_alternates' => [':man_factory_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium-light skin tone', 'worker'],
			],
			'1f468-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone3:',
				'shortname_alternates' => [':man_factory_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium skin tone', 'worker'],
			],
			'1f468-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone4:',
				'shortname_alternates' => [':man_factory_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium-dark skin tone', 'worker'],
			],
			'1f468-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone5:',
				'shortname_alternates' => [':man_factory_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['assembly', 'dark skin tone', 'factory', 'industrial', 'man', 'worker'],
			],
			'1f469-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f4bb', '1f469-1f3fc-1f4bb', '1f469-1f3fd-1f4bb', '1f469-1f3fe-1f4bb', '1f469-1f3ff-1f4bb'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'software', 'technologist', 'woman'],
			],
			'1f469-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone1:',
				'shortname_alternates' => [':woman_technologist_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'light skin tone', 'software', 'technologist', 'woman'],
			],
			'1f469-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone2:',
				'shortname_alternates' => [':woman_technologist_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'medium-light skin tone', 'software', 'technologist', 'woman'],
			],
			'1f469-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone3:',
				'shortname_alternates' => [':woman_technologist_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'medium skin tone', 'software', 'technologist', 'woman'],
			],
			'1f469-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone4:',
				'shortname_alternates' => [':woman_technologist_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'medium-dark skin tone', 'software', 'technologist', 'woman'],
			],
			'1f469-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone5:',
				'shortname_alternates' => [':woman_technologist_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'dark skin tone', 'developer', 'inventor', 'software', 'technologist', 'woman'],
			],
			'1f468-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f4bb', '1f468-1f3fc-1f4bb', '1f468-1f3fd-1f4bb', '1f468-1f3fe-1f4bb', '1f468-1f3ff-1f4bb'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'software', 'technologist'],
			],
			'1f468-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone1:',
				'shortname_alternates' => [':man_technologist_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'light skin tone', 'man', 'software', 'technologist'],
			],
			'1f468-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone2:',
				'shortname_alternates' => [':man_technologist_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium-light skin tone', 'software', 'technologist'],
			],
			'1f468-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone3:',
				'shortname_alternates' => [':man_technologist_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium skin tone', 'software', 'technologist'],
			],
			'1f468-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone4:',
				'shortname_alternates' => [':man_technologist_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium-dark skin tone', 'software', 'technologist'],
			],
			'1f468-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone5:',
				'shortname_alternates' => [':man_technologist_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['coder', 'dark skin tone', 'developer', 'inventor', 'man', 'software', 'technologist'],
			],
			'1f469-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f4bc', '1f469-1f3fc-1f4bc', '1f469-1f3fd-1f4bc', '1f469-1f3fe-1f4bc', '1f469-1f3ff-1f4bc'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'manager', 'office', 'white-collar', 'woman'],
			],
			'1f469-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone1:',
				'shortname_alternates' => [':woman_office_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'light skin tone', 'manager', 'office', 'white-collar', 'woman'],
			],
			'1f469-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone2:',
				'shortname_alternates' => [':woman_office_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'manager', 'medium-light skin tone', 'office', 'white-collar', 'woman'],
			],
			'1f469-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone3:',
				'shortname_alternates' => [':woman_office_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'manager', 'medium skin tone', 'office', 'white-collar', 'woman'],
			],
			'1f469-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone4:',
				'shortname_alternates' => [':woman_office_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'manager', 'medium-dark skin tone', 'office', 'white-collar', 'woman'],
			],
			'1f469-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone5:',
				'shortname_alternates' => [':woman_office_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'dark skin tone', 'manager', 'office', 'white-collar', 'woman'],
			],
			'1f468-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f4bc', '1f468-1f3fc-1f4bc', '1f468-1f3fd-1f4bc', '1f468-1f3fe-1f4bc', '1f468-1f3ff-1f4bc'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'office', 'white-collar'],
			],
			'1f468-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone1:',
				'shortname_alternates' => [':man_office_worker_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'light skin tone', 'man', 'manager', 'office', 'white-collar'],
			],
			'1f468-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone2:',
				'shortname_alternates' => [':man_office_worker_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium-light skin tone', 'office', 'white-collar'],
			],
			'1f468-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone3:',
				'shortname_alternates' => [':man_office_worker_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium skin tone', 'office', 'white-collar'],
			],
			'1f468-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone4:',
				'shortname_alternates' => [':man_office_worker_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium-dark skin tone', 'office', 'white-collar'],
			],
			'1f468-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone5:',
				'shortname_alternates' => [':man_office_worker_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['architect', 'business', 'dark skin tone', 'man', 'manager', 'office', 'white-collar'],
			],
			'1f469-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f527', '1f469-1f3fc-1f527', '1f469-1f3fd-1f527', '1f469-1f3fe-1f527', '1f469-1f3ff-1f527'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'mechanic', 'plumber', 'tradesperson', 'woman'],
			],
			'1f469-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone1:',
				'shortname_alternates' => [':woman_mechanic_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'light skin tone', 'mechanic', 'plumber', 'tradesperson', 'woman'],
			],
			'1f469-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone2:',
				'shortname_alternates' => [':woman_mechanic_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson', 'woman'],
			],
			'1f469-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone3:',
				'shortname_alternates' => [':woman_mechanic_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson', 'woman'],
			],
			'1f469-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone4:',
				'shortname_alternates' => [':woman_mechanic_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson', 'woman'],
			],
			'1f469-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone5:',
				'shortname_alternates' => [':woman_mechanic_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'electrician', 'mechanic', 'plumber', 'tradesperson', 'woman'],
			],
			'1f468-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f527', '1f468-1f3fc-1f527', '1f468-1f3fd-1f527', '1f468-1f3fe-1f527', '1f468-1f3ff-1f527'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'plumber', 'tradesperson'],
			],
			'1f468-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone1:',
				'shortname_alternates' => [':man_mechanic_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'light skin tone', 'man', 'mechanic', 'plumber', 'tradesperson'],
			],
			'1f468-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone2:',
				'shortname_alternates' => [':man_mechanic_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson'],
			],
			'1f468-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone3:',
				'shortname_alternates' => [':man_mechanic_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson'],
			],
			'1f468-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone4:',
				'shortname_alternates' => [':man_mechanic_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson'],
			],
			'1f468-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone5:',
				'shortname_alternates' => [':man_mechanic_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'electrician', 'man', 'mechanic', 'plumber', 'tradesperson'],
			],
			'1f469-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f52c', '1f469-1f3fc-1f52c', '1f469-1f3fd-1f52c', '1f469-1f3fe-1f52c', '1f469-1f3ff-1f52c'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman'],
			],
			'1f469-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone1:',
				'shortname_alternates' => [':woman_scientist_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'light skin tone', 'mathematician', 'physicist', 'scientist', 'woman'],
			],
			'1f469-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone2:',
				'shortname_alternates' => [':woman_scientist_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist', 'woman'],
			],
			'1f469-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone3:',
				'shortname_alternates' => [':woman_scientist_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium skin tone', 'physicist', 'scientist', 'woman'],
			],
			'1f469-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone4:',
				'shortname_alternates' => [':woman_scientist_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist', 'woman'],
			],
			'1f469-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone5:',
				'shortname_alternates' => [':woman_scientist_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'dark skin tone', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman'],
			],
			'1f468-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f52c', '1f468-1f3fc-1f52c', '1f468-1f3fd-1f52c', '1f468-1f3fe-1f52c', '1f468-1f3ff-1f52c'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'physicist', 'scientist'],
			],
			'1f468-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone1:',
				'shortname_alternates' => [':man_scientist_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'light skin tone', 'man', 'mathematician', 'physicist', 'scientist'],
			],
			'1f468-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone2:',
				'shortname_alternates' => [':man_scientist_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist'],
			],
			'1f468-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone3:',
				'shortname_alternates' => [':man_scientist_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium skin tone', 'physicist', 'scientist'],
			],
			'1f468-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone4:',
				'shortname_alternates' => [':man_scientist_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist'],
			],
			'1f468-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone5:',
				'shortname_alternates' => [':man_scientist_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biologist', 'chemist', 'dark skin tone', 'engineer', 'man', 'mathematician', 'physicist', 'scientist'],
			],
			'1f469-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f3a8', '1f469-1f3fc-1f3a8', '1f469-1f3fd-1f3a8', '1f469-1f3fe-1f3a8', '1f469-1f3ff-1f3a8'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'palette', 'woman'],
			],
			'1f469-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone1:',
				'shortname_alternates' => [':woman_artist_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'light skin tone', 'palette', 'woman'],
			],
			'1f469-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone2:',
				'shortname_alternates' => [':woman_artist_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'medium-light skin tone', 'palette', 'woman'],
			],
			'1f469-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone3:',
				'shortname_alternates' => [':woman_artist_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'medium skin tone', 'palette', 'woman'],
			],
			'1f469-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone4:',
				'shortname_alternates' => [':woman_artist_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'medium-dark skin tone', 'palette', 'woman'],
			],
			'1f469-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone5:',
				'shortname_alternates' => [':woman_artist_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'dark skin tone', 'palette', 'woman'],
			],
			'1f468-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f3a8', '1f468-1f3fc-1f3a8', '1f468-1f3fd-1f3a8', '1f468-1f3fe-1f3a8', '1f468-1f3ff-1f3a8'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'man', 'palette'],
			],
			'1f468-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone1:',
				'shortname_alternates' => [':man_artist_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'light skin tone', 'man', 'palette'],
			],
			'1f468-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone2:',
				'shortname_alternates' => [':man_artist_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'man', 'medium-light skin tone', 'palette'],
			],
			'1f468-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone3:',
				'shortname_alternates' => [':man_artist_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'man', 'medium skin tone', 'palette'],
			],
			'1f468-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone4:',
				'shortname_alternates' => [':man_artist_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'man', 'medium-dark skin tone', 'palette'],
			],
			'1f468-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone5:',
				'shortname_alternates' => [':man_artist_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['artist', 'dark skin tone', 'man', 'palette'],
			],
			'1f469-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f692', '1f469-1f3fc-1f692', '1f469-1f3fd-1f692', '1f469-1f3fe-1f692', '1f469-1f3ff-1f692'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'woman'],
			],
			'1f469-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone1:',
				'shortname_alternates' => [':woman_firefighter_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'light skin tone', 'woman'],
			],
			'1f469-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone2:',
				'shortname_alternates' => [':woman_firefighter_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'medium-light skin tone', 'woman'],
			],
			'1f469-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone3:',
				'shortname_alternates' => [':woman_firefighter_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'medium skin tone', 'woman'],
			],
			'1f469-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone4:',
				'shortname_alternates' => [':woman_firefighter_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'medium-dark skin tone', 'woman'],
			],
			'1f469-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone5:',
				'shortname_alternates' => [':woman_firefighter_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'firefighter', 'firetruck', 'woman'],
			],
			'1f468-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f692', '1f468-1f3fc-1f692', '1f468-1f3fd-1f692', '1f468-1f3fe-1f692', '1f468-1f3ff-1f692'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'man'],
			],
			'1f468-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone1:',
				'shortname_alternates' => [':man_firefighter_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'light skin tone', 'man'],
			],
			'1f468-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone2:',
				'shortname_alternates' => [':man_firefighter_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium-light skin tone'],
			],
			'1f468-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone3:',
				'shortname_alternates' => [':man_firefighter_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium skin tone'],
			],
			'1f468-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone4:',
				'shortname_alternates' => [':man_firefighter_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium-dark skin tone'],
			],
			'1f468-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone5:',
				'shortname_alternates' => [':man_firefighter_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'firefighter', 'firetruck', 'man'],
			],
			'1f469-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-2708', '1f469-1f3fc-2708', '1f469-1f3fd-2708', '1f469-1f3fe-2708', '1f469-1f3ff-2708'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pilot', 'plane', 'woman'],
			],
			'1f469-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone1:',
				'shortname_alternates' => [':woman_pilot_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'pilot', 'plane', 'woman'],
			],
			'1f469-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone2:',
				'shortname_alternates' => [':woman_pilot_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'pilot', 'plane', 'woman'],
			],
			'1f469-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone3:',
				'shortname_alternates' => [':woman_pilot_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium skin tone', 'pilot', 'plane', 'woman'],
			],
			'1f469-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone4:',
				'shortname_alternates' => [':woman_pilot_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'pilot', 'plane', 'woman'],
			],
			'1f469-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone5:',
				'shortname_alternates' => [':woman_pilot_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'pilot', 'plane', 'woman'],
			],
			'1f468-2708' => [
				'name' => \XF::phrase('emoji.man_pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-2708', '1f468-1f3fc-2708', '1f468-1f3fd-2708', '1f468-1f3fe-2708', '1f468-1f3ff-2708'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'pilot', 'plane'],
			],
			'1f468-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone1:',
				'shortname_alternates' => [':man_pilot_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'pilot', 'plane'],
			],
			'1f468-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone2:',
				'shortname_alternates' => [':man_pilot_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'pilot', 'plane'],
			],
			'1f468-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone3:',
				'shortname_alternates' => [':man_pilot_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'pilot', 'plane'],
			],
			'1f468-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone4:',
				'shortname_alternates' => [':man_pilot_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'pilot', 'plane'],
			],
			'1f468-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone5:',
				'shortname_alternates' => [':man_pilot_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'pilot', 'plane'],
			],
			'1f469-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-1f680', '1f469-1f3fc-1f680', '1f469-1f3fd-1f680', '1f469-1f3fe-1f680', '1f469-1f3ff-1f680'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'rocket', 'woman'],
			],
			'1f469-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone1:',
				'shortname_alternates' => [':woman_astronaut_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'light skin tone', 'rocket', 'woman'],
			],
			'1f469-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone2:',
				'shortname_alternates' => [':woman_astronaut_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'medium-light skin tone', 'rocket', 'woman'],
			],
			'1f469-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone3:',
				'shortname_alternates' => [':woman_astronaut_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'medium skin tone', 'rocket', 'woman'],
			],
			'1f469-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone4:',
				'shortname_alternates' => [':woman_astronaut_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'medium-dark skin tone', 'rocket', 'woman'],
			],
			'1f469-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone5:',
				'shortname_alternates' => [':woman_astronaut_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'dark skin tone', 'rocket', 'woman'],
			],
			'1f468-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-1f680', '1f468-1f3fc-1f680', '1f468-1f3fd-1f680', '1f468-1f3fe-1f680', '1f468-1f3ff-1f680'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'man', 'rocket'],
			],
			'1f468-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone1:',
				'shortname_alternates' => [':man_astronaut_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'light skin tone', 'man', 'rocket'],
			],
			'1f468-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone2:',
				'shortname_alternates' => [':man_astronaut_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'man', 'medium-light skin tone', 'rocket'],
			],
			'1f468-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone3:',
				'shortname_alternates' => [':man_astronaut_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'man', 'medium skin tone', 'rocket'],
			],
			'1f468-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone4:',
				'shortname_alternates' => [':man_astronaut_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'man', 'medium-dark skin tone', 'rocket'],
			],
			'1f468-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone5:',
				'shortname_alternates' => [':man_astronaut_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['astronaut', 'dark skin tone', 'man', 'rocket'],
			],
			'1f469-2696' => [
				'name' => \XF::phrase('emoji.woman_judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f469-1f3fb-2696', '1f469-1f3fc-2696', '1f469-1f3fd-2696', '1f469-1f3fe-2696', '1f469-1f3ff-2696'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['judge', 'scales', 'woman'],
			],
			'1f469-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone1:',
				'shortname_alternates' => [':woman_judge_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['judge', 'light skin tone', 'scales', 'woman'],
			],
			'1f469-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone2:',
				'shortname_alternates' => [':woman_judge_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['judge', 'medium-light skin tone', 'scales', 'woman'],
			],
			'1f469-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone3:',
				'shortname_alternates' => [':woman_judge_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['judge', 'medium skin tone', 'scales', 'woman'],
			],
			'1f469-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone4:',
				'shortname_alternates' => [':woman_judge_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['judge', 'medium-dark skin tone', 'scales', 'woman'],
			],
			'1f469-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone5:',
				'shortname_alternates' => [':woman_judge_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'judge', 'scales', 'woman'],
			],
			'1f468-2696' => [
				'name' => \XF::phrase('emoji.man_judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f468-1f3fb-2696', '1f468-1f3fc-2696', '1f468-1f3fd-2696', '1f468-1f3fe-2696', '1f468-1f3ff-2696'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['justice', 'man', 'scales'],
			],
			'1f468-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone1:',
				'shortname_alternates' => [':man_judge_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['justice', 'light skin tone', 'man', 'scales'],
			],
			'1f468-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone2:',
				'shortname_alternates' => [':man_judge_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['justice', 'man', 'medium-light skin tone', 'scales'],
			],
			'1f468-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone3:',
				'shortname_alternates' => [':man_judge_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['justice', 'man', 'medium skin tone', 'scales'],
			],
			'1f468-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone4:',
				'shortname_alternates' => [':man_judge_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['justice', 'man', 'medium-dark skin tone', 'scales'],
			],
			'1f468-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone5:',
				'shortname_alternates' => [':man_judge_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'justice', 'man', 'scales'],
			],
			'1f470' => [
				'name' => \XF::phrase('emoji.bride_with_veil'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bride_with_veil:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f470-1f3fb', '1f470-1f3fc', '1f470-1f3fd', '1f470-1f3fe', '1f470-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bride', 'veil', 'wedding'],
			],
			'1f470-1f3fb' => [
				'name' => \XF::phrase('emoji.bride_with_veil_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bride_with_veil_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bride', 'light skin tone', 'veil', 'wedding'],
			],
			'1f470-1f3fc' => [
				'name' => \XF::phrase('emoji.bride_with_veil_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bride_with_veil_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bride', 'medium-light skin tone', 'veil', 'wedding'],
			],
			'1f470-1f3fd' => [
				'name' => \XF::phrase('emoji.bride_with_veil_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bride_with_veil_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bride', 'medium skin tone', 'veil', 'wedding'],
			],
			'1f470-1f3fe' => [
				'name' => \XF::phrase('emoji.bride_with_veil_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bride_with_veil_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bride', 'medium-dark skin tone', 'veil', 'wedding'],
			],
			'1f470-1f3ff' => [
				'name' => \XF::phrase('emoji.bride_with_veil_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bride_with_veil_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bride', 'dark skin tone', 'veil', 'wedding'],
			],
			'1f935' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f935-1f3fb', '1f935-1f3fc', '1f935-1f3fd', '1f935-1f3fe', '1f935-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['groom', 'man', 'tuxedo'],
			],
			'1f935-1f3fb' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone1:',
				'shortname_alternates' => [':tuxedo_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['groom', 'light skin tone', 'man', 'tuxedo'],
			],
			'1f935-1f3fc' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone2:',
				'shortname_alternates' => [':tuxedo_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['groom', 'man', 'medium-light skin tone', 'tuxedo'],
			],
			'1f935-1f3fd' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone3:',
				'shortname_alternates' => [':tuxedo_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['groom', 'man', 'medium skin tone', 'tuxedo'],
			],
			'1f935-1f3fe' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone4:',
				'shortname_alternates' => [':tuxedo_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['groom', 'man', 'medium-dark skin tone', 'tuxedo'],
			],
			'1f935-1f3ff' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone5:',
				'shortname_alternates' => [':tuxedo_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'groom', 'man', 'tuxedo'],
			],
			'1f478' => [
				'name' => \XF::phrase('emoji.princess'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f478-1f3fb', '1f478-1f3fc', '1f478-1f3fd', '1f478-1f3fe', '1f478-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fairy tale', 'fantasy'],
			],
			'1f478-1f3fb' => [
				'name' => \XF::phrase('emoji.princess_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fairy tale', 'fantasy', 'light skin tone'],
			],
			'1f478-1f3fc' => [
				'name' => \XF::phrase('emoji.princess_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fairy tale', 'fantasy', 'medium-light skin tone'],
			],
			'1f478-1f3fd' => [
				'name' => \XF::phrase('emoji.princess_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fairy tale', 'fantasy', 'medium skin tone'],
			],
			'1f478-1f3fe' => [
				'name' => \XF::phrase('emoji.princess_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fairy tale', 'fantasy', 'medium-dark skin tone'],
			],
			'1f478-1f3ff' => [
				'name' => \XF::phrase('emoji.princess_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'fairy tale', 'fantasy'],
			],
			'1f934' => [
				'name' => \XF::phrase('emoji.prince'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f934-1f3fb', '1f934-1f3fc', '1f934-1f3fd', '1f934-1f3fe', '1f934-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['prince'],
			],
			'1f934-1f3fb' => [
				'name' => \XF::phrase('emoji.prince_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'prince'],
			],
			'1f934-1f3fc' => [
				'name' => \XF::phrase('emoji.prince_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'prince'],
			],
			'1f934-1f3fd' => [
				'name' => \XF::phrase('emoji.prince_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium skin tone', 'prince'],
			],
			'1f934-1f3fe' => [
				'name' => \XF::phrase('emoji.prince_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'prince'],
			],
			'1f934-1f3ff' => [
				'name' => \XF::phrase('emoji.prince_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'prince'],
			],
			'1f936' => [
				'name' => \XF::phrase('emoji.mrs_claus'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus:',
				'shortname_alternates' => [':mother_christmas:'],
				'diversity' => '',
				'diversities' => ['1f936-1f3fb', '1f936-1f3fc', '1f936-1f3fd', '1f936-1f3fe', '1f936-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'mother'],
			],
			'1f936-1f3fb' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone1:',
				'shortname_alternates' => [':mother_christmas_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'light skin tone', 'mother'],
			],
			'1f936-1f3fd' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone3:',
				'shortname_alternates' => [':mother_christmas_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium skin tone', 'mother'],
			],
			'1f936-1f3fc' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone2:',
				'shortname_alternates' => [':mother_christmas_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-light skin tone', 'mother'],
			],
			'1f936-1f3fe' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone4:',
				'shortname_alternates' => [':mother_christmas_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-dark skin tone', 'mother'],
			],
			'1f936-1f3ff' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone5:',
				'shortname_alternates' => [':mother_christmas_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'dark skin tone', 'mother'],
			],
			'1f385' => [
				'name' => \XF::phrase('emoji.santa'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f385-1f3fb', '1f385-1f3fc', '1f385-1f3fd', '1f385-1f3fe', '1f385-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'santa'],
			],
			'1f385-1f3fb' => [
				'name' => \XF::phrase('emoji.santa_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'light skin tone', 'santa'],
			],
			'1f385-1f3fc' => [
				'name' => \XF::phrase('emoji.santa_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium-light skin tone', 'santa'],
			],
			'1f385-1f3fd' => [
				'name' => \XF::phrase('emoji.santa_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium skin tone', 'santa'],
			],
			'1f385-1f3fe' => [
				'name' => \XF::phrase('emoji.santa_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium-dark skin tone', 'santa'],
			],
			'1f385-1f3ff' => [
				'name' => \XF::phrase('emoji.santa_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'dark skin tone', 'father', 'santa'],
			],
			'1f9b8' => [
				'name' => \XF::phrase('emoji.superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b8-1f3fb', '1f9b8-1f3fc', '1f9b8-1f3fd', '1f9b8-1f3fe', '1f9b8-1f3ff'],
				'gender' => '',
				'genders' => ['1f9b8-2642', '1f9b8-2640'],
				'keywords' => [''],
			],
			'1f9b8-1f3fb' => [
				'name' => \XF::phrase('emoji.superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone1:',
				'shortname_alternates' => [':superhero_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b8-1f3fb-2642', '1f9b8-1f3fb-2640'],
				'keywords' => [''],
			],
			'1f9b8-1f3fc' => [
				'name' => \XF::phrase('emoji.superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone2:',
				'shortname_alternates' => [':superhero_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b8-1f3fc-2642', '1f9b8-1f3fc-2640'],
				'keywords' => [''],
			],
			'1f9b8-1f3fd' => [
				'name' => \XF::phrase('emoji.superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone3:',
				'shortname_alternates' => [':superhero_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b8-1f3fd-2642', '1f9b8-1f3fd-2640'],
				'keywords' => [''],
			],
			'1f9b8-1f3fe' => [
				'name' => \XF::phrase('emoji.superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone4:',
				'shortname_alternates' => [':superhero_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b8-1f3fe-2642', '1f9b8-1f3fe-2640'],
				'keywords' => [''],
			],
			'1f9b8-1f3ff' => [
				'name' => \XF::phrase('emoji.superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone5:',
				'shortname_alternates' => [':superhero_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b8-1f3ff-2642', '1f9b8-1f3ff-2640'],
				'keywords' => [''],
			],
			'1f9b8-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b8-1f3fb-2640', '1f9b8-1f3fc-2640', '1f9b8-1f3fd-2640', '1f9b8-1f3fe-2640', '1f9b8-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone1:',
				'shortname_alternates' => [':woman_superhero_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone2:',
				'shortname_alternates' => [':woman_superhero_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone3:',
				'shortname_alternates' => [':woman_superhero_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone4:',
				'shortname_alternates' => [':woman_superhero_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone5:',
				'shortname_alternates' => [':woman_superhero_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-2642' => [
				'name' => \XF::phrase('emoji.man_superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b8-1f3fb-2642', '1f9b8-1f3fc-2642', '1f9b8-1f3fd-2642', '1f9b8-1f3fe-2642', '1f9b8-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone1:',
				'shortname_alternates' => [':man_superhero_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone2:',
				'shortname_alternates' => [':man_superhero_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone3:',
				'shortname_alternates' => [':man_superhero_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone4:',
				'shortname_alternates' => [':man_superhero_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b8-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone5:',
				'shortname_alternates' => [':man_superhero_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9' => [
				'name' => \XF::phrase('emoji.supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b9-1f3fb', '1f9b9-1f3fc', '1f9b9-1f3fd', '1f9b9-1f3fe', '1f9b9-1f3ff'],
				'gender' => '',
				'genders' => ['1f9b9-2642', '1f9b9-2640'],
				'keywords' => [''],
			],
			'1f9b9-1f3fb' => [
				'name' => \XF::phrase('emoji.supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone1:',
				'shortname_alternates' => [':supervillain_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b9-1f3fb-2642', '1f9b9-1f3fb-2640'],
				'keywords' => [''],
			],
			'1f9b9-1f3fc' => [
				'name' => \XF::phrase('emoji.supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone2:',
				'shortname_alternates' => [':supervillain_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b9-1f3fc-2642', '1f9b9-1f3fc-2640'],
				'keywords' => [''],
			],
			'1f9b9-1f3fd' => [
				'name' => \XF::phrase('emoji.supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone3:',
				'shortname_alternates' => [':supervillain_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b9-1f3fd-2642', '1f9b9-1f3fd-2640'],
				'keywords' => [''],
			],
			'1f9b9-1f3fe' => [
				'name' => \XF::phrase('emoji.supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone4:',
				'shortname_alternates' => [':supervillain_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b9-1f3fe-2642', '1f9b9-1f3fe-2640'],
				'keywords' => [''],
			],
			'1f9b9-1f3ff' => [
				'name' => \XF::phrase('emoji.supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone5:',
				'shortname_alternates' => [':supervillain_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9b9-1f3ff-2642', '1f9b9-1f3ff-2640'],
				'keywords' => [''],
			],
			'1f9b9-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone1:',
				'shortname_alternates' => [':woman_supervillain_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b9-1f3fb-2640', '1f9b9-1f3fc-2640', '1f9b9-1f3fd-2640', '1f9b9-1f3fe-2640', '1f9b9-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone2:',
				'shortname_alternates' => [':woman_supervillain_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone3:',
				'shortname_alternates' => [':woman_supervillain_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone4:',
				'shortname_alternates' => [':woman_supervillain_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone5:',
				'shortname_alternates' => [':woman_supervillain_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9b9-1f3fb-2642', '1f9b9-1f3fc-2642', '1f9b9-1f3fd-2642', '1f9b9-1f3fe-2642', '1f9b9-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone1:',
				'shortname_alternates' => [':man_supervillain_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone2:',
				'shortname_alternates' => [':man_supervillain_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone3:',
				'shortname_alternates' => [':man_supervillain_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone4:',
				'shortname_alternates' => [':man_supervillain_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b9-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone5:',
				'shortname_alternates' => [':man_supervillain_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9d9' => [
				'name' => \XF::phrase('emoji.mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d9-1f3fb', '1f9d9-1f3fc', '1f9d9-1f3fd', '1f9d9-1f3fe', '1f9d9-1f3ff'],
				'gender' => '',
				'genders' => ['1f9d9-2642', '1f9d9-2640'],
				'keywords' => ['sorcerer', 'sorceress', 'witch', 'wizard'],
			],
			'1f9d9-1f3fb' => [
				'name' => \XF::phrase('emoji.mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone1:',
				'shortname_alternates' => [':mage_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d9-1f3fb-2642', '1f9d9-1f3fb-2640'],
				'keywords' => ['light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard'],
			],
			'1f9d9-1f3fc' => [
				'name' => \XF::phrase('emoji.mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone2:',
				'shortname_alternates' => [':mage_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d9-1f3fc-2642', '1f9d9-1f3fc-2640'],
				'keywords' => ['medium-light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard'],
			],
			'1f9d9-1f3fd' => [
				'name' => \XF::phrase('emoji.mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone3:',
				'shortname_alternates' => [':mage_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d9-1f3fd-2642', '1f9d9-1f3fd-2640'],
				'keywords' => ['medium skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard'],
			],
			'1f9d9-1f3fe' => [
				'name' => \XF::phrase('emoji.mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone4:',
				'shortname_alternates' => [':mage_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d9-1f3fe-2642', '1f9d9-1f3fe-2640'],
				'keywords' => ['medium-dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard'],
			],
			'1f9d9-1f3ff' => [
				'name' => \XF::phrase('emoji.mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone5:',
				'shortname_alternates' => [':mage_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d9-1f3ff-2642', '1f9d9-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard'],
			],
			'1f9d9-2640' => [
				'name' => \XF::phrase('emoji.woman_mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d9-1f3fb-2640', '1f9d9-1f3fc-2640', '1f9d9-1f3fd-2640', '1f9d9-1f3fe-2640', '1f9d9-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['sorceress', 'witch'],
			],
			'1f9d9-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone1:',
				'shortname_alternates' => [':woman_mage_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'sorceress', 'witch'],
			],
			'1f9d9-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone2:',
				'shortname_alternates' => [':woman_mage_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'sorceress', 'witch'],
			],
			'1f9d9-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone3:',
				'shortname_alternates' => [':woman_mage_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'sorceress', 'witch'],
			],
			'1f9d9-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone4:',
				'shortname_alternates' => [':woman_mage_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'sorceress', 'witch'],
			],
			'1f9d9-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone5:',
				'shortname_alternates' => [':woman_mage_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'sorceress', 'witch'],
			],
			'1f9d9-2642' => [
				'name' => \XF::phrase('emoji.man_mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d9-1f3fb-2642', '1f9d9-1f3fc-2642', '1f9d9-1f3fd-2642', '1f9d9-1f3fe-2642', '1f9d9-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['sorcerer', 'wizard'],
			],
			'1f9d9-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone1:',
				'shortname_alternates' => [':man_mage_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'sorcerer', 'wizard'],
			],
			'1f9d9-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone2:',
				'shortname_alternates' => [':man_mage_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'sorcerer', 'wizard'],
			],
			'1f9d9-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone3:',
				'shortname_alternates' => [':man_mage_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['medium skin tone', 'sorcerer', 'wizard'],
			],
			'1f9d9-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone4:',
				'shortname_alternates' => [':man_mage_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'sorcerer', 'wizard'],
			],
			'1f9d9-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone5:',
				'shortname_alternates' => [':man_mage_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'sorcerer', 'wizard'],
			],
			'1f9dd' => [
				'name' => \XF::phrase('emoji.elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9dd-1f3fb', '1f9dd-1f3fc', '1f9dd-1f3fd', '1f9dd-1f3fe', '1f9dd-1f3ff'],
				'gender' => '',
				'genders' => ['1f9dd-2642', '1f9dd-2640'],
				'keywords' => [''],
			],
			'1f9dd-1f3fb' => [
				'name' => \XF::phrase('emoji.elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone1:',
				'shortname_alternates' => [':elf_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dd-1f3fb-2642', '1f9dd-1f3fb-2640'],
				'keywords' => ['light skin tone', 'magical'],
			],
			'1f9dd-1f3fc' => [
				'name' => \XF::phrase('emoji.elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone2:',
				'shortname_alternates' => [':elf_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dd-1f3fc-2642', '1f9dd-1f3fc-2640'],
				'keywords' => ['magical', 'medium-light skin tone'],
			],
			'1f9dd-1f3fd' => [
				'name' => \XF::phrase('emoji.elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone3:',
				'shortname_alternates' => [':elf_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dd-1f3fd-2642', '1f9dd-1f3fd-2640'],
				'keywords' => ['magical', 'medium skin tone'],
			],
			'1f9dd-1f3fe' => [
				'name' => \XF::phrase('emoji.elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone4:',
				'shortname_alternates' => [':elf_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dd-1f3fe-2642', '1f9dd-1f3fe-2640'],
				'keywords' => ['magical', 'medium-dark skin tone'],
			],
			'1f9dd-1f3ff' => [
				'name' => \XF::phrase('emoji.elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone5:',
				'shortname_alternates' => [':elf_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dd-1f3ff-2642', '1f9dd-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'magical'],
			],
			'1f9dd-2640' => [
				'name' => \XF::phrase('emoji.woman_elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9dd-1f3fb-2640', '1f9dd-1f3fc-2640', '1f9dd-1f3fd-2640', '1f9dd-1f3fe-2640', '1f9dd-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['magical'],
			],
			'1f9dd-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone1:',
				'shortname_alternates' => [':woman_elf_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'magical'],
			],
			'1f9dd-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone2:',
				'shortname_alternates' => [':woman_elf_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['magical', 'medium-light skin tone'],
			],
			'1f9dd-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone3:',
				'shortname_alternates' => [':woman_elf_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['magical', 'medium skin tone'],
			],
			'1f9dd-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone4:',
				'shortname_alternates' => [':woman_elf_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['magical', 'medium-dark skin tone'],
			],
			'1f9dd-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone5:',
				'shortname_alternates' => [':woman_elf_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'magical'],
			],
			'1f9dd-2642' => [
				'name' => \XF::phrase('emoji.man_elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9dd-1f3fb-2642', '1f9dd-1f3fc-2642', '1f9dd-1f3fd-2642', '1f9dd-1f3fe-2642', '1f9dd-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['magical'],
			],
			'1f9dd-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone1:',
				'shortname_alternates' => [':man_elf_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'magical'],
			],
			'1f9dd-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone2:',
				'shortname_alternates' => [':man_elf_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['magical', 'medium-light skin tone'],
			],
			'1f9dd-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone3:',
				'shortname_alternates' => [':man_elf_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['magical', 'medium skin tone'],
			],
			'1f9dd-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone4:',
				'shortname_alternates' => [':man_elf_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['magical', 'medium-dark skin tone'],
			],
			'1f9dd-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone5:',
				'shortname_alternates' => [':man_elf_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'magical'],
			],
			'1f9db' => [
				'name' => \XF::phrase('emoji.vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9db-1f3fb', '1f9db-1f3fc', '1f9db-1f3fd', '1f9db-1f3fe', '1f9db-1f3ff'],
				'gender' => '',
				'genders' => ['1f9db-2642', '1f9db-2640'],
				'keywords' => ['Dracula', 'undead'],
			],
			'1f9db-1f3fb' => [
				'name' => \XF::phrase('emoji.vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone1:',
				'shortname_alternates' => [':vampire_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9db-1f3fb-2642', '1f9db-1f3fb-2640'],
				'keywords' => ['Dracula', 'light skin tone', 'undead'],
			],
			'1f9db-1f3fc' => [
				'name' => \XF::phrase('emoji.vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone2:',
				'shortname_alternates' => [':vampire_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9db-1f3fc-2642', '1f9db-1f3fc-2640'],
				'keywords' => ['Dracula', 'medium-light skin tone', 'undead'],
			],
			'1f9db-1f3fd' => [
				'name' => \XF::phrase('emoji.vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone3:',
				'shortname_alternates' => [':vampire_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9db-1f3fd-2642', '1f9db-1f3fd-2640'],
				'keywords' => ['Dracula', 'medium skin tone', 'undead'],
			],
			'1f9db-1f3fe' => [
				'name' => \XF::phrase('emoji.vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone4:',
				'shortname_alternates' => [':vampire_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9db-1f3fe-2642', '1f9db-1f3fe-2640'],
				'keywords' => ['Dracula', 'medium-dark skin tone', 'undead'],
			],
			'1f9db-1f3ff' => [
				'name' => \XF::phrase('emoji.vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone5:',
				'shortname_alternates' => [':vampire_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9db-1f3ff-2642', '1f9db-1f3ff-2640'],
				'keywords' => ['Dracula', 'dark skin tone', 'undead'],
			],
			'1f9db-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9db-1f3fb-2640', '1f9db-1f3fc-2640', '1f9db-1f3fd-2640', '1f9db-1f3fe-2640', '1f9db-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['undead'],
			],
			'1f9db-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone1:',
				'shortname_alternates' => [':woman_vampire_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'undead'],
			],
			'1f9db-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone2:',
				'shortname_alternates' => [':woman_vampire_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'undead'],
			],
			'1f9db-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone3:',
				'shortname_alternates' => [':woman_vampire_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'undead'],
			],
			'1f9db-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone4:',
				'shortname_alternates' => [':woman_vampire_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'undead'],
			],
			'1f9db-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone5:',
				'shortname_alternates' => [':woman_vampire_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'undead'],
			],
			'1f9db-2642' => [
				'name' => \XF::phrase('emoji.man_vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9db-1f3fb-2642', '1f9db-1f3fc-2642', '1f9db-1f3fd-2642', '1f9db-1f3fe-2642', '1f9db-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Dracula', 'undead'],
			],
			'1f9db-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone1:',
				'shortname_alternates' => [':man_vampire_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Dracula', 'light skin tone', 'undead'],
			],
			'1f9db-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone2:',
				'shortname_alternates' => [':man_vampire_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Dracula', 'medium-light skin tone', 'undead'],
			],
			'1f9db-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone3:',
				'shortname_alternates' => [':man_vampire_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Dracula', 'medium skin tone', 'undead'],
			],
			'1f9db-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone4:',
				'shortname_alternates' => [':man_vampire_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Dracula', 'medium-dark skin tone', 'undead'],
			],
			'1f9db-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone5:',
				'shortname_alternates' => [':man_vampire_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Dracula', 'dark skin tone', 'undead'],
			],
			'1f9df' => [
				'name' => \XF::phrase('emoji.zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zombie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9df-2642', '1f9df-2640'],
				'keywords' => [''],
			],
			'1f9df-2640' => [
				'name' => \XF::phrase('emoji.woman_zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_zombie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['undead', 'walking dead'],
			],
			'1f9df-2642' => [
				'name' => \XF::phrase('emoji.man_zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_zombie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['undead', 'walking dead'],
			],
			'1f9de' => [
				'name' => \XF::phrase('emoji.genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':genie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9de-2642', '1f9de-2640'],
				'keywords' => [''],
			],
			'1f9de-2640' => [
				'name' => \XF::phrase('emoji.woman_genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_genie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['djinn'],
			],
			'1f9de-2642' => [
				'name' => \XF::phrase('emoji.man_genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_genie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['djinn'],
			],
			'1f9dc' => [
				'name' => \XF::phrase('emoji.merperson'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9dc-1f3fb', '1f9dc-1f3fc', '1f9dc-1f3fd', '1f9dc-1f3fe', '1f9dc-1f3ff'],
				'gender' => '',
				'genders' => ['1f9dc-2642'],
				'keywords' => ['mermaid', 'merman', 'merwoman'],
			],
			'1f9dc-1f3fb' => [
				'name' => \XF::phrase('emoji.merperson_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone1:',
				'shortname_alternates' => [':merperson_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dc-1f3fb-2642'],
				'keywords' => ['light skin tone', 'mermaid', 'merman', 'merwoman'],
			],
			'1f9dc-1f3fc' => [
				'name' => \XF::phrase('emoji.merperson_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone2:',
				'shortname_alternates' => [':merperson_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dc-1f3fc-2642'],
				'keywords' => ['medium-light skin tone', 'mermaid', 'merman', 'merwoman'],
			],
			'1f9dc-1f3fd' => [
				'name' => \XF::phrase('emoji.merperson_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone3:',
				'shortname_alternates' => [':merperson_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dc-1f3fd-2642'],
				'keywords' => ['medium skin tone', 'mermaid', 'merman', 'merwoman'],
			],
			'1f9dc-1f3fe' => [
				'name' => \XF::phrase('emoji.merperson_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone4:',
				'shortname_alternates' => [':merperson_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dc-1f3fe-2642'],
				'keywords' => ['medium-dark skin tone', 'mermaid', 'merman', 'merwoman'],
			],
			'1f9dc-1f3ff' => [
				'name' => \XF::phrase('emoji.merperson_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone5:',
				'shortname_alternates' => [':merperson_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9dc-1f3ff-2642'],
				'keywords' => ['dark skin tone', 'mermaid', 'merman', 'merwoman'],
			],
			'1f9dc-2640' => [
				'name' => \XF::phrase('emoji.mermaid'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9dc-1f3fb-2640', '1f9dc-1f3fc-2640', '1f9dc-1f3fd-2640', '1f9dc-1f3fe-2640', '1f9dc-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['merwoman'],
			],
			'1f9dc-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone1:',
				'shortname_alternates' => [':mermaid_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'merwoman'],
			],
			'1f9dc-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone2:',
				'shortname_alternates' => [':mermaid_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'merwoman'],
			],
			'1f9dc-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone3:',
				'shortname_alternates' => [':mermaid_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'merwoman'],
			],
			'1f9dc-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone4:',
				'shortname_alternates' => [':mermaid_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'merwoman'],
			],
			'1f9dc-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone5:',
				'shortname_alternates' => [':mermaid_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'merwoman'],
			],
			'1f9dc-2642' => [
				'name' => \XF::phrase('emoji.merman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9dc-1f3fb-2642', '1f9dc-1f3fc-2642', '1f9dc-1f3fd-2642', '1f9dc-1f3fe-2642', '1f9dc-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Triton'],
			],
			'1f9dc-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.merman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone1:',
				'shortname_alternates' => [':merman_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Triton', 'light skin tone'],
			],
			'1f9dc-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.merman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone2:',
				'shortname_alternates' => [':merman_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Triton', 'medium-light skin tone'],
			],
			'1f9dc-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.merman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone3:',
				'shortname_alternates' => [':merman_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Triton', 'medium skin tone'],
			],
			'1f9dc-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.merman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone4:',
				'shortname_alternates' => [':merman_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Triton', 'medium-dark skin tone'],
			],
			'1f9dc-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.merman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone5:',
				'shortname_alternates' => [':merman_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Triton', 'dark skin tone'],
			],
			'1f9da' => [
				'name' => \XF::phrase('emoji.fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9da-1f3fb', '1f9da-1f3fc', '1f9da-1f3fd', '1f9da-1f3fe', '1f9da-1f3ff'],
				'gender' => '',
				'genders' => ['1f9da-2642', '1f9da-2640'],
				'keywords' => ['Oberon', 'Puck', 'Titania'],
			],
			'1f9da-1f3fb' => [
				'name' => \XF::phrase('emoji.fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone1:',
				'shortname_alternates' => [':fairy_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9da-1f3fb-2642', '1f9da-1f3fb-2640'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'light skin tone'],
			],
			'1f9da-1f3fc' => [
				'name' => \XF::phrase('emoji.fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone2:',
				'shortname_alternates' => [':fairy_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9da-1f3fc-2642', '1f9da-1f3fc-2640'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium-light skin tone'],
			],
			'1f9da-1f3fd' => [
				'name' => \XF::phrase('emoji.fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone3:',
				'shortname_alternates' => [':fairy_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9da-1f3fd-2642', '1f9da-1f3fd-2640'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium skin tone'],
			],
			'1f9da-1f3fe' => [
				'name' => \XF::phrase('emoji.fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone4:',
				'shortname_alternates' => [':fairy_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9da-1f3fe-2642', '1f9da-1f3fe-2640'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium-dark skin tone'],
			],
			'1f9da-1f3ff' => [
				'name' => \XF::phrase('emoji.fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone5:',
				'shortname_alternates' => [':fairy_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9da-1f3ff-2642', '1f9da-1f3ff-2640'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'dark skin tone'],
			],
			'1f9da-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9da-1f3fb-2640', '1f9da-1f3fc-2640', '1f9da-1f3fd-2640', '1f9da-1f3fe-2640', '1f9da-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['Titania'],
			],
			'1f9da-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone1:',
				'shortname_alternates' => [':woman_fairy_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['Titania', 'light skin tone'],
			],
			'1f9da-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone2:',
				'shortname_alternates' => [':woman_fairy_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['Titania', 'medium-light skin tone'],
			],
			'1f9da-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone3:',
				'shortname_alternates' => [':woman_fairy_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['Titania', 'medium skin tone'],
			],
			'1f9da-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone4:',
				'shortname_alternates' => [':woman_fairy_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['Titania', 'medium-dark skin tone'],
			],
			'1f9da-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone5:',
				'shortname_alternates' => [':woman_fairy_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['Titania', 'dark skin tone'],
			],
			'1f9da-2642' => [
				'name' => \XF::phrase('emoji.man_fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9da-1f3fb-2642', '1f9da-1f3fc-2642', '1f9da-1f3fd-2642', '1f9da-1f3fe-2642', '1f9da-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Oberon', 'Puck'],
			],
			'1f9da-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone1:',
				'shortname_alternates' => [':man_fairy_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Oberon', 'Puck', 'light skin tone'],
			],
			'1f9da-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone2:',
				'shortname_alternates' => [':man_fairy_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Oberon', 'Puck', 'medium-light skin tone'],
			],
			'1f9da-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone3:',
				'shortname_alternates' => [':man_fairy_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Oberon', 'Puck', 'medium skin tone'],
			],
			'1f9da-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone4:',
				'shortname_alternates' => [':man_fairy_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Oberon', 'Puck', 'medium-dark skin tone'],
			],
			'1f9da-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone5:',
				'shortname_alternates' => [':man_fairy_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['Oberon', 'Puck', 'dark skin tone'],
			],
			'1f47c' => [
				'name' => \XF::phrase('emoji.angel'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f47c-1f3fb', '1f47c-1f3fc', '1f47c-1f3fd', '1f47c-1f3fe', '1f47c-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy'],
			],
			'1f47c-1f3fb' => [
				'name' => \XF::phrase('emoji.angel_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'light skin tone'],
			],
			'1f47c-1f3fc' => [
				'name' => \XF::phrase('emoji.angel_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-light skin tone'],
			],
			'1f47c-1f3fd' => [
				'name' => \XF::phrase('emoji.angel_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium skin tone'],
			],
			'1f47c-1f3fe' => [
				'name' => \XF::phrase('emoji.angel_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-dark skin tone'],
			],
			'1f47c-1f3ff' => [
				'name' => \XF::phrase('emoji.angel_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angel', 'baby', 'dark skin tone', 'face', 'fairy tale', 'fantasy'],
			],
			'1f930' => [
				'name' => \XF::phrase('emoji.pregnant_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman:',
				'shortname_alternates' => [':expecting_woman:'],
				'diversity' => '',
				'diversities' => ['1f930-1f3fb', '1f930-1f3fc', '1f930-1f3fd', '1f930-1f3fe', '1f930-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pregnant', 'woman'],
			],
			'1f930-1f3fb' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone1:',
				'shortname_alternates' => [':expecting_woman_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'pregnant', 'woman'],
			],
			'1f930-1f3fc' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone2:',
				'shortname_alternates' => [':expecting_woman_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'pregnant', 'woman'],
			],
			'1f930-1f3fd' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone3:',
				'shortname_alternates' => [':expecting_woman_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium skin tone', 'pregnant', 'woman'],
			],
			'1f930-1f3fe' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone4:',
				'shortname_alternates' => [':expecting_woman_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'pregnant', 'woman'],
			],
			'1f930-1f3ff' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone5:',
				'shortname_alternates' => [':expecting_woman_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'pregnant', 'woman'],
			],
			'1f931' => [
				'name' => \XF::phrase('emoji.breast_feeding'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f931-1f3fb', '1f931-1f3fc', '1f931-1f3fd', '1f931-1f3fe', '1f931-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'breast', 'nursing'],
			],
			'1f931-1f3fb' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone1:',
				'shortname_alternates' => [':breast_feeding_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'breast', 'light skin tone', 'nursing'],
			],
			'1f931-1f3fc' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone2:',
				'shortname_alternates' => [':breast_feeding_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'breast', 'medium-light skin tone', 'nursing'],
			],
			'1f931-1f3fd' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone3:',
				'shortname_alternates' => [':breast_feeding_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'breast', 'medium skin tone', 'nursing'],
			],
			'1f931-1f3fe' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone4:',
				'shortname_alternates' => [':breast_feeding_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'breast', 'medium-dark skin tone', 'nursing'],
			],
			'1f931-1f3ff' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone5:',
				'shortname_alternates' => [':breast_feeding_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'breast', 'dark skin tone', 'nursing'],
			],
			'1f647' => [
				'name' => \XF::phrase('emoji.person_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing:',
				'shortname_alternates' => [':bow:'],
				'diversity' => '',
				'diversities' => ['1f647-1f3fb', '1f647-1f3fc', '1f647-1f3fd', '1f647-1f3fe', '1f647-1f3ff'],
				'gender' => '',
				'genders' => ['1f647-2642', '1f647-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'sorry'],
			],
			'1f647-1f3fb' => [
				'name' => \XF::phrase('emoji.person_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone1:',
				'shortname_alternates' => [':bow_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f647-1f3fb-2642', '1f647-1f3fb-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'light skin tone', 'sorry'],
			],
			'1f647-1f3fc' => [
				'name' => \XF::phrase('emoji.person_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone2:',
				'shortname_alternates' => [':bow_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f647-1f3fc-2642', '1f647-1f3fc-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'medium-light skin tone', 'sorry'],
			],
			'1f647-1f3fd' => [
				'name' => \XF::phrase('emoji.person_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone3:',
				'shortname_alternates' => [':bow_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f647-1f3fd-2642', '1f647-1f3fd-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'medium skin tone', 'sorry'],
			],
			'1f647-1f3fe' => [
				'name' => \XF::phrase('emoji.person_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone4:',
				'shortname_alternates' => [':bow_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f647-1f3fe-2642', '1f647-1f3fe-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'medium-dark skin tone', 'sorry'],
			],
			'1f647-1f3ff' => [
				'name' => \XF::phrase('emoji.person_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone5:',
				'shortname_alternates' => [':bow_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f647-1f3ff-2642', '1f647-1f3ff-2640'],
				'keywords' => ['apology', 'bow', 'dark skin tone', 'gesture', 'sorry'],
			],
			'1f647-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f647-1f3fb-2640', '1f647-1f3fc-2640', '1f647-1f3fd-2640', '1f647-1f3fe-2640', '1f647-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'sorry', 'woman'],
			],
			'1f647-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone1:',
				'shortname_alternates' => [':woman_bowing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'sorry', 'woman'],
			],
			'1f647-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone2:',
				'shortname_alternates' => [':woman_bowing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium-light skin tone', 'sorry', 'woman'],
			],
			'1f647-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone3:',
				'shortname_alternates' => [':woman_bowing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium skin tone', 'sorry', 'woman'],
			],
			'1f647-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone4:',
				'shortname_alternates' => [':woman_bowing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium-dark skin tone', 'sorry', 'woman'],
			],
			'1f647-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone5:',
				'shortname_alternates' => [':woman_bowing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'sorry', 'woman'],
			],
			'1f647-2642' => [
				'name' => \XF::phrase('emoji.man_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f647-1f3fb-2642', '1f647-1f3fc-2642', '1f647-1f3fd-2642', '1f647-1f3fe-2642', '1f647-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'sorry'],
			],
			'1f647-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone1:',
				'shortname_alternates' => [':man_bowing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'man', 'sorry'],
			],
			'1f647-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone2:',
				'shortname_alternates' => [':man_bowing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-light skin tone', 'sorry'],
			],
			'1f647-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone3:',
				'shortname_alternates' => [':man_bowing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium skin tone', 'sorry'],
			],
			'1f647-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone4:',
				'shortname_alternates' => [':man_bowing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-dark skin tone', 'sorry'],
			],
			'1f647-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone5:',
				'shortname_alternates' => [':man_bowing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'man', 'sorry'],
			],
			'1f481' => [
				'name' => \XF::phrase('emoji.person_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand:',
				'shortname_alternates' => [':information_desk_person:'],
				'diversity' => '',
				'diversities' => ['1f481-1f3fb', '1f481-1f3fc', '1f481-1f3fd', '1f481-1f3fe', '1f481-1f3ff'],
				'gender' => '',
				'genders' => ['1f481-2642', '1f481-2640'],
				'keywords' => ['hand', 'help', 'information', 'sassy', 'tipping'],
			],
			'1f481-1f3fb' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone1:',
				'shortname_alternates' => [':information_desk_person_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f481-1f3fb-2642', '1f481-1f3fb-2640'],
				'keywords' => ['hand', 'help', 'information', 'light skin tone', 'sassy', 'tipping'],
			],
			'1f481-1f3fc' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone2:',
				'shortname_alternates' => [':information_desk_person_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f481-1f3fc-2642', '1f481-1f3fc-2640'],
				'keywords' => ['hand', 'help', 'information', 'medium-light skin tone', 'sassy', 'tipping'],
			],
			'1f481-1f3fd' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone3:',
				'shortname_alternates' => [':information_desk_person_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f481-1f3fd-2642', '1f481-1f3fd-2640'],
				'keywords' => ['hand', 'help', 'information', 'medium skin tone', 'sassy', 'tipping'],
			],
			'1f481-1f3fe' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone4:',
				'shortname_alternates' => [':information_desk_person_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f481-1f3fe-2642', '1f481-1f3fe-2640'],
				'keywords' => ['hand', 'help', 'information', 'medium-dark skin tone', 'sassy', 'tipping'],
			],
			'1f481-1f3ff' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone5:',
				'shortname_alternates' => [':information_desk_person_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f481-1f3ff-2642', '1f481-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'hand', 'help', 'information', 'sassy', 'tipping'],
			],
			'1f481-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f481-1f3fb-2640', '1f481-1f3fc-2640', '1f481-1f3fd-2640', '1f481-1f3fe-2640', '1f481-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['sassy', 'tipping hand', 'woman'],
			],
			'1f481-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone1:',
				'shortname_alternates' => [':woman_tipping_hand_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'sassy', 'tipping hand', 'woman'],
			],
			'1f481-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone2:',
				'shortname_alternates' => [':woman_tipping_hand_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'sassy', 'tipping hand', 'woman'],
			],
			'1f481-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone3:',
				'shortname_alternates' => [':woman_tipping_hand_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'sassy', 'tipping hand', 'woman'],
			],
			'1f481-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone4:',
				'shortname_alternates' => [':woman_tipping_hand_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'sassy', 'tipping hand', 'woman'],
			],
			'1f481-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone5:',
				'shortname_alternates' => [':woman_tipping_hand_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'sassy', 'tipping hand', 'woman'],
			],
			'1f481-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f481-1f3fb-2642', '1f481-1f3fc-2642', '1f481-1f3fd-2642', '1f481-1f3fe-2642', '1f481-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'sassy', 'tipping hand'],
			],
			'1f481-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone1:',
				'shortname_alternates' => [':man_tipping_hand_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'sassy', 'tipping hand'],
			],
			'1f481-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone2:',
				'shortname_alternates' => [':man_tipping_hand_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'sassy', 'tipping hand'],
			],
			'1f481-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone3:',
				'shortname_alternates' => [':man_tipping_hand_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'sassy', 'tipping hand'],
			],
			'1f481-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone4:',
				'shortname_alternates' => [':man_tipping_hand_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'sassy', 'tipping hand'],
			],
			'1f481-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone5:',
				'shortname_alternates' => [':man_tipping_hand_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'sassy', 'tipping hand'],
			],
			'1f645' => [
				'name' => \XF::phrase('emoji.person_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no:',
				'shortname_alternates' => [':no_good:'],
				'diversity' => '',
				'diversities' => ['1f645-1f3fb', '1f645-1f3fc', '1f645-1f3fd', '1f645-1f3fe', '1f645-1f3ff'],
				'gender' => '',
				'genders' => ['1f645-2642', '1f645-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited'],
			],
			'1f645-1f3fb' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone1:',
				'shortname_alternates' => [':no_good_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f645-1f3fb-2642', '1f645-1f3fb-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'not', 'prohibited'],
			],
			'1f645-1f3fc' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone2:',
				'shortname_alternates' => [':no_good_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f645-1f3fc-2642', '1f645-1f3fc-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'not', 'prohibited'],
			],
			'1f645-1f3fd' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone3:',
				'shortname_alternates' => [':no_good_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f645-1f3fd-2642', '1f645-1f3fd-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'not', 'prohibited'],
			],
			'1f645-1f3fe' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone4:',
				'shortname_alternates' => [':no_good_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f645-1f3fe-2642', '1f645-1f3fe-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'not', 'prohibited'],
			],
			'1f645-1f3ff' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone5:',
				'shortname_alternates' => [':no_good_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f645-1f3ff-2642', '1f645-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited'],
			],
			'1f645-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f645-1f3fb-2640', '1f645-1f3fc-2640', '1f645-1f3fd-2640', '1f645-1f3fe-2640', '1f645-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman'],
			],
			'1f645-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone1:',
				'shortname_alternates' => [':woman_gesturing_no_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'prohibited', 'woman'],
			],
			'1f645-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone2:',
				'shortname_alternates' => [':woman_gesturing_no_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'prohibited', 'woman'],
			],
			'1f645-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone3:',
				'shortname_alternates' => [':woman_gesturing_no_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'prohibited', 'woman'],
			],
			'1f645-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone4:',
				'shortname_alternates' => [':woman_gesturing_no_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'prohibited', 'woman'],
			],
			'1f645-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone5:',
				'shortname_alternates' => [':woman_gesturing_no_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman'],
			],
			'1f645-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f645-1f3fb-2642', '1f645-1f3fc-2642', '1f645-1f3fd-2642', '1f645-1f3fe-2642', '1f645-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited'],
			],
			'1f645-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone1:',
				'shortname_alternates' => [':man_gesturing_no_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'man', 'no', 'prohibited'],
			],
			'1f645-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone2:',
				'shortname_alternates' => [':man_gesturing_no_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium-light skin tone', 'no', 'prohibited'],
			],
			'1f645-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone3:',
				'shortname_alternates' => [':man_gesturing_no_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium skin tone', 'no', 'prohibited'],
			],
			'1f645-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone4:',
				'shortname_alternates' => [':man_gesturing_no_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium-dark skin tone', 'no', 'prohibited'],
			],
			'1f645-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone5:',
				'shortname_alternates' => [':man_gesturing_no_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited'],
			],
			'1f646' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok:',
				'shortname_alternates' => [':ok_woman:'],
				'diversity' => '',
				'diversities' => ['1f646-1f3fb', '1f646-1f3fc', '1f646-1f3fd', '1f646-1f3fe', '1f646-1f3ff'],
				'gender' => '',
				'genders' => ['1f646-2642', '1f646-2640'],
				'keywords' => ['OK', 'gesture', 'hand'],
			],
			'1f646-1f3fb' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone1:',
				'shortname_alternates' => [':ok_woman_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f646-1f3fb-2642', '1f646-1f3fb-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone'],
			],
			'1f646-1f3fc' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone2:',
				'shortname_alternates' => [':ok_woman_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f646-1f3fc-2642', '1f646-1f3fc-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-light skin tone'],
			],
			'1f646-1f3fd' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone3:',
				'shortname_alternates' => [':ok_woman_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f646-1f3fd-2642', '1f646-1f3fd-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'medium skin tone'],
			],
			'1f646-1f3fe' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone4:',
				'shortname_alternates' => [':ok_woman_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f646-1f3fe-2642', '1f646-1f3fe-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-dark skin tone'],
			],
			'1f646-1f3ff' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone5:',
				'shortname_alternates' => [':ok_woman_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f646-1f3ff-2642', '1f646-1f3ff-2640'],
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand'],
			],
			'1f646-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f646-1f3fb-2640', '1f646-1f3fc-2640', '1f646-1f3fd-2640', '1f646-1f3fe-2640', '1f646-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'woman'],
			],
			'1f646-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone1:',
				'shortname_alternates' => [':woman_gesturing_ok_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'woman'],
			],
			'1f646-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone2:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-light skin tone', 'woman'],
			],
			'1f646-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone3:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'medium skin tone', 'woman'],
			],
			'1f646-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone4:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-dark skin tone', 'woman'],
			],
			'1f646-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone5:',
				'shortname_alternates' => [':woman_gesturing_ok_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'woman'],
			],
			'1f646-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f646-1f3fb-2642', '1f646-1f3fc-2642', '1f646-1f3fd-2642', '1f646-1f3fe-2642', '1f646-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man'],
			],
			'1f646-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone1:',
				'shortname_alternates' => [':man_gesturing_ok_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'man'],
			],
			'1f646-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone2:',
				'shortname_alternates' => [':man_gesturing_ok_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium-light skin tone'],
			],
			'1f646-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone3:',
				'shortname_alternates' => [':man_gesturing_ok_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium skin tone'],
			],
			'1f646-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone4:',
				'shortname_alternates' => [':man_gesturing_ok_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium-dark skin tone'],
			],
			'1f646-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone5:',
				'shortname_alternates' => [':man_gesturing_ok_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'man'],
			],
			'1f64b' => [
				'name' => \XF::phrase('emoji.person_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand:',
				'shortname_alternates' => [':raising_hand:'],
				'diversity' => '',
				'diversities' => ['1f64b-1f3fb', '1f64b-1f3fc', '1f64b-1f3fd', '1f64b-1f3fe', '1f64b-1f3ff'],
				'gender' => '',
				'genders' => ['1f64b-2642', '1f64b-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'raised'],
			],
			'1f64b-1f3fb' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone1:',
				'shortname_alternates' => [':raising_hand_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64b-1f3fb-2642', '1f64b-1f3fb-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'light skin tone', 'raised'],
			],
			'1f64b-1f3fc' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone2:',
				'shortname_alternates' => [':raising_hand_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64b-1f3fc-2642', '1f64b-1f3fc-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'medium-light skin tone', 'raised'],
			],
			'1f64b-1f3fd' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone3:',
				'shortname_alternates' => [':raising_hand_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64b-1f3fd-2642', '1f64b-1f3fd-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'medium skin tone', 'raised'],
			],
			'1f64b-1f3fe' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone4:',
				'shortname_alternates' => [':raising_hand_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64b-1f3fe-2642', '1f64b-1f3fe-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'medium-dark skin tone', 'raised'],
			],
			'1f64b-1f3ff' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone5:',
				'shortname_alternates' => [':raising_hand_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64b-1f3ff-2642', '1f64b-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'gesture', 'hand', 'happy', 'raised'],
			],
			'1f64b-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64b-1f3fb-2640', '1f64b-1f3fc-2640', '1f64b-1f3fd-2640', '1f64b-1f3fe-2640', '1f64b-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'raising hand', 'woman'],
			],
			'1f64b-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone1:',
				'shortname_alternates' => [':woman_raising_hand_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'light skin tone', 'raising hand', 'woman'],
			],
			'1f64b-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone2:',
				'shortname_alternates' => [':woman_raising_hand_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'medium-light skin tone', 'raising hand', 'woman'],
			],
			'1f64b-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone3:',
				'shortname_alternates' => [':woman_raising_hand_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'medium skin tone', 'raising hand', 'woman'],
			],
			'1f64b-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone4:',
				'shortname_alternates' => [':woman_raising_hand_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'medium-dark skin tone', 'raising hand', 'woman'],
			],
			'1f64b-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone5:',
				'shortname_alternates' => [':woman_raising_hand_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'gesture', 'raising hand', 'woman'],
			],
			'1f64b-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64b-1f3fb-2642', '1f64b-1f3fc-2642', '1f64b-1f3fd-2642', '1f64b-1f3fe-2642', '1f64b-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'raising hand'],
			],
			'1f64b-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone1:',
				'shortname_alternates' => [':man_raising_hand_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'light skin tone', 'man', 'raising hand'],
			],
			'1f64b-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone2:',
				'shortname_alternates' => [':man_raising_hand_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'medium-light skin tone', 'raising hand'],
			],
			'1f64b-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone3:',
				'shortname_alternates' => [':man_raising_hand_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'medium skin tone', 'raising hand'],
			],
			'1f64b-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone4:',
				'shortname_alternates' => [':man_raising_hand_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'medium-dark skin tone', 'raising hand'],
			],
			'1f64b-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone5:',
				'shortname_alternates' => [':man_raising_hand_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'gesture', 'man', 'raising hand'],
			],
			'1f926' => [
				'name' => \XF::phrase('emoji.person_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming:',
				'shortname_alternates' => [':face_palm:', ':facepalm:'],
				'diversity' => '',
				'diversities' => ['1f926-1f3fb', '1f926-1f3fc', '1f926-1f3fd', '1f926-1f3fe', '1f926-1f3ff'],
				'gender' => '',
				'genders' => ['1f926-2642', '1f926-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'palm'],
			],
			'1f926-1f3fb' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone1:',
				'shortname_alternates' => [':face_palm_tone1:', ':facepalm_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f926-1f3fb-2642', '1f926-1f3fb-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'light skin tone', 'palm'],
			],
			'1f926-1f3fc' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone2:',
				'shortname_alternates' => [':face_palm_tone2:', ':facepalm_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f926-1f3fc-2642', '1f926-1f3fc-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium-light skin tone', 'palm'],
			],
			'1f926-1f3fd' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone3:',
				'shortname_alternates' => [':face_palm_tone3:', ':facepalm_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f926-1f3fd-2642', '1f926-1f3fd-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium skin tone', 'palm'],
			],
			'1f926-1f3fe' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone4:',
				'shortname_alternates' => [':face_palm_tone4:', ':facepalm_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f926-1f3fe-2642', '1f926-1f3fe-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium-dark skin tone', 'palm'],
			],
			'1f926-1f3ff' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone5:',
				'shortname_alternates' => [':face_palm_tone5:', ':facepalm_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f926-1f3ff-2642', '1f926-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'face', 'palm'],
			],
			'1f926-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f926-1f3fb-2640', '1f926-1f3fc-2640', '1f926-1f3fd-2640', '1f926-1f3fe-2640', '1f926-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'woman'],
			],
			'1f926-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone1:',
				'shortname_alternates' => [':woman_facepalming_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'woman'],
			],
			'1f926-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone2:',
				'shortname_alternates' => [':woman_facepalming_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium-light skin tone', 'woman'],
			],
			'1f926-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone3:',
				'shortname_alternates' => [':woman_facepalming_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium skin tone', 'woman'],
			],
			'1f926-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone4:',
				'shortname_alternates' => [':woman_facepalming_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium-dark skin tone', 'woman'],
			],
			'1f926-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone5:',
				'shortname_alternates' => [':woman_facepalming_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'woman'],
			],
			'1f926-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f926-1f3fb-2642', '1f926-1f3fc-2642', '1f926-1f3fd-2642', '1f926-1f3fe-2642', '1f926-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man'],
			],
			'1f926-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone1:',
				'shortname_alternates' => [':man_facepalming_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'man'],
			],
			'1f926-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone2:',
				'shortname_alternates' => [':man_facepalming_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-light skin tone'],
			],
			'1f926-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone3:',
				'shortname_alternates' => [':man_facepalming_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium skin tone'],
			],
			'1f926-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone4:',
				'shortname_alternates' => [':man_facepalming_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-dark skin tone'],
			],
			'1f926-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone5:',
				'shortname_alternates' => [':man_facepalming_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'man'],
			],
			'1f937' => [
				'name' => \XF::phrase('emoji.person_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging:',
				'shortname_alternates' => [':shrug:'],
				'diversity' => '',
				'diversities' => ['1f937-1f3fb', '1f937-1f3fc', '1f937-1f3fd', '1f937-1f3fe', '1f937-1f3ff'],
				'gender' => '',
				'genders' => ['1f937-2642', '1f937-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'shrug'],
			],
			'1f937-1f3fb' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone1:',
				'shortname_alternates' => [':shrug_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f937-1f3fb-2642', '1f937-1f3fb-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug'],
			],
			'1f937-1f3fc' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone2:',
				'shortname_alternates' => [':shrug_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f937-1f3fc-2642', '1f937-1f3fc-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug'],
			],
			'1f937-1f3fd' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone3:',
				'shortname_alternates' => [':shrug_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f937-1f3fd-2642', '1f937-1f3fd-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug'],
			],
			'1f937-1f3fe' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone4:',
				'shortname_alternates' => [':shrug_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f937-1f3fe-2642', '1f937-1f3fe-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug'],
			],
			'1f937-1f3ff' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone5:',
				'shortname_alternates' => [':shrug_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f937-1f3ff-2642', '1f937-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug'],
			],
			'1f937-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f937-1f3fb-2640', '1f937-1f3fc-2640', '1f937-1f3fd-2640', '1f937-1f3fe-2640', '1f937-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'shrug', 'woman'],
			],
			'1f937-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone1:',
				'shortname_alternates' => [':woman_shrugging_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug', 'woman'],
			],
			'1f937-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone2:',
				'shortname_alternates' => [':woman_shrugging_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug', 'woman'],
			],
			'1f937-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone3:',
				'shortname_alternates' => [':woman_shrugging_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug', 'woman'],
			],
			'1f937-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone4:',
				'shortname_alternates' => [':woman_shrugging_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug', 'woman'],
			],
			'1f937-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone5:',
				'shortname_alternates' => [':woman_shrugging_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug', 'woman'],
			],
			'1f937-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f937-1f3fb-2642', '1f937-1f3fc-2642', '1f937-1f3fd-2642', '1f937-1f3fe-2642', '1f937-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'shrug'],
			],
			'1f937-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone1:',
				'shortname_alternates' => [':man_shrugging_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'man', 'shrug'],
			],
			'1f937-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone2:',
				'shortname_alternates' => [':man_shrugging_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium-light skin tone', 'shrug'],
			],
			'1f937-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone3:',
				'shortname_alternates' => [':man_shrugging_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium skin tone', 'shrug'],
			],
			'1f937-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone4:',
				'shortname_alternates' => [':man_shrugging_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium-dark skin tone', 'shrug'],
			],
			'1f937-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone5:',
				'shortname_alternates' => [':man_shrugging_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'man', 'shrug'],
			],
			'1f64e' => [
				'name' => \XF::phrase('emoji.person_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting:',
				'shortname_alternates' => [':person_with_pouting_face:'],
				'diversity' => '',
				'diversities' => ['1f64e-1f3fb', '1f64e-1f3fc', '1f64e-1f3fd', '1f64e-1f3fe', '1f64e-1f3ff'],
				'gender' => '',
				'genders' => ['1f64e-2642', '1f64e-2640'],
				'keywords' => ['gesture', 'pouting'],
			],
			'1f64e-1f3fb' => [
				'name' => \XF::phrase('emoji.person_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone1:',
				'shortname_alternates' => [':person_with_pouting_face_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64e-1f3fb-2642', '1f64e-1f3fb-2640'],
				'keywords' => ['gesture', 'light skin tone', 'pouting'],
			],
			'1f64e-1f3fc' => [
				'name' => \XF::phrase('emoji.person_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone2:',
				'shortname_alternates' => [':person_with_pouting_face_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64e-1f3fc-2642', '1f64e-1f3fc-2640'],
				'keywords' => ['gesture', 'medium-light skin tone', 'pouting'],
			],
			'1f64e-1f3fd' => [
				'name' => \XF::phrase('emoji.person_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone3:',
				'shortname_alternates' => [':person_with_pouting_face_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64e-1f3fd-2642', '1f64e-1f3fd-2640'],
				'keywords' => ['gesture', 'medium skin tone', 'pouting'],
			],
			'1f64e-1f3fe' => [
				'name' => \XF::phrase('emoji.person_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone4:',
				'shortname_alternates' => [':person_with_pouting_face_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64e-1f3fe-2642', '1f64e-1f3fe-2640'],
				'keywords' => ['gesture', 'medium-dark skin tone', 'pouting'],
			],
			'1f64e-1f3ff' => [
				'name' => \XF::phrase('emoji.person_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone5:',
				'shortname_alternates' => [':person_with_pouting_face_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64e-1f3ff-2642', '1f64e-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'gesture', 'pouting'],
			],
			'1f64e-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64e-1f3fb-2640', '1f64e-1f3fc-2640', '1f64e-1f3fd-2640', '1f64e-1f3fe-2640', '1f64e-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'pouting', 'woman'],
			],
			'1f64e-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone1:',
				'shortname_alternates' => [':woman_pouting_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'light skin tone', 'pouting', 'woman'],
			],
			'1f64e-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone2:',
				'shortname_alternates' => [':woman_pouting_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'medium-light skin tone', 'pouting', 'woman'],
			],
			'1f64e-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone3:',
				'shortname_alternates' => [':woman_pouting_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'medium skin tone', 'pouting', 'woman'],
			],
			'1f64e-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone4:',
				'shortname_alternates' => [':woman_pouting_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['gesture', 'medium-dark skin tone', 'pouting', 'woman'],
			],
			'1f64e-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone5:',
				'shortname_alternates' => [':woman_pouting_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'gesture', 'pouting', 'woman'],
			],
			'1f64e-2642' => [
				'name' => \XF::phrase('emoji.man_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64e-1f3fb-2642', '1f64e-1f3fc-2642', '1f64e-1f3fd-2642', '1f64e-1f3fe-2642', '1f64e-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'pouting'],
			],
			'1f64e-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone1:',
				'shortname_alternates' => [':man_pouting_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'light skin tone', 'man', 'pouting'],
			],
			'1f64e-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone2:',
				'shortname_alternates' => [':man_pouting_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'medium-light skin tone', 'pouting'],
			],
			'1f64e-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone3:',
				'shortname_alternates' => [':man_pouting_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'medium skin tone', 'pouting'],
			],
			'1f64e-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone4:',
				'shortname_alternates' => [':man_pouting_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['gesture', 'man', 'medium-dark skin tone', 'pouting'],
			],
			'1f64e-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone5:',
				'shortname_alternates' => [':man_pouting_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'gesture', 'man', 'pouting'],
			],
			'1f64d' => [
				'name' => \XF::phrase('emoji.person_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64d-1f3fb', '1f64d-1f3fc', '1f64d-1f3fd', '1f64d-1f3fe', '1f64d-1f3ff'],
				'gender' => '',
				'genders' => ['1f64d-2642', '1f64d-2640'],
				'keywords' => ['frown', 'gesture'],
			],
			'1f64d-1f3fb' => [
				'name' => \XF::phrase('emoji.person_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64d-1f3fb-2642', '1f64d-1f3fb-2640'],
				'keywords' => ['frown', 'gesture', 'light skin tone'],
			],
			'1f64d-1f3fc' => [
				'name' => \XF::phrase('emoji.person_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64d-1f3fc-2642', '1f64d-1f3fc-2640'],
				'keywords' => ['frown', 'gesture', 'medium-light skin tone'],
			],
			'1f64d-1f3fd' => [
				'name' => \XF::phrase('emoji.person_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64d-1f3fd-2642', '1f64d-1f3fd-2640'],
				'keywords' => ['frown', 'gesture', 'medium skin tone'],
			],
			'1f64d-1f3fe' => [
				'name' => \XF::phrase('emoji.person_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64d-1f3fe-2642', '1f64d-1f3fe-2640'],
				'keywords' => ['frown', 'gesture', 'medium-dark skin tone'],
			],
			'1f64d-1f3ff' => [
				'name' => \XF::phrase('emoji.person_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f64d-1f3ff-2642', '1f64d-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'frown', 'gesture'],
			],
			'1f64d-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64d-1f3fb-2640', '1f64d-1f3fc-2640', '1f64d-1f3fd-2640', '1f64d-1f3fe-2640', '1f64d-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'woman'],
			],
			'1f64d-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone1:',
				'shortname_alternates' => [':woman_frowning_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'light skin tone', 'woman'],
			],
			'1f64d-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone2:',
				'shortname_alternates' => [':woman_frowning_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'medium-light skin tone', 'woman'],
			],
			'1f64d-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone3:',
				'shortname_alternates' => [':woman_frowning_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'medium skin tone', 'woman'],
			],
			'1f64d-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone4:',
				'shortname_alternates' => [':woman_frowning_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'medium-dark skin tone', 'woman'],
			],
			'1f64d-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone5:',
				'shortname_alternates' => [':woman_frowning_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'frowning', 'gesture', 'woman'],
			],
			'1f64d-2642' => [
				'name' => \XF::phrase('emoji.man_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f64d-1f3fb-2642', '1f64d-1f3fc-2642', '1f64d-1f3fd-2642', '1f64d-1f3fe-2642', '1f64d-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'man'],
			],
			'1f64d-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone1:',
				'shortname_alternates' => [':man_frowning_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'light skin tone', 'man'],
			],
			'1f64d-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone2:',
				'shortname_alternates' => [':man_frowning_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'man', 'medium-light skin tone'],
			],
			'1f64d-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone3:',
				'shortname_alternates' => [':man_frowning_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'man', 'medium skin tone'],
			],
			'1f64d-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone4:',
				'shortname_alternates' => [':man_frowning_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['frowning', 'gesture', 'man', 'medium-dark skin tone'],
			],
			'1f64d-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone5:',
				'shortname_alternates' => [':man_frowning_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'frowning', 'gesture', 'man'],
			],
			'1f487' => [
				'name' => \XF::phrase('emoji.person_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut:',
				'shortname_alternates' => [':haircut:'],
				'diversity' => '',
				'diversities' => ['1f487-1f3fb', '1f487-1f3fc', '1f487-1f3fd', '1f487-1f3fe', '1f487-1f3ff'],
				'gender' => '',
				'genders' => ['1f487-2642', '1f487-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'parlor'],
			],
			'1f487-1f3fb' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone1:',
				'shortname_alternates' => [':haircut_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f487-1f3fb-2642', '1f487-1f3fb-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'light skin tone', 'parlor'],
			],
			'1f487-1f3fc' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone2:',
				'shortname_alternates' => [':haircut_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f487-1f3fc-2642', '1f487-1f3fc-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'medium-light skin tone', 'parlor'],
			],
			'1f487-1f3fd' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone3:',
				'shortname_alternates' => [':haircut_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f487-1f3fd-2642', '1f487-1f3fd-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'medium skin tone', 'parlor'],
			],
			'1f487-1f3fe' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone4:',
				'shortname_alternates' => [':haircut_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f487-1f3fe-2642', '1f487-1f3fe-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'medium-dark skin tone', 'parlor'],
			],
			'1f487-1f3ff' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone5:',
				'shortname_alternates' => [':haircut_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f487-1f3ff-2642', '1f487-1f3ff-2640'],
				'keywords' => ['barber', 'beauty', 'dark skin tone', 'haircut', 'parlor'],
			],
			'1f487-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f487-1f3fb-2640', '1f487-1f3fc-2640', '1f487-1f3fd-2640', '1f487-1f3fe-2640', '1f487-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['haircut', 'woman'],
			],
			'1f487-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone1:',
				'shortname_alternates' => [':woman_getting_haircut_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['haircut', 'light skin tone', 'woman'],
			],
			'1f487-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone2:',
				'shortname_alternates' => [':woman_getting_haircut_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['haircut', 'medium-light skin tone', 'woman'],
			],
			'1f487-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone3:',
				'shortname_alternates' => [':woman_getting_haircut_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['haircut', 'medium skin tone', 'woman'],
			],
			'1f487-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone4:',
				'shortname_alternates' => [':woman_getting_haircut_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['haircut', 'medium-dark skin tone', 'woman'],
			],
			'1f487-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone5:',
				'shortname_alternates' => [':woman_getting_haircut_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'haircut', 'woman'],
			],
			'1f487-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f487-1f3fb-2642', '1f487-1f3fc-2642', '1f487-1f3fd-2642', '1f487-1f3fe-2642', '1f487-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['haircut', 'man'],
			],
			'1f487-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone1:',
				'shortname_alternates' => [':man_getting_haircut_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['haircut', 'light skin tone', 'man'],
			],
			'1f487-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone2:',
				'shortname_alternates' => [':man_getting_haircut_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['haircut', 'man', 'medium-light skin tone'],
			],
			'1f487-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone3:',
				'shortname_alternates' => [':man_getting_haircut_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['haircut', 'man', 'medium skin tone'],
			],
			'1f487-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone4:',
				'shortname_alternates' => [':man_getting_haircut_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['haircut', 'man', 'medium-dark skin tone'],
			],
			'1f487-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone5:',
				'shortname_alternates' => [':man_getting_haircut_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'haircut', 'man'],
			],
			'1f486' => [
				'name' => \XF::phrase('emoji.person_getting_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage:',
				'shortname_alternates' => [':massage:'],
				'diversity' => '',
				'diversities' => ['1f486-1f3fb', '1f486-1f3fc', '1f486-1f3fd', '1f486-1f3fe', '1f486-1f3ff'],
				'gender' => '',
				'genders' => ['1f486-2642', '1f486-2640'],
				'keywords' => ['face', 'massage', 'salon'],
			],
			'1f486-1f3fb' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone1:',
				'shortname_alternates' => [':massage_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f486-1f3fb-2642', '1f486-1f3fb-2640'],
				'keywords' => ['face', 'light skin tone', 'massage', 'salon'],
			],
			'1f486-1f3fc' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone2:',
				'shortname_alternates' => [':massage_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f486-1f3fc-2642', '1f486-1f3fc-2640'],
				'keywords' => ['face', 'massage', 'medium-light skin tone', 'salon'],
			],
			'1f486-1f3fd' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone3:',
				'shortname_alternates' => [':massage_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f486-1f3fd-2642', '1f486-1f3fd-2640'],
				'keywords' => ['face', 'massage', 'medium skin tone', 'salon'],
			],
			'1f486-1f3fe' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone4:',
				'shortname_alternates' => [':massage_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f486-1f3fe-2642', '1f486-1f3fe-2640'],
				'keywords' => ['face', 'massage', 'medium-dark skin tone', 'salon'],
			],
			'1f486-1f3ff' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone5:',
				'shortname_alternates' => [':massage_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f486-1f3ff-2642', '1f486-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'face', 'massage', 'salon'],
			],
			'1f486-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f486-1f3fb-2640', '1f486-1f3fc-2640', '1f486-1f3fd-2640', '1f486-1f3fe-2640', '1f486-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['face', 'massage', 'woman'],
			],
			'1f486-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone1:',
				'shortname_alternates' => [':woman_getting_face_massage_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['face', 'light skin tone', 'massage', 'woman'],
			],
			'1f486-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone2:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['face', 'massage', 'medium-light skin tone', 'woman'],
			],
			'1f486-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone3:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['face', 'massage', 'medium skin tone', 'woman'],
			],
			'1f486-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone4:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['face', 'massage', 'medium-dark skin tone', 'woman'],
			],
			'1f486-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone5:',
				'shortname_alternates' => [':woman_getting_face_massage_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'face', 'massage', 'woman'],
			],
			'1f486-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f486-1f3fb-2642', '1f486-1f3fc-2642', '1f486-1f3fd-2642', '1f486-1f3fe-2642', '1f486-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['face', 'man', 'massage'],
			],
			'1f486-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone1:',
				'shortname_alternates' => [':man_getting_face_massage_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['face', 'light skin tone', 'man', 'massage'],
			],
			'1f486-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone2:',
				'shortname_alternates' => [':man_getting_face_massage_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['face', 'man', 'massage', 'medium-light skin tone'],
			],
			'1f486-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone3:',
				'shortname_alternates' => [':man_getting_face_massage_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['face', 'man', 'massage', 'medium skin tone'],
			],
			'1f486-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone4:',
				'shortname_alternates' => [':man_getting_face_massage_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['face', 'man', 'massage', 'medium-dark skin tone'],
			],
			'1f486-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone5:',
				'shortname_alternates' => [':man_getting_face_massage_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'face', 'man', 'massage'],
			],
			'1f9d6' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d6-1f3fb', '1f9d6-1f3fc', '1f9d6-1f3fd', '1f9d6-1f3fe', '1f9d6-1f3ff'],
				'gender' => '',
				'genders' => ['1f9d6-2642', '1f9d6-2640'],
				'keywords' => [''],
			],
			'1f9d6-1f3fb' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone1:',
				'shortname_alternates' => [':person_in_steamy_room_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d6-1f3fb-2642', '1f9d6-1f3fb-2640'],
				'keywords' => ['light skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fc' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone2:',
				'shortname_alternates' => [':person_in_steamy_room_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d6-1f3fc-2642', '1f9d6-1f3fc-2640'],
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fd' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone3:',
				'shortname_alternates' => [':person_in_steamy_room_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d6-1f3fd-2642', '1f9d6-1f3fd-2640'],
				'keywords' => ['medium skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fe' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone4:',
				'shortname_alternates' => [':person_in_steamy_room_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d6-1f3fe-2642', '1f9d6-1f3fe-2640'],
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3ff' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone5:',
				'shortname_alternates' => [':person_in_steamy_room_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d6-1f3ff-2642', '1f9d6-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d6-1f3fb-2640', '1f9d6-1f3fc-2640', '1f9d6-1f3fd-2640', '1f9d6-1f3fe-2640', '1f9d6-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['sauna', 'steam room'],
			],
			'1f9d6-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone1:',
				'shortname_alternates' => [':woman_in_steamy_room_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone2:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone3:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone4:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone5:',
				'shortname_alternates' => [':woman_in_steamy_room_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d6-1f3fb-2642', '1f9d6-1f3fc-2642', '1f9d6-1f3fd-2642', '1f9d6-1f3fe-2642', '1f9d6-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['sauna', 'steam room'],
			],
			'1f9d6-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone1:',
				'shortname_alternates' => [':man_in_steamy_room_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone2:',
				'shortname_alternates' => [':man_in_steamy_room_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone3:',
				'shortname_alternates' => [':man_in_steamy_room_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['medium skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone4:',
				'shortname_alternates' => [':man_in_steamy_room_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room'],
			],
			'1f9d6-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone5:',
				'shortname_alternates' => [':man_in_steamy_room_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'sauna', 'steam room'],
			],
			'1f485' => [
				'name' => \XF::phrase('emoji.nail_care'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f485-1f3fb', '1f485-1f3fc', '1f485-1f3fd', '1f485-1f3fe', '1f485-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'nail', 'polish'],
			],
			'1f485-1f3fb' => [
				'name' => \XF::phrase('emoji.nail_care_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['care', 'cosmetics', 'light skin tone', 'manicure', 'nail', 'polish'],
			],
			'1f485-1f3fc' => [
				'name' => \XF::phrase('emoji.nail_care_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium-light skin tone', 'nail', 'polish'],
			],
			'1f485-1f3fd' => [
				'name' => \XF::phrase('emoji.nail_care_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium skin tone', 'nail', 'polish'],
			],
			'1f485-1f3fe' => [
				'name' => \XF::phrase('emoji.nail_care_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium-dark skin tone', 'nail', 'polish'],
			],
			'1f485-1f3ff' => [
				'name' => \XF::phrase('emoji.nail_care_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['care', 'cosmetics', 'dark skin tone', 'manicure', 'nail', 'polish'],
			],
			'1f933' => [
				'name' => \XF::phrase('emoji.selfie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f933-1f3fb', '1f933-1f3fc', '1f933-1f3fd', '1f933-1f3fe', '1f933-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'phone', 'selfie'],
			],
			'1f933-1f3fb' => [
				'name' => \XF::phrase('emoji.selfie_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'light skin tone', 'phone', 'selfie'],
			],
			'1f933-1f3fc' => [
				'name' => \XF::phrase('emoji.selfie_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'medium-light skin tone', 'phone', 'selfie'],
			],
			'1f933-1f3fd' => [
				'name' => \XF::phrase('emoji.selfie_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'medium skin tone', 'phone', 'selfie'],
			],
			'1f933-1f3fe' => [
				'name' => \XF::phrase('emoji.selfie_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'medium-dark skin tone', 'phone', 'selfie'],
			],
			'1f933-1f3ff' => [
				'name' => \XF::phrase('emoji.selfie_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'dark skin tone', 'phone', 'selfie'],
			],
			'1f483' => [
				'name' => \XF::phrase('emoji.dancer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f483-1f3fb', '1f483-1f3fc', '1f483-1f3fd', '1f483-1f3fe', '1f483-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dancing', 'woman'],
			],
			'1f483-1f3fb' => [
				'name' => \XF::phrase('emoji.dancer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dancing', 'light skin tone', 'woman'],
			],
			'1f483-1f3fc' => [
				'name' => \XF::phrase('emoji.dancer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dancing', 'medium-light skin tone', 'woman'],
			],
			'1f483-1f3fd' => [
				'name' => \XF::phrase('emoji.dancer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dancing', 'medium skin tone', 'woman'],
			],
			'1f483-1f3fe' => [
				'name' => \XF::phrase('emoji.dancer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dancing', 'medium-dark skin tone', 'woman'],
			],
			'1f483-1f3ff' => [
				'name' => \XF::phrase('emoji.dancer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dancing', 'dark skin tone', 'woman'],
			],
			'1f57a' => [
				'name' => \XF::phrase('emoji.man_dancing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing:',
				'shortname_alternates' => [':male_dancer:'],
				'diversity' => '',
				'diversities' => ['1f57a-1f3fb', '1f57a-1f3fc', '1f57a-1f3fd', '1f57a-1f3fe', '1f57a-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dance', 'man'],
			],
			'1f57a-1f3fb' => [
				'name' => \XF::phrase('emoji.man_dancing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone1:',
				'shortname_alternates' => [':male_dancer_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dance', 'light skin tone', 'man'],
			],
			'1f57a-1f3fc' => [
				'name' => \XF::phrase('emoji.man_dancing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone2:',
				'shortname_alternates' => [':male_dancer_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dance', 'man', 'medium-light skin tone'],
			],
			'1f57a-1f3fd' => [
				'name' => \XF::phrase('emoji.man_dancing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone3:',
				'shortname_alternates' => [':male_dancer_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dance', 'man', 'medium skin tone'],
			],
			'1f57a-1f3ff' => [
				'name' => \XF::phrase('emoji.man_dancing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone5:',
				'shortname_alternates' => [':male_dancer_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dance', 'dark skin tone', 'man'],
			],
			'1f57a-1f3fe' => [
				'name' => \XF::phrase('emoji.man_dancing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone4:',
				'shortname_alternates' => [':male_dancer_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dance', 'man', 'medium-dark skin tone'],
			],
			'1f46f' => [
				'name' => \XF::phrase('emoji.people_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_with_bunny_ears_partying:',
				'shortname_alternates' => [':dancers:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f46f-2642', '1f46f-2640'],
				'keywords' => ['bunny ear', 'dancer', 'partying'],
			],
			'1f46f-2640' => [
				'name' => \XF::phrase('emoji.women_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_with_bunny_ears_partying:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bunny ear', 'dancer', 'partying', 'women'],
			],
			'1f46f-2642' => [
				'name' => \XF::phrase('emoji.men_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_with_bunny_ears_partying:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bunny ear', 'dancer', 'men', 'partying'],
			],
			'1f574' => [
				'name' => \XF::phrase('emoji.levitate'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate:',
				'shortname_alternates' => [':man_in_business_suit_levitating:'],
				'diversity' => '',
				'diversities' => ['1f574-1f3fb', '1f574-1f3fc', '1f574-1f3fd', '1f574-1f3fe', '1f574-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['business', 'man', 'suit'],
			],
			'1f574-1f3fb' => [
				'name' => \XF::phrase('emoji.levitate_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone1:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone1:', ':man_in_business_suit_levitating_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['business', 'light skin tone', 'man', 'suit'],
			],
			'1f574-1f3fc' => [
				'name' => \XF::phrase('emoji.levitate_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone2:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone2:', ':man_in_business_suit_levitating_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['business', 'man', 'medium-light skin tone', 'suit'],
			],
			'1f574-1f3fd' => [
				'name' => \XF::phrase('emoji.levitate_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone3:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone3:', ':man_in_business_suit_levitating_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['business', 'man', 'medium skin tone', 'suit'],
			],
			'1f574-1f3fe' => [
				'name' => \XF::phrase('emoji.levitate_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone4:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone4:', ':man_in_business_suit_levitating_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['business', 'man', 'medium-dark skin tone', 'suit'],
			],
			'1f574-1f3ff' => [
				'name' => \XF::phrase('emoji.levitate_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone5:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone5:', ':man_in_business_suit_levitating_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['business', 'dark skin tone', 'man', 'suit'],
			],
			'1f6b6' => [
				'name' => \XF::phrase('emoji.person_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking:',
				'shortname_alternates' => [':walking:'],
				'diversity' => '',
				'diversities' => ['1f6b6-1f3fb', '1f6b6-1f3fc', '1f6b6-1f3fd', '1f6b6-1f3fe', '1f6b6-1f3ff'],
				'gender' => '',
				'genders' => ['1f6b6-2642', '1f6b6-2640'],
				'keywords' => ['hike', 'walk', 'walking'],
			],
			'1f6b6-1f3fb' => [
				'name' => \XF::phrase('emoji.person_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone1:',
				'shortname_alternates' => [':walking_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b6-1f3fb-2642', '1f6b6-1f3fb-2640'],
				'keywords' => ['hike', 'light skin tone', 'walk', 'walking'],
			],
			'1f6b6-1f3fc' => [
				'name' => \XF::phrase('emoji.person_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone2:',
				'shortname_alternates' => [':walking_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b6-1f3fc-2642', '1f6b6-1f3fc-2640'],
				'keywords' => ['hike', 'medium-light skin tone', 'walk', 'walking'],
			],
			'1f6b6-1f3fd' => [
				'name' => \XF::phrase('emoji.person_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone3:',
				'shortname_alternates' => [':walking_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b6-1f3fd-2642', '1f6b6-1f3fd-2640'],
				'keywords' => ['hike', 'medium skin tone', 'walk', 'walking'],
			],
			'1f6b6-1f3fe' => [
				'name' => \XF::phrase('emoji.person_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone4:',
				'shortname_alternates' => [':walking_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b6-1f3fe-2642', '1f6b6-1f3fe-2640'],
				'keywords' => ['hike', 'medium-dark skin tone', 'walk', 'walking'],
			],
			'1f6b6-1f3ff' => [
				'name' => \XF::phrase('emoji.person_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone5:',
				'shortname_alternates' => [':walking_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b6-1f3ff-2642', '1f6b6-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'hike', 'walk', 'walking'],
			],
			'1f6b6-2640' => [
				'name' => \XF::phrase('emoji.woman_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6b6-1f3fb-2640', '1f6b6-1f3fc-2640', '1f6b6-1f3fd-2640', '1f6b6-1f3fe-2640', '1f6b6-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['hike', 'walk', 'woman'],
			],
			'1f6b6-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone1:',
				'shortname_alternates' => [':woman_walking_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['hike', 'light skin tone', 'walk', 'woman'],
			],
			'1f6b6-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone2:',
				'shortname_alternates' => [':woman_walking_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['hike', 'medium-light skin tone', 'walk', 'woman'],
			],
			'1f6b6-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone3:',
				'shortname_alternates' => [':woman_walking_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['hike', 'medium skin tone', 'walk', 'woman'],
			],
			'1f6b6-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone4:',
				'shortname_alternates' => [':woman_walking_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['hike', 'medium-dark skin tone', 'walk', 'woman'],
			],
			'1f6b6-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone5:',
				'shortname_alternates' => [':woman_walking_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hike', 'walk', 'woman'],
			],
			'1f6b6-2642' => [
				'name' => \XF::phrase('emoji.man_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6b6-1f3fb-2642', '1f6b6-1f3fc-2642', '1f6b6-1f3fd-2642', '1f6b6-1f3fe-2642', '1f6b6-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['hike', 'man', 'walk'],
			],
			'1f6b6-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone1:',
				'shortname_alternates' => [':man_walking_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['hike', 'light skin tone', 'man', 'walk'],
			],
			'1f6b6-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone2:',
				'shortname_alternates' => [':man_walking_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['hike', 'man', 'medium-light skin tone', 'walk'],
			],
			'1f6b6-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone3:',
				'shortname_alternates' => [':man_walking_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['hike', 'man', 'medium skin tone', 'walk'],
			],
			'1f6b6-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone4:',
				'shortname_alternates' => [':man_walking_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['hike', 'man', 'medium-dark skin tone', 'walk'],
			],
			'1f6b6-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone5:',
				'shortname_alternates' => [':man_walking_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hike', 'man', 'walk'],
			],
			'1f3c3' => [
				'name' => \XF::phrase('emoji.person_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running:',
				'shortname_alternates' => [':runner:'],
				'diversity' => '',
				'diversities' => ['1f3c3-1f3fb', '1f3c3-1f3fc', '1f3c3-1f3fd', '1f3c3-1f3fe', '1f3c3-1f3ff'],
				'gender' => '',
				'genders' => ['1f3c3-2642', '1f3c3-2640'],
				'keywords' => ['marathon', 'running'],
			],
			'1f3c3-1f3fb' => [
				'name' => \XF::phrase('emoji.person_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone1:',
				'shortname_alternates' => [':runner_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c3-1f3fb-2642', '1f3c3-1f3fb-2640'],
				'keywords' => ['light skin tone', 'marathon', 'running'],
			],
			'1f3c3-1f3fc' => [
				'name' => \XF::phrase('emoji.person_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone2:',
				'shortname_alternates' => [':runner_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c3-1f3fc-2642', '1f3c3-1f3fc-2640'],
				'keywords' => ['marathon', 'medium-light skin tone', 'running'],
			],
			'1f3c3-1f3fd' => [
				'name' => \XF::phrase('emoji.person_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone3:',
				'shortname_alternates' => [':runner_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c3-1f3fd-2642', '1f3c3-1f3fd-2640'],
				'keywords' => ['marathon', 'medium skin tone', 'running'],
			],
			'1f3c3-1f3fe' => [
				'name' => \XF::phrase('emoji.person_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone4:',
				'shortname_alternates' => [':runner_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c3-1f3fe-2642', '1f3c3-1f3fe-2640'],
				'keywords' => ['marathon', 'medium-dark skin tone', 'running'],
			],
			'1f3c3-1f3ff' => [
				'name' => \XF::phrase('emoji.person_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone5:',
				'shortname_alternates' => [':runner_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c3-1f3ff-2642', '1f3c3-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'marathon', 'running'],
			],
			'1f3c3-2640' => [
				'name' => \XF::phrase('emoji.woman_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3c3-1f3fb-2640', '1f3c3-1f3fc-2640', '1f3c3-1f3fd-2640', '1f3c3-1f3fe-2640', '1f3c3-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['marathon', 'racing', 'running', 'woman'],
			],
			'1f3c3-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone1:',
				'shortname_alternates' => [':woman_running_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'marathon', 'racing', 'running', 'woman'],
			],
			'1f3c3-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone2:',
				'shortname_alternates' => [':woman_running_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['marathon', 'medium-light skin tone', 'racing', 'running', 'woman'],
			],
			'1f3c3-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone3:',
				'shortname_alternates' => [':woman_running_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['marathon', 'medium skin tone', 'racing', 'running', 'woman'],
			],
			'1f3c3-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone4:',
				'shortname_alternates' => [':woman_running_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['marathon', 'medium-dark skin tone', 'racing', 'running', 'woman'],
			],
			'1f3c3-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone5:',
				'shortname_alternates' => [':woman_running_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'marathon', 'racing', 'running', 'woman'],
			],
			'1f3c3-2642' => [
				'name' => \XF::phrase('emoji.man_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3c3-1f3fb-2642', '1f3c3-1f3fc-2642', '1f3c3-1f3fd-2642', '1f3c3-1f3fe-2642', '1f3c3-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'marathon', 'racing', 'running'],
			],
			'1f3c3-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone1:',
				'shortname_alternates' => [':man_running_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'marathon', 'racing', 'running'],
			],
			'1f3c3-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone2:',
				'shortname_alternates' => [':man_running_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'marathon', 'medium-light skin tone', 'racing', 'running'],
			],
			'1f3c3-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone3:',
				'shortname_alternates' => [':man_running_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'marathon', 'medium skin tone', 'racing', 'running'],
			],
			'1f3c3-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone4:',
				'shortname_alternates' => [':man_running_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'marathon', 'medium-dark skin tone', 'racing', 'running'],
			],
			'1f3c3-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone5:',
				'shortname_alternates' => [':man_running_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'marathon', 'racing', 'running'],
			],
			'1f46b' => [
				'name' => \XF::phrase('emoji.couple'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'hand', 'hold', 'man', 'woman'],
			],
			'1f46d' => [
				'name' => \XF::phrase('emoji.two_women_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':two_women_holding_hands:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'hand', 'hold', 'woman'],
			],
			'1f46c' => [
				'name' => \XF::phrase('emoji.two_men_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':two_men_holding_hands:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Gemini', 'couple', 'hand', 'hold', 'man', 'twins', 'zodiac'],
			],
			'1f491' => [
				'name' => \XF::phrase('emoji.couple_with_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'love'],
			],
			'1f469-2764-1f468' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'love', 'man', 'woman'],
			],
			'1f469-2764-1f469' => [
				'name' => \XF::phrase('emoji.couple_ww'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_ww:',
				'shortname_alternates' => [':couple_with_heart_ww:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'love', 'woman'],
			],
			'1f468-2764-1f468' => [
				'name' => \XF::phrase('emoji.couple_mm'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_mm:',
				'shortname_alternates' => [':couple_with_heart_mm:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'love', 'man'],
			],
			'1f48f' => [
				'name' => \XF::phrase('emoji.couplekiss'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couplekiss:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple'],
			],
			'1f469-2764-1f48b-1f468' => [
				'name' => \XF::phrase('emoji.kiss_woman_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss_woman_man:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'man', 'woman'],
			],
			'1f469-2764-1f48b-1f469' => [
				'name' => \XF::phrase('emoji.kiss_ww'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss_ww:',
				'shortname_alternates' => [':couplekiss_ww:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'woman'],
			],
			'1f468-2764-1f48b-1f468' => [
				'name' => \XF::phrase('emoji.kiss_mm'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss_mm:',
				'shortname_alternates' => [':couplekiss_mm:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couple', 'man'],
			],
			'1f46a' => [
				'name' => \XF::phrase('emoji.family'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family'],
			],
			'1f468-1f469-1f466' => [
				'name' => \XF::phrase('emoji.family_man_woman_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_woman_boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'man', 'woman'],
			],
			'1f468-1f469-1f467' => [
				'name' => \XF::phrase('emoji.family_mwg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'man', 'woman'],
			],
			'1f468-1f469-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_mwgb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwgb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'girl', 'man', 'woman'],
			],
			'1f468-1f469-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_mwbb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwbb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'man', 'woman'],
			],
			'1f468-1f469-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_mwgg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwgg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'man', 'woman'],
			],
			'1f469-1f469-1f466' => [
				'name' => \XF::phrase('emoji.family_wwb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'woman'],
			],
			'1f469-1f469-1f467' => [
				'name' => \XF::phrase('emoji.family_wwg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'woman'],
			],
			'1f469-1f469-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_wwgb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwgb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'girl', 'woman'],
			],
			'1f469-1f469-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_wwbb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwbb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'woman'],
			],
			'1f469-1f469-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_wwgg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwgg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'woman'],
			],
			'1f468-1f468-1f466' => [
				'name' => \XF::phrase('emoji.family_mmb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'man'],
			],
			'1f468-1f468-1f467' => [
				'name' => \XF::phrase('emoji.family_mmg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'man'],
			],
			'1f468-1f468-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_mmgb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmgb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'girl', 'man'],
			],
			'1f468-1f468-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_mmbb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmbb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'man'],
			],
			'1f468-1f468-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_mmgg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmgg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'man'],
			],
			'1f469-1f466' => [
				'name' => \XF::phrase('emoji.family_woman_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'woman'],
			],
			'1f469-1f467' => [
				'name' => \XF::phrase('emoji.family_woman_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_girl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'woman'],
			],
			'1f469-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_woman_girl_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_girl_boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'girl', 'woman'],
			],
			'1f469-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_woman_boy_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_boy_boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'woman'],
			],
			'1f469-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_woman_girl_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_girl_girl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'woman'],
			],
			'1f468-1f466' => [
				'name' => \XF::phrase('emoji.family_man_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'man'],
			],
			'1f468-1f467' => [
				'name' => \XF::phrase('emoji.family_man_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_girl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'man'],
			],
			'1f468-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_man_girl_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_girl_boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'girl', 'man'],
			],
			'1f468-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_man_boy_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_boy_boy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boy', 'family', 'man'],
			],
			'1f468-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_man_girl_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_girl_girl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['family', 'girl', 'man'],
			],
			'1f9e5' => [
				'name' => \XF::phrase('emoji.coat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':coat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['jacket'],
			],
			'1f45a' => [
				'name' => \XF::phrase('emoji.womans_clothes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':womans_clothes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'woman'],
			],
			'1f455' => [
				'name' => \XF::phrase('emoji.shirt'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':shirt:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'shirt', 'tshirt'],
			],
			'1f456' => [
				'name' => \XF::phrase('emoji.jeans'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':jeans:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'pants', 'trousers'],
			],
			'1f454' => [
				'name' => \XF::phrase('emoji.necktie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':necktie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing'],
			],
			'1f457' => [
				'name' => \XF::phrase('emoji.dress'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dress:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing'],
			],
			'1f459' => [
				'name' => \XF::phrase('emoji.bikini'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bikini:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'swim'],
			],
			'1f458' => [
				'name' => \XF::phrase('emoji.kimono'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kimono:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing'],
			],
			'1f97c' => [
				'name' => \XF::phrase('emoji.lab_coat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lab_coat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f460' => [
				'name' => \XF::phrase('emoji.high_heel'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':high_heel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'heel', 'shoe', 'woman'],
			],
			'1f461' => [
				'name' => \XF::phrase('emoji.sandal'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sandal:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'sandal', 'shoe', 'woman'],
			],
			'1f462' => [
				'name' => \XF::phrase('emoji.boot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boot', 'clothing', 'shoe', 'woman'],
			],
			'1f45e' => [
				'name' => \XF::phrase('emoji.mans_shoe'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mans_shoe:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'man', 'shoe'],
			],
			'1f45f' => [
				'name' => \XF::phrase('emoji.athletic_shoe'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':athletic_shoe:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['athletic', 'clothing', 'shoe', 'sneaker'],
			],
			'1f97e' => [
				'name' => \XF::phrase('emoji.hiking_boot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hiking_boot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f97f' => [
				'name' => \XF::phrase('emoji.womans_flat_shoe'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':womans_flat_shoe:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9e6' => [
				'name' => \XF::phrase('emoji.socks'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':socks:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['stocking'],
			],
			'1f9e4' => [
				'name' => \XF::phrase('emoji.gloves'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':gloves:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hand'],
			],
			'1f9e3' => [
				'name' => \XF::phrase('emoji.scarf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scarf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['neck'],
			],
			'1f3a9' => [
				'name' => \XF::phrase('emoji.tophat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tophat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'hat', 'top', 'tophat'],
			],
			'1f9e2' => [
				'name' => \XF::phrase('emoji.billed_cap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':billed_cap:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baseball cap'],
			],
			'1f452' => [
				'name' => \XF::phrase('emoji.womans_hat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':womans_hat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'hat', 'woman'],
			],
			'1f393' => [
				'name' => \XF::phrase('emoji.mortar_board'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mortar_board:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cap', 'celebration', 'clothing', 'graduation', 'hat'],
			],
			'26d1' => [
				'name' => \XF::phrase('emoji.helmet_with_cross'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':helmet_with_cross:',
				'shortname_alternates' => [':helmet_with_white_cross:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['aid', 'cross', 'face', 'hat', 'helmet'],
			],
			'1f451' => [
				'name' => \XF::phrase('emoji.crown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':crown:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'king', 'queen'],
			],
			'1f45d' => [
				'name' => \XF::phrase('emoji.pouch'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pouch:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bag', 'clothing', 'pouch'],
			],
			'1f45b' => [
				'name' => \XF::phrase('emoji.purse'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':purse:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'coin'],
			],
			'1f45c' => [
				'name' => \XF::phrase('emoji.handbag'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handbag:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bag', 'clothing', 'purse'],
			],
			'1f4bc' => [
				'name' => \XF::phrase('emoji.briefcase'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':briefcase:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['briefcase'],
			],
			'1f392' => [
				'name' => \XF::phrase('emoji.school_satchel'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':school_satchel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bag', 'satchel', 'school'],
			],
			'1f453' => [
				'name' => \XF::phrase('emoji.eyeglasses'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eyeglasses:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'eye', 'eyeglasses', 'eyewear'],
			],
			'1f576' => [
				'name' => \XF::phrase('emoji.dark_sunglasses'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dark_sunglasses:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark', 'eye', 'eyewear', 'glasses'],
			],
			'1f97d' => [
				'name' => \XF::phrase('emoji.goggles'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':goggles:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f302' => [
				'name' => \XF::phrase('emoji.closed_umbrella'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':closed_umbrella:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'rain', 'umbrella'],
			],
			'1f9b0' => [
				'name' => \XF::phrase('emoji.red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':red_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b1' => [
				'name' => \XF::phrase('emoji.curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':curly_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b3' => [
				'name' => \XF::phrase('emoji.white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':white_haired:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9b2' => [
				'name' => \XF::phrase('emoji.bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bald:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f436' => [
				'name' => \XF::phrase('emoji.dog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dog:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dog', 'face', 'pet'],
			],
			'1f431' => [
				'name' => \XF::phrase('emoji.cat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cat', 'face', 'pet'],
			],
			'1f42d' => [
				'name' => \XF::phrase('emoji.mouse'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mouse:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'mouse'],
			],
			'1f439' => [
				'name' => \XF::phrase('emoji.hamster'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hamster:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'hamster', 'pet'],
			],
			'1f430' => [
				'name' => \XF::phrase('emoji.rabbit'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rabbit:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bunny', 'face', 'pet', 'rabbit'],
			],
			'1f98a' => [
				'name' => \XF::phrase('emoji.fox'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fox:',
				'shortname_alternates' => [':fox_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'fox'],
			],
			'1f99d' => [
				'name' => \XF::phrase('emoji.raccoon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':raccoon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f43b' => [
				'name' => \XF::phrase('emoji.bear'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bear:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bear', 'face'],
			],
			'1f43c' => [
				'name' => \XF::phrase('emoji.panda_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':panda_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'panda'],
			],
			'1f998' => [
				'name' => \XF::phrase('emoji.kangaroo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':kangaroo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9a1' => [
				'name' => \XF::phrase('emoji.badger'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':badger:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f428' => [
				'name' => \XF::phrase('emoji.koala'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':koala:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bear'],
			],
			'1f42f' => [
				'name' => \XF::phrase('emoji.tiger'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tiger:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'tiger'],
			],
			'1f981' => [
				'name' => \XF::phrase('emoji.lion_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':lion_face:',
				'shortname_alternates' => [':lion:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Leo', 'face', 'lion', 'zodiac'],
			],
			'1f42e' => [
				'name' => \XF::phrase('emoji.cow'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cow:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cow', 'face'],
			],
			'1f437' => [
				'name' => \XF::phrase('emoji.pig'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':pig:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'pig'],
			],
			'1f43d' => [
				'name' => \XF::phrase('emoji.pig_nose'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':pig_nose:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'nose', 'pig'],
			],
			'1f438' => [
				'name' => \XF::phrase('emoji.frog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':frog:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'frog'],
			],
			'1f435' => [
				'name' => \XF::phrase('emoji.monkey_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':monkey_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'monkey'],
			],
			'1f648' => [
				'name' => \XF::phrase('emoji.see_no_evil'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':see_no_evil:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['evil', 'face', 'forbidden', 'gesture', 'monkey', 'no', 'not', 'prohibited', 'see'],
			],
			'1f649' => [
				'name' => \XF::phrase('emoji.hear_no_evil'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hear_no_evil:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['evil', 'face', 'forbidden', 'gesture', 'hear', 'monkey', 'no', 'not', 'prohibited'],
			],
			'1f64a' => [
				'name' => \XF::phrase('emoji.speak_no_evil'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':speak_no_evil:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['evil', 'face', 'forbidden', 'gesture', 'monkey', 'no', 'not', 'prohibited', 'speak'],
			],
			'1f412' => [
				'name' => \XF::phrase('emoji.monkey'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':monkey:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['monkey'],
			],
			'1f414' => [
				'name' => \XF::phrase('emoji.chicken'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':chicken:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'chicken'],
			],
			'1f427' => [
				'name' => \XF::phrase('emoji.penguin'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':penguin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'penguin'],
			],
			'1f426' => [
				'name' => \XF::phrase('emoji.bird'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bird:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird'],
			],
			'1f424' => [
				'name' => \XF::phrase('emoji.baby_chick'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':baby_chick:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'bird', 'chick'],
			],
			'1f423' => [
				'name' => \XF::phrase('emoji.hatching_chick'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hatching_chick:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'bird', 'chick', 'hatching'],
			],
			'1f425' => [
				'name' => \XF::phrase('emoji.hatched_chick'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hatched_chick:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'bird', 'chick'],
			],
			'1f986' => [
				'name' => \XF::phrase('emoji.duck'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':duck:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'duck'],
			],
			'1f9a2' => [
				'name' => \XF::phrase('emoji.swan'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':swan:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f985' => [
				'name' => \XF::phrase('emoji.eagle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':eagle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'eagle'],
			],
			'1f989' => [
				'name' => \XF::phrase('emoji.owl'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':owl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'owl', 'wise'],
			],
			'1f99c' => [
				'name' => \XF::phrase('emoji.parrot'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':parrot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f99a' => [
				'name' => \XF::phrase('emoji.peacock'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':peacock:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f987' => [
				'name' => \XF::phrase('emoji.bat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bat', 'vampire'],
			],
			'1f43a' => [
				'name' => \XF::phrase('emoji.wolf'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':wolf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'wolf'],
			],
			'1f417' => [
				'name' => \XF::phrase('emoji.boar'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':boar:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pig'],
			],
			'1f434' => [
				'name' => \XF::phrase('emoji.horse'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':horse:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'horse'],
			],
			'1f984' => [
				'name' => \XF::phrase('emoji.unicorn'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':unicorn:',
				'shortname_alternates' => [':unicorn_face:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'unicorn'],
			],
			'1f41d' => [
				'name' => \XF::phrase('emoji.bee'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bee:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bee', 'insect'],
			],
			'1f41b' => [
				'name' => \XF::phrase('emoji.bug'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bug:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['insect'],
			],
			'1f98b' => [
				'name' => \XF::phrase('emoji.butterfly'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':butterfly:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['butterfly', 'insect', 'pretty'],
			],
			'1f40c' => [
				'name' => \XF::phrase('emoji.snail'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snail:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['snail'],
			],
			'1f41a' => [
				'name' => \XF::phrase('emoji.shell'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shell:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['shell', 'spiral'],
			],
			'1f41e' => [
				'name' => \XF::phrase('emoji.beetle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':beetle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beetle', 'insect', 'ladybird', 'ladybug'],
			],
			'1f41c' => [
				'name' => \XF::phrase('emoji.ant'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ant:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['insect'],
			],
			'1f997' => [
				'name' => \XF::phrase('emoji.cricket'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cricket:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f577' => [
				'name' => \XF::phrase('emoji.spider'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':spider:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['insect'],
			],
			'1f578' => [
				'name' => \XF::phrase('emoji.spider_web'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':spider_web:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['spider', 'web'],
			],
			'1f982' => [
				'name' => \XF::phrase('emoji.scorpion'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':scorpion:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Scorpius', 'scorpio', 'zodiac'],
			],
			'1f99f' => [
				'name' => \XF::phrase('emoji.mosquito'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mosquito:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9a0' => [
				'name' => \XF::phrase('emoji.microbe'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':microbe:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f422' => [
				'name' => \XF::phrase('emoji.turtle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':turtle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['terrapin', 'tortoise', 'turtle'],
			],
			'1f40d' => [
				'name' => \XF::phrase('emoji.snake'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snake:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Ophiuchus', 'bearer', 'serpent', 'zodiac'],
			],
			'1f98e' => [
				'name' => \XF::phrase('emoji.lizard'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':lizard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lizard', 'reptile'],
			],
			'1f996' => [
				'name' => \XF::phrase('emoji.t_rex'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':t_rex:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Tyrannosaurus Rex'],
			],
			'1f995' => [
				'name' => \XF::phrase('emoji.sauropod'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sauropod:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['brachiosaurus', 'brontosaurus', 'diplodocus'],
			],
			'1f419' => [
				'name' => \XF::phrase('emoji.octopus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':octopus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['octopus'],
			],
			'1f991' => [
				'name' => \XF::phrase('emoji.squid'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':squid:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['food', 'molusc', 'squid'],
			],
			'1f990' => [
				'name' => \XF::phrase('emoji.shrimp'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shrimp:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['food', 'shellfish', 'shrimp', 'small'],
			],
			'1f980' => [
				'name' => \XF::phrase('emoji.crab'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':crab:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Cancer', 'zodiac'],
			],
			'1f99e' => [
				'name' => \XF::phrase('emoji.lobster'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':lobster:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f421' => [
				'name' => \XF::phrase('emoji.blowfish'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':blowfish:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fish'],
			],
			'1f420' => [
				'name' => \XF::phrase('emoji.tropical_fish'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tropical_fish:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fish', 'tropical'],
			],
			'1f41f' => [
				'name' => \XF::phrase('emoji.fish'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fish:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Pisces', 'zodiac'],
			],
			'1f42c' => [
				'name' => \XF::phrase('emoji.dolphin'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dolphin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flipper'],
			],
			'1f433' => [
				'name' => \XF::phrase('emoji.whale'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':whale:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'spouting', 'whale'],
			],
			'1f40b' => [
				'name' => \XF::phrase('emoji.whale2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':whale2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['whale'],
			],
			'1f988' => [
				'name' => \XF::phrase('emoji.shark'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shark:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fish', 'shark'],
			],
			'1f40a' => [
				'name' => \XF::phrase('emoji.crocodile'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':crocodile:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crocodile'],
			],
			'1f405' => [
				'name' => \XF::phrase('emoji.tiger2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tiger2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['tiger'],
			],
			'1f406' => [
				'name' => \XF::phrase('emoji.leopard'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':leopard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['leopard'],
			],
			'1f993' => [
				'name' => \XF::phrase('emoji.zebra'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':zebra:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['stripe'],
			],
			'1f98d' => [
				'name' => \XF::phrase('emoji.gorilla'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':gorilla:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gorilla'],
			],
			'1f418' => [
				'name' => \XF::phrase('emoji.elephant'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':elephant:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['elephant'],
			],
			'1f98f' => [
				'name' => \XF::phrase('emoji.rhino'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rhino:',
				'shortname_alternates' => [':rhinoceros:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['rhinoceros'],
			],
			'1f99b' => [
				'name' => \XF::phrase('emoji.hippopotamus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hippopotamus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f42a' => [
				'name' => \XF::phrase('emoji.dromedary_camel'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dromedary_camel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dromedary', 'hump'],
			],
			'1f42b' => [
				'name' => \XF::phrase('emoji.camel'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':camel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bactrian', 'camel', 'hump'],
			],
			'1f992' => [
				'name' => \XF::phrase('emoji.giraffe'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':giraffe:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['spots'],
			],
			'1f999' => [
				'name' => \XF::phrase('emoji.llama'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':llama:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f403' => [
				'name' => \XF::phrase('emoji.water_buffalo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':water_buffalo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['buffalo', 'water'],
			],
			'1f402' => [
				'name' => \XF::phrase('emoji.ox'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ox:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Taurus', 'bull', 'zodiac'],
			],
			'1f404' => [
				'name' => \XF::phrase('emoji.cow2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cow2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cow'],
			],
			'1f40e' => [
				'name' => \XF::phrase('emoji.racehorse'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':racehorse:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['equestrian', 'racehorse', 'racing'],
			],
			'1f416' => [
				'name' => \XF::phrase('emoji.pig2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':pig2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['sow'],
			],
			'1f40f' => [
				'name' => \XF::phrase('emoji.ram'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ram:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Aries', 'male', 'sheep', 'zodiac'],
			],
			'1f411' => [
				'name' => \XF::phrase('emoji.sheep'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sheep:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['female', 'sheep'],
			],
			'1f410' => [
				'name' => \XF::phrase('emoji.goat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':goat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Capricorn', 'zodiac'],
			],
			'1f98c' => [
				'name' => \XF::phrase('emoji.deer'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':deer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['deer'],
			],
			'1f415' => [
				'name' => \XF::phrase('emoji.dog2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dog2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pet'],
			],
			'1f429' => [
				'name' => \XF::phrase('emoji.poodle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':poodle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dog'],
			],
			'1f408' => [
				'name' => \XF::phrase('emoji.cat2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cat2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pet'],
			],
			'1f413' => [
				'name' => \XF::phrase('emoji.rooster'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rooster:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'rooster'],
			],
			'1f983' => [
				'name' => \XF::phrase('emoji.turkey'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':turkey:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'turkey'],
			],
			'1f54a' => [
				'name' => \XF::phrase('emoji.dove'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dove:',
				'shortname_alternates' => [':dove_of_peace:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bird', 'fly', 'peace'],
			],
			'1f407' => [
				'name' => \XF::phrase('emoji.rabbit2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rabbit2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bunny', 'pet'],
			],
			'1f401' => [
				'name' => \XF::phrase('emoji.mouse2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mouse2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mouse'],
			],
			'1f400' => [
				'name' => \XF::phrase('emoji.rat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['rat'],
			],
			'1f43f' => [
				'name' => \XF::phrase('emoji.chipmunk'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':chipmunk:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chipmunk'],
			],
			'1f994' => [
				'name' => \XF::phrase('emoji.hedgehog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hedgehog:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['spiny'],
			],
			'1f43e' => [
				'name' => \XF::phrase('emoji.feet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':feet:',
				'shortname_alternates' => [':paw_prints:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['feet', 'paw', 'print'],
			],
			'1f409' => [
				'name' => \XF::phrase('emoji.dragon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dragon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fairy tale'],
			],
			'1f432' => [
				'name' => \XF::phrase('emoji.dragon_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dragon_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dragon', 'face', 'fairy tale'],
			],
			'1f335' => [
				'name' => \XF::phrase('emoji.cactus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cactus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['plant'],
			],
			'1f384' => [
				'name' => \XF::phrase('emoji.christmas_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':christmas_tree:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christmas', 'celebration', 'tree'],
			],
			'1f332' => [
				'name' => \XF::phrase('emoji.evergreen_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':evergreen_tree:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['tree'],
			],
			'1f333' => [
				'name' => \XF::phrase('emoji.deciduous_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':deciduous_tree:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['deciduous', 'shedding', 'tree'],
			],
			'1f334' => [
				'name' => \XF::phrase('emoji.palm_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':palm_tree:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['palm', 'tree'],
			],
			'1f331' => [
				'name' => \XF::phrase('emoji.seedling'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':seedling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['young'],
			],
			'1f33f' => [
				'name' => \XF::phrase('emoji.herb'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':herb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['leaf'],
			],
			'2618' => [
				'name' => \XF::phrase('emoji.shamrock'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shamrock:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['plant'],
			],
			'1f340' => [
				'name' => \XF::phrase('emoji.four_leaf_clover'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':four_leaf_clover:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['4', 'clover', 'four', 'leaf'],
			],
			'1f38d' => [
				'name' => \XF::phrase('emoji.bamboo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bamboo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'bamboo', 'celebration', 'pine'],
			],
			'1f38b' => [
				'name' => \XF::phrase('emoji.tanabata_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tanabata_tree:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'banner', 'celebration', 'tree'],
			],
			'1f343' => [
				'name' => \XF::phrase('emoji.leaves'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':leaves:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blow', 'flutter', 'leaf', 'wind'],
			],
			'1f342' => [
				'name' => \XF::phrase('emoji.fallen_leaf'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fallen_leaf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['falling', 'leaf'],
			],
			'1f341' => [
				'name' => \XF::phrase('emoji.maple_leaf'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':maple_leaf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['falling', 'leaf', 'maple'],
			],
			'1f344' => [
				'name' => \XF::phrase('emoji.mushroom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mushroom:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['toadstool'],
			],
			'1f33e' => [
				'name' => \XF::phrase('emoji.ear_of_rice'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ear_of_rice:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ear', 'grain', 'rice'],
			],
			'1f490' => [
				'name' => \XF::phrase('emoji.bouquet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bouquet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower'],
			],
			'1f337' => [
				'name' => \XF::phrase('emoji.tulip'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tulip:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower'],
			],
			'1f339' => [
				'name' => \XF::phrase('emoji.rose'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rose:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower'],
			],
			'1f940' => [
				'name' => \XF::phrase('emoji.wilted_rose'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':wilted_rose:',
				'shortname_alternates' => [':wilted_flower:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower', 'wilted'],
			],
			'1f33a' => [
				'name' => \XF::phrase('emoji.hibiscus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hibiscus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower'],
			],
			'1f338' => [
				'name' => \XF::phrase('emoji.cherry_blossom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cherry_blossom:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blossom', 'cherry', 'flower'],
			],
			'1f33c' => [
				'name' => \XF::phrase('emoji.blossom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':blossom:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower'],
			],
			'1f33b' => [
				'name' => \XF::phrase('emoji.sunflower'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sunflower:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower', 'sun'],
			],
			'1f31e' => [
				'name' => \XF::phrase('emoji.sun_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sun_with_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bright', 'face', 'sun'],
			],
			'1f31d' => [
				'name' => \XF::phrase('emoji.full_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':full_moon_with_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bright', 'face', 'full', 'moon'],
			],
			'1f31b' => [
				'name' => \XF::phrase('emoji.first_quarter_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':first_quarter_moon_with_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'moon', 'quarter'],
			],
			'1f31c' => [
				'name' => \XF::phrase('emoji.last_quarter_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':last_quarter_moon_with_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'moon', 'quarter'],
			],
			'1f31a' => [
				'name' => \XF::phrase('emoji.new_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':new_moon_with_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'moon'],
			],
			'1f315' => [
				'name' => \XF::phrase('emoji.full_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':full_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['full', 'moon'],
			],
			'1f316' => [
				'name' => \XF::phrase('emoji.waning_gibbous_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waning_gibbous_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gibbous', 'moon', 'waning'],
			],
			'1f317' => [
				'name' => \XF::phrase('emoji.last_quarter_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':last_quarter_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['moon', 'quarter'],
			],
			'1f318' => [
				'name' => \XF::phrase('emoji.waning_crescent_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waning_crescent_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crescent', 'moon', 'waning'],
			],
			'1f311' => [
				'name' => \XF::phrase('emoji.new_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':new_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark', 'moon'],
			],
			'1f312' => [
				'name' => \XF::phrase('emoji.waxing_crescent_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waxing_crescent_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crescent', 'moon', 'waxing'],
			],
			'1f313' => [
				'name' => \XF::phrase('emoji.first_quarter_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':first_quarter_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['moon', 'quarter'],
			],
			'1f314' => [
				'name' => \XF::phrase('emoji.waxing_gibbous_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waxing_gibbous_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gibbous', 'moon', 'waxing'],
			],
			'1f319' => [
				'name' => \XF::phrase('emoji.crescent_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':crescent_moon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crescent', 'moon'],
			],
			'1f30e' => [
				'name' => \XF::phrase('emoji.earth_americas'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':earth_americas:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Americas', 'earth', 'globe', 'world'],
			],
			'1f30d' => [
				'name' => \XF::phrase('emoji.earth_africa'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':earth_africa:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Africa', 'Europe', 'earth', 'globe', 'world'],
			],
			'1f30f' => [
				'name' => \XF::phrase('emoji.earth_asia'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':earth_asia:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Asia', 'Australia', 'earth', 'globe', 'world'],
			],
			'1f4ab' => [
				'name' => \XF::phrase('emoji.dizzy'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dizzy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['comic', 'star'],
			],
			'2b50' => [
				'name' => \XF::phrase('emoji.star'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':star:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['star'],
			],
			'1f31f' => [
				'name' => \XF::phrase('emoji.star2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':star2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['glittery', 'glow', 'shining', 'sparkle', 'star'],
			],
			'2728' => [
				'name' => \XF::phrase('emoji.sparkles'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sparkles:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['sparkle', 'star'],
			],
			'26a1' => [
				'name' => \XF::phrase('emoji.zap'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':zap:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['danger', 'electric', 'electricity', 'lightning', 'voltage', 'zap'],
			],
			'2604' => [
				'name' => \XF::phrase('emoji.comet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':comet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['space'],
			],
			'1f4a5' => [
				'name' => \XF::phrase('emoji.boom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':boom:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boom', 'comic'],
			],
			'1f525' => [
				'name' => \XF::phrase('emoji.fire'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fire:',
				'shortname_alternates' => [':flame:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flame', 'tool'],
			],
			'1f32a' => [
				'name' => \XF::phrase('emoji.cloud_tornado'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_tornado:',
				'shortname_alternates' => [':cloud_with_tornado:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'whirlwind'],
			],
			'1f308' => [
				'name' => \XF::phrase('emoji.rainbow'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rainbow:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['rain'],
			],
			'2600' => [
				'name' => \XF::phrase('emoji.sunny'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sunny:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bright', 'rays', 'sunny'],
			],
			'1f324' => [
				'name' => \XF::phrase('emoji.white_sun_small_cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':white_sun_small_cloud:',
				'shortname_alternates' => [':white_sun_with_small_cloud:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'sun'],
			],
			'26c5' => [
				'name' => \XF::phrase('emoji.partly_sunny'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':partly_sunny:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'sun'],
			],
			'1f325' => [
				'name' => \XF::phrase('emoji.white_sun_cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':white_sun_cloud:',
				'shortname_alternates' => [':white_sun_behind_cloud:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'sun'],
			],
			'2601' => [
				'name' => \XF::phrase('emoji.cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['weather'],
			],
			'1f326' => [
				'name' => \XF::phrase('emoji.white_sun_rain_cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':white_sun_rain_cloud:',
				'shortname_alternates' => [':white_sun_behind_cloud_with_rain:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'rain', 'sun'],
			],
			'1f327' => [
				'name' => \XF::phrase('emoji.cloud_rain'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_rain:',
				'shortname_alternates' => [':cloud_with_rain:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'rain'],
			],
			'26c8' => [
				'name' => \XF::phrase('emoji.thunder_cloud_rain'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':thunder_cloud_rain:',
				'shortname_alternates' => [':thunder_cloud_and_rain:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'rain', 'thunder'],
			],
			'1f329' => [
				'name' => \XF::phrase('emoji.cloud_lightning'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_lightning:',
				'shortname_alternates' => [':cloud_with_lightning:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'lightning'],
			],
			'1f328' => [
				'name' => \XF::phrase('emoji.cloud_snow'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_snow:',
				'shortname_alternates' => [':cloud_with_snow:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud', 'cold', 'snow'],
			],
			'2744' => [
				'name' => \XF::phrase('emoji.snowflake'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snowflake:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'snow'],
			],
			'2603' => [
				'name' => \XF::phrase('emoji.snowman2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snowman2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'snow'],
			],
			'26c4' => [
				'name' => \XF::phrase('emoji.snowman'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snowman:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'snow', 'snowman'],
			],
			'1f32c' => [
				'name' => \XF::phrase('emoji.wind_blowing_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':wind_blowing_face:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blow', 'cloud', 'face', 'wind'],
			],
			'1f4a8' => [
				'name' => \XF::phrase('emoji.dash'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dash:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['comic', 'dash', 'running'],
			],
			'1f4a7' => [
				'name' => \XF::phrase('emoji.droplet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':droplet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'comic', 'drop', 'sweat'],
			],
			'1f4a6' => [
				'name' => \XF::phrase('emoji.sweat_drops'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sweat_drops:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['comic', 'splashing', 'sweat'],
			],
			'2614' => [
				'name' => \XF::phrase('emoji.umbrella'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':umbrella:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'drop', 'rain', 'umbrella'],
			],
			'2602' => [
				'name' => \XF::phrase('emoji.umbrella2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':umbrella2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clothing', 'rain'],
			],
			'1f30a' => [
				'name' => \XF::phrase('emoji.ocean'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ocean:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ocean', 'water', 'wave'],
			],
			'1f32b' => [
				'name' => \XF::phrase('emoji.fog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fog:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cloud'],
			],
			'1f34f' => [
				'name' => \XF::phrase('emoji.green_apple'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':green_apple:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['apple', 'fruit', 'green'],
			],
			'1f34e' => [
				'name' => \XF::phrase('emoji.apple'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':apple:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['apple', 'fruit', 'red'],
			],
			'1f350' => [
				'name' => \XF::phrase('emoji.pear'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pear:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit'],
			],
			'1f34a' => [
				'name' => \XF::phrase('emoji.tangerine'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':tangerine:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit', 'orange'],
			],
			'1f34b' => [
				'name' => \XF::phrase('emoji.lemon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':lemon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['citrus', 'fruit'],
			],
			'1f34c' => [
				'name' => \XF::phrase('emoji.banana'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':banana:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit'],
			],
			'1f349' => [
				'name' => \XF::phrase('emoji.watermelon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':watermelon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit'],
			],
			'1f347' => [
				'name' => \XF::phrase('emoji.grapes'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':grapes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit', 'grape'],
			],
			'1f353' => [
				'name' => \XF::phrase('emoji.strawberry'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':strawberry:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['berry', 'fruit'],
			],
			'1f348' => [
				'name' => \XF::phrase('emoji.melon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':melon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit'],
			],
			'1f352' => [
				'name' => \XF::phrase('emoji.cherries'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cherries:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cherry', 'fruit'],
			],
			'1f351' => [
				'name' => \XF::phrase('emoji.peach'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':peach:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit'],
			],
			'1f96d' => [
				'name' => \XF::phrase('emoji.mango'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':mango:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f34d' => [
				'name' => \XF::phrase('emoji.pineapple'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pineapple:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit'],
			],
			'1f965' => [
				'name' => \XF::phrase('emoji.coconut'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':coconut:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['palm', 'piña colada'],
			],
			'1f95d' => [
				'name' => \XF::phrase('emoji.kiwi'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':kiwi:',
				'shortname_alternates' => [':kiwifruit:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['food', 'fruit', 'kiwi'],
			],
			'1f345' => [
				'name' => \XF::phrase('emoji.tomato'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':tomato:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fruit', 'vegetable'],
			],
			'1f346' => [
				'name' => \XF::phrase('emoji.eggplant'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':eggplant:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['aubergine', 'vegetable'],
			],
			'1f951' => [
				'name' => \XF::phrase('emoji.avocado'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':avocado:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['avocado', 'food', 'fruit'],
			],
			'1f966' => [
				'name' => \XF::phrase('emoji.broccoli'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':broccoli:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['wild cabbage'],
			],
			'1f96c' => [
				'name' => \XF::phrase('emoji.leafy_green'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':leafy_green:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f952' => [
				'name' => \XF::phrase('emoji.cucumber'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cucumber:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cucumber', 'food', 'pickle', 'vegetable'],
			],
			'1f336' => [
				'name' => \XF::phrase('emoji.hot_pepper'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':hot_pepper:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hot', 'pepper'],
			],
			'1f33d' => [
				'name' => \XF::phrase('emoji.corn'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':corn:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['corn', 'ear', 'maize', 'maze'],
			],
			'1f955' => [
				'name' => \XF::phrase('emoji.carrot'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':carrot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['carrot', 'food', 'vegetable'],
			],
			'1f954' => [
				'name' => \XF::phrase('emoji.potato'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':potato:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['food', 'potato', 'vegetable'],
			],
			'1f360' => [
				'name' => \XF::phrase('emoji.sweet_potato'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':sweet_potato:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['potato', 'roasted', 'sweet'],
			],
			'1f950' => [
				'name' => \XF::phrase('emoji.croissant'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':croissant:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bread', 'crescent roll', 'croissant', 'food', 'french'],
			],
			'1f35e' => [
				'name' => \XF::phrase('emoji.bread'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bread:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['loaf'],
			],
			'1f956' => [
				'name' => \XF::phrase('emoji.french_bread'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':french_bread:',
				'shortname_alternates' => [':baguette_bread:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baguette', 'bread', 'food', 'french'],
			],
			'1f968' => [
				'name' => \XF::phrase('emoji.pretzel'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pretzel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f96f' => [
				'name' => \XF::phrase('emoji.bagel'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bagel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9c0' => [
				'name' => \XF::phrase('emoji.cheese'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cheese:',
				'shortname_alternates' => [':cheese_wedge:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cheese'],
			],
			'1f95a' => [
				'name' => \XF::phrase('emoji.egg'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':egg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['egg', 'food'],
			],
			'1f373' => [
				'name' => \XF::phrase('emoji.cooking'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cooking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['egg', 'frying', 'pan'],
			],
			'1f95e' => [
				'name' => \XF::phrase('emoji.pancakes'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pancakes:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crêpe', 'food', 'hotcake', 'pancake'],
			],
			'1f953' => [
				'name' => \XF::phrase('emoji.bacon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bacon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bacon', 'food', 'meat'],
			],
			'1f969' => [
				'name' => \XF::phrase('emoji.cut_of_meat'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cut_of_meat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chop', 'lambchop', 'porkchop', 'steak'],
			],
			'1f357' => [
				'name' => \XF::phrase('emoji.poultry_leg'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':poultry_leg:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bone', 'chicken', 'leg', 'poultry'],
			],
			'1f356' => [
				'name' => \XF::phrase('emoji.meat_on_bone'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':meat_on_bone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bone', 'meat'],
			],
			'1f32d' => [
				'name' => \XF::phrase('emoji.hotdog'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':hotdog:',
				'shortname_alternates' => [':hot_dog:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['frankfurter', 'hotdog', 'sausage'],
			],
			'1f354' => [
				'name' => \XF::phrase('emoji.hamburger'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':hamburger:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['burger'],
			],
			'1f35f' => [
				'name' => \XF::phrase('emoji.fries'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':fries:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['french', 'fries'],
			],
			'1f355' => [
				'name' => \XF::phrase('emoji.pizza'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pizza:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cheese', 'slice'],
			],
			'1f96a' => [
				'name' => \XF::phrase('emoji.sandwich'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':sandwich:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bread'],
			],
			'1f959' => [
				'name' => \XF::phrase('emoji.stuffed_flatbread'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':stuffed_flatbread:',
				'shortname_alternates' => [':stuffed_pita:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['falafel', 'flatbread', 'food', 'gyro', 'kebab', 'stuffed'],
			],
			'1f32e' => [
				'name' => \XF::phrase('emoji.taco'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':taco:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mexican'],
			],
			'1f32f' => [
				'name' => \XF::phrase('emoji.burrito'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':burrito:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mexican', 'wrap'],
			],
			'1f957' => [
				'name' => \XF::phrase('emoji.salad'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':salad:',
				'shortname_alternates' => [':green_salad:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['food', 'green', 'salad'],
			],
			'1f958' => [
				'name' => \XF::phrase('emoji.shallow_pan_of_food'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':shallow_pan_of_food:',
				'shortname_alternates' => [':paella:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['casserole', 'food', 'paella', 'pan', 'shallow'],
			],
			'1f96b' => [
				'name' => \XF::phrase('emoji.canned_food'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':canned_food:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['can'],
			],
			'1f35d' => [
				'name' => \XF::phrase('emoji.spaghetti'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':spaghetti:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pasta'],
			],
			'1f35c' => [
				'name' => \XF::phrase('emoji.ramen'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':ramen:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bowl', 'noodle', 'ramen', 'steaming'],
			],
			'1f372' => [
				'name' => \XF::phrase('emoji.stew'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':stew:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pot', 'stew'],
			],
			'1f35b' => [
				'name' => \XF::phrase('emoji.curry'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':curry:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['curry', 'rice'],
			],
			'1f363' => [
				'name' => \XF::phrase('emoji.sushi'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':sushi:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['sushi'],
			],
			'1f371' => [
				'name' => \XF::phrase('emoji.bento'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bento:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bento', 'box'],
			],
			'1f364' => [
				'name' => \XF::phrase('emoji.fried_shrimp'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':fried_shrimp:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fried', 'prawn', 'shrimp', 'tempura'],
			],
			'1f359' => [
				'name' => \XF::phrase('emoji.rice_ball'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':rice_ball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ball', 'rice'],
			],
			'1f35a' => [
				'name' => \XF::phrase('emoji.rice'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':rice:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cooked', 'rice'],
			],
			'1f358' => [
				'name' => \XF::phrase('emoji.rice_cracker'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':rice_cracker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cracker', 'rice'],
			],
			'1f365' => [
				'name' => \XF::phrase('emoji.fish_cake'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':fish_cake:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cake', 'fish', 'pastry', 'swirl'],
			],
			'1f960' => [
				'name' => \XF::phrase('emoji.fortune_cookie'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':fortune_cookie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['prophecy'],
			],
			'1f362' => [
				'name' => \XF::phrase('emoji.oden'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':oden:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['kebab', 'seafood', 'skewer', 'stick'],
			],
			'1f361' => [
				'name' => \XF::phrase('emoji.dango'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':dango:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'dessert', 'skewer', 'stick', 'sweet'],
			],
			'1f367' => [
				'name' => \XF::phrase('emoji.shaved_ice'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':shaved_ice:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dessert', 'ice', 'shaved', 'sweet'],
			],
			'1f368' => [
				'name' => \XF::phrase('emoji.ice_cream'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':ice_cream:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cream', 'dessert', 'ice', 'sweet'],
			],
			'1f366' => [
				'name' => \XF::phrase('emoji.icecream'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':icecream:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cream', 'dessert', 'ice', 'icecream', 'soft', 'sweet'],
			],
			'1f967' => [
				'name' => \XF::phrase('emoji.pie'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f370' => [
				'name' => \XF::phrase('emoji.cake'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cake:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cake', 'dessert', 'pastry', 'slice', 'sweet'],
			],
			'1f382' => [
				'name' => \XF::phrase('emoji.birthday'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':birthday:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['birthday', 'cake', 'celebration', 'dessert', 'pastry', 'sweet'],
			],
			'1f96e' => [
				'name' => \XF::phrase('emoji.moon_cake'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':moon_cake:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9c1' => [
				'name' => \XF::phrase('emoji.cupcake'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cupcake:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f36e' => [
				'name' => \XF::phrase('emoji.custard'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':custard:',
				'shortname_alternates' => [':pudding:', ':flan:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dessert', 'pudding', 'sweet'],
			],
			'1f36d' => [
				'name' => \XF::phrase('emoji.lollipop'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':lollipop:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['candy', 'dessert', 'sweet'],
			],
			'1f36c' => [
				'name' => \XF::phrase('emoji.candy'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':candy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dessert', 'sweet'],
			],
			'1f36b' => [
				'name' => \XF::phrase('emoji.chocolate_bar'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':chocolate_bar:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'chocolate', 'dessert', 'sweet'],
			],
			'1f37f' => [
				'name' => \XF::phrase('emoji.popcorn'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':popcorn:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['popcorn'],
			],
			'1f9c2' => [
				'name' => \XF::phrase('emoji.salt'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':salt:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f369' => [
				'name' => \XF::phrase('emoji.doughnut'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':doughnut:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dessert', 'donut', 'sweet'],
			],
			'1f95f' => [
				'name' => \XF::phrase('emoji.dumpling'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':dumpling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['empanada', 'gyōza', 'jiaozi', 'pierogi', 'potsticker'],
			],
			'1f36a' => [
				'name' => \XF::phrase('emoji.cookie'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cookie:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dessert', 'sweet'],
			],
			'1f330' => [
				'name' => \XF::phrase('emoji.chestnut'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':chestnut:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['plant'],
			],
			'1f95c' => [
				'name' => \XF::phrase('emoji.peanuts'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':peanuts:',
				'shortname_alternates' => [':shelled_peanut:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['food', 'nut', 'peanut', 'vegetable'],
			],
			'1f36f' => [
				'name' => \XF::phrase('emoji.honey_pot'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':honey_pot:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['honey', 'honeypot', 'pot', 'sweet'],
			],
			'1f95b' => [
				'name' => \XF::phrase('emoji.milk'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':milk:',
				'shortname_alternates' => [':glass_of_milk:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['drink', 'glass', 'milk'],
			],
			'1f37c' => [
				'name' => \XF::phrase('emoji.baby_bottle'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':baby_bottle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'bottle', 'drink', 'milk'],
			],
			'2615' => [
				'name' => \XF::phrase('emoji.coffee'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':coffee:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beverage', 'coffee', 'drink', 'hot', 'steaming', 'tea'],
			],
			'1f375' => [
				'name' => \XF::phrase('emoji.tea'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':tea:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beverage', 'cup', 'drink', 'tea', 'teacup'],
			],
			'1f964' => [
				'name' => \XF::phrase('emoji.cup_with_straw'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cup_with_straw:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f376' => [
				'name' => \XF::phrase('emoji.sake'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':sake:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'beverage', 'bottle', 'cup', 'drink'],
			],
			'1f37a' => [
				'name' => \XF::phrase('emoji.beer'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':beer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'beer', 'drink', 'mug'],
			],
			'1f37b' => [
				'name' => \XF::phrase('emoji.beers'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':beers:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'beer', 'clink', 'drink', 'mug'],
			],
			'1f942' => [
				'name' => \XF::phrase('emoji.champagne_glass'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':champagne_glass:',
				'shortname_alternates' => [':clinking_glass:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebrate', 'clink', 'drink', 'glass'],
			],
			'1f377' => [
				'name' => \XF::phrase('emoji.wine_glass'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':wine_glass:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'beverage', 'drink', 'glass', 'wine'],
			],
			'1f943' => [
				'name' => \XF::phrase('emoji.tumbler_glass'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':tumbler_glass:',
				'shortname_alternates' => [':whisky:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['glass', 'liquor', 'shot', 'tumbler', 'whisky'],
			],
			'1f378' => [
				'name' => \XF::phrase('emoji.cocktail'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cocktail:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'cocktail', 'drink', 'glass'],
			],
			'1f379' => [
				'name' => \XF::phrase('emoji.tropical_drink'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':tropical_drink:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'drink', 'tropical'],
			],
			'1f37e' => [
				'name' => \XF::phrase('emoji.champagne'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':champagne:',
				'shortname_alternates' => [':bottle_with_popping_cork:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'bottle', 'cork', 'drink', 'popping'],
			],
			'1f944' => [
				'name' => \XF::phrase('emoji.spoon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':spoon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['spoon', 'tableware'],
			],
			'1f374' => [
				'name' => \XF::phrase('emoji.fork_and_knife'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':fork_and_knife:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cooking', 'fork', 'knife'],
			],
			'1f37d' => [
				'name' => \XF::phrase('emoji.fork_knife_plate'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':fork_knife_plate:',
				'shortname_alternates' => [':fork_and_knife_with_plate:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cooking', 'fork', 'knife', 'plate'],
			],
			'1f963' => [
				'name' => \XF::phrase('emoji.bowl_with_spoon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bowl_with_spoon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f961' => [
				'name' => \XF::phrase('emoji.takeout_box'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':takeout_box:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['oyster pail'],
			],
			'1f962' => [
				'name' => \XF::phrase('emoji.chopsticks'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':chopsticks:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'26bd' => [
				'name' => \XF::phrase('emoji.soccer'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':soccer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'football', 'soccer'],
			],
			'1f3c0' => [
				'name' => \XF::phrase('emoji.basketball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':basketball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'hoop'],
			],
			'1f3c8' => [
				'name' => \XF::phrase('emoji.football'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':football:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['american', 'ball', 'football'],
			],
			'26be' => [
				'name' => \XF::phrase('emoji.baseball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':baseball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball'],
			],
			'1f94e' => [
				'name' => \XF::phrase('emoji.softball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':softball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f3be' => [
				'name' => \XF::phrase('emoji.tennis'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':tennis:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'racquet'],
			],
			'1f3d0' => [
				'name' => \XF::phrase('emoji.volleyball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':volleyball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'game'],
			],
			'1f3c9' => [
				'name' => \XF::phrase('emoji.rugby_football'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':rugby_football:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'football', 'rugby'],
			],
			'1f3b1' => [
				'name' => \XF::phrase('emoji.8ball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':8ball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['8', '8 ball', 'ball', 'billiard', 'eight', 'game'],
			],
			'1f3d3' => [
				'name' => \XF::phrase('emoji.ping_pong'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':ping_pong:',
				'shortname_alternates' => [':table_tennis:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'bat', 'game', 'paddle', 'ping pong', 'table tennis'],
			],
			'1f3f8' => [
				'name' => \XF::phrase('emoji.badminton'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':badminton:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['birdie', 'game', 'racquet', 'shuttlecock'],
			],
			'1f945' => [
				'name' => \XF::phrase('emoji.goal'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':goal:',
				'shortname_alternates' => [':goal_net:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['goal', 'net'],
			],
			'1f3d2' => [
				'name' => \XF::phrase('emoji.hockey'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':hockey:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['game', 'hockey', 'ice', 'puck', 'stick'],
			],
			'1f3d1' => [
				'name' => \XF::phrase('emoji.field_hockey'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':field_hockey:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'field', 'game', 'hockey', 'stick'],
			],
			'1f3cf' => [
				'name' => \XF::phrase('emoji.cricket_game'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':cricket_game:',
				'shortname_alternates' => [':cricket_bat_ball:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'bat', 'game'],
			],
			'1f94d' => [
				'name' => \XF::phrase('emoji.lacrosse'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':lacrosse:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'26f3' => [
				'name' => \XF::phrase('emoji.golf'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':golf:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['golf', 'hole'],
			],
			'1f94f' => [
				'name' => \XF::phrase('emoji.flying_disc'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':flying_disc:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f3f9' => [
				'name' => \XF::phrase('emoji.bow_and_arrow'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':bow_and_arrow:',
				'shortname_alternates' => [':archery:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Sagittarius', 'archer', 'archery', 'arrow', 'bow', 'tool', 'weapon', 'zodiac'],
			],
			'1f3a3' => [
				'name' => \XF::phrase('emoji.fishing_pole_and_fish'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':fishing_pole_and_fish:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fish', 'pole'],
			],
			'1f94a' => [
				'name' => \XF::phrase('emoji.boxing_glove'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':boxing_glove:',
				'shortname_alternates' => [':boxing_gloves:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boxing', 'glove'],
			],
			'1f94b' => [
				'name' => \XF::phrase('emoji.martial_arts_uniform'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':martial_arts_uniform:',
				'shortname_alternates' => [':karate_uniform:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['judo', 'karate', 'martial arts', 'taekwondo', 'uniform'],
			],
			'1f3bd' => [
				'name' => \XF::phrase('emoji.running_shirt_with_sash'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':running_shirt_with_sash:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['athletics', 'running', 'sash', 'shirt'],
			],
			'1f6f9' => [
				'name' => \XF::phrase('emoji.skateboard'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':skateboard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'26f8' => [
				'name' => \XF::phrase('emoji.ice_skate'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':ice_skate:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ice', 'skate'],
			],
			'1f94c' => [
				'name' => \XF::phrase('emoji.curling_stone'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':curling_stone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['game', 'rock'],
			],
			'1f6f7' => [
				'name' => \XF::phrase('emoji.sled'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':sled:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f3bf' => [
				'name' => \XF::phrase('emoji.ski'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':ski:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ski', 'snow'],
			],
			'26f7' => [
				'name' => \XF::phrase('emoji.skier'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':skier:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ski', 'snow'],
			],
			'1f3c2' => [
				'name' => \XF::phrase('emoji.snowboarder'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':snowboarder:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3c2-1f3fb', '1f3c2-1f3fc', '1f3c2-1f3fd', '1f3c2-1f3fe', '1f3c2-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ski', 'snow', 'snowboard'],
			],
			'1f3c2-1f3fb' => [
				'name' => \XF::phrase('emoji.snowboarder_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':snowboarder_tone1:',
				'shortname_alternates' => [':snowboarder_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light skin tone', 'ski', 'snow', 'snowboard'],
			],
			'1f3c2-1f3fc' => [
				'name' => \XF::phrase('emoji.snowboarder_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':snowboarder_tone2:',
				'shortname_alternates' => [':snowboarder_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'ski', 'snow', 'snowboard'],
			],
			'1f3c2-1f3fd' => [
				'name' => \XF::phrase('emoji.snowboarder_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':snowboarder_tone3:',
				'shortname_alternates' => [':snowboarder_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium skin tone', 'ski', 'snow', 'snowboard'],
			],
			'1f3c2-1f3fe' => [
				'name' => \XF::phrase('emoji.snowboarder_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':snowboarder_tone4:',
				'shortname_alternates' => [':snowboarder_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'ski', 'snow', 'snowboard'],
			],
			'1f3c2-1f3ff' => [
				'name' => \XF::phrase('emoji.snowboarder_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':snowboarder_tone5:',
				'shortname_alternates' => [':snowboarder_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'ski', 'snow', 'snowboard'],
			],
			'1f3cb' => [
				'name' => \XF::phrase('emoji.person_lifting_weights'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_lifting_weights:',
				'shortname_alternates' => [':lifter:', ':weight_lifter:'],
				'diversity' => '',
				'diversities' => ['1f3cb-1f3fb', '1f3cb-1f3fc', '1f3cb-1f3fd', '1f3cb-1f3fe', '1f3cb-1f3ff'],
				'gender' => '',
				'genders' => ['1f3cb-2642', '1f3cb-2640'],
				'keywords' => ['lifter', 'weight'],
			],
			'1f3cb-1f3fb' => [
				'name' => \XF::phrase('emoji.person_lifting_weights_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_lifting_weights_tone1:',
				'shortname_alternates' => [':lifter_tone1:', ':weight_lifter_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cb-1f3fb-2642', '1f3cb-1f3fb-2640'],
				'keywords' => ['lifter', 'light skin tone', 'weight'],
			],
			'1f3cb-1f3fc' => [
				'name' => \XF::phrase('emoji.person_lifting_weights_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_lifting_weights_tone2:',
				'shortname_alternates' => [':lifter_tone2:', ':weight_lifter_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cb-1f3fc-2642', '1f3cb-1f3fc-2640'],
				'keywords' => ['lifter', 'medium-light skin tone', 'weight'],
			],
			'1f3cb-1f3fd' => [
				'name' => \XF::phrase('emoji.person_lifting_weights_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_lifting_weights_tone3:',
				'shortname_alternates' => [':lifter_tone3:', ':weight_lifter_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cb-1f3fd-2642', '1f3cb-1f3fd-2640'],
				'keywords' => ['lifter', 'medium skin tone', 'weight'],
			],
			'1f3cb-1f3fe' => [
				'name' => \XF::phrase('emoji.person_lifting_weights_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_lifting_weights_tone4:',
				'shortname_alternates' => [':lifter_tone4:', ':weight_lifter_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cb-1f3fe-2642', '1f3cb-1f3fe-2640'],
				'keywords' => ['lifter', 'medium-dark skin tone', 'weight'],
			],
			'1f3cb-1f3ff' => [
				'name' => \XF::phrase('emoji.person_lifting_weights_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_lifting_weights_tone5:',
				'shortname_alternates' => [':lifter_tone5:', ':weight_lifter_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cb-1f3ff-2642', '1f3cb-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'lifter', 'weight'],
			],
			'1f3cb-2640' => [
				'name' => \XF::phrase('emoji.woman_lifting_weights'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_lifting_weights:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3cb-1f3fb-2640', '1f3cb-1f3fc-2640', '1f3cb-1f3fd-2640', '1f3cb-1f3fe-2640', '1f3cb-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['weight lifter', 'woman'],
			],
			'1f3cb-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_lifting_weights_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_lifting_weights_tone1:',
				'shortname_alternates' => [':woman_lifting_weights_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'weight lifter', 'woman'],
			],
			'1f3cb-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_lifting_weights_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_lifting_weights_tone2:',
				'shortname_alternates' => [':woman_lifting_weights_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'weight lifter', 'woman'],
			],
			'1f3cb-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_lifting_weights_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_lifting_weights_tone3:',
				'shortname_alternates' => [':woman_lifting_weights_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'weight lifter', 'woman'],
			],
			'1f3cb-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_lifting_weights_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_lifting_weights_tone4:',
				'shortname_alternates' => [':woman_lifting_weights_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'weight lifter', 'woman'],
			],
			'1f3cb-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_lifting_weights_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_lifting_weights_tone5:',
				'shortname_alternates' => [':woman_lifting_weights_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'weight lifter', 'woman'],
			],
			'1f3cb-2642' => [
				'name' => \XF::phrase('emoji.man_lifting_weights'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_lifting_weights:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3cb-1f3fb-2642', '1f3cb-1f3fc-2642', '1f3cb-1f3fd-2642', '1f3cb-1f3fe-2642', '1f3cb-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'weight lifter'],
			],
			'1f3cb-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_lifting_weights_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_lifting_weights_tone1:',
				'shortname_alternates' => [':man_lifting_weights_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'weight lifter'],
			],
			'1f3cb-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_lifting_weights_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_lifting_weights_tone2:',
				'shortname_alternates' => [':man_lifting_weights_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'weight lifter'],
			],
			'1f3cb-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_lifting_weights_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_lifting_weights_tone3:',
				'shortname_alternates' => [':man_lifting_weights_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'weight lifter'],
			],
			'1f3cb-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_lifting_weights_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_lifting_weights_tone4:',
				'shortname_alternates' => [':man_lifting_weights_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'weight lifter'],
			],
			'1f3cb-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_lifting_weights_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_lifting_weights_tone5:',
				'shortname_alternates' => [':man_lifting_weights_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'weight lifter'],
			],
			'1f93c' => [
				'name' => \XF::phrase('emoji.people_wrestling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':people_wrestling:',
				'shortname_alternates' => [':wrestlers:', ':wrestling:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93c-2642', '1f93c-2640'],
				'keywords' => ['wrestle', 'wrestler'],
			],
			'1f93c-2640' => [
				'name' => \XF::phrase('emoji.women_wrestling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':women_wrestling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['women', 'wrestle'],
			],
			'1f93c-2642' => [
				'name' => \XF::phrase('emoji.men_wrestling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':men_wrestling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['men', 'wrestle'],
			],
			'1f938' => [
				'name' => \XF::phrase('emoji.person_doing_cartwheel'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_doing_cartwheel:',
				'shortname_alternates' => [':cartwheel:'],
				'diversity' => '',
				'diversities' => ['1f938-1f3fb', '1f938-1f3fc', '1f938-1f3fd', '1f938-1f3fe', '1f938-1f3ff'],
				'gender' => '',
				'genders' => ['1f938-2642', '1f938-2640'],
				'keywords' => ['cartwheel', 'gymnastics'],
			],
			'1f938-1f3fb' => [
				'name' => \XF::phrase('emoji.person_doing_cartwheel_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_doing_cartwheel_tone1:',
				'shortname_alternates' => [':cartwheel_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f938-1f3fb-2642', '1f938-1f3fb-2640'],
				'keywords' => ['cartwheel', 'gymnastics', 'light skin tone'],
			],
			'1f938-1f3fc' => [
				'name' => \XF::phrase('emoji.person_doing_cartwheel_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_doing_cartwheel_tone2:',
				'shortname_alternates' => [':cartwheel_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f938-1f3fc-2642', '1f938-1f3fc-2640'],
				'keywords' => ['cartwheel', 'gymnastics', 'medium-light skin tone'],
			],
			'1f938-1f3fd' => [
				'name' => \XF::phrase('emoji.person_doing_cartwheel_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_doing_cartwheel_tone3:',
				'shortname_alternates' => [':cartwheel_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f938-1f3fd-2642', '1f938-1f3fd-2640'],
				'keywords' => ['cartwheel', 'gymnastics', 'medium skin tone'],
			],
			'1f938-1f3fe' => [
				'name' => \XF::phrase('emoji.person_doing_cartwheel_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_doing_cartwheel_tone4:',
				'shortname_alternates' => [':cartwheel_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f938-1f3fe-2642', '1f938-1f3fe-2640'],
				'keywords' => ['cartwheel', 'gymnastics', 'medium-dark skin tone'],
			],
			'1f938-1f3ff' => [
				'name' => \XF::phrase('emoji.person_doing_cartwheel_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_doing_cartwheel_tone5:',
				'shortname_alternates' => [':cartwheel_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f938-1f3ff-2642', '1f938-1f3ff-2640'],
				'keywords' => ['cartwheel', 'dark skin tone', 'gymnastics'],
			],
			'1f938-2640' => [
				'name' => \XF::phrase('emoji.woman_cartwheeling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_cartwheeling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f938-1f3fb-2640', '1f938-1f3fc-2640', '1f938-1f3fd-2640', '1f938-1f3fe-2640', '1f938-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'woman'],
			],
			'1f938-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_cartwheeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_cartwheeling_tone1:',
				'shortname_alternates' => [':woman_cartwheeling_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'light skin tone', 'woman'],
			],
			'1f938-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_cartwheeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_cartwheeling_tone2:',
				'shortname_alternates' => [':woman_cartwheeling_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'medium-light skin tone', 'woman'],
			],
			'1f938-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_cartwheeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_cartwheeling_tone3:',
				'shortname_alternates' => [':woman_cartwheeling_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'medium skin tone', 'woman'],
			],
			'1f938-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_cartwheeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_cartwheeling_tone4:',
				'shortname_alternates' => [':woman_cartwheeling_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'medium-dark skin tone', 'woman'],
			],
			'1f938-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_cartwheeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_cartwheeling_tone5:',
				'shortname_alternates' => [':woman_cartwheeling_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['cartwheel', 'dark skin tone', 'gymnastics', 'woman'],
			],
			'1f938-2642' => [
				'name' => \XF::phrase('emoji.man_cartwheeling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_cartwheeling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f938-1f3fb-2642', '1f938-1f3fc-2642', '1f938-1f3fd-2642', '1f938-1f3fe-2642', '1f938-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'man'],
			],
			'1f938-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_cartwheeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_cartwheeling_tone1:',
				'shortname_alternates' => [':man_cartwheeling_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'light skin tone', 'man'],
			],
			'1f938-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_cartwheeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_cartwheeling_tone2:',
				'shortname_alternates' => [':man_cartwheeling_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'man', 'medium-light skin tone'],
			],
			'1f938-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_cartwheeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_cartwheeling_tone3:',
				'shortname_alternates' => [':man_cartwheeling_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'man', 'medium skin tone'],
			],
			'1f938-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_cartwheeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_cartwheeling_tone4:',
				'shortname_alternates' => [':man_cartwheeling_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cartwheel', 'gymnastics', 'man', 'medium-dark skin tone'],
			],
			'1f938-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_cartwheeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_cartwheeling_tone5:',
				'shortname_alternates' => [':man_cartwheeling_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['cartwheel', 'dark skin tone', 'gymnastics', 'man'],
			],
			'26f9' => [
				'name' => \XF::phrase('emoji.person_bouncing_ball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_bouncing_ball:',
				'shortname_alternates' => [':basketball_player:', ':person_with_ball:'],
				'diversity' => '',
				'diversities' => ['26f9-1f3fb', '26f9-1f3fc', '26f9-1f3fd', '26f9-1f3fe', '26f9-1f3ff'],
				'gender' => '',
				'genders' => ['26f9-2642', '26f9-2640'],
				'keywords' => ['ball'],
			],
			'26f9-1f3fb' => [
				'name' => \XF::phrase('emoji.person_bouncing_ball_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_bouncing_ball_tone1:',
				'shortname_alternates' => [':basketball_player_tone1:', ':person_with_ball_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['26f9-1f3fb-2642', '26f9-1f3fb-2640'],
				'keywords' => ['ball', 'light skin tone'],
			],
			'26f9-1f3fc' => [
				'name' => \XF::phrase('emoji.person_bouncing_ball_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_bouncing_ball_tone2:',
				'shortname_alternates' => [':basketball_player_tone2:', ':person_with_ball_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['26f9-1f3fc-2642', '26f9-1f3fc-2640'],
				'keywords' => ['ball', 'medium-light skin tone'],
			],
			'26f9-1f3fd' => [
				'name' => \XF::phrase('emoji.person_bouncing_ball_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_bouncing_ball_tone3:',
				'shortname_alternates' => [':basketball_player_tone3:', ':person_with_ball_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['26f9-1f3fd-2642', '26f9-1f3fd-2640'],
				'keywords' => ['ball', 'medium skin tone'],
			],
			'26f9-1f3fe' => [
				'name' => \XF::phrase('emoji.person_bouncing_ball_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_bouncing_ball_tone4:',
				'shortname_alternates' => [':basketball_player_tone4:', ':person_with_ball_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['26f9-1f3fe-2642', '26f9-1f3fe-2640'],
				'keywords' => ['ball', 'medium-dark skin tone'],
			],
			'26f9-1f3ff' => [
				'name' => \XF::phrase('emoji.person_bouncing_ball_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_bouncing_ball_tone5:',
				'shortname_alternates' => [':basketball_player_tone5:', ':person_with_ball_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['26f9-1f3ff-2642', '26f9-1f3ff-2640'],
				'keywords' => ['ball', 'dark skin tone'],
			],
			'26f9-2640' => [
				'name' => \XF::phrase('emoji.woman_bouncing_ball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_bouncing_ball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['26f9-1f3fb-2640', '26f9-1f3fc-2640', '26f9-1f3fd-2640', '26f9-1f3fe-2640', '26f9-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['ball', 'woman'],
			],
			'26f9-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_bouncing_ball_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_bouncing_ball_tone1:',
				'shortname_alternates' => [':woman_bouncing_ball_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['ball', 'light skin tone', 'woman'],
			],
			'26f9-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_bouncing_ball_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_bouncing_ball_tone2:',
				'shortname_alternates' => [':woman_bouncing_ball_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['ball', 'medium-light skin tone', 'woman'],
			],
			'26f9-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_bouncing_ball_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_bouncing_ball_tone3:',
				'shortname_alternates' => [':woman_bouncing_ball_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['ball', 'medium skin tone', 'woman'],
			],
			'26f9-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_bouncing_ball_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_bouncing_ball_tone4:',
				'shortname_alternates' => [':woman_bouncing_ball_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['ball', 'medium-dark skin tone', 'woman'],
			],
			'26f9-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_bouncing_ball_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_bouncing_ball_tone5:',
				'shortname_alternates' => [':woman_bouncing_ball_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['ball', 'dark skin tone', 'woman'],
			],
			'26f9-2642' => [
				'name' => \XF::phrase('emoji.man_bouncing_ball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_bouncing_ball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['26f9-1f3fb-2642', '26f9-1f3fc-2642', '26f9-1f3fd-2642', '26f9-1f3fe-2642', '26f9-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['ball', 'man'],
			],
			'26f9-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_bouncing_ball_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_bouncing_ball_tone1:',
				'shortname_alternates' => [':man_bouncing_ball_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['ball', 'light skin tone', 'man'],
			],
			'26f9-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_bouncing_ball_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_bouncing_ball_tone2:',
				'shortname_alternates' => [':man_bouncing_ball_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['ball', 'man', 'medium-light skin tone'],
			],
			'26f9-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_bouncing_ball_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_bouncing_ball_tone3:',
				'shortname_alternates' => [':man_bouncing_ball_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['ball', 'man', 'medium skin tone'],
			],
			'26f9-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_bouncing_ball_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_bouncing_ball_tone4:',
				'shortname_alternates' => [':man_bouncing_ball_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['ball', 'man', 'medium-dark skin tone'],
			],
			'26f9-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_bouncing_ball_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_bouncing_ball_tone5:',
				'shortname_alternates' => [':man_bouncing_ball_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['ball', 'dark skin tone', 'man'],
			],
			'1f93a' => [
				'name' => \XF::phrase('emoji.person_fencing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_fencing:',
				'shortname_alternates' => [':fencer:', ':fencing:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fencer', 'fencing', 'sword'],
			],
			'1f93e' => [
				'name' => \XF::phrase('emoji.person_playing_handball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_handball:',
				'shortname_alternates' => [':handball:'],
				'diversity' => '',
				'diversities' => ['1f93e-1f3fb', '1f93e-1f3fc', '1f93e-1f3fd', '1f93e-1f3fe', '1f93e-1f3ff'],
				'gender' => '',
				'genders' => ['1f93e-2642', '1f93e-2640'],
				'keywords' => ['ball', 'handball'],
			],
			'1f93e-1f3fb' => [
				'name' => \XF::phrase('emoji.person_playing_handball_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_handball_tone1:',
				'shortname_alternates' => [':handball_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93e-1f3fb-2642', '1f93e-1f3fb-2640'],
				'keywords' => ['ball', 'handball', 'light skin tone'],
			],
			'1f93e-1f3fc' => [
				'name' => \XF::phrase('emoji.person_playing_handball_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_handball_tone2:',
				'shortname_alternates' => [':handball_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93e-1f3fc-2642', '1f93e-1f3fc-2640'],
				'keywords' => ['ball', 'handball', 'medium-light skin tone'],
			],
			'1f93e-1f3fd' => [
				'name' => \XF::phrase('emoji.person_playing_handball_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_handball_tone3:',
				'shortname_alternates' => [':handball_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93e-1f3fd-2642', '1f93e-1f3fd-2640'],
				'keywords' => ['ball', 'handball', 'medium skin tone'],
			],
			'1f93e-1f3fe' => [
				'name' => \XF::phrase('emoji.person_playing_handball_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_handball_tone4:',
				'shortname_alternates' => [':handball_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93e-1f3fe-2642', '1f93e-1f3fe-2640'],
				'keywords' => ['ball', 'handball', 'medium-dark skin tone'],
			],
			'1f93e-1f3ff' => [
				'name' => \XF::phrase('emoji.person_playing_handball_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_handball_tone5:',
				'shortname_alternates' => [':handball_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93e-1f3ff-2642', '1f93e-1f3ff-2640'],
				'keywords' => ['ball', 'dark skin tone', 'handball'],
			],
			'1f93e-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_handball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_handball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f93e-1f3fb-2640', '1f93e-1f3fc-2640', '1f93e-1f3fd-2640', '1f93e-1f3fe-2640', '1f93e-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['handball', 'woman'],
			],
			'1f93e-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_handball_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_handball_tone1:',
				'shortname_alternates' => [':woman_playing_handball_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['handball', 'light skin tone', 'woman'],
			],
			'1f93e-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_handball_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_handball_tone2:',
				'shortname_alternates' => [':woman_playing_handball_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['handball', 'medium-light skin tone', 'woman'],
			],
			'1f93e-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_handball_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_handball_tone3:',
				'shortname_alternates' => [':woman_playing_handball_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['handball', 'medium skin tone', 'woman'],
			],
			'1f93e-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_handball_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_handball_tone4:',
				'shortname_alternates' => [':woman_playing_handball_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['handball', 'medium-dark skin tone', 'woman'],
			],
			'1f93e-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_handball_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_handball_tone5:',
				'shortname_alternates' => [':woman_playing_handball_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'handball', 'woman'],
			],
			'1f93e-2642' => [
				'name' => \XF::phrase('emoji.man_playing_handball'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_handball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f93e-1f3fb-2642', '1f93e-1f3fc-2642', '1f93e-1f3fd-2642', '1f93e-1f3fe-2642', '1f93e-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['handball', 'man'],
			],
			'1f93e-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_playing_handball_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_handball_tone1:',
				'shortname_alternates' => [':man_playing_handball_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['handball', 'light skin tone', 'man'],
			],
			'1f93e-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_playing_handball_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_handball_tone2:',
				'shortname_alternates' => [':man_playing_handball_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['handball', 'man', 'medium-light skin tone'],
			],
			'1f93e-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_playing_handball_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_handball_tone3:',
				'shortname_alternates' => [':man_playing_handball_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['handball', 'man', 'medium skin tone'],
			],
			'1f93e-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_playing_handball_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_handball_tone4:',
				'shortname_alternates' => [':man_playing_handball_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['handball', 'man', 'medium-dark skin tone'],
			],
			'1f93e-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_playing_handball_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_handball_tone5:',
				'shortname_alternates' => [':man_playing_handball_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'handball', 'man'],
			],
			'1f3cc' => [
				'name' => \XF::phrase('emoji.person_golfing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_golfing:',
				'shortname_alternates' => [':golfer:'],
				'diversity' => '',
				'diversities' => ['1f3cc-1f3fb', '1f3cc-1f3fc', '1f3cc-1f3fd', '1f3cc-1f3fe', '1f3cc-1f3ff'],
				'gender' => '',
				'genders' => ['1f3cc-2642', '1f3cc-2640'],
				'keywords' => ['ball', 'golf'],
			],
			'1f3cc-1f3fb' => [
				'name' => \XF::phrase('emoji.person_golfing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_golfing_tone1:',
				'shortname_alternates' => [':person_golfing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cc-1f3fb-2642', '1f3cc-1f3fb-2640'],
				'keywords' => ['ball', 'golf', 'light skin tone'],
			],
			'1f3cc-1f3fc' => [
				'name' => \XF::phrase('emoji.person_golfing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_golfing_tone2:',
				'shortname_alternates' => [':person_golfing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cc-1f3fc-2642', '1f3cc-1f3fc-2640'],
				'keywords' => ['ball', 'golf', 'medium-light skin tone'],
			],
			'1f3cc-1f3fd' => [
				'name' => \XF::phrase('emoji.person_golfing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_golfing_tone3:',
				'shortname_alternates' => [':person_golfing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cc-1f3fd-2642', '1f3cc-1f3fd-2640'],
				'keywords' => ['ball', 'golf', 'medium skin tone'],
			],
			'1f3cc-1f3fe' => [
				'name' => \XF::phrase('emoji.person_golfing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_golfing_tone4:',
				'shortname_alternates' => [':person_golfing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cc-1f3fe-2642', '1f3cc-1f3fe-2640'],
				'keywords' => ['ball', 'golf', 'medium-dark skin tone'],
			],
			'1f3cc-1f3ff' => [
				'name' => \XF::phrase('emoji.person_golfing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_golfing_tone5:',
				'shortname_alternates' => [':person_golfing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3cc-1f3ff-2642', '1f3cc-1f3ff-2640'],
				'keywords' => ['ball', 'dark skin tone', 'golf'],
			],
			'1f3cc-2640' => [
				'name' => \XF::phrase('emoji.woman_golfing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_golfing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3cc-1f3fb-2640', '1f3cc-1f3fc-2640', '1f3cc-1f3fd-2640', '1f3cc-1f3fe-2640', '1f3cc-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['golf', 'woman'],
			],
			'1f3cc-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_golfing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_golfing_tone1:',
				'shortname_alternates' => [':woman_golfing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['golf', 'light skin tone', 'woman'],
			],
			'1f3cc-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_golfing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_golfing_tone2:',
				'shortname_alternates' => [':woman_golfing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['golf', 'medium-light skin tone', 'woman'],
			],
			'1f3cc-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_golfing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_golfing_tone3:',
				'shortname_alternates' => [':woman_golfing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['golf', 'medium skin tone', 'woman'],
			],
			'1f3cc-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_golfing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_golfing_tone4:',
				'shortname_alternates' => [':woman_golfing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['golf', 'medium-dark skin tone', 'woman'],
			],
			'1f3cc-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_golfing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_golfing_tone5:',
				'shortname_alternates' => [':woman_golfing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'golf', 'woman'],
			],
			'1f3cc-2642' => [
				'name' => \XF::phrase('emoji.man_golfing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_golfing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3cc-1f3fb-2642', '1f3cc-1f3fc-2642', '1f3cc-1f3fd-2642', '1f3cc-1f3fe-2642', '1f3cc-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['golf', 'man'],
			],
			'1f3cc-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_golfing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_golfing_tone1:',
				'shortname_alternates' => [':man_golfing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['golf', 'light skin tone', 'man'],
			],
			'1f3cc-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_golfing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_golfing_tone2:',
				'shortname_alternates' => [':man_golfing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['golf', 'man', 'medium-light skin tone'],
			],
			'1f3cc-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_golfing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_golfing_tone3:',
				'shortname_alternates' => [':man_golfing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['golf', 'man', 'medium skin tone'],
			],
			'1f3cc-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_golfing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_golfing_tone4:',
				'shortname_alternates' => [':man_golfing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['golf', 'man', 'medium-dark skin tone'],
			],
			'1f3cc-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_golfing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_golfing_tone5:',
				'shortname_alternates' => [':man_golfing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'golf', 'man'],
			],
			'1f3c7' => [
				'name' => \XF::phrase('emoji.horse_racing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':horse_racing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3c7-1f3fb', '1f3c7-1f3fc', '1f3c7-1f3fd', '1f3c7-1f3fe', '1f3c7-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['horse', 'jockey', 'racehorse', 'racing'],
			],
			'1f3c7-1f3fb' => [
				'name' => \XF::phrase('emoji.horse_racing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':horse_racing_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['horse', 'jockey', 'light skin tone', 'racehorse', 'racing'],
			],
			'1f3c7-1f3fc' => [
				'name' => \XF::phrase('emoji.horse_racing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':horse_racing_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['horse', 'jockey', 'medium-light skin tone', 'racehorse', 'racing'],
			],
			'1f3c7-1f3fd' => [
				'name' => \XF::phrase('emoji.horse_racing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':horse_racing_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['horse', 'jockey', 'medium skin tone', 'racehorse', 'racing'],
			],
			'1f3c7-1f3fe' => [
				'name' => \XF::phrase('emoji.horse_racing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':horse_racing_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['horse', 'jockey', 'medium-dark skin tone', 'racehorse', 'racing'],
			],
			'1f3c7-1f3ff' => [
				'name' => \XF::phrase('emoji.horse_racing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':horse_racing_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'horse', 'jockey', 'racehorse', 'racing'],
			],
			'1f9d8' => [
				'name' => \XF::phrase('emoji.person_in_lotus_position'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_in_lotus_position:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d8-1f3fb', '1f9d8-1f3fc', '1f9d8-1f3fd', '1f9d8-1f3fe', '1f9d8-1f3ff'],
				'gender' => '',
				'genders' => ['1f9d8-2642', '1f9d8-2640'],
				'keywords' => [''],
			],
			'1f9d8-1f3fb' => [
				'name' => \XF::phrase('emoji.person_in_lotus_position_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_in_lotus_position_tone1:',
				'shortname_alternates' => [':person_in_lotus_position_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d8-1f3fb-2642', '1f9d8-1f3fb-2640'],
				'keywords' => ['light skin tone', 'meditation', 'yoga'],
			],
			'1f9d8-1f3fc' => [
				'name' => \XF::phrase('emoji.person_in_lotus_position_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_in_lotus_position_tone2:',
				'shortname_alternates' => [':person_in_lotus_position_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d8-1f3fc-2642', '1f9d8-1f3fc-2640'],
				'keywords' => ['meditation', 'medium-light skin tone', 'yoga'],
			],
			'1f9d8-1f3fd' => [
				'name' => \XF::phrase('emoji.person_in_lotus_position_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_in_lotus_position_tone3:',
				'shortname_alternates' => [':person_in_lotus_position_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d8-1f3fd-2642', '1f9d8-1f3fd-2640'],
				'keywords' => ['meditation', 'medium skin tone', 'yoga'],
			],
			'1f9d8-1f3fe' => [
				'name' => \XF::phrase('emoji.person_in_lotus_position_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_in_lotus_position_tone4:',
				'shortname_alternates' => [':person_in_lotus_position_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d8-1f3fe-2642', '1f9d8-1f3fe-2640'],
				'keywords' => ['meditation', 'medium-dark skin tone', 'yoga'],
			],
			'1f9d8-1f3ff' => [
				'name' => \XF::phrase('emoji.person_in_lotus_position_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_in_lotus_position_tone5:',
				'shortname_alternates' => [':person_in_lotus_position_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d8-1f3ff-2642', '1f9d8-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'meditation', 'yoga'],
			],
			'1f9d8-2640' => [
				'name' => \XF::phrase('emoji.woman_in_lotus_position'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_in_lotus_position:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d8-1f3fb-2640', '1f9d8-1f3fc-2640', '1f9d8-1f3fd-2640', '1f9d8-1f3fe-2640', '1f9d8-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['meditation', 'yoga'],
			],
			'1f9d8-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_in_lotus_position_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_in_lotus_position_tone1:',
				'shortname_alternates' => [':woman_in_lotus_position_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'meditation', 'yoga'],
			],
			'1f9d8-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_in_lotus_position_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_in_lotus_position_tone2:',
				'shortname_alternates' => [':woman_in_lotus_position_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['meditation', 'medium-light skin tone', 'yoga'],
			],
			'1f9d8-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_in_lotus_position_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_in_lotus_position_tone3:',
				'shortname_alternates' => [':woman_in_lotus_position_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['meditation', 'medium skin tone', 'yoga'],
			],
			'1f9d8-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_in_lotus_position_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_in_lotus_position_tone4:',
				'shortname_alternates' => [':woman_in_lotus_position_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['meditation', 'medium-dark skin tone', 'yoga'],
			],
			'1f9d8-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_in_lotus_position_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_in_lotus_position_tone5:',
				'shortname_alternates' => [':woman_in_lotus_position_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'meditation', 'yoga'],
			],
			'1f9d8-2642' => [
				'name' => \XF::phrase('emoji.man_in_lotus_position'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_in_lotus_position:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d8-1f3fb-2642', '1f9d8-1f3fc-2642', '1f9d8-1f3fd-2642', '1f9d8-1f3fe-2642', '1f9d8-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['meditation', 'yoga'],
			],
			'1f9d8-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_in_lotus_position_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_in_lotus_position_tone1:',
				'shortname_alternates' => [':man_in_lotus_position_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'meditation', 'yoga'],
			],
			'1f9d8-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_in_lotus_position_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_in_lotus_position_tone2:',
				'shortname_alternates' => [':man_in_lotus_position_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['meditation', 'medium-light skin tone', 'yoga'],
			],
			'1f9d8-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_in_lotus_position_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_in_lotus_position_tone3:',
				'shortname_alternates' => [':man_in_lotus_position_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['meditation', 'medium skin tone', 'yoga'],
			],
			'1f9d8-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_in_lotus_position_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_in_lotus_position_tone4:',
				'shortname_alternates' => [':man_in_lotus_position_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['meditation', 'medium-dark skin tone', 'yoga'],
			],
			'1f9d8-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_in_lotus_position_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_in_lotus_position_tone5:',
				'shortname_alternates' => [':man_in_lotus_position_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'meditation', 'yoga'],
			],
			'1f3c4' => [
				'name' => \XF::phrase('emoji.person_surfing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_surfing:',
				'shortname_alternates' => [':surfer:'],
				'diversity' => '',
				'diversities' => ['1f3c4-1f3fb', '1f3c4-1f3fc', '1f3c4-1f3fd', '1f3c4-1f3fe', '1f3c4-1f3ff'],
				'gender' => '',
				'genders' => ['1f3c4-2642', '1f3c4-2640'],
				'keywords' => ['surfing'],
			],
			'1f3c4-1f3fb' => [
				'name' => \XF::phrase('emoji.person_surfing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_surfing_tone1:',
				'shortname_alternates' => [':surfer_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c4-1f3fb-2642', '1f3c4-1f3fb-2640'],
				'keywords' => ['light skin tone', 'surfing'],
			],
			'1f3c4-1f3fc' => [
				'name' => \XF::phrase('emoji.person_surfing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_surfing_tone2:',
				'shortname_alternates' => [':surfer_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c4-1f3fc-2642', '1f3c4-1f3fc-2640'],
				'keywords' => ['medium-light skin tone', 'surfing'],
			],
			'1f3c4-1f3fd' => [
				'name' => \XF::phrase('emoji.person_surfing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_surfing_tone3:',
				'shortname_alternates' => [':surfer_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c4-1f3fd-2642', '1f3c4-1f3fd-2640'],
				'keywords' => ['medium skin tone', 'surfing'],
			],
			'1f3c4-1f3fe' => [
				'name' => \XF::phrase('emoji.person_surfing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_surfing_tone4:',
				'shortname_alternates' => [':surfer_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c4-1f3fe-2642', '1f3c4-1f3fe-2640'],
				'keywords' => ['medium-dark skin tone', 'surfing'],
			],
			'1f3c4-1f3ff' => [
				'name' => \XF::phrase('emoji.person_surfing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_surfing_tone5:',
				'shortname_alternates' => [':surfer_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3c4-1f3ff-2642', '1f3c4-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'surfing'],
			],
			'1f3c4-2640' => [
				'name' => \XF::phrase('emoji.woman_surfing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_surfing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3c4-1f3fb-2640', '1f3c4-1f3fc-2640', '1f3c4-1f3fd-2640', '1f3c4-1f3fe-2640', '1f3c4-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['surfing', 'woman'],
			],
			'1f3c4-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_surfing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_surfing_tone1:',
				'shortname_alternates' => [':woman_surfing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'surfing', 'woman'],
			],
			'1f3c4-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_surfing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_surfing_tone2:',
				'shortname_alternates' => [':woman_surfing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'surfing', 'woman'],
			],
			'1f3c4-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_surfing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_surfing_tone3:',
				'shortname_alternates' => [':woman_surfing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'surfing', 'woman'],
			],
			'1f3c4-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_surfing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_surfing_tone4:',
				'shortname_alternates' => [':woman_surfing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'surfing', 'woman'],
			],
			'1f3c4-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_surfing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_surfing_tone5:',
				'shortname_alternates' => [':woman_surfing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'surfing', 'woman'],
			],
			'1f3c4-2642' => [
				'name' => \XF::phrase('emoji.man_surfing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_surfing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3c4-1f3fb-2642', '1f3c4-1f3fc-2642', '1f3c4-1f3fd-2642', '1f3c4-1f3fe-2642', '1f3c4-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'surfing'],
			],
			'1f3c4-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_surfing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_surfing_tone1:',
				'shortname_alternates' => [':man_surfing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'surfing'],
			],
			'1f3c4-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_surfing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_surfing_tone2:',
				'shortname_alternates' => [':man_surfing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'surfing'],
			],
			'1f3c4-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_surfing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_surfing_tone3:',
				'shortname_alternates' => [':man_surfing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'surfing'],
			],
			'1f3c4-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_surfing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_surfing_tone4:',
				'shortname_alternates' => [':man_surfing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'surfing'],
			],
			'1f3c4-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_surfing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_surfing_tone5:',
				'shortname_alternates' => [':man_surfing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'surfing'],
			],
			'1f3ca' => [
				'name' => \XF::phrase('emoji.person_swimming'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_swimming:',
				'shortname_alternates' => [':swimmer:'],
				'diversity' => '',
				'diversities' => ['1f3ca-1f3fb', '1f3ca-1f3fc', '1f3ca-1f3fd', '1f3ca-1f3fe', '1f3ca-1f3ff'],
				'gender' => '',
				'genders' => ['1f3ca-2642', '1f3ca-2640'],
				'keywords' => ['swim'],
			],
			'1f3ca-1f3fb' => [
				'name' => \XF::phrase('emoji.person_swimming_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_swimming_tone1:',
				'shortname_alternates' => [':swimmer_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3ca-1f3fb-2642', '1f3ca-1f3fb-2640'],
				'keywords' => ['light skin tone', 'swim'],
			],
			'1f3ca-1f3fc' => [
				'name' => \XF::phrase('emoji.person_swimming_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_swimming_tone2:',
				'shortname_alternates' => [':swimmer_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3ca-1f3fc-2642', '1f3ca-1f3fc-2640'],
				'keywords' => ['medium-light skin tone', 'swim'],
			],
			'1f3ca-1f3fd' => [
				'name' => \XF::phrase('emoji.person_swimming_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_swimming_tone3:',
				'shortname_alternates' => [':swimmer_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3ca-1f3fd-2642', '1f3ca-1f3fd-2640'],
				'keywords' => ['medium skin tone', 'swim'],
			],
			'1f3ca-1f3fe' => [
				'name' => \XF::phrase('emoji.person_swimming_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_swimming_tone4:',
				'shortname_alternates' => [':swimmer_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3ca-1f3fe-2642', '1f3ca-1f3fe-2640'],
				'keywords' => ['medium-dark skin tone', 'swim'],
			],
			'1f3ca-1f3ff' => [
				'name' => \XF::phrase('emoji.person_swimming_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_swimming_tone5:',
				'shortname_alternates' => [':swimmer_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f3ca-1f3ff-2642', '1f3ca-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'swim'],
			],
			'1f3ca-2640' => [
				'name' => \XF::phrase('emoji.woman_swimming'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_swimming:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3ca-1f3fb-2640', '1f3ca-1f3fc-2640', '1f3ca-1f3fd-2640', '1f3ca-1f3fe-2640', '1f3ca-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['swim', 'woman'],
			],
			'1f3ca-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_swimming_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_swimming_tone1:',
				'shortname_alternates' => [':woman_swimming_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'swim', 'woman'],
			],
			'1f3ca-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_swimming_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_swimming_tone2:',
				'shortname_alternates' => [':woman_swimming_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'swim', 'woman'],
			],
			'1f3ca-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_swimming_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_swimming_tone3:',
				'shortname_alternates' => [':woman_swimming_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'swim', 'woman'],
			],
			'1f3ca-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_swimming_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_swimming_tone4:',
				'shortname_alternates' => [':woman_swimming_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'swim', 'woman'],
			],
			'1f3ca-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_swimming_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_swimming_tone5:',
				'shortname_alternates' => [':woman_swimming_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'swim', 'woman'],
			],
			'1f3ca-2642' => [
				'name' => \XF::phrase('emoji.man_swimming'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_swimming:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f3ca-1f3fb-2642', '1f3ca-1f3fc-2642', '1f3ca-1f3fd-2642', '1f3ca-1f3fe-2642', '1f3ca-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'swim'],
			],
			'1f3ca-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_swimming_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_swimming_tone1:',
				'shortname_alternates' => [':man_swimming_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'swim'],
			],
			'1f3ca-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_swimming_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_swimming_tone2:',
				'shortname_alternates' => [':man_swimming_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'swim'],
			],
			'1f3ca-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_swimming_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_swimming_tone3:',
				'shortname_alternates' => [':man_swimming_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'swim'],
			],
			'1f3ca-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_swimming_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_swimming_tone4:',
				'shortname_alternates' => [':man_swimming_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'swim'],
			],
			'1f3ca-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_swimming_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_swimming_tone5:',
				'shortname_alternates' => [':man_swimming_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'swim'],
			],
			'1f93d' => [
				'name' => \XF::phrase('emoji.person_playing_water_polo'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_water_polo:',
				'shortname_alternates' => [':water_polo:'],
				'diversity' => '',
				'diversities' => ['1f93d-1f3fb', '1f93d-1f3fc', '1f93d-1f3fd', '1f93d-1f3fe', '1f93d-1f3ff'],
				'gender' => '',
				'genders' => ['1f93d-2642', '1f93d-2640'],
				'keywords' => ['polo', 'water'],
			],
			'1f93d-1f3fb' => [
				'name' => \XF::phrase('emoji.person_playing_water_polo_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_water_polo_tone1:',
				'shortname_alternates' => [':water_polo_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93d-1f3fb-2642', '1f93d-1f3fb-2640'],
				'keywords' => ['light skin tone', 'polo', 'water'],
			],
			'1f93d-1f3fc' => [
				'name' => \XF::phrase('emoji.person_playing_water_polo_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_water_polo_tone2:',
				'shortname_alternates' => [':water_polo_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93d-1f3fc-2642', '1f93d-1f3fc-2640'],
				'keywords' => ['medium-light skin tone', 'polo', 'water'],
			],
			'1f93d-1f3fd' => [
				'name' => \XF::phrase('emoji.person_playing_water_polo_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_water_polo_tone3:',
				'shortname_alternates' => [':water_polo_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93d-1f3fd-2642', '1f93d-1f3fd-2640'],
				'keywords' => ['medium skin tone', 'polo', 'water'],
			],
			'1f93d-1f3fe' => [
				'name' => \XF::phrase('emoji.person_playing_water_polo_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_water_polo_tone4:',
				'shortname_alternates' => [':water_polo_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93d-1f3fe-2642', '1f93d-1f3fe-2640'],
				'keywords' => ['medium-dark skin tone', 'polo', 'water'],
			],
			'1f93d-1f3ff' => [
				'name' => \XF::phrase('emoji.person_playing_water_polo_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_playing_water_polo_tone5:',
				'shortname_alternates' => [':water_polo_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f93d-1f3ff-2642', '1f93d-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'polo', 'water'],
			],
			'1f93d-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_water_polo'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_water_polo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f93d-1f3fb-2640', '1f93d-1f3fc-2640', '1f93d-1f3fd-2640', '1f93d-1f3fe-2640', '1f93d-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['water polo', 'woman'],
			],
			'1f93d-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_water_polo_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_water_polo_tone1:',
				'shortname_alternates' => [':woman_playing_water_polo_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['light skin tone', 'water polo', 'woman'],
			],
			'1f93d-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_water_polo_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_water_polo_tone2:',
				'shortname_alternates' => [':woman_playing_water_polo_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-light skin tone', 'water polo', 'woman'],
			],
			'1f93d-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_water_polo_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_water_polo_tone3:',
				'shortname_alternates' => [':woman_playing_water_polo_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium skin tone', 'water polo', 'woman'],
			],
			'1f93d-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_water_polo_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_water_polo_tone4:',
				'shortname_alternates' => [':woman_playing_water_polo_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['medium-dark skin tone', 'water polo', 'woman'],
			],
			'1f93d-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_playing_water_polo_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_playing_water_polo_tone5:',
				'shortname_alternates' => [':woman_playing_water_polo_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'water polo', 'woman'],
			],
			'1f93d-2642' => [
				'name' => \XF::phrase('emoji.man_playing_water_polo'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_water_polo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f93d-1f3fb-2642', '1f93d-1f3fc-2642', '1f93d-1f3fd-2642', '1f93d-1f3fe-2642', '1f93d-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'water polo'],
			],
			'1f93d-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_playing_water_polo_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_water_polo_tone1:',
				'shortname_alternates' => [':man_playing_water_polo_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['light skin tone', 'man', 'water polo'],
			],
			'1f93d-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_playing_water_polo_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_water_polo_tone2:',
				'shortname_alternates' => [':man_playing_water_polo_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-light skin tone', 'water polo'],
			],
			'1f93d-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_playing_water_polo_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_water_polo_tone3:',
				'shortname_alternates' => [':man_playing_water_polo_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium skin tone', 'water polo'],
			],
			'1f93d-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_playing_water_polo_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_water_polo_tone4:',
				'shortname_alternates' => [':man_playing_water_polo_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'water polo'],
			],
			'1f93d-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_playing_water_polo_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_playing_water_polo_tone5:',
				'shortname_alternates' => [':man_playing_water_polo_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'man', 'water polo'],
			],
			'1f6a3' => [
				'name' => \XF::phrase('emoji.person_rowing_boat'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_rowing_boat:',
				'shortname_alternates' => [':rowboat:'],
				'diversity' => '',
				'diversities' => ['1f6a3-1f3fb', '1f6a3-1f3fc', '1f6a3-1f3fd', '1f6a3-1f3fe', '1f6a3-1f3ff'],
				'gender' => '',
				'genders' => ['1f6a3-2642', '1f6a3-2640'],
				'keywords' => ['boat', 'rowboat'],
			],
			'1f6a3-1f3fb' => [
				'name' => \XF::phrase('emoji.person_rowing_boat_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_rowing_boat_tone1:',
				'shortname_alternates' => [':rowboat_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6a3-1f3fb-2642', '1f6a3-1f3fb-2640'],
				'keywords' => ['boat', 'light skin tone', 'rowboat'],
			],
			'1f6a3-1f3fc' => [
				'name' => \XF::phrase('emoji.person_rowing_boat_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_rowing_boat_tone2:',
				'shortname_alternates' => [':rowboat_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6a3-1f3fc-2642', '1f6a3-1f3fc-2640'],
				'keywords' => ['boat', 'medium-light skin tone', 'rowboat'],
			],
			'1f6a3-1f3fd' => [
				'name' => \XF::phrase('emoji.person_rowing_boat_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_rowing_boat_tone3:',
				'shortname_alternates' => [':rowboat_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6a3-1f3fd-2642', '1f6a3-1f3fd-2640'],
				'keywords' => ['boat', 'medium skin tone', 'rowboat'],
			],
			'1f6a3-1f3fe' => [
				'name' => \XF::phrase('emoji.person_rowing_boat_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_rowing_boat_tone4:',
				'shortname_alternates' => [':rowboat_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6a3-1f3fe-2642', '1f6a3-1f3fe-2640'],
				'keywords' => ['boat', 'medium-dark skin tone', 'rowboat'],
			],
			'1f6a3-1f3ff' => [
				'name' => \XF::phrase('emoji.person_rowing_boat_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_rowing_boat_tone5:',
				'shortname_alternates' => [':rowboat_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6a3-1f3ff-2642', '1f6a3-1f3ff-2640'],
				'keywords' => ['boat', 'dark skin tone', 'rowboat'],
			],
			'1f6a3-2640' => [
				'name' => \XF::phrase('emoji.woman_rowing_boat'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_rowing_boat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6a3-1f3fb-2640', '1f6a3-1f3fc-2640', '1f6a3-1f3fd-2640', '1f6a3-1f3fe-2640', '1f6a3-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['boat', 'rowboat', 'woman'],
			],
			'1f6a3-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_rowing_boat_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_rowing_boat_tone1:',
				'shortname_alternates' => [':woman_rowing_boat_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['boat', 'light skin tone', 'rowboat', 'woman'],
			],
			'1f6a3-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_rowing_boat_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_rowing_boat_tone2:',
				'shortname_alternates' => [':woman_rowing_boat_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['boat', 'medium-light skin tone', 'rowboat', 'woman'],
			],
			'1f6a3-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_rowing_boat_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_rowing_boat_tone3:',
				'shortname_alternates' => [':woman_rowing_boat_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['boat', 'medium skin tone', 'rowboat', 'woman'],
			],
			'1f6a3-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_rowing_boat_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_rowing_boat_tone4:',
				'shortname_alternates' => [':woman_rowing_boat_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['boat', 'medium-dark skin tone', 'rowboat', 'woman'],
			],
			'1f6a3-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_rowing_boat_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_rowing_boat_tone5:',
				'shortname_alternates' => [':woman_rowing_boat_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['boat', 'dark skin tone', 'rowboat', 'woman'],
			],
			'1f6a3-2642' => [
				'name' => \XF::phrase('emoji.man_rowing_boat'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_rowing_boat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6a3-1f3fb-2642', '1f6a3-1f3fc-2642', '1f6a3-1f3fd-2642', '1f6a3-1f3fe-2642', '1f6a3-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['boat', 'man', 'rowboat'],
			],
			'1f6a3-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_rowing_boat_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_rowing_boat_tone1:',
				'shortname_alternates' => [':man_rowing_boat_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['boat', 'light skin tone', 'man', 'rowboat'],
			],
			'1f6a3-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_rowing_boat_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_rowing_boat_tone2:',
				'shortname_alternates' => [':man_rowing_boat_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['boat', 'man', 'medium-light skin tone', 'rowboat'],
			],
			'1f6a3-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_rowing_boat_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_rowing_boat_tone3:',
				'shortname_alternates' => [':man_rowing_boat_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['boat', 'man', 'medium skin tone', 'rowboat'],
			],
			'1f6a3-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_rowing_boat_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_rowing_boat_tone4:',
				'shortname_alternates' => [':man_rowing_boat_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['boat', 'man', 'medium-dark skin tone', 'rowboat'],
			],
			'1f6a3-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_rowing_boat_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_rowing_boat_tone5:',
				'shortname_alternates' => [':man_rowing_boat_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['boat', 'dark skin tone', 'man', 'rowboat'],
			],
			'1f9d7' => [
				'name' => \XF::phrase('emoji.person_climbing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_climbing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d7-1f3fb', '1f9d7-1f3fc', '1f9d7-1f3fd', '1f9d7-1f3fe', '1f9d7-1f3ff'],
				'gender' => '',
				'genders' => ['1f9d7-2642', '1f9d7-2640'],
				'keywords' => ['climber'],
			],
			'1f9d7-1f3fb' => [
				'name' => \XF::phrase('emoji.person_climbing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_climbing_tone1:',
				'shortname_alternates' => [':person_climbing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d7-1f3fb-2642', '1f9d7-1f3fb-2640'],
				'keywords' => ['climber', 'light skin tone'],
			],
			'1f9d7-1f3fc' => [
				'name' => \XF::phrase('emoji.person_climbing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_climbing_tone2:',
				'shortname_alternates' => [':person_climbing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d7-1f3fc-2642', '1f9d7-1f3fc-2640'],
				'keywords' => ['climber', 'medium-light skin tone'],
			],
			'1f9d7-1f3fd' => [
				'name' => \XF::phrase('emoji.person_climbing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_climbing_tone3:',
				'shortname_alternates' => [':person_climbing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d7-1f3fd-2642', '1f9d7-1f3fd-2640'],
				'keywords' => ['climber', 'medium skin tone'],
			],
			'1f9d7-1f3fe' => [
				'name' => \XF::phrase('emoji.person_climbing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_climbing_tone4:',
				'shortname_alternates' => [':person_climbing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d7-1f3fe-2642', '1f9d7-1f3fe-2640'],
				'keywords' => ['climber', 'medium-dark skin tone'],
			],
			'1f9d7-1f3ff' => [
				'name' => \XF::phrase('emoji.person_climbing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_climbing_tone5:',
				'shortname_alternates' => [':person_climbing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f9d7-1f3ff-2642', '1f9d7-1f3ff-2640'],
				'keywords' => ['climber', 'dark skin tone'],
			],
			'1f9d7-2640' => [
				'name' => \XF::phrase('emoji.woman_climbing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_climbing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d7-1f3fb-2640', '1f9d7-1f3fc-2640', '1f9d7-1f3fd-2640', '1f9d7-1f3fe-2640', '1f9d7-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['climber'],
			],
			'1f9d7-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_climbing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_climbing_tone1:',
				'shortname_alternates' => [':woman_climbing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['climber', 'light skin tone'],
			],
			'1f9d7-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_climbing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_climbing_tone2:',
				'shortname_alternates' => [':woman_climbing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['climber', 'medium-light skin tone'],
			],
			'1f9d7-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_climbing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_climbing_tone3:',
				'shortname_alternates' => [':woman_climbing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['climber', 'medium skin tone'],
			],
			'1f9d7-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_climbing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_climbing_tone4:',
				'shortname_alternates' => [':woman_climbing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['climber', 'medium-dark skin tone'],
			],
			'1f9d7-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_climbing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_climbing_tone5:',
				'shortname_alternates' => [':woman_climbing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['climber', 'dark skin tone'],
			],
			'1f9d7-2642' => [
				'name' => \XF::phrase('emoji.man_climbing'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_climbing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f9d7-1f3fb-2642', '1f9d7-1f3fc-2642', '1f9d7-1f3fd-2642', '1f9d7-1f3fe-2642', '1f9d7-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['climber'],
			],
			'1f9d7-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_climbing_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_climbing_tone1:',
				'shortname_alternates' => [':man_climbing_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['climber', 'light skin tone'],
			],
			'1f9d7-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_climbing_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_climbing_tone2:',
				'shortname_alternates' => [':man_climbing_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['climber', 'medium-light skin tone'],
			],
			'1f9d7-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_climbing_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_climbing_tone3:',
				'shortname_alternates' => [':man_climbing_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['climber', 'medium skin tone'],
			],
			'1f9d7-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_climbing_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_climbing_tone4:',
				'shortname_alternates' => [':man_climbing_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['climber', 'medium-dark skin tone'],
			],
			'1f9d7-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_climbing_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_climbing_tone5:',
				'shortname_alternates' => [':man_climbing_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['climber', 'dark skin tone'],
			],
			'1f6b5' => [
				'name' => \XF::phrase('emoji.person_mountain_biking'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_mountain_biking:',
				'shortname_alternates' => [':mountain_bicyclist:'],
				'diversity' => '',
				'diversities' => ['1f6b5-1f3fb', '1f6b5-1f3fc', '1f6b5-1f3fd', '1f6b5-1f3fe', '1f6b5-1f3ff'],
				'gender' => '',
				'genders' => ['1f6b5-2642', '1f6b5-2640'],
				'keywords' => ['bicycle', 'bicyclist', 'bike', 'cyclist', 'mountain'],
			],
			'1f6b5-1f3fb' => [
				'name' => \XF::phrase('emoji.person_mountain_biking_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_mountain_biking_tone1:',
				'shortname_alternates' => [':mountain_bicyclist_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b5-1f3fb-2642', '1f6b5-1f3fb-2640'],
				'keywords' => ['bicycle', 'bicyclist', 'bike', 'cyclist', 'light skin tone', 'mountain'],
			],
			'1f6b5-1f3fc' => [
				'name' => \XF::phrase('emoji.person_mountain_biking_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_mountain_biking_tone2:',
				'shortname_alternates' => [':mountain_bicyclist_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b5-1f3fc-2642', '1f6b5-1f3fc-2640'],
				'keywords' => ['bicycle', 'bicyclist', 'bike', 'cyclist', 'medium-light skin tone', 'mountain'],
			],
			'1f6b5-1f3fd' => [
				'name' => \XF::phrase('emoji.person_mountain_biking_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_mountain_biking_tone3:',
				'shortname_alternates' => [':mountain_bicyclist_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b5-1f3fd-2642', '1f6b5-1f3fd-2640'],
				'keywords' => ['bicycle', 'bicyclist', 'bike', 'cyclist', 'medium skin tone', 'mountain'],
			],
			'1f6b5-1f3fe' => [
				'name' => \XF::phrase('emoji.person_mountain_biking_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_mountain_biking_tone4:',
				'shortname_alternates' => [':mountain_bicyclist_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b5-1f3fe-2642', '1f6b5-1f3fe-2640'],
				'keywords' => ['bicycle', 'bicyclist', 'bike', 'cyclist', 'medium-dark skin tone', 'mountain'],
			],
			'1f6b5-1f3ff' => [
				'name' => \XF::phrase('emoji.person_mountain_biking_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_mountain_biking_tone5:',
				'shortname_alternates' => [':mountain_bicyclist_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b5-1f3ff-2642', '1f6b5-1f3ff-2640'],
				'keywords' => ['bicycle', 'bicyclist', 'bike', 'cyclist', 'dark skin tone', 'mountain'],
			],
			'1f6b5-2640' => [
				'name' => \XF::phrase('emoji.woman_mountain_biking'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_mountain_biking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6b5-1f3fb-2640', '1f6b5-1f3fc-2640', '1f6b5-1f3fd-2640', '1f6b5-1f3fe-2640', '1f6b5-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'biking', 'cyclist', 'mountain', 'woman'],
			],
			'1f6b5-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_mountain_biking_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_mountain_biking_tone1:',
				'shortname_alternates' => [':woman_mountain_biking_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'biking', 'cyclist', 'light skin tone', 'mountain', 'woman'],
			],
			'1f6b5-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_mountain_biking_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_mountain_biking_tone2:',
				'shortname_alternates' => [':woman_mountain_biking_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'biking', 'cyclist', 'medium-light skin tone', 'mountain', 'woman'],
			],
			'1f6b5-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_mountain_biking_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_mountain_biking_tone3:',
				'shortname_alternates' => [':woman_mountain_biking_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'biking', 'cyclist', 'medium skin tone', 'mountain', 'woman'],
			],
			'1f6b5-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_mountain_biking_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_mountain_biking_tone4:',
				'shortname_alternates' => [':woman_mountain_biking_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'biking', 'cyclist', 'medium-dark skin tone', 'mountain', 'woman'],
			],
			'1f6b5-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_mountain_biking_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_mountain_biking_tone5:',
				'shortname_alternates' => [':woman_mountain_biking_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'biking', 'cyclist', 'dark skin tone', 'mountain', 'woman'],
			],
			'1f6b5-2642' => [
				'name' => \XF::phrase('emoji.man_mountain_biking'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_mountain_biking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6b5-1f3fb-2642', '1f6b5-1f3fc-2642', '1f6b5-1f3fd-2642', '1f6b5-1f3fe-2642', '1f6b5-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'cyclist', 'man', 'mountain'],
			],
			'1f6b5-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_mountain_biking_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_mountain_biking_tone1:',
				'shortname_alternates' => [':man_mountain_biking_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'cyclist', 'light skin tone', 'man', 'mountain'],
			],
			'1f6b5-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_mountain_biking_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_mountain_biking_tone2:',
				'shortname_alternates' => [':man_mountain_biking_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'cyclist', 'man', 'medium-light skin tone', 'mountain'],
			],
			'1f6b5-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_mountain_biking_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_mountain_biking_tone3:',
				'shortname_alternates' => [':man_mountain_biking_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'cyclist', 'man', 'medium skin tone', 'mountain'],
			],
			'1f6b5-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_mountain_biking_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_mountain_biking_tone4:',
				'shortname_alternates' => [':man_mountain_biking_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'cyclist', 'man', 'medium-dark skin tone', 'mountain'],
			],
			'1f6b5-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_mountain_biking_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_mountain_biking_tone5:',
				'shortname_alternates' => [':man_mountain_biking_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'cyclist', 'dark skin tone', 'man', 'mountain'],
			],
			'1f6b4' => [
				'name' => \XF::phrase('emoji.person_biking'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_biking:',
				'shortname_alternates' => [':bicyclist:'],
				'diversity' => '',
				'diversities' => ['1f6b4-1f3fb', '1f6b4-1f3fc', '1f6b4-1f3fd', '1f6b4-1f3fe', '1f6b4-1f3ff'],
				'gender' => '',
				'genders' => ['1f6b4-2642', '1f6b4-2640'],
				'keywords' => ['bicycle', 'biking', 'cyclist'],
			],
			'1f6b4-1f3fb' => [
				'name' => \XF::phrase('emoji.person_biking_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_biking_tone1:',
				'shortname_alternates' => [':bicyclist_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b4-1f3fb-2642', '1f6b4-1f3fb-2640'],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'light skin tone'],
			],
			'1f6b4-1f3fc' => [
				'name' => \XF::phrase('emoji.person_biking_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_biking_tone2:',
				'shortname_alternates' => [':bicyclist_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b4-1f3fc-2642', '1f6b4-1f3fc-2640'],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'medium-light skin tone'],
			],
			'1f6b4-1f3fd' => [
				'name' => \XF::phrase('emoji.person_biking_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_biking_tone3:',
				'shortname_alternates' => [':bicyclist_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b4-1f3fd-2642', '1f6b4-1f3fd-2640'],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'medium skin tone'],
			],
			'1f6b4-1f3fe' => [
				'name' => \XF::phrase('emoji.person_biking_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_biking_tone4:',
				'shortname_alternates' => [':bicyclist_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b4-1f3fe-2642', '1f6b4-1f3fe-2640'],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'medium-dark skin tone'],
			],
			'1f6b4-1f3ff' => [
				'name' => \XF::phrase('emoji.person_biking_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_biking_tone5:',
				'shortname_alternates' => [':bicyclist_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f6b4-1f3ff-2642', '1f6b4-1f3ff-2640'],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'dark skin tone'],
			],
			'1f6b4-2640' => [
				'name' => \XF::phrase('emoji.woman_biking'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_biking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6b4-1f3fb-2640', '1f6b4-1f3fc-2640', '1f6b4-1f3fd-2640', '1f6b4-1f3fe-2640', '1f6b4-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'woman'],
			],
			'1f6b4-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_biking_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_biking_tone1:',
				'shortname_alternates' => [':woman_biking_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'light skin tone', 'woman'],
			],
			'1f6b4-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_biking_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_biking_tone2:',
				'shortname_alternates' => [':woman_biking_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'medium-light skin tone', 'woman'],
			],
			'1f6b4-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_biking_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_biking_tone3:',
				'shortname_alternates' => [':woman_biking_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'medium skin tone', 'woman'],
			],
			'1f6b4-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_biking_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_biking_tone4:',
				'shortname_alternates' => [':woman_biking_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'medium-dark skin tone', 'woman'],
			],
			'1f6b4-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_biking_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_biking_tone5:',
				'shortname_alternates' => [':woman_biking_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'dark skin tone', 'woman'],
			],
			'1f6b4-2642' => [
				'name' => \XF::phrase('emoji.man_biking'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_biking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6b4-1f3fb-2642', '1f6b4-1f3fc-2642', '1f6b4-1f3fd-2642', '1f6b4-1f3fe-2642', '1f6b4-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'man'],
			],
			'1f6b4-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_biking_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_biking_tone1:',
				'shortname_alternates' => [':man_biking_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'light skin tone', 'man'],
			],
			'1f6b4-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_biking_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_biking_tone2:',
				'shortname_alternates' => [':man_biking_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'man', 'medium-light skin tone'],
			],
			'1f6b4-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_biking_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_biking_tone3:',
				'shortname_alternates' => [':man_biking_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'man', 'medium skin tone'],
			],
			'1f6b4-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_biking_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_biking_tone4:',
				'shortname_alternates' => [':man_biking_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'man', 'medium-dark skin tone'],
			],
			'1f6b4-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_biking_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_biking_tone5:',
				'shortname_alternates' => [':man_biking_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['bicycle', 'biking', 'cyclist', 'dark skin tone', 'man'],
			],
			'1f3c6' => [
				'name' => \XF::phrase('emoji.trophy'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':trophy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['prize'],
			],
			'1f947' => [
				'name' => \XF::phrase('emoji.first_place'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':first_place:',
				'shortname_alternates' => [':first_place_medal:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['first', 'gold', 'medal'],
			],
			'1f948' => [
				'name' => \XF::phrase('emoji.second_place'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':second_place:',
				'shortname_alternates' => [':second_place_medal:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medal', 'second', 'silver'],
			],
			'1f949' => [
				'name' => \XF::phrase('emoji.third_place'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':third_place:',
				'shortname_alternates' => [':third_place_medal:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bronze', 'medal', 'third'],
			],
			'1f3c5' => [
				'name' => \XF::phrase('emoji.medal'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':medal:',
				'shortname_alternates' => [':sports_medal:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['medal'],
			],
			'1f396' => [
				'name' => \XF::phrase('emoji.military_medal'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':military_medal:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'medal', 'military'],
			],
			'1f3f5' => [
				'name' => \XF::phrase('emoji.rosette'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':rosette:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['plant'],
			],
			'1f397' => [
				'name' => \XF::phrase('emoji.reminder_ribbon'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':reminder_ribbon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'reminder', 'ribbon'],
			],
			'1f3ab' => [
				'name' => \XF::phrase('emoji.ticket'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':ticket:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['admission'],
			],
			'1f39f' => [
				'name' => \XF::phrase('emoji.tickets'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':tickets:',
				'shortname_alternates' => [':admission_tickets:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['admission', 'ticket'],
			],
			'1f3aa' => [
				'name' => \XF::phrase('emoji.circus_tent'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':circus_tent:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['circus', 'tent'],
			],
			'1f939' => [
				'name' => \XF::phrase('emoji.person_juggling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_juggling:',
				'shortname_alternates' => [':juggling:', ':juggler:'],
				'diversity' => '',
				'diversities' => ['1f939-1f3fb', '1f939-1f3fc', '1f939-1f3fd', '1f939-1f3fe', '1f939-1f3ff'],
				'gender' => '',
				'genders' => ['1f939-2642', '1f939-2640'],
				'keywords' => ['balance', 'juggle', 'multitask', 'skill'],
			],
			'1f939-1f3fb' => [
				'name' => \XF::phrase('emoji.person_juggling_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_juggling_tone1:',
				'shortname_alternates' => [':juggling_tone1:', ':juggler_tone1:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f939-1f3fb-2642', '1f939-1f3fb-2640'],
				'keywords' => ['balance', 'juggle', 'light skin tone', 'multitask', 'skill'],
			],
			'1f939-1f3fc' => [
				'name' => \XF::phrase('emoji.person_juggling_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_juggling_tone2:',
				'shortname_alternates' => [':juggling_tone2:', ':juggler_tone2:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f939-1f3fc-2642', '1f939-1f3fc-2640'],
				'keywords' => ['balance', 'juggle', 'medium-light skin tone', 'multitask', 'skill'],
			],
			'1f939-1f3fd' => [
				'name' => \XF::phrase('emoji.person_juggling_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_juggling_tone3:',
				'shortname_alternates' => [':juggling_tone3:', ':juggler_tone3:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f939-1f3fd-2642', '1f939-1f3fd-2640'],
				'keywords' => ['balance', 'juggle', 'medium skin tone', 'multitask', 'skill'],
			],
			'1f939-1f3fe' => [
				'name' => \XF::phrase('emoji.person_juggling_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_juggling_tone4:',
				'shortname_alternates' => [':juggling_tone4:', ':juggler_tone4:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f939-1f3fe-2642', '1f939-1f3fe-2640'],
				'keywords' => ['balance', 'juggle', 'medium-dark skin tone', 'multitask', 'skill'],
			],
			'1f939-1f3ff' => [
				'name' => \XF::phrase('emoji.person_juggling_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':person_juggling_tone5:',
				'shortname_alternates' => [':juggling_tone5:', ':juggler_tone5:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => ['1f939-1f3ff-2642', '1f939-1f3ff-2640'],
				'keywords' => ['balance', 'dark skin tone', 'juggle', 'multitask', 'skill'],
			],
			'1f939-2640' => [
				'name' => \XF::phrase('emoji.woman_juggling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_juggling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f939-1f3fb-2640', '1f939-1f3fc-2640', '1f939-1f3fd-2640', '1f939-1f3fe-2640', '1f939-1f3ff-2640'],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['juggling', 'multitask', 'woman'],
			],
			'1f939-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_juggling_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_juggling_tone1:',
				'shortname_alternates' => [':woman_juggling_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['juggling', 'light skin tone', 'multitask', 'woman'],
			],
			'1f939-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_juggling_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_juggling_tone2:',
				'shortname_alternates' => [':woman_juggling_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['juggling', 'medium-light skin tone', 'multitask', 'woman'],
			],
			'1f939-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_juggling_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_juggling_tone3:',
				'shortname_alternates' => [':woman_juggling_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['juggling', 'medium skin tone', 'multitask', 'woman'],
			],
			'1f939-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_juggling_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_juggling_tone4:',
				'shortname_alternates' => [':woman_juggling_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['juggling', 'medium-dark skin tone', 'multitask', 'woman'],
			],
			'1f939-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_juggling_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':woman_juggling_tone5:',
				'shortname_alternates' => [':woman_juggling_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2640',
				'genders' => [],
				'keywords' => ['dark skin tone', 'juggling', 'multitask', 'woman'],
			],
			'1f939-2642' => [
				'name' => \XF::phrase('emoji.man_juggling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_juggling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f939-1f3fb-2642', '1f939-1f3fc-2642', '1f939-1f3fd-2642', '1f939-1f3fe-2642', '1f939-1f3ff-2642'],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['juggling', 'man', 'multitask'],
			],
			'1f939-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_juggling_tone1'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_juggling_tone1:',
				'shortname_alternates' => [':man_juggling_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['juggling', 'light skin tone', 'man', 'multitask'],
			],
			'1f939-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_juggling_tone2'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_juggling_tone2:',
				'shortname_alternates' => [':man_juggling_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['juggling', 'man', 'medium-light skin tone', 'multitask'],
			],
			'1f939-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_juggling_tone3'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_juggling_tone3:',
				'shortname_alternates' => [':man_juggling_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['juggling', 'man', 'medium skin tone', 'multitask'],
			],
			'1f939-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_juggling_tone4'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_juggling_tone4:',
				'shortname_alternates' => [':man_juggling_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['juggling', 'man', 'medium-dark skin tone', 'multitask'],
			],
			'1f939-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_juggling_tone5'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':man_juggling_tone5:',
				'shortname_alternates' => [':man_juggling_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '2642',
				'genders' => [],
				'keywords' => ['dark skin tone', 'juggling', 'man', 'multitask'],
			],
			'1f3ad' => [
				'name' => \XF::phrase('emoji.performing_arts'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':performing_arts:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['art', 'mask', 'performing', 'theater', 'theatre'],
			],
			'1f3a8' => [
				'name' => \XF::phrase('emoji.art'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':art:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['art', 'museum', 'painting', 'palette'],
			],
			'1f3ac' => [
				'name' => \XF::phrase('emoji.clapper'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':clapper:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clapper', 'movie'],
			],
			'1f3a4' => [
				'name' => \XF::phrase('emoji.microphone'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':microphone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['karaoke', 'mic'],
			],
			'1f3a7' => [
				'name' => \XF::phrase('emoji.headphones'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':headphones:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['earbud'],
			],
			'1f3bc' => [
				'name' => \XF::phrase('emoji.musical_score'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':musical_score:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['music', 'score'],
			],
			'1f3b9' => [
				'name' => \XF::phrase('emoji.musical_keyboard'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':musical_keyboard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instrument', 'keyboard', 'music', 'piano'],
			],
			'1f941' => [
				'name' => \XF::phrase('emoji.drum'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':drum:',
				'shortname_alternates' => [':drum_with_drumsticks:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['drum', 'drumsticks', 'music'],
			],
			'1f3b7' => [
				'name' => \XF::phrase('emoji.saxophone'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':saxophone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instrument', 'music', 'sax'],
			],
			'1f3ba' => [
				'name' => \XF::phrase('emoji.trumpet'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':trumpet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instrument', 'music'],
			],
			'1f3b8' => [
				'name' => \XF::phrase('emoji.guitar'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':guitar:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instrument', 'music'],
			],
			'1f3bb' => [
				'name' => \XF::phrase('emoji.violin'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':violin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['instrument', 'music'],
			],
			'1f3b2' => [
				'name' => \XF::phrase('emoji.game_die'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':game_die:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dice', 'die', 'game'],
			],
			'1f3af' => [
				'name' => \XF::phrase('emoji.dart'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':dart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bull', 'bullseye', 'dart', 'eye', 'game', 'hit', 'target'],
			],
			'1f3b3' => [
				'name' => \XF::phrase('emoji.bowling'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':bowling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'game'],
			],
			'1f3ae' => [
				'name' => \XF::phrase('emoji.video_game'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':video_game:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['controller', 'game'],
			],
			'1f3b0' => [
				'name' => \XF::phrase('emoji.slot_machine'),
				'category_name' => \XF::phrase('emoji_category.activity'),
				'category' => 'activity',
				'shortname' => ':slot_machine:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['game', 'slot'],
			],
			'1f697' => [
				'name' => \XF::phrase('emoji.red_car'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':red_car:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['car'],
			],
			'1f695' => [
				'name' => \XF::phrase('emoji.taxi'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':taxi:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['vehicle'],
			],
			'1f699' => [
				'name' => \XF::phrase('emoji.blue_car'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':blue_car:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['recreational', 'sport utility'],
			],
			'1f68c' => [
				'name' => \XF::phrase('emoji.bus'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':bus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['vehicle'],
			],
			'1f68e' => [
				'name' => \XF::phrase('emoji.trolleybus'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':trolleybus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bus', 'tram', 'trolley'],
			],
			'1f3ce' => [
				'name' => \XF::phrase('emoji.race_car'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':race_car:',
				'shortname_alternates' => [':racing_car:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['car', 'racing'],
			],
			'1f693' => [
				'name' => \XF::phrase('emoji.police_car'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':police_car:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['car', 'patrol', 'police'],
			],
			'1f691' => [
				'name' => \XF::phrase('emoji.ambulance'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':ambulance:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['vehicle'],
			],
			'1f692' => [
				'name' => \XF::phrase('emoji.fire_engine'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':fire_engine:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['engine', 'fire', 'truck'],
			],
			'1f690' => [
				'name' => \XF::phrase('emoji.minibus'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':minibus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bus'],
			],
			'1f69a' => [
				'name' => \XF::phrase('emoji.truck'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':truck:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['delivery', 'truck'],
			],
			'1f69b' => [
				'name' => \XF::phrase('emoji.articulated_lorry'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':articulated_lorry:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lorry', 'semi', 'truck'],
			],
			'1f69c' => [
				'name' => \XF::phrase('emoji.tractor'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':tractor:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['vehicle'],
			],
			'1f6f4' => [
				'name' => \XF::phrase('emoji.scooter'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':scooter:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['kick', 'scooter'],
			],
			'1f6b2' => [
				'name' => \XF::phrase('emoji.bike'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':bike:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bike'],
			],
			'1f6f5' => [
				'name' => \XF::phrase('emoji.motor_scooter'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':motor_scooter:',
				'shortname_alternates' => [':motorbike:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['motor', 'scooter'],
			],
			'1f3cd' => [
				'name' => \XF::phrase('emoji.motorcycle'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':motorcycle:',
				'shortname_alternates' => [':racing_motorcycle:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['racing'],
			],
			'1f6a8' => [
				'name' => \XF::phrase('emoji.rotating_light'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':rotating_light:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beacon', 'car', 'light', 'police', 'revolving'],
			],
			'1f694' => [
				'name' => \XF::phrase('emoji.oncoming_police_car'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':oncoming_police_car:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['car', 'oncoming', 'police'],
			],
			'1f68d' => [
				'name' => \XF::phrase('emoji.oncoming_bus'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':oncoming_bus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bus', 'oncoming'],
			],
			'1f698' => [
				'name' => \XF::phrase('emoji.oncoming_automobile'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':oncoming_automobile:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['automobile', 'car', 'oncoming'],
			],
			'1f696' => [
				'name' => \XF::phrase('emoji.oncoming_taxi'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':oncoming_taxi:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['oncoming', 'taxi'],
			],
			'1f6a1' => [
				'name' => \XF::phrase('emoji.aerial_tramway'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':aerial_tramway:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['aerial', 'cable', 'car', 'gondola', 'tramway'],
			],
			'1f6a0' => [
				'name' => \XF::phrase('emoji.mountain_cableway'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':mountain_cableway:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cable', 'gondola', 'mountain'],
			],
			'1f69f' => [
				'name' => \XF::phrase('emoji.suspension_railway'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':suspension_railway:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['railway', 'suspension'],
			],
			'1f683' => [
				'name' => \XF::phrase('emoji.railway_car'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':railway_car:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['car', 'electric', 'railway', 'train', 'tram', 'trolleybus'],
			],
			'1f68b' => [
				'name' => \XF::phrase('emoji.train'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':train:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['car', 'tram', 'trolleybus'],
			],
			'1f69e' => [
				'name' => \XF::phrase('emoji.mountain_railway'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':mountain_railway:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['car', 'mountain', 'railway'],
			],
			'1f69d' => [
				'name' => \XF::phrase('emoji.monorail'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':monorail:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['vehicle'],
			],
			'1f684' => [
				'name' => \XF::phrase('emoji.bullettrain_side'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':bullettrain_side:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['railway', 'shinkansen', 'speed', 'train'],
			],
			'1f685' => [
				'name' => \XF::phrase('emoji.bullettrain_front'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':bullettrain_front:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bullet', 'railway', 'shinkansen', 'speed', 'train'],
			],
			'1f688' => [
				'name' => \XF::phrase('emoji.light_rail'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':light_rail:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['railway'],
			],
			'1f682' => [
				'name' => \XF::phrase('emoji.steam_locomotive'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':steam_locomotive:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['engine', 'railway', 'steam', 'train'],
			],
			'1f686' => [
				'name' => \XF::phrase('emoji.train2'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':train2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['railway'],
			],
			'1f687' => [
				'name' => \XF::phrase('emoji.metro'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':metro:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['subway'],
			],
			'1f68a' => [
				'name' => \XF::phrase('emoji.tram'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':tram:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['trolleybus'],
			],
			'1f689' => [
				'name' => \XF::phrase('emoji.station'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':station:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['railway', 'train'],
			],
			'2708' => [
				'name' => \XF::phrase('emoji.airplane'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':airplane:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['aeroplane', 'airplane'],
			],
			'1f6eb' => [
				'name' => \XF::phrase('emoji.airplane_departure'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':airplane_departure:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['aeroplane', 'airplane', 'check-in', 'departure', 'departures'],
			],
			'1f6ec' => [
				'name' => \XF::phrase('emoji.airplane_arriving'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':airplane_arriving:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['aeroplane', 'airplane', 'arrivals', 'arriving', 'landing'],
			],
			'1f6e9' => [
				'name' => \XF::phrase('emoji.airplane_small'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':airplane_small:',
				'shortname_alternates' => [':small_airplane:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['aeroplane', 'airplane'],
			],
			'1f4ba' => [
				'name' => \XF::phrase('emoji.seat'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':seat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chair'],
			],
			'1f9f3' => [
				'name' => \XF::phrase('emoji.luggage'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':luggage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f6f0' => [
				'name' => \XF::phrase('emoji.satellite_orbital'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':satellite_orbital:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['space'],
			],
			'1f680' => [
				'name' => \XF::phrase('emoji.rocket'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':rocket:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['space'],
			],
			'1f6f8' => [
				'name' => \XF::phrase('emoji.flying_saucer'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':flying_saucer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['UFO'],
			],
			'1f681' => [
				'name' => \XF::phrase('emoji.helicopter'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':helicopter:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['vehicle'],
			],
			'1f6f6' => [
				'name' => \XF::phrase('emoji.canoe'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':canoe:',
				'shortname_alternates' => [':kayak:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boat', 'canoe'],
			],
			'26f5' => [
				'name' => \XF::phrase('emoji.sailboat'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':sailboat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boat', 'resort', 'sea', 'yacht'],
			],
			'1f6a4' => [
				'name' => \XF::phrase('emoji.speedboat'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':speedboat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boat'],
			],
			'1f6e5' => [
				'name' => \XF::phrase('emoji.motorboat'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':motorboat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boat', 'motorboat'],
			],
			'1f6f3' => [
				'name' => \XF::phrase('emoji.cruise_ship'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':cruise_ship:',
				'shortname_alternates' => [':passenger_ship:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['passenger', 'ship'],
			],
			'26f4' => [
				'name' => \XF::phrase('emoji.ferry'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':ferry:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boat', 'passenger'],
			],
			'1f6a2' => [
				'name' => \XF::phrase('emoji.ship'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':ship:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['boat', 'passenger'],
			],
			'2693' => [
				'name' => \XF::phrase('emoji.anchor'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':anchor:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ship', 'tool'],
			],
			'26fd' => [
				'name' => \XF::phrase('emoji.fuelpump'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':fuelpump:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fuel', 'fuelpump', 'gas', 'pump', 'station'],
			],
			'1f6a7' => [
				'name' => \XF::phrase('emoji.construction'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':construction:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['barrier'],
			],
			'1f6a6' => [
				'name' => \XF::phrase('emoji.vertical_traffic_light'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':vertical_traffic_light:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light', 'signal', 'traffic'],
			],
			'1f6a5' => [
				'name' => \XF::phrase('emoji.traffic_light'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':traffic_light:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light', 'signal', 'traffic'],
			],
			'1f68f' => [
				'name' => \XF::phrase('emoji.busstop'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':busstop:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bus', 'busstop', 'stop'],
			],
			'1f5fa' => [
				'name' => \XF::phrase('emoji.map'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':map:',
				'shortname_alternates' => [':world_map:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['map', 'world'],
			],
			'1f5ff' => [
				'name' => \XF::phrase('emoji.moyai'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':moyai:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['face', 'moyai', 'statue'],
			],
			'1f5fd' => [
				'name' => \XF::phrase('emoji.statue_of_liberty'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':statue_of_liberty:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['liberty', 'statue'],
			],
			'1f5fc' => [
				'name' => \XF::phrase('emoji.tokyo_tower'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':tokyo_tower:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Tokyo', 'tower'],
			],
			'1f3f0' => [
				'name' => \XF::phrase('emoji.european_castle'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':european_castle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['European'],
			],
			'1f3ef' => [
				'name' => \XF::phrase('emoji.japanese_castle'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':japanese_castle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'castle'],
			],
			'1f3df' => [
				'name' => \XF::phrase('emoji.stadium'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':stadium:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['stadium'],
			],
			'1f3a1' => [
				'name' => \XF::phrase('emoji.ferris_wheel'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':ferris_wheel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['amusement park', 'ferris', 'wheel'],
			],
			'1f3a2' => [
				'name' => \XF::phrase('emoji.roller_coaster'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':roller_coaster:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['amusement park', 'coaster', 'roller'],
			],
			'1f3a0' => [
				'name' => \XF::phrase('emoji.carousel_horse'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':carousel_horse:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['carousel', 'horse'],
			],
			'26f2' => [
				'name' => \XF::phrase('emoji.fountain'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':fountain:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fountain'],
			],
			'26f1' => [
				'name' => \XF::phrase('emoji.beach_umbrella'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':beach_umbrella:',
				'shortname_alternates' => [':umbrella_on_ground:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['rain', 'sun', 'umbrella'],
			],
			'1f3d6' => [
				'name' => \XF::phrase('emoji.beach'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':beach:',
				'shortname_alternates' => [':beach_with_umbrella:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beach', 'umbrella'],
			],
			'1f3dd' => [
				'name' => \XF::phrase('emoji.island'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':island:',
				'shortname_alternates' => [':desert_island:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['desert', 'island'],
			],
			'1f3dc' => [
				'name' => \XF::phrase('emoji.desert'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':desert:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['desert'],
			],
			'1f30b' => [
				'name' => \XF::phrase('emoji.volcano'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':volcano:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['eruption', 'mountain'],
			],
			'26f0' => [
				'name' => \XF::phrase('emoji.mountain'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':mountain:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mountain'],
			],
			'1f3d4' => [
				'name' => \XF::phrase('emoji.mountain_snow'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':mountain_snow:',
				'shortname_alternates' => [':snow_capped_mountain:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cold', 'mountain', 'snow'],
			],
			'1f5fb' => [
				'name' => \XF::phrase('emoji.mount_fuji'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':mount_fuji:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fuji', 'mountain'],
			],
			'1f3d5' => [
				'name' => \XF::phrase('emoji.camping'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':camping:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camping'],
			],
			'26fa' => [
				'name' => \XF::phrase('emoji.tent'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':tent:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camping'],
			],
			'1f3e0' => [
				'name' => \XF::phrase('emoji.house'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':house:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['home', 'house'],
			],
			'1f3e1' => [
				'name' => \XF::phrase('emoji.house_with_garden'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':house_with_garden:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['garden', 'home', 'house'],
			],
			'1f3d8' => [
				'name' => \XF::phrase('emoji.homes'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':homes:',
				'shortname_alternates' => [':house_buildings:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['houses'],
			],
			'1f3da' => [
				'name' => \XF::phrase('emoji.house_abandoned'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':house_abandoned:',
				'shortname_alternates' => [':derelict_house_building:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['derelict', 'house'],
			],
			'1f3d7' => [
				'name' => \XF::phrase('emoji.construction_site'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':construction_site:',
				'shortname_alternates' => [':building_construction:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['construction'],
			],
			'1f3ed' => [
				'name' => \XF::phrase('emoji.factory'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':factory:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['building'],
			],
			'1f3e2' => [
				'name' => \XF::phrase('emoji.office'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':office:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['building'],
			],
			'1f3ec' => [
				'name' => \XF::phrase('emoji.department_store'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':department_store:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['department', 'store'],
			],
			'1f3e3' => [
				'name' => \XF::phrase('emoji.post_office'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':post_office:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'post'],
			],
			'1f3e4' => [
				'name' => \XF::phrase('emoji.european_post_office'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':european_post_office:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['European', 'post'],
			],
			'1f3e5' => [
				'name' => \XF::phrase('emoji.hospital'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':hospital:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'medicine'],
			],
			'1f3e6' => [
				'name' => \XF::phrase('emoji.bank'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':bank:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['building'],
			],
			'1f3e8' => [
				'name' => \XF::phrase('emoji.hotel'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':hotel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['building'],
			],
			'1f3ea' => [
				'name' => \XF::phrase('emoji.convenience_store'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':convenience_store:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['convenience', 'store'],
			],
			'1f3eb' => [
				'name' => \XF::phrase('emoji.school'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':school:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['building'],
			],
			'1f3e9' => [
				'name' => \XF::phrase('emoji.love_hotel'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':love_hotel:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hotel', 'love'],
			],
			'1f492' => [
				'name' => \XF::phrase('emoji.wedding'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':wedding:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chapel', 'romance'],
			],
			'1f3db' => [
				'name' => \XF::phrase('emoji.classical_building'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':classical_building:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['classical'],
			],
			'26ea' => [
				'name' => \XF::phrase('emoji.church'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':church:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christian', 'cross', 'religion'],
			],
			'1f54c' => [
				'name' => \XF::phrase('emoji.mosque'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':mosque:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Muslim', 'islam', 'religion'],
			],
			'1f54d' => [
				'name' => \XF::phrase('emoji.synagogue'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':synagogue:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Jew', 'Jewish', 'religion', 'temple'],
			],
			'1f54b' => [
				'name' => \XF::phrase('emoji.kaaba'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':kaaba:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Muslim', 'islam', 'religion'],
			],
			'26e9' => [
				'name' => \XF::phrase('emoji.shinto_shrine'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':shinto_shrine:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['religion', 'shinto', 'shrine'],
			],
			'1f6e4' => [
				'name' => \XF::phrase('emoji.railway_track'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':railway_track:',
				'shortname_alternates' => [':railroad_track:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['railway', 'train'],
			],
			'1f6e3' => [
				'name' => \XF::phrase('emoji.motorway'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':motorway:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['highway', 'road'],
			],
			'1f5fe' => [
				'name' => \XF::phrase('emoji.japan'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':japan:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japan', 'map'],
			],
			'1f391' => [
				'name' => \XF::phrase('emoji.rice_scene'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':rice_scene:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'ceremony', 'moon'],
			],
			'1f3de' => [
				'name' => \XF::phrase('emoji.park'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':park:',
				'shortname_alternates' => [':national_park:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['park'],
			],
			'1f305' => [
				'name' => \XF::phrase('emoji.sunrise'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':sunrise:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['morning', 'sun'],
			],
			'1f304' => [
				'name' => \XF::phrase('emoji.sunrise_over_mountains'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':sunrise_over_mountains:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['morning', 'mountain', 'sun', 'sunrise'],
			],
			'1f320' => [
				'name' => \XF::phrase('emoji.stars'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':stars:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['falling', 'shooting', 'star'],
			],
			'1f387' => [
				'name' => \XF::phrase('emoji.sparkler'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':sparkler:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'fireworks', 'sparkle'],
			],
			'1f386' => [
				'name' => \XF::phrase('emoji.fireworks'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':fireworks:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration'],
			],
			'1f9e8' => [
				'name' => \XF::phrase('emoji.firecracker'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':firecracker:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f307' => [
				'name' => \XF::phrase('emoji.city_sunset'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':city_sunset:',
				'shortname_alternates' => [':city_sunrise:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dusk', 'sun'],
			],
			'1f306' => [
				'name' => \XF::phrase('emoji.city_dusk'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':city_dusk:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['city', 'dusk', 'evening', 'landscape', 'sun', 'sunset'],
			],
			'1f3d9' => [
				'name' => \XF::phrase('emoji.cityscape'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':cityscape:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['city'],
			],
			'1f303' => [
				'name' => \XF::phrase('emoji.night_with_stars'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':night_with_stars:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['night', 'star'],
			],
			'1f30c' => [
				'name' => \XF::phrase('emoji.milky_way'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':milky_way:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['space'],
			],
			'1f309' => [
				'name' => \XF::phrase('emoji.bridge_at_night'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':bridge_at_night:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bridge', 'night'],
			],
			'1f301' => [
				'name' => \XF::phrase('emoji.foggy'),
				'category_name' => \XF::phrase('emoji_category.travel'),
				'category' => 'travel',
				'shortname' => ':foggy:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fog'],
			],
			'231a' => [
				'name' => \XF::phrase('emoji.watch'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':watch:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clock'],
			],
			'1f4f1' => [
				'name' => \XF::phrase('emoji.iphone'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':iphone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cell', 'mobile', 'phone', 'telephone'],
			],
			'1f4f2' => [
				'name' => \XF::phrase('emoji.calling'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':calling:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['arrow', 'call', 'cell', 'mobile', 'phone', 'receive', 'telephone'],
			],
			'1f4bb' => [
				'name' => \XF::phrase('emoji.computer'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':computer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer', 'pc', 'personal'],
			],
			'2328' => [
				'name' => \XF::phrase('emoji.keyboard'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':keyboard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer'],
			],
			'1f5a5' => [
				'name' => \XF::phrase('emoji.desktop'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':desktop:',
				'shortname_alternates' => [':desktop_computer:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer', 'desktop'],
			],
			'1f5a8' => [
				'name' => \XF::phrase('emoji.printer'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':printer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer'],
			],
			'1f5b1' => [
				'name' => \XF::phrase('emoji.mouse_three_button'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':mouse_three_button:',
				'shortname_alternates' => [':three_button_mouse:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer'],
			],
			'1f5b2' => [
				'name' => \XF::phrase('emoji.trackball'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':trackball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer'],
			],
			'1f579' => [
				'name' => \XF::phrase('emoji.joystick'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':joystick:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['game', 'video game'],
			],
			'265f' => [
				'name' => \XF::phrase('emoji.chess_pawn'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':chess_pawn:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9e9' => [
				'name' => \XF::phrase('emoji.jigsaw'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':jigsaw:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f5dc' => [
				'name' => \XF::phrase('emoji.compression'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':compression:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['compress', 'tool', 'vice'],
			],
			'1f4bd' => [
				'name' => \XF::phrase('emoji.minidisc'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':minidisc:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer', 'disk', 'minidisk', 'optical'],
			],
			'1f4be' => [
				'name' => \XF::phrase('emoji.floppy_disk'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':floppy_disk:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['computer', 'disk', 'floppy'],
			],
			'1f4bf' => [
				'name' => \XF::phrase('emoji.cd'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':cd:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cd', 'computer', 'disk', 'optical'],
			],
			'1f4c0' => [
				'name' => \XF::phrase('emoji.dvd'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':dvd:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blu-ray', 'computer', 'disk', 'dvd', 'optical'],
			],
			'1f4fc' => [
				'name' => \XF::phrase('emoji.vhs'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':vhs:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['tape', 'vhs', 'video'],
			],
			'1f4f7' => [
				'name' => \XF::phrase('emoji.camera'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':camera:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['video'],
			],
			'1f4f8' => [
				'name' => \XF::phrase('emoji.camera_with_flash'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':camera_with_flash:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'flash', 'video'],
			],
			'1f4f9' => [
				'name' => \XF::phrase('emoji.video_camera'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':video_camera:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'video'],
			],
			'1f3a5' => [
				'name' => \XF::phrase('emoji.movie_camera'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':movie_camera:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'cinema', 'movie'],
			],
			'1f4fd' => [
				'name' => \XF::phrase('emoji.projector'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':projector:',
				'shortname_alternates' => [':film_projector:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cinema', 'film', 'movie', 'projector', 'video'],
			],
			'1f39e' => [
				'name' => \XF::phrase('emoji.film_frames'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':film_frames:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cinema', 'film', 'frames', 'movie'],
			],
			'1f4de' => [
				'name' => \XF::phrase('emoji.telephone_receiver'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':telephone_receiver:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['phone', 'receiver', 'telephone'],
			],
			'260e' => [
				'name' => \XF::phrase('emoji.telephone'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':telephone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['phone'],
			],
			'1f4df' => [
				'name' => \XF::phrase('emoji.pager'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pager:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pager'],
			],
			'1f4e0' => [
				'name' => \XF::phrase('emoji.fax'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':fax:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fax'],
			],
			'1f4fa' => [
				'name' => \XF::phrase('emoji.tv'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':tv:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['tv', 'video'],
			],
			'1f4fb' => [
				'name' => \XF::phrase('emoji.radio'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':radio:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['video'],
			],
			'1f399' => [
				'name' => \XF::phrase('emoji.microphone2'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':microphone2:',
				'shortname_alternates' => [':studio_microphone:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mic', 'microphone', 'music', 'studio'],
			],
			'1f39a' => [
				'name' => \XF::phrase('emoji.level_slider'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':level_slider:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['level', 'music', 'slider'],
			],
			'1f39b' => [
				'name' => \XF::phrase('emoji.control_knobs'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':control_knobs:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['control', 'knobs', 'music'],
			],
			'23f1' => [
				'name' => \XF::phrase('emoji.stopwatch'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':stopwatch:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clock'],
			],
			'23f2' => [
				'name' => \XF::phrase('emoji.timer'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':timer:',
				'shortname_alternates' => [':timer_clock:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clock', 'timer'],
			],
			'23f0' => [
				'name' => \XF::phrase('emoji.alarm_clock'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':alarm_clock:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['alarm', 'clock'],
			],
			'1f570' => [
				'name' => \XF::phrase('emoji.clock'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':clock:',
				'shortname_alternates' => [':mantlepiece_clock:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clock'],
			],
			'231b' => [
				'name' => \XF::phrase('emoji.hourglass'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':hourglass:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['sand', 'timer'],
			],
			'23f3' => [
				'name' => \XF::phrase('emoji.hourglass_flowing_sand'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':hourglass_flowing_sand:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hourglass', 'sand', 'timer'],
			],
			'1f4e1' => [
				'name' => \XF::phrase('emoji.satellite'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':satellite:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['antenna', 'dish', 'satellite'],
			],
			'1f9ed' => [
				'name' => \XF::phrase('emoji.compass'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':compass:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f50b' => [
				'name' => \XF::phrase('emoji.battery'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':battery:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['battery'],
			],
			'1f50c' => [
				'name' => \XF::phrase('emoji.electric_plug'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':electric_plug:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electric', 'electricity', 'plug'],
			],
			'1f9f2' => [
				'name' => \XF::phrase('emoji.magnet'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':magnet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f4a1' => [
				'name' => \XF::phrase('emoji.bulb'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bulb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bulb', 'comic', 'electric', 'idea', 'light'],
			],
			'1f526' => [
				'name' => \XF::phrase('emoji.flashlight'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':flashlight:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['electric', 'light', 'tool', 'torch'],
			],
			'1f56f' => [
				'name' => \XF::phrase('emoji.candle'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':candle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['light'],
			],
			'1f9ef' => [
				'name' => \XF::phrase('emoji.fire_extinguisher'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':fire_extinguisher:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f5d1' => [
				'name' => \XF::phrase('emoji.wastebasket'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':wastebasket:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['wastebasket'],
			],
			'1f6e2' => [
				'name' => \XF::phrase('emoji.oil'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':oil:',
				'shortname_alternates' => [':oil_drum:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['drum', 'oil'],
			],
			'1f4b8' => [
				'name' => \XF::phrase('emoji.money_with_wings'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':money_with_wings:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bank', 'banknote', 'bill', 'dollar', 'fly', 'money', 'note', 'wings'],
			],
			'1f4b5' => [
				'name' => \XF::phrase('emoji.dollar'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':dollar:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bank', 'banknote', 'bill', 'currency', 'dollar', 'money', 'note'],
			],
			'1f4b4' => [
				'name' => \XF::phrase('emoji.yen'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':yen:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bank', 'banknote', 'bill', 'currency', 'money', 'note', 'yen'],
			],
			'1f4b6' => [
				'name' => \XF::phrase('emoji.euro'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':euro:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bank', 'banknote', 'bill', 'currency', 'euro', 'money', 'note'],
			],
			'1f4b7' => [
				'name' => \XF::phrase('emoji.pound'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pound:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bank', 'banknote', 'bill', 'currency', 'money', 'note', 'pound'],
			],
			'1f4b0' => [
				'name' => \XF::phrase('emoji.moneybag'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':moneybag:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bag', 'dollar', 'money', 'moneybag'],
			],
			'1f4b3' => [
				'name' => \XF::phrase('emoji.credit_card'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':credit_card:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bank', 'card', 'credit', 'money'],
			],
			'1f48e' => [
				'name' => \XF::phrase('emoji.gem'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':gem:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['diamond', 'gem', 'jewel'],
			],
			'1f9ff' => [
				'name' => \XF::phrase('emoji.nazar_amulet'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':nazar_amulet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9f1' => [
				'name' => \XF::phrase('emoji.bricks'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bricks:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'2696' => [
				'name' => \XF::phrase('emoji.scales'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':scales:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Libra', 'balance', 'justice', 'scales', 'tool', 'weight', 'zodiac'],
			],
			'1f9f0' => [
				'name' => \XF::phrase('emoji.toolbox'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':toolbox:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f527' => [
				'name' => \XF::phrase('emoji.wrench'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':wrench:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['spanner', 'tool', 'wrench'],
			],
			'1f528' => [
				'name' => \XF::phrase('emoji.hammer'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':hammer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['tool'],
			],
			'2692' => [
				'name' => \XF::phrase('emoji.hammer_pick'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':hammer_pick:',
				'shortname_alternates' => [':hammer_and_pick:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hammer', 'pick', 'tool'],
			],
			'1f6e0' => [
				'name' => \XF::phrase('emoji.tools'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':tools:',
				'shortname_alternates' => [':hammer_and_wrench:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hammer', 'spanner', 'tool', 'wrench'],
			],
			'26cf' => [
				'name' => \XF::phrase('emoji.pick'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pick:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mining', 'tool'],
			],
			'1f529' => [
				'name' => \XF::phrase('emoji.nut_and_bolt'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':nut_and_bolt:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bolt', 'nut', 'tool'],
			],
			'2699' => [
				'name' => \XF::phrase('emoji.gear'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':gear:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['tool'],
			],
			'26d3' => [
				'name' => \XF::phrase('emoji.chains'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':chains:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chain'],
			],
			'1f52b' => [
				'name' => \XF::phrase('emoji.gun'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':gun:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['gun', 'handgun', 'revolver', 'tool', 'weapon'],
			],
			'1f4a3' => [
				'name' => \XF::phrase('emoji.bomb'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bomb:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['comic'],
			],
			'1f52a' => [
				'name' => \XF::phrase('emoji.knife'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':knife:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cooking', 'hocho', 'knife', 'tool', 'weapon'],
			],
			'1f5e1' => [
				'name' => \XF::phrase('emoji.dagger'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':dagger:',
				'shortname_alternates' => [':dagger_knife:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['knife', 'weapon'],
			],
			'2694' => [
				'name' => \XF::phrase('emoji.crossed_swords'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':crossed_swords:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crossed', 'swords', 'weapon'],
			],
			'1f6e1' => [
				'name' => \XF::phrase('emoji.shield'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':shield:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['weapon'],
			],
			'1f6ac' => [
				'name' => \XF::phrase('emoji.smoking'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':smoking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['smoking'],
			],
			'26b0' => [
				'name' => \XF::phrase('emoji.coffin'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':coffin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['death'],
			],
			'26b1' => [
				'name' => \XF::phrase('emoji.urn'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':urn:',
				'shortname_alternates' => [':funeral_urn:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ashes', 'death', 'funeral', 'urn'],
			],
			'1f3fa' => [
				'name' => \XF::phrase('emoji.amphora'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':amphora:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Aquarius', 'cooking', 'drink', 'jug', 'tool', 'weapon', 'zodiac'],
			],
			'1f52e' => [
				'name' => \XF::phrase('emoji.crystal_ball'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':crystal_ball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'crystal', 'fairy tale', 'fantasy', 'fortune', 'tool'],
			],
			'1f4ff' => [
				'name' => \XF::phrase('emoji.prayer_beads'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':prayer_beads:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beads', 'clothing', 'necklace', 'prayer', 'religion'],
			],
			'1f488' => [
				'name' => \XF::phrase('emoji.barber'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':barber:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['barber', 'haircut', 'pole'],
			],
			'2697' => [
				'name' => \XF::phrase('emoji.alembic'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':alembic:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chemistry', 'tool'],
			],
			'1f9ea' => [
				'name' => \XF::phrase('emoji.test_tube'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':test_tube:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9eb' => [
				'name' => \XF::phrase('emoji.petri_dish'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':petri_dish:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9ec' => [
				'name' => \XF::phrase('emoji.dna'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':dna:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9ee' => [
				'name' => \XF::phrase('emoji.abacus'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':abacus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f52d' => [
				'name' => \XF::phrase('emoji.telescope'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':telescope:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['science', 'tool'],
			],
			'1f52c' => [
				'name' => \XF::phrase('emoji.microscope'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':microscope:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['science', 'tool'],
			],
			'1f573' => [
				'name' => \XF::phrase('emoji.hole'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':hole:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hole'],
			],
			'1f48a' => [
				'name' => \XF::phrase('emoji.pill'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pill:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'medicine', 'sick'],
			],
			'1f489' => [
				'name' => \XF::phrase('emoji.syringe'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':syringe:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['doctor', 'medicine', 'needle', 'shot', 'sick', 'tool'],
			],
			'1f321' => [
				'name' => \XF::phrase('emoji.thermometer'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':thermometer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['weather'],
			],
			'1f6bd' => [
				'name' => \XF::phrase('emoji.toilet'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':toilet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['toilet'],
			],
			'1f6b0' => [
				'name' => \XF::phrase('emoji.potable_water'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':potable_water:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['drinking', 'potable', 'water'],
			],
			'1f6bf' => [
				'name' => \XF::phrase('emoji.shower'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':shower:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['water'],
			],
			'1f6c1' => [
				'name' => \XF::phrase('emoji.bathtub'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bathtub:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bath'],
			],
			'1f6c0' => [
				'name' => \XF::phrase('emoji.bath'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bath:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6c0-1f3fb', '1f6c0-1f3fc', '1f6c0-1f3fd', '1f6c0-1f3fe', '1f6c0-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bath', 'bathtub'],
			],
			'1f6c0-1f3fb' => [
				'name' => \XF::phrase('emoji.bath_tone1'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bath_tone1:',
				'shortname_alternates' => [],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bath', 'bathtub', 'light skin tone'],
			],
			'1f6c0-1f3fc' => [
				'name' => \XF::phrase('emoji.bath_tone2'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bath_tone2:',
				'shortname_alternates' => [],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bath', 'bathtub', 'medium-light skin tone'],
			],
			'1f6c0-1f3fd' => [
				'name' => \XF::phrase('emoji.bath_tone3'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bath_tone3:',
				'shortname_alternates' => [],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bath', 'bathtub', 'medium skin tone'],
			],
			'1f6c0-1f3fe' => [
				'name' => \XF::phrase('emoji.bath_tone4'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bath_tone4:',
				'shortname_alternates' => [],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bath', 'bathtub', 'medium-dark skin tone'],
			],
			'1f6c0-1f3ff' => [
				'name' => \XF::phrase('emoji.bath_tone5'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bath_tone5:',
				'shortname_alternates' => [],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bath', 'bathtub', 'dark skin tone'],
			],
			'1f9f9' => [
				'name' => \XF::phrase('emoji.broom'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':broom:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9fa' => [
				'name' => \XF::phrase('emoji.basket'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':basket:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9fb' => [
				'name' => \XF::phrase('emoji.roll_of_paper'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':roll_of_paper:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9fc' => [
				'name' => \XF::phrase('emoji.soap'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':soap:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9fd' => [
				'name' => \XF::phrase('emoji.sponge'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':sponge:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9f4' => [
				'name' => \XF::phrase('emoji.squeeze_bottle'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':squeeze_bottle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9f5' => [
				'name' => \XF::phrase('emoji.thread'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':thread:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f9f6' => [
				'name' => \XF::phrase('emoji.yarn'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':yarn:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f6ce' => [
				'name' => \XF::phrase('emoji.bellhop'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bellhop:',
				'shortname_alternates' => [':bellhop_bell:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bell', 'bellhop', 'hotel'],
			],
			'1f511' => [
				'name' => \XF::phrase('emoji.key'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':key:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lock', 'password'],
			],
			'1f5dd' => [
				'name' => \XF::phrase('emoji.key2'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':key2:',
				'shortname_alternates' => [':old_key:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clue', 'key', 'lock', 'old'],
			],
			'1f6aa' => [
				'name' => \XF::phrase('emoji.door'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':door:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['door'],
			],
			'1f6cb' => [
				'name' => \XF::phrase('emoji.couch'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':couch:',
				'shortname_alternates' => [':couch_and_lamp:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['couch', 'hotel', 'lamp'],
			],
			'1f6cf' => [
				'name' => \XF::phrase('emoji.bed'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bed:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hotel', 'sleep'],
			],
			'1f6cc' => [
				'name' => \XF::phrase('emoji.sleeping_accommodation'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':sleeping_accommodation:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => ['1f6cc-1f3fb', '1f6cc-1f3fc', '1f6cc-1f3fd', '1f6cc-1f3fe', '1f6cc-1f3ff'],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hotel', 'sleep'],
			],
			'1f6cc-1f3fb' => [
				'name' => \XF::phrase('emoji.person_in_bed_tone1'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':person_in_bed_tone1:',
				'shortname_alternates' => [':person_in_bed_light_skin_tone:'],
				'diversity' => '1f3fb',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hotel', 'light skin tone', 'sleep'],
			],
			'1f6cc-1f3fc' => [
				'name' => \XF::phrase('emoji.person_in_bed_tone2'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':person_in_bed_tone2:',
				'shortname_alternates' => [':person_in_bed_medium_light_skin_tone:'],
				'diversity' => '1f3fc',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hotel', 'medium-light skin tone', 'sleep'],
			],
			'1f6cc-1f3fd' => [
				'name' => \XF::phrase('emoji.person_in_bed_tone3'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':person_in_bed_tone3:',
				'shortname_alternates' => [':person_in_bed_medium_skin_tone:'],
				'diversity' => '1f3fd',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hotel', 'medium skin tone', 'sleep'],
			],
			'1f6cc-1f3fe' => [
				'name' => \XF::phrase('emoji.person_in_bed_tone4'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':person_in_bed_tone4:',
				'shortname_alternates' => [':person_in_bed_medium_dark_skin_tone:'],
				'diversity' => '1f3fe',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hotel', 'medium-dark skin tone', 'sleep'],
			],
			'1f6cc-1f3ff' => [
				'name' => \XF::phrase('emoji.person_in_bed_tone5'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':person_in_bed_tone5:',
				'shortname_alternates' => [':person_in_bed_dark_skin_tone:'],
				'diversity' => '1f3ff',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dark skin tone', 'hotel', 'sleep'],
			],
			'1f9f8' => [
				'name' => \XF::phrase('emoji.teddy_bear'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':teddy_bear:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f5bc' => [
				'name' => \XF::phrase('emoji.frame_photo'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':frame_photo:',
				'shortname_alternates' => [':frame_with_picture:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['art', 'frame', 'museum', 'painting', 'picture'],
			],
			'1f6cd' => [
				'name' => \XF::phrase('emoji.shopping_bags'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':shopping_bags:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bag', 'hotel', 'shopping'],
			],
			'1f6d2' => [
				'name' => \XF::phrase('emoji.shopping_cart'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':shopping_cart:',
				'shortname_alternates' => [':shopping_trolley:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cart', 'shopping', 'trolley'],
			],
			'1f381' => [
				'name' => \XF::phrase('emoji.gift'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':gift:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['box', 'celebration', 'gift', 'present', 'wrapped'],
			],
			'1f388' => [
				'name' => \XF::phrase('emoji.balloon'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':balloon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration'],
			],
			'1f38f' => [
				'name' => \XF::phrase('emoji.flags'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':flags:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['carp', 'celebration', 'streamer'],
			],
			'1f380' => [
				'name' => \XF::phrase('emoji.ribbon'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':ribbon:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration'],
			],
			'1f38a' => [
				'name' => \XF::phrase('emoji.confetti_ball'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':confetti_ball:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ball', 'celebration', 'confetti'],
			],
			'1f389' => [
				'name' => \XF::phrase('emoji.tada'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':tada:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['celebration', 'party', 'popper', 'tada'],
			],
			'1f38e' => [
				'name' => \XF::phrase('emoji.dolls'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':dolls:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'celebration', 'doll', 'festival'],
			],
			'1f3ee' => [
				'name' => \XF::phrase('emoji.izakaya_lantern'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':izakaya_lantern:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'lantern', 'light', 'red'],
			],
			'1f390' => [
				'name' => \XF::phrase('emoji.wind_chime'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':wind_chime:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bell', 'celebration', 'chime', 'wind'],
			],
			'1f9e7' => [
				'name' => \XF::phrase('emoji.red_envelope'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':red_envelope:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'2709' => [
				'name' => \XF::phrase('emoji.envelope'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':envelope:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['email', 'letter'],
			],
			'1f4e9' => [
				'name' => \XF::phrase('emoji.envelope_with_arrow'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':envelope_with_arrow:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['arrow', 'down', 'e-mail', 'email', 'envelope', 'letter', 'mail', 'outgoing', 'sent'],
			],
			'1f4e8' => [
				'name' => \XF::phrase('emoji.incoming_envelope'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':incoming_envelope:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['e-mail', 'email', 'envelope', 'incoming', 'letter', 'mail', 'receive'],
			],
			'1f4e7' => [
				'name' => \XF::phrase('emoji.e_mail'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':e-mail:',
				'shortname_alternates' => [':email:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['email', 'letter', 'mail'],
			],
			'1f48c' => [
				'name' => \XF::phrase('emoji.love_letter'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':love_letter:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['heart', 'letter', 'love', 'mail'],
			],
			'1f4e5' => [
				'name' => \XF::phrase('emoji.inbox_tray'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':inbox_tray:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['box', 'inbox', 'letter', 'mail', 'receive', 'tray'],
			],
			'1f4e4' => [
				'name' => \XF::phrase('emoji.outbox_tray'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':outbox_tray:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['box', 'letter', 'mail', 'outbox', 'sent', 'tray'],
			],
			'1f4e6' => [
				'name' => \XF::phrase('emoji.package'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':package:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['box', 'parcel'],
			],
			'1f3f7' => [
				'name' => \XF::phrase('emoji.label'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':label:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['label'],
			],
			'1f4ea' => [
				'name' => \XF::phrase('emoji.mailbox_closed'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':mailbox_closed:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['closed', 'lowered', 'mail', 'mailbox', 'postbox'],
			],
			'1f4eb' => [
				'name' => \XF::phrase('emoji.mailbox'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':mailbox:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['closed', 'mail', 'mailbox', 'postbox'],
			],
			'1f4ec' => [
				'name' => \XF::phrase('emoji.mailbox_with_mail'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':mailbox_with_mail:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mail', 'mailbox', 'open', 'postbox'],
			],
			'1f4ed' => [
				'name' => \XF::phrase('emoji.mailbox_with_no_mail'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':mailbox_with_no_mail:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lowered', 'mail', 'mailbox', 'open', 'postbox'],
			],
			'1f4ee' => [
				'name' => \XF::phrase('emoji.postbox'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':postbox:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mail', 'mailbox'],
			],
			'1f4ef' => [
				'name' => \XF::phrase('emoji.postal_horn'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':postal_horn:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['horn', 'post', 'postal'],
			],
			'1f4dc' => [
				'name' => \XF::phrase('emoji.scroll'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':scroll:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['paper'],
			],
			'1f4c3' => [
				'name' => \XF::phrase('emoji.page_with_curl'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':page_with_curl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['curl', 'document', 'page'],
			],
			'1f4c4' => [
				'name' => \XF::phrase('emoji.page_facing_up'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':page_facing_up:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['document', 'page'],
			],
			'1f9fe' => [
				'name' => \XF::phrase('emoji.receipt'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':receipt:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f4d1' => [
				'name' => \XF::phrase('emoji.bookmark_tabs'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bookmark_tabs:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bookmark', 'mark', 'marker', 'tabs'],
			],
			'1f4ca' => [
				'name' => \XF::phrase('emoji.bar_chart'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bar_chart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bar', 'chart', 'graph'],
			],
			'1f4c8' => [
				'name' => \XF::phrase('emoji.chart_with_upwards_trend'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':chart_with_upwards_trend:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chart', 'graph', 'growth', 'trend', 'upward'],
			],
			'1f4c9' => [
				'name' => \XF::phrase('emoji.chart_with_downwards_trend'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':chart_with_downwards_trend:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['chart', 'down', 'graph', 'trend'],
			],
			'1f5d2' => [
				'name' => \XF::phrase('emoji.notepad_spiral'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':notepad_spiral:',
				'shortname_alternates' => [':spiral_note_pad:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['note', 'pad', 'spiral'],
			],
			'1f5d3' => [
				'name' => \XF::phrase('emoji.calendar_spiral'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':calendar_spiral:',
				'shortname_alternates' => [':spiral_calendar_pad:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['calendar', 'pad', 'spiral'],
			],
			'1f4c6' => [
				'name' => \XF::phrase('emoji.calendar'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':calendar:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['calendar'],
			],
			'1f4c5' => [
				'name' => \XF::phrase('emoji.date'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':date:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['date'],
			],
			'1f4c7' => [
				'name' => \XF::phrase('emoji.card_index'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':card_index:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['card', 'index', 'rolodex'],
			],
			'1f5c3' => [
				'name' => \XF::phrase('emoji.card_box'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':card_box:',
				'shortname_alternates' => [':card_file_box:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['box', 'card', 'file'],
			],
			'1f5f3' => [
				'name' => \XF::phrase('emoji.ballot_box'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':ballot_box:',
				'shortname_alternates' => [':ballot_box_with_ballot:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ballot', 'box'],
			],
			'1f5c4' => [
				'name' => \XF::phrase('emoji.file_cabinet'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':file_cabinet:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cabinet', 'file', 'filing'],
			],
			'1f4cb' => [
				'name' => \XF::phrase('emoji.clipboard'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':clipboard:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['clipboard'],
			],
			'1f4c1' => [
				'name' => \XF::phrase('emoji.file_folder'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':file_folder:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['file', 'folder'],
			],
			'1f4c2' => [
				'name' => \XF::phrase('emoji.open_file_folder'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':open_file_folder:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['file', 'folder', 'open'],
			],
			'1f5c2' => [
				'name' => \XF::phrase('emoji.dividers'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':dividers:',
				'shortname_alternates' => [':card_index_dividers:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['card', 'dividers', 'index'],
			],
			'1f5de' => [
				'name' => \XF::phrase('emoji.newspaper2'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':newspaper2:',
				'shortname_alternates' => [':rolled_up_newspaper:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['news', 'newspaper', 'paper', 'rolled'],
			],
			'1f4f0' => [
				'name' => \XF::phrase('emoji.newspaper'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':newspaper:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['news', 'paper'],
			],
			'1f4d3' => [
				'name' => \XF::phrase('emoji.notebook'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':notebook:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['notebook'],
			],
			'1f4d4' => [
				'name' => \XF::phrase('emoji.notebook_with_decorative_cover'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':notebook_with_decorative_cover:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['book', 'cover', 'decorated', 'notebook'],
			],
			'1f4d2' => [
				'name' => \XF::phrase('emoji.ledger'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':ledger:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['notebook'],
			],
			'1f4d5' => [
				'name' => \XF::phrase('emoji.closed_book'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':closed_book:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['book', 'closed'],
			],
			'1f4d7' => [
				'name' => \XF::phrase('emoji.green_book'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':green_book:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['book', 'green'],
			],
			'1f4d8' => [
				'name' => \XF::phrase('emoji.blue_book'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':blue_book:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blue', 'book'],
			],
			'1f4d9' => [
				'name' => \XF::phrase('emoji.orange_book'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':orange_book:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['book', 'orange'],
			],
			'1f4da' => [
				'name' => \XF::phrase('emoji.books'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':books:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['book'],
			],
			'1f4d6' => [
				'name' => \XF::phrase('emoji.book'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':book:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['book', 'open'],
			],
			'1f516' => [
				'name' => \XF::phrase('emoji.bookmark'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':bookmark:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mark'],
			],
			'1f517' => [
				'name' => \XF::phrase('emoji.link'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':link:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['link'],
			],
			'1f4ce' => [
				'name' => \XF::phrase('emoji.paperclip'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':paperclip:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['paperclip'],
			],
			'1f587' => [
				'name' => \XF::phrase('emoji.paperclips'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':paperclips:',
				'shortname_alternates' => [':linked_paperclips:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['link', 'paperclip'],
			],
			'1f4d0' => [
				'name' => \XF::phrase('emoji.triangular_ruler'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':triangular_ruler:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ruler', 'set', 'triangle'],
			],
			'1f4cf' => [
				'name' => \XF::phrase('emoji.straight_ruler'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':straight_ruler:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ruler', 'straight edge'],
			],
			'1f9f7' => [
				'name' => \XF::phrase('emoji.safety_pin'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':safety_pin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f4cc' => [
				'name' => \XF::phrase('emoji.pushpin'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pushpin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pin'],
			],
			'1f4cd' => [
				'name' => \XF::phrase('emoji.round_pushpin'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':round_pushpin:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pin', 'pushpin'],
			],
			'2702' => [
				'name' => \XF::phrase('emoji.scissors'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':scissors:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cutting', 'tool'],
			],
			'1f58a' => [
				'name' => \XF::phrase('emoji.pen_ballpoint'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pen_ballpoint:',
				'shortname_alternates' => [':lower_left_ballpoint_pen:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ballpoint'],
			],
			'1f58b' => [
				'name' => \XF::phrase('emoji.pen_fountain'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pen_fountain:',
				'shortname_alternates' => [':lower_left_fountain_pen:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fountain', 'pen'],
			],
			'2712' => [
				'name' => \XF::phrase('emoji.black_nib'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':black_nib:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['nib', 'pen'],
			],
			'1f58c' => [
				'name' => \XF::phrase('emoji.paintbrush'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':paintbrush:',
				'shortname_alternates' => [':lower_left_paintbrush:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['painting'],
			],
			'1f58d' => [
				'name' => \XF::phrase('emoji.crayon'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':crayon:',
				'shortname_alternates' => [':lower_left_crayon:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crayon'],
			],
			'1f4dd' => [
				'name' => \XF::phrase('emoji.pencil'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pencil:',
				'shortname_alternates' => [':memo:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pencil'],
			],
			'270f' => [
				'name' => \XF::phrase('emoji.pencil2'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':pencil2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['pencil'],
			],
			'1f50d' => [
				'name' => \XF::phrase('emoji.mag'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':mag:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['glass', 'magnifying', 'search', 'tool'],
			],
			'1f50e' => [
				'name' => \XF::phrase('emoji.mag_right'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':mag_right:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['glass', 'magnifying', 'search', 'tool'],
			],
			'1f50f' => [
				'name' => \XF::phrase('emoji.lock_with_ink_pen'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':lock_with_ink_pen:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ink', 'lock', 'nib', 'pen', 'privacy'],
			],
			'1f510' => [
				'name' => \XF::phrase('emoji.closed_lock_with_key'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':closed_lock_with_key:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['closed', 'key', 'lock', 'secure'],
			],
			'1f512' => [
				'name' => \XF::phrase('emoji.lock'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':lock:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['closed'],
			],
			'1f513' => [
				'name' => \XF::phrase('emoji.unlock'),
				'category_name' => \XF::phrase('emoji_category.objects'),
				'category' => 'objects',
				'shortname' => ':unlock:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lock', 'open', 'unlock'],
			],
			'2764' => [
				'name' => \XF::phrase('emoji.heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['heart'],
			],
			'1f9e1' => [
				'name' => \XF::phrase('emoji.orange_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':orange_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['orange'],
			],
			'1f49b' => [
				'name' => \XF::phrase('emoji.yellow_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':yellow_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['yellow'],
			],
			'1f49a' => [
				'name' => \XF::phrase('emoji.green_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':green_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['green'],
			],
			'1f499' => [
				'name' => \XF::phrase('emoji.blue_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':blue_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blue'],
			],
			'1f49c' => [
				'name' => \XF::phrase('emoji.purple_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':purple_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['purple'],
			],
			'1f5a4' => [
				'name' => \XF::phrase('emoji.black_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':black_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['black', 'evil', 'wicked'],
			],
			'1f494' => [
				'name' => \XF::phrase('emoji.broken_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':broken_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['break', 'broken'],
			],
			'2763' => [
				'name' => \XF::phrase('emoji.heart_exclamation'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':heart_exclamation:',
				'shortname_alternates' => [':heavy_heart_exclamation_mark_ornament:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['exclamation', 'mark', 'punctuation'],
			],
			'1f495' => [
				'name' => \XF::phrase('emoji.two_hearts'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':two_hearts:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['love'],
			],
			'1f49e' => [
				'name' => \XF::phrase('emoji.revolving_hearts'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':revolving_hearts:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['revolving'],
			],
			'1f493' => [
				'name' => \XF::phrase('emoji.heartbeat'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':heartbeat:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['beating', 'heartbeat', 'pulsating'],
			],
			'1f497' => [
				'name' => \XF::phrase('emoji.heartpulse'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':heartpulse:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['excited', 'growing', 'nervous', 'pulse'],
			],
			'1f496' => [
				'name' => \XF::phrase('emoji.sparkling_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':sparkling_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['excited', 'sparkle'],
			],
			'1f498' => [
				'name' => \XF::phrase('emoji.cupid'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':cupid:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['arrow', 'cupid'],
			],
			'1f49d' => [
				'name' => \XF::phrase('emoji.gift_heart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':gift_heart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ribbon', 'valentine'],
			],
			'1f49f' => [
				'name' => \XF::phrase('emoji.heart_decoration'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':heart_decoration:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['heart'],
			],
			'262e' => [
				'name' => \XF::phrase('emoji.peace'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':peace:',
				'shortname_alternates' => [':peace_symbol:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['peace'],
			],
			'271d' => [
				'name' => \XF::phrase('emoji.cross'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':cross:',
				'shortname_alternates' => [':latin_cross:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christian', 'cross', 'religion'],
			],
			'262a' => [
				'name' => \XF::phrase('emoji.star_and_crescent'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':star_and_crescent:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Muslim', 'islam', 'religion'],
			],
			'1f549' => [
				'name' => \XF::phrase('emoji.om_symbol'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':om_symbol:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Hindu', 'religion'],
			],
			'2638' => [
				'name' => \XF::phrase('emoji.wheel_of_dharma'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':wheel_of_dharma:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Buddhist', 'dharma', 'religion', 'wheel'],
			],
			'2721' => [
				'name' => \XF::phrase('emoji.star_of_david'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':star_of_david:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['David', 'Jew', 'Jewish', 'religion', 'star'],
			],
			'1f52f' => [
				'name' => \XF::phrase('emoji.six_pointed_star'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':six_pointed_star:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fortune', 'star'],
			],
			'1f54e' => [
				'name' => \XF::phrase('emoji.menorah'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':menorah:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['candelabrum', 'candlestick', 'religion'],
			],
			'262f' => [
				'name' => \XF::phrase('emoji.yin_yang'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':yin_yang:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['religion', 'tao', 'taoist', 'yang', 'yin'],
			],
			'2626' => [
				'name' => \XF::phrase('emoji.orthodox_cross'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':orthodox_cross:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Christian', 'cross', 'religion'],
			],
			'1f6d0' => [
				'name' => \XF::phrase('emoji.place_of_worship'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':place_of_worship:',
				'shortname_alternates' => [':worship_symbol:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['religion', 'worship'],
			],
			'26ce' => [
				'name' => \XF::phrase('emoji.ophiuchus'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':ophiuchus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bearer', 'serpent', 'snake', 'zodiac'],
			],
			'2648' => [
				'name' => \XF::phrase('emoji.aries'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':aries:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ram', 'zodiac'],
			],
			'2649' => [
				'name' => \XF::phrase('emoji.taurus'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':taurus:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bull', 'ox', 'zodiac'],
			],
			'264a' => [
				'name' => \XF::phrase('emoji.gemini'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':gemini:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['twins', 'zodiac'],
			],
			'264b' => [
				'name' => \XF::phrase('emoji.cancer'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':cancer:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['crab', 'zodiac'],
			],
			'264c' => [
				'name' => \XF::phrase('emoji.leo'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':leo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lion', 'zodiac'],
			],
			'264d' => [
				'name' => \XF::phrase('emoji.virgo'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':virgo:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['zodiac'],
			],
			'264e' => [
				'name' => \XF::phrase('emoji.libra'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':libra:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['balance', 'justice', 'scales', 'zodiac'],
			],
			'264f' => [
				'name' => \XF::phrase('emoji.scorpius'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':scorpius:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['scorpio', 'scorpion', 'zodiac'],
			],
			'2650' => [
				'name' => \XF::phrase('emoji.sagittarius'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':sagittarius:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['archer', 'zodiac'],
			],
			'2651' => [
				'name' => \XF::phrase('emoji.capricorn'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':capricorn:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['goat', 'zodiac'],
			],
			'2652' => [
				'name' => \XF::phrase('emoji.aquarius'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':aquarius:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bearer', 'water', 'zodiac'],
			],
			'2653' => [
				'name' => \XF::phrase('emoji.pisces'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':pisces:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fish', 'zodiac'],
			],
			'1f194' => [
				'name' => \XF::phrase('emoji.id'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':id:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['id', 'identity'],
			],
			'269b' => [
				'name' => \XF::phrase('emoji.atom'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':atom:',
				'shortname_alternates' => [':atom_symbol:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['atheist', 'atom'],
			],
			'267e' => [
				'name' => \XF::phrase('emoji.infinity'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':infinity:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => [''],
			],
			'1f251' => [
				'name' => \XF::phrase('emoji.accept'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':accept:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“acceptable”', '可'],
			],
			'2622' => [
				'name' => \XF::phrase('emoji.radioactive'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':radioactive:',
				'shortname_alternates' => [':radioactive_sign:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['radioactive', 'sign'],
			],
			'2623' => [
				'name' => \XF::phrase('emoji.biohazard'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':biohazard:',
				'shortname_alternates' => [':biohazard_sign:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['biohazard', 'sign'],
			],
			'1f4f4' => [
				'name' => \XF::phrase('emoji.mobile_phone_off'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':mobile_phone_off:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cell', 'mobile', 'off', 'phone', 'telephone'],
			],
			'1f4f3' => [
				'name' => \XF::phrase('emoji.vibration_mode'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':vibration_mode:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cell', 'mobile', 'mode', 'phone', 'telephone', 'vibration'],
			],
			'1f236' => [
				'name' => \XF::phrase('emoji.u6709'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u6709:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“not free of charge”', '有'],
			],
			'1f21a' => [
				'name' => \XF::phrase('emoji.u7121'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u7121:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“free of charge”', '無'],
			],
			'1f238' => [
				'name' => \XF::phrase('emoji.u7533'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u7533:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“application”', '申'],
			],
			'1f23a' => [
				'name' => \XF::phrase('emoji.u55b6'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u55b6:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“open for business”', '営'],
			],
			'1f237' => [
				'name' => \XF::phrase('emoji.u6708'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u6708:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“monthly amount”', '月'],
			],
			'2734' => [
				'name' => \XF::phrase('emoji.eight_pointed_black_star'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':eight_pointed_black_star:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['star'],
			],
			'1f19a' => [
				'name' => \XF::phrase('emoji.vs'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':vs:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['versus', 'vs'],
			],
			'1f4ae' => [
				'name' => \XF::phrase('emoji.white_flower'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':white_flower:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['flower'],
			],
			'1f250' => [
				'name' => \XF::phrase('emoji.ideograph_advantage'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':ideograph_advantage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“bargain”', '得'],
			],
			'3299' => [
				'name' => \XF::phrase('emoji.secret'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':secret:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“secret”', '秘'],
			],
			'3297' => [
				'name' => \XF::phrase('emoji.congratulations'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':congratulations:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“congratulations”', '祝'],
			],
			'1f234' => [
				'name' => \XF::phrase('emoji.u5408'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u5408:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“passing grade”', '合'],
			],
			'1f235' => [
				'name' => \XF::phrase('emoji.u6e80'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u6e80:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“no vacancy”', '満'],
			],
			'1f239' => [
				'name' => \XF::phrase('emoji.u5272'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u5272:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“discount”', '割'],
			],
			'1f232' => [
				'name' => \XF::phrase('emoji.u7981'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u7981:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“prohibited”', '禁'],
			],
			'1f170' => [
				'name' => \XF::phrase('emoji.a'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':a:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['a', 'blood type'],
			],
			'1f171' => [
				'name' => \XF::phrase('emoji.b'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':b:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['b', 'blood type'],
			],
			'1f18e' => [
				'name' => \XF::phrase('emoji.ab'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':ab:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ab', 'blood type'],
			],
			'1f191' => [
				'name' => \XF::phrase('emoji.cl'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':cl:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cl'],
			],
			'1f17e' => [
				'name' => \XF::phrase('emoji.o2'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':o2:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['blood type', 'o'],
			],
			'1f198' => [
				'name' => \XF::phrase('emoji.sos'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':sos:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['help', 'sos'],
			],
			'274c' => [
				'name' => \XF::phrase('emoji.x'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':x:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cancel', 'mark', 'multiplication', 'multiply', 'x'],
			],
			'2b55' => [
				'name' => \XF::phrase('emoji.o'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':o:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['circle', 'o'],
			],
			'1f6d1' => [
				'name' => \XF::phrase('emoji.octagonal_sign'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':octagonal_sign:',
				'shortname_alternates' => [':stop_sign:'],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['octagonal', 'sign', 'stop'],
			],
			'26d4' => [
				'name' => \XF::phrase('emoji.no_entry'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':no_entry:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['entry', 'forbidden', 'no', 'not', 'prohibited', 'traffic'],
			],
			'1f4db' => [
				'name' => \XF::phrase('emoji.name_badge'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':name_badge:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['badge', 'name'],
			],
			'1f6ab' => [
				'name' => \XF::phrase('emoji.no_entry_sign'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':no_entry_sign:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['entry', 'forbidden', 'no', 'not'],
			],
			'1f4af' => [
				'name' => \XF::phrase('emoji.100'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':100:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['100', 'full', 'hundred', 'score'],
			],
			'1f4a2' => [
				'name' => \XF::phrase('emoji.anger'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':anger:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['angry', 'comic', 'mad'],
			],
			'2668' => [
				'name' => \XF::phrase('emoji.hotsprings'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':hotsprings:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['hot', 'hotsprings', 'springs', 'steaming'],
			],
			'1f6b7' => [
				'name' => \XF::phrase('emoji.no_pedestrians'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':no_pedestrians:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['forbidden', 'no', 'not', 'pedestrian', 'prohibited'],
			],
			'1f6af' => [
				'name' => \XF::phrase('emoji.do_not_litter'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':do_not_litter:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['forbidden', 'litter', 'no', 'not', 'prohibited'],
			],
			'1f6b3' => [
				'name' => \XF::phrase('emoji.no_bicycles'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':no_bicycles:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bicycle', 'bike', 'forbidden', 'no', 'not', 'prohibited'],
			],
			'1f6b1' => [
				'name' => \XF::phrase('emoji.non_potable_water'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':non-potable_water:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['non-drinking', 'non-potable', 'water'],
			],
			'1f51e' => [
				'name' => \XF::phrase('emoji.underage'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':underage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['18', 'age restriction', 'eighteen', 'forbidden', 'no', 'not', 'prohibited', 'underage'],
			],
			'1f4f5' => [
				'name' => \XF::phrase('emoji.no_mobile_phones'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':no_mobile_phones:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cell', 'forbidden', 'mobile', 'no', 'not', 'phone', 'prohibited', 'telephone'],
			],
			'1f6ad' => [
				'name' => \XF::phrase('emoji.no_smoking'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':no_smoking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['forbidden', 'no', 'not', 'prohibited', 'smoking'],
			],
			'2757' => [
				'name' => \XF::phrase('emoji.exclamation'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':exclamation:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['exclamation', 'mark', 'punctuation'],
			],
			'2755' => [
				'name' => \XF::phrase('emoji.grey_exclamation'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':grey_exclamation:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['exclamation', 'mark', 'outlined', 'punctuation'],
			],
			'2753' => [
				'name' => \XF::phrase('emoji.question'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':question:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mark', 'punctuation', 'question'],
			],
			'2754' => [
				'name' => \XF::phrase('emoji.grey_question'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':grey_question:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mark', 'outlined', 'punctuation', 'question'],
			],
			'203c' => [
				'name' => \XF::phrase('emoji.bangbang'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':bangbang:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bangbang', 'exclamation', 'mark', 'punctuation'],
			],
			'2049' => [
				'name' => \XF::phrase('emoji.interrobang'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':interrobang:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['exclamation', 'interrobang', 'mark', 'punctuation', 'question'],
			],
			'1f505' => [
				'name' => \XF::phrase('emoji.low_brightness'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':low_brightness:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['brightness', 'dim', 'low'],
			],
			'1f506' => [
				'name' => \XF::phrase('emoji.high_brightness'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':high_brightness:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bright', 'brightness'],
			],
			'303d' => [
				'name' => \XF::phrase('emoji.part_alternation_mark'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':part_alternation_mark:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mark', 'part'],
			],
			'26a0' => [
				'name' => \XF::phrase('emoji.warning'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':warning:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['warning'],
			],
			'1f6b8' => [
				'name' => \XF::phrase('emoji.children_crossing'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':children_crossing:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['child', 'crossing', 'pedestrian', 'traffic'],
			],
			'1f531' => [
				'name' => \XF::phrase('emoji.trident'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':trident:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['anchor', 'emblem', 'ship', 'tool', 'trident'],
			],
			'269c' => [
				'name' => \XF::phrase('emoji.fleur_de_lis'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':fleur-de-lis:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['fleur-de-lis'],
			],
			'1f530' => [
				'name' => \XF::phrase('emoji.beginner'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':beginner:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'beginner', 'chevron', 'green', 'leaf', 'tool', 'yellow'],
			],
			'267b' => [
				'name' => \XF::phrase('emoji.recycle'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':recycle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['recycle'],
			],
			'2705' => [
				'name' => \XF::phrase('emoji.white_check_mark'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':white_check_mark:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['check', 'mark'],
			],
			'1f22f' => [
				'name' => \XF::phrase('emoji.u6307'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u6307:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“reserved”', '指'],
			],
			'1f4b9' => [
				'name' => \XF::phrase('emoji.chart'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':chart:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['bank', 'chart', 'currency', 'graph', 'growth', 'market', 'money', 'rise', 'trend', 'upward', 'yen'],
			],
			'2747' => [
				'name' => \XF::phrase('emoji.sparkle'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':sparkle:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['sparkle'],
			],
			'2733' => [
				'name' => \XF::phrase('emoji.eight_spoked_asterisk'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':eight_spoked_asterisk:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['asterisk'],
			],
			'274e' => [
				'name' => \XF::phrase('emoji.negative_squared_cross_mark'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':negative_squared_cross_mark:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mark', 'square'],
			],
			'1f310' => [
				'name' => \XF::phrase('emoji.globe_with_meridians'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':globe_with_meridians:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['earth', 'globe', 'meridians', 'world'],
			],
			'1f4a0' => [
				'name' => \XF::phrase('emoji.diamond_shape_with_a_dot_inside'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':diamond_shape_with_a_dot_inside:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['comic', 'diamond', 'geometric', 'inside'],
			],
			'24c2' => [
				'name' => \XF::phrase('emoji.m'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':m:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['circle', 'm'],
			],
			'1f300' => [
				'name' => \XF::phrase('emoji.cyclone'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':cyclone:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['dizzy', 'twister', 'typhoon'],
			],
			'1f4a4' => [
				'name' => \XF::phrase('emoji.zzz'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':zzz:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['comic', 'sleep'],
			],
			'1f3e7' => [
				'name' => \XF::phrase('emoji.atm'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':atm:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['atm', 'automated', 'bank', 'teller'],
			],
			'1f6be' => [
				'name' => \XF::phrase('emoji.wc'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':wc:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['closet', 'lavatory', 'restroom', 'water', 'wc'],
			],
			'267f' => [
				'name' => \XF::phrase('emoji.wheelchair'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':wheelchair:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['access'],
			],
			'1f17f' => [
				'name' => \XF::phrase('emoji.parking'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':parking:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['parking'],
			],
			'1f233' => [
				'name' => \XF::phrase('emoji.u7a7a'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':u7a7a:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'ideograph', '“vacancy”', '空'],
			],
			'1f202' => [
				'name' => \XF::phrase('emoji.sa'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':sa:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'katakana', '“service charge”', 'サ'],
			],
			'1f6c2' => [
				'name' => \XF::phrase('emoji.passport_control'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':passport_control:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['control', 'passport'],
			],
			'1f6c3' => [
				'name' => \XF::phrase('emoji.customs'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':customs:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['customs'],
			],
			'1f6c4' => [
				'name' => \XF::phrase('emoji.baggage_claim'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':baggage_claim:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baggage', 'claim'],
			],
			'1f6c5' => [
				'name' => \XF::phrase('emoji.left_luggage'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':left_luggage:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baggage', 'locker', 'luggage'],
			],
			'1f6b9' => [
				'name' => \XF::phrase('emoji.mens'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':mens:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lavatory', 'man', 'restroom', 'wc'],
			],
			'1f6ba' => [
				'name' => \XF::phrase('emoji.womens'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':womens:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['lavatory', 'restroom', 'wc', 'woman'],
			],
			'1f6bc' => [
				'name' => \XF::phrase('emoji.baby_symbol'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':baby_symbol:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['baby', 'changing'],
			],
			'1f6bb' => [
				'name' => \XF::phrase('emoji.restroom'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':restroom:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['WC', 'lavatory', 'restroom'],
			],
			'1f6ae' => [
				'name' => \XF::phrase('emoji.put_litter_in_its_place'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':put_litter_in_its_place:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['litter', 'litter bin'],
			],
			'1f3a6' => [
				'name' => \XF::phrase('emoji.cinema'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':cinema:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['camera', 'film', 'movie'],
			],
			'1f4f6' => [
				'name' => \XF::phrase('emoji.signal_strength'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':signal_strength:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['antenna', 'bar', 'cell', 'mobile', 'phone', 'signal', 'telephone'],
			],
			'1f201' => [
				'name' => \XF::phrase('emoji.koko'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':koko:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['Japanese', 'katakana', '“here”', 'ココ'],
			],
			'1f523' => [
				'name' => \XF::phrase('emoji.symbols'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':symbols:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['input', '〒♪&amp;%'],
			],
			'2139' => [
				'name' => \XF::phrase('emoji.information_source'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':information_source:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['i', 'information'],
			],
			'1f524' => [
				'name' => \XF::phrase('emoji.abc'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':abc:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['abc', 'alphabet', 'input', 'latin', 'letters'],
			],
			'1f521' => [
				'name' => \XF::phrase('emoji.abcd'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':abcd:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['abcd', 'input', 'latin', 'letters', 'lowercase'],
			],
			'1f520' => [
				'name' => \XF::phrase('emoji.capital_abcd'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':capital_abcd:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ABCD', 'input', 'latin', 'letters', 'uppercase'],
			],
			'1f196' => [
				'name' => \XF::phrase('emoji.ng'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':ng:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['ng'],
			],
			'1f197' => [
				'name' => \XF::phrase('emoji.ok'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':ok:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['OK'],
			],
			'1f199' => [
				'name' => \XF::phrase('emoji.up'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':up:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['mark', 'up'],
			],
			'1f192' => [
				'name' => \XF::phrase('emoji.cool'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':cool:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['cool'],
			],
			'1f195' => [
				'name' => \XF::phrase('emoji.new'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':new:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['new'],
			],
			'1f193' => [
				'name' => \XF::phrase('emoji.free'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':free:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['free'],
			],
			'0030-20e3' => [
				'name' => \XF::phrase('emoji.zero'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':zero:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['keycap'],
			],
			'0031-20e3' => [
				'name' => \XF::phrase('emoji.one'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':one:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['keycap'],
			],
			'0032-20e3' => [
				'name' => \XF::phrase('emoji.two'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':two:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['keycap'],
			],
			'0033-20e3' => [
				'name' => \XF::phrase('emoji.three'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbols',
				'shortname' => ':three:',
				'shortname_alternates' => [],
				'diversity' => '',
				'diversities' => [],
				'gender' => '',
				'genders' => [],
				'keywords' => ['keycap'],
			],
			'0034-20e3' => [
				'name' => \XF::phrase('emoji.four'),
				'category_name' => \XF::phrase('emoji_category.symbols'),
				'category' => 'symbol