/**
 * History.js jQuery Adapter and History.js Core
 * @author Benjamin Arthur Lupton <contact@balupton.com>
 * @copyright 2010-2011 Benjamin Arthur Lupton <contact@balupton.com>
 * @license New BSD License <http://creativecommons.org/licenses/BSD/>
 *
 * ============ NOTE: This version contains patch from https://github.com/christanto/history.js/commit/b78af84fc2b6b5da573e5ee0bd72f4213e36bb18 ============
 */	
(function(b,d){"use strict";var a=b.History=b.History||{},c=b.jQuery;if(typeof a.Adapter!=="undefined"){throw new Error("History.js Adapter has already been loaded...")}a.Adapter={bind:function(e,f,g){c(e).bind(f,g)},trigger:function(f,g,e){c(f).trigger(g,e)},extractEventData:function(g,h,f){var e=(h&&h.originalEvent&&h.originalEvent[g])||(f&&f[g])||d;return e},onDomLoad:function(e){c(e)}};if(typeof a.init!=="undefined"){a.init()}})(window);(function(g,a){"use strict";var d=g.console||a,i=g.document,l=g.navigator,k=g.sessionStorage||false,c=g.setTimeout,j=g.clearTimeout,e=g.setInterval,n=g.clearInterval,m=g.JSON,h=g.alert,b=g.History=g.History||{},f=g.history;m.stringify=m.stringify||m.encode;m.parse=m.parse||m.decode;if(typeof b.init!=="undefined"){throw new Error("History.js Core has already been loaded...")}b.init=function(){if(typeof b.Adapter==="undefined"){return false}if(typeof b.initCore!=="undefined"){b.initCore()}if(typeof b.initHtml4!=="undefined"){b.initHtml4()}return true};b.initCore=function(){if(typeof b.initCore.initialized!=="undefined"){return false}else{b.initCore.initialized=true}b.options=b.options||{};b.options.hashChangeInterval=b.options.hashChangeInterval||100;b.options.safariPollInterval=b.options.safariPollInterval||500;b.options.doubleCheckInterval=b.options.doubleCheckInterval||500;b.options.storeInterval=b.options.storeInterval||1000;b.options.busyDelay=b.options.busyDelay||250;b.options.debug=b.options.debug||false;b.options.initialTitle=b.options.initialTitle||i.title;b.options.transformHash=b.options.transformHash||true;b.intervalList=[];b.clearAllIntervals=function(){var r,q=b.intervalList;if(typeof q!=="undefined"&&q!==null){for(r=0;r<q.length;r++){n(q[r])}b.intervalList=null}};b.debug=function(){if((b.options.debug||false)){b.log.apply(b,arguments)}};b.log=function(){var w=!(typeof d==="undefined"||typeof d.log==="undefined"||typeof d.log.apply==="undefined"),r=i.getElementById("log"),v,u,x,s,q;if(w){s=Array.prototype.slice.call(arguments);v=s.shift();if(typeof d.debug!=="undefined"){d.debug.apply(d,[v,s])}else{d.log.apply(d,[v,s])}}else{v=("\n"+arguments[0]+"\n")}for(u=1,x=arguments.length;u<x;++u){q=arguments[u];if(typeof q==="object"&&typeof m!=="undefined"){try{q=m.stringify(q)}catch(t){}}v+="\n"+q+"\n"}if(r){r.value+=v+"\n-----\n";r.scrollTop=r.scrollHeight-r.clientHeight}else{if(!w){h(v)}}return true};b.getInternetExplorerMajorVersion=function(){var q=b.getInternetExplorerMajorVersion.cached=(typeof b.getInternetExplorerMajorVersion.cached!=="undefined")?b.getInternetExplorerMajorVersion.cached:(function(){var r=3,t=i.createElement("div"),s=t.getElementsByTagName("i");while((t.innerHTML="<!--[if gt IE "+(++r)+"]><i></i><![endif]-->")&&s[0]){}return(r>4)?r:false})();return q};b.isInternetExplorer=function(){var q=b.isInternetExplorer.cached=(typeof b.isInternetExplorer.cached!=="undefined")?b.isInternetExplorer.cached:Boolean(b.getInternetExplorerMajorVersion());return q};b.emulated={pushState:!Boolean(g.history&&g.history.pushState&&g.history.replaceState&&!((/ Mobile\/([1-7][a-z]|(8([abcde]|f(1[0-8]))))/i).test(l.userAgent)||(/AppleWebKit\/5([0-2]|3[0-2])/i).test(l.userAgent))),hashChange:Boolean(!(("onhashchange" in g)||("onhashchange" in i))||(b.isInternetExplorer()&&b.getInternetExplorerMajorVersion()<8))};b.enabled=!b.emulated.pushState;b.bugs={setHash:Boolean(!b.emulated.pushState&&l.vendor==="Apple Computer, Inc."&&/AppleWebKit\/5([0-2]|3[0-3])/.test(l.userAgent)),safariPoll:Boolean(!b.emulated.pushState&&l.vendor==="Apple Computer, Inc."&&/AppleWebKit\/5([0-2]|3[0-3])/.test(l.userAgent)),ieDoubleCheck:Boolean(b.isInternetExplorer()&&b.getInternetExplorerMajorVersion()<8),hashEscape:Boolean(b.isInternetExplorer()&&b.getInternetExplorerMajorVersion()<7)};b.isEmptyObject=function(r){for(var q in r){return false}return true};b.cloneObject=function(s){var r,q;if(s){r=m.stringify(s);q=m.parse(r)}else{q={}}return q};b.getRootUrl=function(){var q=i.location.protocol+"//"+(i.location.hostname||i.location.host);if(i.location.port||false){q+=":"+i.location.port}q+="/";return q};b.getBaseHref=function(){var q=i.getElementsByTagName("base"),s=null,r="";if(q.length===1){s=q[0];r=s.href.replace(/[^\/]+$/,"")}r=r.replace(/\/+$/,"");if(r){r+="/"}return r};b.getBaseUrl=function(){var q=b.getBaseHref()||b.getBasePageUrl()||b.getRootUrl();return q};b.getPageUrl=function(){var q=b.getState(false,false),s=(q||{}).url||i.location.href,r;r=s.replace(/\/+$/,"").replace(/[^\/]+$/,function(v,u,t){return(/\./).test(v)?v:v+"/"});return r};b.getBasePageUrl=function(){var q=i.location.href.replace(/[#\?].*/,"").replace(/[^\/]+$/,function(t,s,r){return(/[^\/]$/).test(t)?"":t}).replace(/\/+$/,"")+"/";return q};b.getFullUrl=function(r,t){var q=r,s=r.substring(0,1);t=(typeof t==="undefined")?true:t;if(/[a-z]+\:\/\//.test(r)){}else{if(s==="/"){q=b.getRootUrl()+r.replace(/^\/+/,"")}else{if(s==="#"){q=b.getPageUrl().replace(/#.*/,"")+r}else{if(s==="?"){q=b.getPageUrl().replace(/[\?#].*/,"")+r}else{if(t){q=b.getBaseUrl()+r.replace(/^(\.\/)+/,"")}else{q=b.getBasePageUrl()+r.replace(/^(\.\/)+/,"")}}}}}return q.replace(/\#$/,"")};b.getShortUrl=function(s){var r=s,t=b.getBaseUrl(),q=b.getRootUrl();if(b.emulated.pushState){r=r.replace(t,"")}r=r.replace(q,"/");if(b.isTraditionalAnchor(r)){r="./"+r}r=r.replace(/^(\.\/)+/g,"./").replace(/\#$/,"");return r};b.store={};b.idToState=b.idToState||{};b.stateToId=b.stateToId||{};b.urlToId=b.urlToId||{};b.storedStates=b.storedStates||[];b.savedStates=b.savedStates||[];b.normalizeStore=function(){b.store.idToState=b.store.idToState||{};b.store.urlToId=b.store.urlToId||{};b.store.stateToId=b.store.stateToId||{}};b.getState=function(s,r){if(typeof s==="undefined"){s=true}if(typeof r==="undefined"){r=true}var q=b.getLastSavedState();if(!q&&r){q=b.createStateObject()}if(s){q=b.cloneObject(q);q.url=q.cleanUrl||q.url}return q};b.getIdByState=function(q){var s=b.extractId(q.url),r;if(!s){r=b.getStateString(q);if(typeof b.stateToId[r]!=="undefined"){s=b.stateToId[r]}else{if(typeof b.store.stateToId[r]!=="undefined"){s=b.store.stateToId[r]}else{while(true){s=(new Date()).getTime()+String(Math.random()).replace(/\D/g,"");if(typeof b.idToState[s]==="undefined"&&typeof b.store.idToState[s]==="undefined"){break}}b.stateToId[r]=s;b.idToState[s]=q}}}return s};b.normalizeState=function(r){var s,q;if(!r||(typeof r!=="object")){r={}}if(typeof r.normalized!=="undefined"){return r}if(!r.data||(typeof r.data!=="object")){r.data={}}s={};s.normalized=true;s.title=r.title||"";s.url=b.getFullUrl(b.unescapeString(r.url||i.location.href));s.hash=b.getShortUrl(s.url);s.data=b.cloneObject(r.data);s.id=b.getIdByState(s);s.cleanUrl=s.url.replace(/\??\&_suid.*/,"");s.url=s.cleanUrl;q=!b.isEmptyObject(s.data);if(s.title||q){s.hash=b.getShortUrl(s.url).replace(/\??\&_suid.*/,"");if(!/\?/.test(s.hash)){s.hash+="?"}s.hash+="&_suid="+s.id}s.hashedUrl=b.getFullUrl(s.hash);if((b.emulated.pushState||b.bugs.safariPoll)&&b.hasUrlDuplicate(s)){s.url=s.hashedUrl}return s};b.createStateObject=function(s,t,r){var q={data:s,title:t,url:r};q=b.normalizeState(q);return q};b.getStateById=function(r){r=String(r);var q=b.idToState[r]||b.store.idToState[r]||a;return q};b.getStateString=function(r){var q,s,t;q=b.normalizeState(r);s={data:q.data,title:r.title,url:r.url};t=m.stringify(s);return t};b.getStateId=function(r){var q,s;q=b.normalizeState(r);s=q.id;return s};b.getHashByState=function(r){var q,s;q=b.normalizeState(r);s=q.hash;return s};b.extractId=function(s){var t,r,q;r=/(.*)\&_suid=([0-9]+)$/.exec(s);q=r?(r[1]||s):s;t=r?String(r[2]||""):"";return t||false};b.isTraditionalAnchor=function(r){var q=!(/[\/\?\.]/.test(r));return q};b.extractState=function(t,s){var q=null,u,r;s=s||false;u=b.extractId(t);if(u){q=b.getStateById(u)}if(!q){r=b.getFullUrl(t);u=b.getIdByUrl(r)||false;if(u){q=b.getStateById(u)}if(!q&&s&&!b.isTraditionalAnchor(t)){q=b.createStateObject(null,null,r)}}return q};b.getIdByUrl=function(q){var r=b.urlToId[q]||b.store.urlToId[q]||a;return r};b.getLastSavedState=function(){return b.savedStates[b.savedStates.length-1]||a};b.getLastStoredState=function(){return b.storedStates[b.storedStates.length-1]||a};b.hasUrlDuplicate=function(s){var r=false,q;q=b.extractState(s.url);r=q&&q.id!==s.id;return r};b.storeState=function(q){b.urlToId[q.url]=q.id;b.storedStates.push(b.cloneObject(q));return q};b.isLastSavedState=function(t){var s=false,r,q,u;if(b.savedStates.length){r=t.id;q=b.getLastSavedState();u=q.id;s=(r===u)}return s};b.saveState=function(q){if(b.isLastSavedState(q)){return false}b.savedStates.push(b.cloneObject(q));return true};b.getStateByIndex=function(r){var q=null;if(typeof r==="undefined"){q=b.savedStates[b.savedStates.length-1]}else{if(r<0){q=b.savedStates[b.savedStates.length+r]}else{q=b.savedStates[r]}}return q};b.getHash=function(){var q=b.unescapeHash(i.location.hash);return q};b.unescapeString=function(s){var q=s,r;while(true){r=g.unescape(q);if(r===q){break}q=r}return q};b.unescapeHash=function(r){var q=b.normalizeHash(r);q=b.unescapeString(q);return q};b.normalizeHash=function(r){var q=r.replace(/[^#]*#/,"").replace(/#.*/,"");return q};b.setHash=function(u,r){var q,s,t;if(r!==false&&b.busy()){b.pushQueue({scope:b,callback:b.setHash,args:arguments,queue:r});return false}q=b.escapeHash(u);b.busy(true);s=b.extractState(u,true);if(s&&!b.emulated.pushState){b.pushState(s.data,s.title,s.url,false)}else{if(i.location.hash!==q){if(b.bugs.setHash){t=b.getPageUrl();b.pushState(null,null,t+"#"+q,false)}else{i.location.hash=q}}}return b};b.escapeHash=function(r){var q=b.normalizeHash(r);q=g.escape(q);if(!b.bugs.hashEscape){q=q.replace(/\%21/g,"!").replace(/\%26/g,"&").replace(/\%3D/g,"=").replace(/\%3F/g,"?")}return q};b.getHashByUrl=function(q){var r=String(q).replace(/([^#]*)#?([^#]*)#?(.*)/,"$2");r=b.unescapeHash(r);return r};b.setTitle=function(s){var t=s.title,r;if(!t){r=b.getStateByIndex(0);if(r&&r.url===s.url){t=r.title||b.options.initialTitle}}try{i.getElementsByTagName("title")[0].innerHTML=t.replace("<","&lt;").replace(">","&gt;").replace(" & "," &amp; ")}catch(q){}i.title=t;return b};b.queues=[];b.busy=function(r){if(typeof r!=="undefined"){b.busy.flag=r}else{if(typeof b.busy.flag==="undefined"){b.busy.flag=false}}if(!b.busy.flag){j(b.busy.timeout);var q=function(){var t,s,u;if(b.busy.flag){return}for(t=b.queues.length-1;t>=0;--t){s=b.queues[t];if(s.length===0){continue}u=s.shift();b.fireQueueItem(u);b.busy.timeout=c(q,b.options.busyDelay)}};b.busy.timeout=c(q,b.options.busyDelay)}return b.busy.flag};b.busy.flag=false;b.fireQueueItem=function(q){return q.callback.apply(q.scope||b,q.args||[])};b.pushQueue=function(q){b.queues[q.queue||0]=b.queues[q.queue||0]||[];b.queues[q.queue||0].push(q);return b};b.queue=function(r,q){if(typeof r==="function"){r={callback:r}}if(typeof q!=="undefined"){r.queue=q}if(b.busy()){b.pushQueue(r)}else{b.fireQueueItem(r)}return b};b.clearQueue=function(){b.busy.flag=false;b.queues=[];return b};b.stateChanged=false;b.doubleChecker=false;b.doubleCheckComplete=function(){b.stateChanged=true;b.doubleCheckClear();return b};b.doubleCheckClear=function(){if(b.doubleChecker){j(b.doubleChecker);b.doubleChecker=false}return b};b.doubleCheck=function(q){b.stateChanged=false;b.doubleCheckClear();if(b.bugs.ieDoubleCheck){b.doubleChecker=c(function(){b.doubleCheckClear();if(!b.stateChanged){q()}return true},b.options.doubleCheckInterval)}return b};b.safariStatePoll=function(){var r=b.extractState(i.location.href),q;if(!b.isLastSavedState(r)){q=r}else{return}if(!q){q=b.createStateObject()}b.Adapter.trigger(g,"popstate");return b};b.back=function(q){if(q!==false&&b.busy()){b.pushQueue({scope:b,callback:b.back,args:arguments,queue:q});return false}b.busy(true);b.doubleCheck(function(){b.back(false)});f.go(-1);return true};b.forward=function(q){if(q!==false&&b.busy()){b.pushQueue({scope:b,callback:b.forward,args:arguments,queue:q});return false}b.busy(true);b.doubleCheck(function(){b.forward(false)});f.go(1);return true};b.go=function(r,q){var s;if(r>0){for(s=1;s<=r;++s){b.forward(q)}}else{if(r<0){for(s=-1;s>=r;--s){b.back(q)}}else{throw new Error("History.go: History.go requires a positive or negative integer passed.")}}return b};if(b.emulated.pushState){var p=function(){};b.pushState=b.pushState||p;b.replaceState=b.replaceState||p}else{b.onPopState=function(t,q){var v=false,u=false,s,r;b.doubleCheckComplete();s=b.getHash();if(s){r=b.extractState(s||i.location.href,true);if(b.options.transformHash&&r){b.replaceState(r.data,r.title,r.url,false)}else{b.Adapter.trigger(g,"anchorchange");b.busy(false)}b.expectedStateId=false;return false}v=b.Adapter.extractEventData("state",t,q)||false;if(v){u=b.getStateById(v)}else{if(b.expectedStateId){u=b.getStateById(b.expectedStateId)}else{u=b.extractState(i.location.href)}}if(!u){u=b.createStateObject(null,null,i.location.href)}b.expectedStateId=false;if(b.isLastSavedState(u)){b.busy(false);return false}b.storeState(u);b.saveState(u);b.setTitle(u);b.Adapter.trigger(g,"statechange");b.busy(false);return true};b.Adapter.bind(g,"popstate",b.onPopState);b.pushState=function(s,u,r,q){if(b.getHashByUrl(r)&&b.emulated.pushState){throw new Error("History.js does not support states with fragment-identifiers (hashes/anchors).")}if(q!==false&&b.busy()){b.pushQueue({scope:b,callback:b.pushState,args:arguments,queue:q});return false}b.busy(true);var t=b.createStateObject(s,u,r);if(b.isLastSavedState(t)){b.busy(false)}else{b.storeState(t);b.expectedStateId=t.id;f.pushState(t.id,t.title,t.url);b.Adapter.trigger(g,"popstate")}return true};b.replaceState=function(s,u,r,q){if(b.getHashByUrl(r)&&b.emulated.pushState){throw new Error("History.js does not support states with fragement-identifiers (hashes/anchors).")}if(q!==false&&b.busy()){b.pushQueue({scope:b,callback:b.replaceState,args:arguments,queue:q});return false}b.busy(true);var t=b.createStateObject(s,u,r);if(b.isLastSavedState(t)){b.busy(false)}else{b.storeState(t);b.expectedStateId=t.id;f.replaceState(t.id,t.title,t.url);b.Adapter.trigger(g,"popstate")}return true}}if(k){try{b.store=m.parse(k.getItem("History.store"))||{}}catch(o){b.store={}}b.normalizeStore()}else{b.store={};b.normalizeStore()}b.Adapter.bind(g,"beforeunload",b.clearAllIntervals);b.Adapter.bind(g,"unload",b.clearAllIntervals);b.saveState(b.storeState(b.extractState(i.location.href,true)));if(k){b.onUnload=function(){var q,s;try{q=m.parse(k.getItem("History.store"))||{}}catch(r){q={}}q.idToState=q.idToState||{};q.urlToId=q.urlToId||{};q.stateToId=q.stateToId||{};for(s in b.idToState){if(!b.idToState.hasOwnProperty(s)){continue}q.idToState[s]=b.idToState[s]}for(s in b.urlToId){if(!b.urlToId.hasOwnProperty(s)){continue}q.urlToId[s]=b.urlToId[s]}for(s in b.stateToId){if(!b.stateToId.hasOwnProperty(s)){continue}q.stateToId[s]=b.stateToId[s]}b.store=q;b.normalizeStore();k.setItem("History.store",m.stringify(q))};b.intervalList.push(e(b.onUnload,b.options.storeInterval));b.Adapter.bind(g,"beforeunload",b.onUnload);b.Adapter.bind(g,"unload",b.onUnload)}if(!b.emulated.pushState){if(b.bugs.safariPoll){b.intervalList.push(e(b.safariStatePoll,b.options.safariPollInterval))}if(l.vendor==="Apple Computer, Inc."||(l.appCodeName||"")==="Mozilla"){b.Adapter.bind(g,"hashchange",function(){b.Adapter.trigger(g,"popstate")});if(b.getHash()){b.Adapter.onDomLoad(function(){b.Adapter.trigger(g,"hashchange")})}}}};b.init()})(window);