<?php
if (!defined('BASE_DIR')) { exit(); } 

class Engine
{
  private static $instance;
  public $html_head = '';
  public $html_after = '';
  public $html_body = '';
  public $html_title = '';
  public $page = 'index.php';
  public $config;
  
  private function __construct()
  {
    $this->router();
    $this->loadConfig();
  }

  public static function getInstance()
  {
    if (self::$instance === null)
    {
      self::$instance = new self();
    }

    return self::$instance;
  }
      
  public function router() 
  {
    $url = $_SERVER['REQUEST_URI'];      
    
    if ($url == '/') $url = 'index.php';

    $url = parse_url($url);

    $page = trim($url['path'], '/');

    $page = explode('/', $page);
    
    if ($page[0] != '')
    {
      $this->page = $page[0];
    }
    else
    { 
      $this->page = 'index.php';
    }
  }
  
  public function addHeadHtml($head)
  {
    $test = $this->html_head;

    $test = $test.$head. "\r\n";

    $this->html_head = $test;
  }
  
  public function addAfterHtml($head)
  {
    $test = $this->html_after;

    $test = $test.$head. "\r\n";

    $this->html_after = $test;
  }
  
  public function addTitleHtml($title)
  {   
    $test = $this->html_title;

    $test = $test.$title;

    $this->html_title = $test;
  }
  
  public function printTitleHtml()
  {
    if ($this->html_title) { return $this->config['site_name'].' - '.$this->html_title; } else { return $this->config['site_name']; }
  }
  
  public function printHeadHtml()
  {
    echo $this->html_head;
  }
  
  public function printAfterHtml()
  {
    echo $this->html_after;
  }
  
  public function addBodyHtml($body)
  {
    $test = $this->html_body;

    $test = $test.$body. "\r\n";

    $this->html_body = $test;
  }
  
  public function printBodyHtml()
  {
    echo $this->html_body;
  }
  
  private function loadConfig()
  {
    global $mysqli;
    
    $query = $mysqli->query("SELECT * FROM `".PREFIX."_config` WHERE `id` = '1' LIMIT 1");	
  
    if ($query->num_rows)
    {
      $res = $query->fetch_assoc();  
        
      $res['topic'] = json_decode($res['topic'], true);
      
      $this->config = $res;
    }    
  }    
  
  public function getConfig($param)
  {
    return $this->config[$param];
  }        
}
?>