<?php
// Получение икс
function getTicCounter($url) {
    $domain = str_replace(['https://', 'http://', 'www.'], '', $url);
    return '<img width="50" height="20" alt="Яндекс ИКС" border="0" style="border-radius: 8px;" src="https://yandex.ru/cycounter?' . htmlspecialchars($domain) . '&theme=dark&lang=ru">';
}

//склонение слов
function getWord($number, $suffix) {
    $keys = array(2, 0, 1, 1, 1, 2);
    $mod = $number % 100;
    $suffix_key = ($mod > 7 && $mod < 20) ? 2: $keys[min($mod % 10, 5)];
    return $suffix[$suffix_key];
}
//информация о пользователе
function usersInfo($id=null) {
    global $mysqli;
    static $result = array();
    if ($id === null) $id = $_SESSION['user_id'];
    if (!isset($result[$id])) {
        $query = $mysqli->query("SELECT * FROM `".PREFIX."_users` WHERE `id` = '".$id."' LIMIT 1");
        $result[$id] = $query->fetch_assoc();
    }
    return $result[$id];
}
//проверка цвета
function isValidColor($color) {
    if (!is_string($color)) {
        trigger_error('Parameter 1 must be string, ' . gettype($color) . ' given', E_USER_WARNING);
        return false;
    }
    $color = str_replace(array("\f", "\n", "\r", "\t", "\v", ' '), '', strtolower($color));
    $colors = array('transparent', 'white', 'silver', 'gray', 'black', 'maroon', 'red', 'orange', 'yellow', 'olive', 'lime', 'green', 'aqua', 'blue', 'navy', 'teal', 'fuchsia', 'purple');
    return in_array($color, $colors) ?: (bool) preg_match('#^(?:\#[\da-f]{3}|[\da-f]{6})|(?:rgb(a)?\((?:(?:1?\d{1,2}|2(5)?(?(2)[0-5]|[0-4]\d)),){2}(?:1?\d{1,2}|2(5)?(?(3)[0-5]|[0-4]\d))(?(1),(?:1(?:\.0+)?|0?\.\d+))\))|(?:hsl(a)?\((?:[1-2]?\d{1,2}|3[0-5]\d),1?\d{1,2}%,1?\d{1,2}%(?(4),(?:1(?:\.0+)?|0?\.\d+))\))$#i', trim($color));
}
//обновление статистики сайта
function addStats($type, $num) {
  global $mysqli;
  $mysqli->query("UPDATE `".PREFIX."_config` SET `".$type."` = `".$type."` + '".$num."' WHERE id = '1'");  
}
//вывод сообщений
function printMessage($msg) {
    switch ($msg) {
        case '100':
            $m = '<div class="success">Сохранение прошло успешно!</div>';
        break;
        case '200':
            $m = '<div class="error">Ошибка введённых данных</div>';
        break;
        case '300':
            $m = 'Сообщение отправлено';
            return $m;
        break;
        default:
        break;
    }
    $m = '<div id="notes">'.$m.'</div>';
    return $m;
}
//генератор пароля
function genPassword($number) {
    $arr = array('a','b','c','d','e','f',
                 'g','h','i','j','k','l',
                 'm','n','p','r','s',
                 't','u','v','x','y','z',
                 'A','B','C','D','E','F',
                 'G','H','I','J','K','L',
                 'M','N','P','R','S',
                 'T','U','V','X','Y','Z',
                 '1','2','3','4','5','6',
                 '7','8','9');
    $pass = "";
    for($i = 0; $i < $number; $i++) {
        $index = rand(0, count($arr) - 1);
        $pass .= $arr[$index];
    }
    return $pass;
}
//постраничная навигация ссылок
function printPageNavLink($page, $pages_count, $total, $perpage)
{ 
    global $_POST;
    global $topic;

    $topic = implode($topic, ",");
    $tmp = '';
    $tmp = $tmp.'<div class="page_selector">';
    $tmp = $tmp.'<span>Страница: </span>';
    if ($page > 1) {
        $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
        <input type="hidden" name="type" value="search">
        <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
        <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
        <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
        <input type="hidden" name="price" value="'.clear($_POST['price']).'">
        <input type="hidden" name="text" value="'.clear($_POST['text']).'">
        <input type="hidden" name="url" value="'.clear($_POST['url']).'">
        <input type="hidden" name="page" value="'.($page - 1).'">
        <input type="hidden" name="specc" value="'.clear(@$_POST['specc']).'">
        <input type="hidden" name="scolor" value="'.clear($_POST['scolor']).'">
        <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
        <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
        <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
        <input type="hidden" name="hidden_topics" value="'.$topic.'">
        <input type="submit" class="selector" value="&#9668;">
        </form>';
    }
    $start_page = 1;
    $end_page = $pages_count;
    if ($page - 5 > 0) {
        $start_page = $page - 4;
        if ($page + 4 > $pages_count) {
            $start_page = $pages_count - 8;
        }
        if ($start_page < 2) {
            $start_page = 1;
        }
        if ($start_page > 1) {
            $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
            <input type="hidden" name="type" value="search">
            <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
            <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
            <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
            <input type="hidden" name="price" value="'.clear($_POST['price']).'">
            <input type="hidden" name="text" value="'.clear($_POST['text']).'">
            <input type="hidden" name="url" value="'.clear($_POST['url']).'">
            <input type="hidden" name="page" value="1">
            <input type="hidden" name="specc" value="'.clear(@$_POST['specc']).'">
            <input type="hidden" name="scolor" value="'.clear($_POST['scolor']).'">
            <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
            <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
            <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
            <input type="hidden" name="hidden_topics" value="'.$topic.'">
            <input type="submit" class="selector" value="...">
            </form>';
        }
    }
    $t = 0;
    if ($page + 4 < $pages_count && $page + 8 < $pages_count) {
        $end_page = $start_page + 8;
        $t = 1;
    }
    if ($total > $perpage) {
        for($n = $start_page; $n <= $end_page; $n++) {
            if ($n == $page) {
                $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
                <input type="hidden" name="type" value="search">
                <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
                <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
                <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
                <input type="hidden" name="price" value="'.clear($_POST['price']).'">
                <input type="hidden" name="text" value="'.clear($_POST['text']).'">
                <input type="hidden" name="url" value="'.clear($_POST['url']).'">
                <input type="hidden" name="page" value="'.$n.'">
                <input type="hidden" name="specc" value="'.clear(@$_POST['specc']).'">
                <input type="hidden" name="scolor" value="'.clear($_POST['scolor']).'">
                <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
                <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
                <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
                <input type="hidden" name="hidden_topics" value="'.$topic.'">
                <input type="submit" class="selector active" disabled="disabled" value="'.$n.'">
                </form>';
                } else {
                $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
                <input type="hidden" name="type" value="search">
                <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
                <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
                <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
                <input type="hidden" name="price" value="'.clear($_POST['price']).'">
                <input type="hidden" name="text" value="'.clear($_POST['text']).'">
                <input type="hidden" name="url" value="'.clear($_POST['url']).'">
                <input type="hidden" name="page" value="'.$n.'">
                <input type="hidden" name="specc" value="'.clear(@$_POST['specc']).'">
                <input type="hidden" name="scolor" value="'.clear($_POST['scolor']).'">
                <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
                <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
                <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
                <input type="hidden" name="hidden_topics" value="'.$topic.'">
                <input type="submit" class="selector" value="'.$n.'">
                </form>';
            }
        }
    }
    if ($t) {
        $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
        <input type="hidden" name="type" value="search">
        <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
        <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
        <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
        <input type="hidden" name="price" value="'.clear($_POST['price']).'">
        <input type="hidden" name="text" value="'.clear($_POST['text']).'">
        <input type="hidden" name="url" value="'.clear($_POST['url']).'">
        <input type="hidden" name="page" value="'.$pages_count.'">
        <input type="hidden" name="specc" value="'.clear(@$_POST['specc']).'">
        <input type="hidden" name="scolor" value="'.clear($_POST['scolor']).'">
        <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
        <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
        <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
        <input type="hidden" name="hidden_topics" value="'.$topic.'">
        <input type="submit" class="selector" value="...">
        </form>';
    }
    if ($page < $pages_count && $pages_count > 1) {
        $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
        <input type="hidden" name="type" value="search">
        <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
        <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
        <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
        <input type="hidden" name="price" value="'.clear($_POST['price']).'">
        <input type="hidden" name="text" value="'.clear($_POST['text']).'">
        <input type="hidden" name="url" value="'.clear($_POST['url']).'">
        <input type="hidden" name="page" value="'.($page + 1).'">				
        <input type="hidden" name="specc" value="'.clear(@$_POST['specc']).'">
        <input type="hidden" name="scolor" value="'.clear($_POST['scolor']).'">
        <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
        <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
        <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
        <input type="hidden" name="hidden_topics" value="'.$topic.'">
        <input type="submit" class="selector" value="&#9658;">
        </form>';
    }
    $tmp = $tmp.'</div>';
    echo $tmp;
}
//постраничная навигация баннеров
function printPageNavBanner($page, $pages_count, $total, $perpage) {
    global $_POST;
    global $topic;

    $topic = implode($topic, ",");
    $tmp = '';
    $tmp = $tmp.'<div class="page_selector">';
    $tmp = $tmp.'<span>Страница: </span>';
    if ($page > 1) {
        $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
        <input type="hidden" name="type" value="search">
        <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
        <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
        <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
        <input type="hidden" name="price" value="'.clear($_POST['price']).'">
        <input type="hidden" name="url" value="'.clear($_POST['url']).'">
        <input type="hidden" name="img" value="'.clear($_POST['img']).'">
        <input type="hidden" name="size" value="'.clear($_POST['size']).'">
        <input type="hidden" name="weeks" value="'.clear($_POST['weeks']).'">    
        <input type="hidden" name="page" value="'.($page - 1).'">				
        <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
        <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
        <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
        <input type="hidden" name="hidden_topics" value="'.$topic.'">
        <input type="submit" class="selector" value="&#9668;">
        </form>';
    }
    $start_page = 1;
    $end_page = $pages_count;
    if ($page - 5 > 0) {
        $start_page = $page - 4;
        if ($page + 4 > $pages_count) {
            $start_page = $pages_count - 8;
        }
        if ($start_page < 2) {
            $start_page = 1;
        }
        if ($start_page > 1) {
            $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
            <input type="hidden" name="type" value="search">
            <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
            <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
            <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
            <input type="hidden" name="price" value="'.clear($_POST['price']).'">
            <input type="hidden" name="url" value="'.clear($_POST['url']).'">
            <input type="hidden" name="page" value="1">
            <input type="hidden" name="img" value="'.clear($_POST['img']).'">
            <input type="hidden" name="size" value="'.clear($_POST['size']).'">
            <input type="hidden" name="weeks" value="'.clear($_POST['weeks']).'">  
            <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
            <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
            <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
            <input type="hidden" name="hidden_topics" value="'.$topic.'">
            <input type="submit" class="selector" value="...">
            </form>';
        }
    }
    $t = 0;
    if ($page + 4 < $pages_count && $page + 8 < $pages_count) {
        $end_page = $start_page + 8;
        $t = 1;
    }
    if ($total > $perpage) {
        for($n = $start_page; $n <= $end_page; $n++) {
            if ($n == $page) {
                $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
                <input type="hidden" name="type" value="search">
                <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
                <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
                <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
                <input type="hidden" name="price" value="'.clear($_POST['price']).'">
                <input type="hidden" name="url" value="'.clear($_POST['url']).'">
                <input type="hidden" name="img" value="'.clear($_POST['img']).'">
                <input type="hidden" name="size" value="'.clear($_POST['size']).'">
                <input type="hidden" name="weeks" value="'.clear($_POST['weeks']).'">  
                <input type="hidden" name="page" value="'.$n.'">             
                <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
                <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
                <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
                <input type="hidden" name="hidden_topics" value="'.$topic.'">
                <input type="submit" class="selector active" disabled="disabled" value="'.$n.'">
                </form>';
            } else {
                $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
                <input type="hidden" name="type" value="search">
                <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
                <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
                <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
                <input type="hidden" name="price" value="'.clear($_POST['price']).'">
                <input type="hidden" name="url" value="'.clear($_POST['url']).'">
                <input type="hidden" name="img" value="'.clear($_POST['img']).'">
                <input type="hidden" name="size" value="'.clear($_POST['size']).'">
                <input type="hidden" name="weeks" value="'.clear($_POST['weeks']).'">  
                <input type="hidden" name="page" value="'.$n.'">               
                <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
                <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
                <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
                <input type="hidden" name="hidden_topics" value="'.$topic.'">
                <input type="submit" class="selector" value="'.$n.'">
                </form>';
            }
        }
    }
    if ($t) {
        $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
        <input type="hidden" name="type" value="search">
        <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
        <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
        <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
        <input type="hidden" name="price" value="'.clear($_POST['price']).'">
        <input type="hidden" name="url" value="'.clear($_POST['url']).'">
        <input type="hidden" name="img" value="'.clear($_POST['img']).'">
        <input type="hidden" name="size" value="'.clear($_POST['size']).'">
        <input type="hidden" name="weeks" value="'.clear($_POST['weeks']).'">  
        <input type="hidden" name="page" value="'.$pages_count.'">    
        <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
        <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
        <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
        <input type="hidden" name="hidden_topics" value="'.$topic.'">
        <input type="submit" class="selector" value="...">
        </form>';
    }
    if ($page < $pages_count && $pages_count > 1) {
        $tmp = $tmp.'<form name="form2" method="post" action="" onsubmit="transfer();">
        <input type="hidden" name="type" value="search">
        <input type="hidden" name="hosts" value="'.clear($_POST['hosts']).'">
        <input type="hidden" name="ctr" value="'.clear($_POST['ctr']).'">
        <input type="hidden" name="tic" value="'.clear($_POST['tic']).'">
        <input type="hidden" name="price" value="'.clear($_POST['price']).'">
        <input type="hidden" name="url" value="'.clear($_POST['url']).'">
        <input type="hidden" name="img" value="'.clear($_POST['img']).'">
        <input type="hidden" name="size" value="'.clear($_POST['size']).'">
        <input type="hidden" name="weeks" value="'.clear($_POST['weeks']).'">  
        <input type="hidden" name="page" value="'.($page + 1).'">								
        <input type="hidden" id="multiprice" name="multiprice" value="'.clear(@$_POST['multiprice']).'">
        <input type="hidden" id="multiid" name="multiid" value="'.clear(@$_POST['multiid']).'">
        <input type="hidden" id="selectallid" name="selectallid" value="'.clear(@$_POST['selectallid']).'">
        <input type="hidden" name="hidden_topics" value="'.$topic.'">
        <input type="submit" class="selector" value="&#9658;">
        </form>';
    }
    $tmp = $tmp.'</div>';
    echo $tmp;
}
//постраничная навигация
function printPageNav($page, $pages_count, $url, $total, $perpage) {
  $uri = '?';
  if (isset($_GET)) {
    foreach($_GET as $key => $value) {
      if ($key != 'p') {
        if (is_array($value)) {
          foreach ($value as $v) {
            $uri .= "{$key}[]={$v}&amp;";
          }
        } else {
          $uri .= "{$key}={$value}&amp;"; 
        } 
      }
    }
  }
  $url = $url.$uri;
  $tmp = '';
  $tmp = $tmp.'<div class="page_selector">';
  $tmp = $tmp.'<span>Страница: </span>';
  if ($page > 1) {
    $tmp = $tmp.'<a class="selector" href="'.$url.'p='.($page - 1).'">&#9668;</a>';
  }
  $start_page = 1;
  $end_page = $pages_count;
  if ($page - 5 > 0) {
    $start_page = $page - 4;
    if ($page + 4 > $pages_count) {
      $start_page = $pages_count - 8;             
    }
    if ($start_page < 2) {
      $start_page = 1;               
    }
    if ($start_page > 1) {
      $tmp = $tmp.'<a class="selector" href="'.$url.'p=1">...></a>';       
    } 
  }
  $t = 0;
  if ($page + 4 < $pages_count && $page + 8 < $pages_count) {
    $end_page = $start_page + 8;
    $t = 1;
  }
  if ($total > $perpage) {
    for($n = $start_page; $n <= $end_page; $n++) {
      if ($n == $page) {
        $tmp = $tmp.'<a class="selector active" href="'.$url.'p='.$n.'">'.$n.'</a>';
      } else {
        $tmp = $tmp.'<a class="selector" href="'.$url.'p='.$n.'">'.$n.'</a>';
      }
    }
  }
  if ($t) {
    $tmp = $tmp.'<a class="selector" href="'.$url.'p='.$pages_count.'">...</a>';
  }
  if ($page < $pages_count && $pages_count > 1) {
    $tmp = $tmp.'<a class="selector" href="'.$url.'p='.($page + 1).'">&#9658;</a>'; 
  }
  $tmp = $tmp.'</div>';
  echo $tmp;
}
// дебаг 11.11.2025
function addZakaz($res, $wallet, $payment) {
    global $obEngine;
    global $mysqli;
    $check_query = $mysqli->query("SELECT status, payment FROM `".PREFIX."_history_pay` WHERE `id` = '".$res['id']."' LIMIT 1");
    if ($check_query->num_rows) {
        $check_res = $check_query->fetch_assoc();
        if ($check_res['status'] == '1') {
            error_log("DUPLICATE_ORDER_BLOCKED: order_id=" . $res['id'] . ", user_id=" . $res['user_id'] . ", payment=" . $payment);
            return false;
        }
    }
    
    $type = $res['type'];
    if ($type == 1) {
        payRef($res, $type, $payment);

        $log_entry = "
        IP:".$_SERVER['REMOTE_ADDR']." \n
        URL: ".$_SERVER['REQUEST_URI']." \n
        REF: ".$_SERVER['HTTP_REFERER']." \n
        ФАЙЛ: /inc/function.php \n
        USER_ID: ".$res['user_id']." \n
        ORDER_ID: ".$res['id']." \n
        СУММА: ".$res['price']." \n
        PAYMENT: ".$payment." \n
        СТРОКА: 493 \n***\n\n";
        file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs_sql/post_'.date('Y-m-d H:i:s').'.txt', $log_entry, FILE_APPEND);
                
        $mysqli->query("UPDATE `".PREFIX."_users` SET `money` = `money` + '".$res['price']."', `money_in` = `money_in` + '".$res['price']."' WHERE `id` = '".$res['user_id']."'");
    $mysqli->query("UPDATE `".PREFIX."_history_pay` SET `status` = '1', `wallet` = '".$wallet."' WHERE `id` = '".$res['id']."'");
        
    return true;
 //дебаг блоков ссылок 12.11.2025

} else if ($type == 2) {
    $data = unserialize($res['data']);
    if (!$data || !isset($data['ids'], $data['url'], $data['text'])) {
        return false;
    }
    
    $ids = array_filter(explode("_", $data['ids']), function($id) {
        return is_numeric($id) && $id > 0;
    });
    
    if (empty($ids)) {
        return false;
    }
    $total_order_price = (float)$res['price'];
    $url = $data['url'];
    $text = $data['text'];
    $color = $data['color'] ?? '';
    $specc = isset($data['specc']) ? (int)$data['specc'] : 0;
    
    $has_color_highlight = $specc;
    $highlight_color = $color;
    $price_per_link = round($total_order_price / count($ids), 2);
    
    $n_count = 0;
    foreach ($ids as $key => $value) {
        $id = (int)$value;
        $query = $mysqli->query("SELECT * FROM `".PREFIX."_blocks` WHERE `type` = '1' and `id` = '".$id."' LIMIT 1");
        if ($query->num_rows) {
            $res_block = $query->fetch_assoc();
            $mysqli->query("UPDATE `".PREFIX."_users` SET `money_frozen` = `money_frozen` + '".$price_per_link."' WHERE `id` = '".$res_block['user_id']."'");
            $mysqli->query("INSERT INTO `".PREFIX."_links` (`ident`,`time_add`,`user_id`,`user_blocks`,`sum`,`price`,`money`,`text`,`url_block`,`url_site`,`color`,`specc`,`stats`,`status`) VALUES ('".$id."',NOW(),'".$res['user_id']."','".$res_block['user_id']."','".$res_block['sum']."','".$price_per_link."','".$price_per_link."','".$text."','".$res_block['url']."','".$url."','".$highlight_color."','".$has_color_highlight."','','1')");
            $n_count++;
            
            $mysqli->query("UPDATE `".PREFIX."_config` SET `success_work` = `success_work` + '1' WHERE `id` = '1'");
            $query = $mysqli->query("SELECT * FROM `".PREFIX."_links` WHERE `status` = '1' and `ident` = '".$id."' ORDER BY `time_add` DESC");
            if ($query->num_rows > $res_block['slots']) {
                $n = 1;
                while ($row = $query->fetch_assoc()) {
                    if ($n > $res_block['slots']) {
                        $mysqli->query("UPDATE `".PREFIX."_links` SET `status` = '0' WHERE `id` = '".$row['id']."'");
                        $res_user = $mysqli->query("SELECT `money_frozen` FROM `".PREFIX."_users` WHERE `id` = '".$row['user_blocks']."' LIMIT 1")->fetch_assoc();
                      
                        if ($res_user['money_frozen'] >= $row['price']) {
                            $mysqli->query("UPDATE `".PREFIX."_users` SET `money` = `money` + '".$row['price']."', `money_all` = `money_all` + '".$row['price']."', `money_link` = `money_link` + '".$row['price']."', `money_frozen` = `money_frozen` - '".$row['price']."' WHERE `id` = '".$row['user_blocks']."'");
                        } else {
                            $mysqli->query("UPDATE `".PREFIX."_users` SET `money` = `money` + '".$row['price']."', `money_all` = `money_all` + '".$row['price']."', `money_link` = `money_link` + '".$row['price']."', `money_frozen` = '0' WHERE `id` = '".$row['user_blocks']."'");
                        }

                       $mysqli->query("INSERT INTO `".PREFIX."_history` (`time_pay`,`user_id`,`type`,`money`) VALUES (NOW(),'".$row['user_blocks']."','link','".$row['price']."')");
                    }
                    $n++;
                }
            }
        }
    }
    if ($n_count > 0 && $payment != 'Баланс') {
        payRef($res, $type, $payment);
    }

#дебаг баннерных блоков 09.11.2025
    } else if ($type == 3) {
        $data = unserialize($res['data']);
        if (!$data || !isset($data['ids'], $data['url'], $data['img'], $data['weeks'])) {
            return false;
        }
        
        $ids = array_filter(explode("_", $data['ids']), function($id) {
            return is_numeric($id) && $id > 0;
        });
        
        if (empty($ids)) {
            return false;
        }
        $total_order_price = (float)$res['price'];
        $weeks = max(1, min(4, (int)$data['weeks']));
        $url = $data['url'];
        $img = $data['img'];
        $price_per_banner = round($total_order_price / count($ids), 2);
        
        $n_count = 0;
        foreach ($ids as $key => $value) {
            $id = (int)$value;
            $query = $mysqli->query("SELECT * FROM `".PREFIX."_blocks` WHERE `type` = '2' and `id` = '".$id."' LIMIT 1");
            if ($query->num_rows) {
                $res_block = $query->fetch_assoc();
                $slot_check = $mysqli->query("SELECT COUNT(*) as count FROM `".PREFIX."_banners` WHERE `ident` = '".$id."' AND `status` = '1'");
                $slot_count = $slot_check->fetch_assoc()['count'];
                if ($slot_count >= $res_block['slots']) {
                    continue;
                }
                $mysqli->query("UPDATE `".PREFIX."_users` SET `money_frozen` = `money_frozen` + '".$price_per_banner."' WHERE `id` = '".$res_block['user_id']."'");
                $mysqli->query("INSERT INTO `".PREFIX."_banners` (`ident`,`time_add`,`user_id`,`user_blocks`,`size`,`sum`,`price`,`money`,`weeks`,`url_block`,`url_banner`,`url_site`,`stats`,`status`) VALUES ('".$id."',NOW(),'".$res['user_id']."','".$res_block['user_id']."','".$res_block['size']."','".$res_block['sum']."','".$price_per_banner."','".$price_per_banner."','".$weeks."','".$res_block['url']."','".$img."','".$url."','','1')");
                $n_count++;
                $mysqli->query("UPDATE `".PREFIX."_config` SET `success_work` = `success_work` + '1' WHERE `id` = '1'");
            }
        }
        if ($n_count > 0 && $payment != 'Баланс') {
            payRef($res, $type, $payment);
        }
    }
    $mysqli->query("UPDATE `".PREFIX."_history_pay` SET `time_add` = NOW(), `payment` = '".$payment."', `wallet` = '".$wallet."', `status` = '1' WHERE `id` = '".$res['id']."'");
    return true;
}
#дебаг 09.11.2025


function payRef($res, $type, $payment) {
    global $obEngine;
    global $mysqli;
    $ref = $mysqli->query("SELECT `id`, `referer` FROM `".PREFIX."_users` WHERE `id` = '".$res['user_id']."' LIMIT 1")->fetch_assoc();
    if ($ref['referer'] > 0) {
        $money_ref = sprintf("%.2f", $res['price']*($obEngine->getConfig('ref_proc')/100));
        
        // 30.10.2025 
                        $log_entry = "
	            IP:".$_SERVER['REMOTE_ADDR']." \n
	            URL: ".$_SERVER['REQUEST_URI']." \n
	            REF: ".$_SERVER['HTTP_REFERER']." \n
	            ФАЙЛ: /inc/function.php \n
	            СУММА: ".$money_ref." \n
	            СТРОКА: 621 \n***\n\n";
                file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs_sql/post_'.date('Y-m-d H:i:s').'.txt', $log_entry, FILE_APPEND);
                // 30.10.2025 
                
        $mysqli->query("UPDATE `".PREFIX."_users` SET `money` = `money` + '".$money_ref."', `money_ref` = `money_ref` + '".$money_ref."', `money_all` = `money_all` + '".$money_ref."' WHERE `id` = '".$ref['referer']."'");
        $mysqli->query("INSERT INTO `".PREFIX."_history_payref` (`time_add`,`user_id`,`referer`,`type`,`payment`,`price`,`money`,`id_zakaz`) VALUES (NOW(),'".$res['user_id']."','".$ref['referer']."','".$type."','".$payment."','".$res['price']."','".$money_ref."','".$res['id']."')");
        $mysqli->query("UPDATE `".PREFIX."_config` SET `users_profit` = `users_profit` + '".$money_ref."' WHERE `id` = '1'");
    }
}
function addLogs($data) {
  $all = "|$data|\n";
  $filename = BASE_DIR.'/logs/log.txt';
  function object2file($value, $filename) {
    $f = fopen($filename, 'a');
    fwrite($f, $value);
    fclose($f);
  }
  object2file($all, $filename);
}

function clear($data, $type='str') {
    $data = trim($data);
    $data = strip_tags($data);
    $data = htmlspecialchars($data);
    $data = ($type == 'str') ? strval($data) : intval($data);
    return $data;
}
function isMail($mail) {
    if(is_array($mail) && empty($mail) && strlen($mail) > 255 && strpos($mail,'@') > 64) return false;
    return (!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]{2,20}+\.)+[a-z]{2,6}$/ix", $mail)) ? false : strtolower($mail);
}
function siteURL() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    return $protocol.$domainName;
}

class YandexIks
{
    private static $reference = [
        '..xxxxxx....xxxxxxxxx.xxxxxxxxxxxxx.......xxxx.......xxxxx.....xxxxxxxxxxxxxx.xxxxxxxx..',
        '..xx........xxx.......xxx........xxxxxxxxxxxxxxxxxxxxxx',
        '.........xxxx......xxxxx......xxxxx.....xxxxxx...xxxx.xxxx.xxxx..xxxxxxxx...x.xxxx.....x',
        'x........xxxx.......xxxx...x...xxxx...x...xxxx..xxx..xxxxxxxxxxxxxxxxxxxxxxxx......xxxx.',
        '......xx.......xxxx......xxxxx....xxxx..x...xxxx...x...xxxxxxxxxxxxxxxxxxxxxx.......x...',
        '..........xxxxxxx...xxxxxxxx...xxx...xx...xxx...xx...xxx...xxxxxxxx...xxxxxxx.....xxxx..',
        '....xxxxx....xxxxxxxxx.xxxxxx.xxxxxxxxx...xxxxx.xx...xxxx..xx...xxx...xxxxxxxx....xxxxx.',
        'x..........x.........xx.......xxxx....xxxxxxx..xxxxxx..xxxxxxx....xxxxx......xxx........',
        '......xxxx.xxxxxxxxxxxxxxxxxxxxxxxx..xxx..xxxx..xxx..xxxxxxxxx..xxxxxxxxxxxxx.xxxx.xxxx.',
        '.xxxxx.....xxxxxxx...xxxx.xxx...xxx...xx..xxxx...xx.xxxxxx..xxxxx.xxxxxxxxx...xxxxxxx...',
    ];

    /**
     * Получение значения ИКС для указанного домена
     *
     * Данный метод не должен приводить к бану по IP при слишком частых запросов,
     * не выводится капча.
     */
    public static function getValueFromImage($domain) {
        $yaurl = 'https://www.yandex.ru/cycounter?' . $domain;
        $img = @imagecreatefrompng($yaurl);
        return $img ? self::parseImg($img) : '0';
    }

    private static function parseImg(&$src_img) {
        // где могут размещаться данные по ИКС
        $iks_x = 26;
        $iks_y = 10;
        $iks_w = 56;
        $iks_h = 11;

        // сюда вырезается нужная часть изображения
        $dst_img = imagecreatetruecolor($iks_w, $iks_h);

        // нужна часть изображения, на которой могут быть цифры
        imagecopy($dst_img, $src_img, 0, 0, $iks_x, $iks_y, $iks_w, $iks_h);

        $arr = [];
        for ($i = 0; $i < $iks_w; ++$i) {
            $arr[$i] = '';
            for ($j = 0; $j < $iks_h; ++$j) {
                $arr[$i] .= 8882055 == imagecolorat($dst_img, $i, $j) ? '.' : 'x';
            }
        }

        // подчистить пустые ряды
        for ($i = 0; $i < $iks_w; ++$i) {
            if ('...........' == $arr[$i])  unset($arr[$i]);
        }

        $iks = '';
        $current_symbol = '';
        $current_len = 0;

        foreach ($arr as $v) {
            $current_symbol .= $v;
            $current_len += 11;

            if (88 == $current_len) { // все символы имеют ширину 8
                foreach (self::$reference as $num => $symb) {
                    if (similar_text($symb, $current_symbol) > 80) {
                        $iks .= $num;
                        break;
                    }
                }
                $current_symbol = '';
                $current_len = 0;
            } elseif (55 == $current_len) { // кроме 1 — у него ширина 5
                if (similar_text(self::$reference[1], $current_symbol) > 50) {
                    $iks .= 1;
                    $current_symbol = '';
                    $current_len = 0;
                }
            }
        }

        return !empty($iks) ? $iks : 0;
    }
}